
/*  A Bison parser, made from zmac.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	STRING	258
#define	NOOPERAND	259
#define	ARITHC	260
#define	ADD	261
#define	LOGICAL	262
#define	BIT	263
#define	CALL	264
#define	INCDEC	265
#define	DJNZ	266
#define	EX	267
#define	IM	268
#define	PHASE	269
#define	DEPHASE	270
#define	IN	271
#define	JP	272
#define	JR	273
#define	LD	274
#define	OUT	275
#define	PUSHPOP	276
#define	RET	277
#define	SHIFT	278
#define	RST	279
#define	REGNAME	280
#define	ACC	281
#define	C	282
#define	RP	283
#define	HL	284
#define	INDEX	285
#define	AF	286
#define	SP	287
#define	MISCREG	288
#define	F	289
#define	COND	290
#define	SPCOND	291
#define	NUMBER	292
#define	UNDECLARED	293
#define	END	294
#define	ORG	295
#define	DEFB	296
#define	DEFS	297
#define	DEFW	298
#define	EQU	299
#define	DEFL	300
#define	LABEL	301
#define	EQUATED	302
#define	WASEQUATED	303
#define	DEFLED	304
#define	MULTDEF	305
#define	MOD	306
#define	SHL	307
#define	SHR	308
#define	NOT	309
#define	IF	310
#define	ELSE	311
#define	ENDIF	312
#define	ARGPSEUDO	313
#define	LIST	314
#define	MINMAX	315
#define	MACRO	316
#define	MNAME	317
#define	OLDMNAME	318
#define	ARG	319
#define	ENDM	320
#define	MPARM	321
#define	ONECHAR	322
#define	TWOCHAR	323
#define	UNARY	324

#line 1 "zmac.y"

/*
 *  zmac -- macro cross-assembler for the Zilog Z80 microprocessor
 *
 *  Bruce Norskog	4/78
 *
 *  Last modification  2000-02-20 by mgr
 *
 *  This assembler is modeled after the Intel 8080 macro cross-assembler
 *  for the Intel 8080 by Ken Borgendale.  The major features are:
 *	1.  Full macro capabilities
 *	2.  Conditional assembly
 *	3.  A very flexible set of listing options and pseudo-ops
 *	4.  Symbol table output
 *	5.  Error report
 *	6.  Elimination of sequential searching
 *	7.  Commenting of source
 *	8.  Facilities for system definiton files
 *
 * (Revision history is now in ChangeLog. -rjm)
 */

#define ZMAC_VERSION	"1.2"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include "mio.h"
#include "getoptn.h"

#if defined (__riscos__) && !defined (__riscos)
#define __riscos
#endif

#ifdef __riscos
#include <swis.h>
#define alloca malloc /* FIXME: anyone know how to convince bison not to use alloca ()? */
#define DDEUtils_Prefix		0x42580
#define DDEUtils_ThrowbackStart	0x42587
#define DDEUtils_ThrowbackSend	0x42588
#define DDEUtils_ThrowbackEnd	0x42589
#endif

#ifndef OS_DIR_SEP
#if defined (MSDOS)
#define OS_DIR_SEP '\\'
#elif defined (__riscos)
#define OS_DIR_SEP '.'
#else
#define OS_DIR_SEP '/'
#endif
#endif

#ifndef OS_EXT_SEP
#if defined (__riscos)
#define OS_EXT_SEP '/'
#else
#define OS_EXT_SEP '.'
#endif
#endif

/*
 * DEBUG turns on pass reporting.
 * Macro debug and Token debug enables.
#define	DEBUG
#define	M_DEBUG
#define	T_DEBUG
 */

#define ITEMTABLESIZE	2000
#define TEMPBUFSIZE	200
#define LINEBUFFERSIZE	200
#define EMITBUFFERSIZE	200
#define MAXSYMBOLSIZE	40
#define IFSTACKSIZE	20
#define MAXIFS		1024
#define TITLELEN	50
#define BINPERLINE	16
#define	PARMMAX		25
#define MAXEXP		25
#define SYMMAJIC	07203
#define	NEST_IN		8


#define loop	for(;;)

void yyerror(char *err)
{}		/* we will do our own error printing */

struct	item	{
	char	*i_string;
	int	i_value;
	int	i_token;
	int	i_uses;
	int	i_equbad;
};

FILE	*fout,
	*fbuf,
	*fin[NEST_IN],
	*now_file ;

int	pass2;	/*set when pass one completed*/
int	dollarsign ;	/* location counter */
int	olddollar ;	/* kept to put out binary */

/* program counter save for PHASE/DEPHASE */
int	phdollar, phbegin, phaseflag ;

char	*src_name[NEST_IN] ;
int	linein[NEST_IN] ;
int	now_in ;

int	tokeninline = 0; /* FIXME: a bit of a nasty hack; can it be done more cleanly? */


#define bflag	0	/* balance error */
#define eflag	1	/* expression error */
#define fflag	2	/* format error */
#define iflag	3	/* bad digits */
#define mflag	4	/* multiply defined */
#define pflag	5	/* phase error */
#define uflag	6	/* undeclared used */
#define vflag	7	/* value out of range */
#define oflag	8	/* phase/dephase error */
#define frflag	9	/* double forward ref. via equ error */
#define zflag	10	/* Z80-only instruction (when `-z' option in use) */
#define orgflag 11	/* retrograde org error (when `-h' option not in use) */

#define FLAGS	12	/* number of flags */

char	err[FLAGS];
int	keeperr[FLAGS];
char	errlet[FLAGS]="BEFIMPUVORZG";
char	*errname[FLAGS]={
	"Balance",
	"Expression",
	"Format",
	"Digit",
	"Mult. def.",
	"Phase",
	"Undeclared",
	"Value",
	"Phase/Dephase",
	"Forward ref. to EQU with forward ref.",
	"Z80-specific instruction",
	"Retrograde ORG"
};
char	*warnname[]={
	"Symbol length exceeded",
	"Non-standard syntax",
	"Could replace JP with JR",
	"Could replace LD A, 0 with XOR A if flags unimportant",
	"Could replace RLC A with RLCA if S, Z and P/V flags unimportant",
	"Could replace RRC A with RRCA if S, Z and P/V flags unimportant",
	"Could replace RL A with RLA if S, Z and P/V flags unimportant",
	"Could replace RR A with RRA if S, Z and P/V flags unimportant",
	"Could replace SLA A with ADD A, A if H and P/V flags unimportant"
};

/* for "0 symbols", "1 symbol", "2 symbols", etc. */
#define DO_PLURAL(x)	(x),((x)==1)?"":"s"

char	linebuf[LINEBUFFERSIZE];
char	*lineptr;
char	*linemax = linebuf+LINEBUFFERSIZE;

char	outbin[BINPERLINE];
char	*outbinp = outbin;
char	*outbinm = outbin+BINPERLINE;

char	emitbuf[EMITBUFFERSIZE];
char	*emitptr;

char	ifstack[IFSTACKSIZE];
char	*ifptr;
char	*ifstmax = ifstack+IFSTACKSIZE-1;


char	expif[MAXIFS];
char	*expifp;
char	*expifmax = expif+MAXIFS;

char	hexadec[] = "0123456789ABCDEF" ;
char	*expstack[MAXEXP];
int	expptr;


int	nitems;
int	linecnt;
int	nbytes;
int	invented;


char	tempbuf[TEMPBUFSIZE];
char	*tempmax = tempbuf+TEMPBUFSIZE-1;

char	inmlex;
char	arg_flag;
char	quoteflag;
int	parm_number;
int	exp_number;
char	symlong[] = "Symbol too long";

int	disp;
#define FLOC	PARMMAX
#define TEMPNUM	PARMMAX+1
char	**est;
char	**est2;

char	*floc;
int	mfptr;
FILE	*mfile;


char	*title;
char	titlespace[TITLELEN];
char	*timp;
char	*sourcef;
/* changed to cope with filenames longer than 14 chars -rjm 1998-12-15 */
char	src[1024];
char	bin[1024];
char	mtmp[1024];
char	listf[1024];
char	writesyms[1024];
#ifdef __riscos
char	riscos_thbkf[1024];
#endif

char	bopt = 1,
	edef = 1,
	eopt = 1,
	fdef = 0,
	fopt = 0,
	gdef = 1,
	gopt = 1,
	iopt = 0 ,	/* list include files */
	lstoff = 0,
	lston = 0,	/* flag to force listing on */
	lopt = 0,
	mdef = 0,
	mopt = 0,
	nopt = 1,	/* line numbers on as default */
	oldoopt = 0,
	popt = 1,	/* form feed as default page eject */
	sopt = 0,	/* turn on symbol table listing */
	output_hex = 0,	/* `-h', output .hex rather than .bin -rjm */
	output_8080_only = 0,	/* `-z', output 8080-compat. ops only -rjm */
	show_error_line = 0,	/* `-S', show line which caused error -rjm */
	terse_lst_errors = 0,	/* `-t', terse errors in listing -rjm */
	continuous_listing = 1,	/* `-d', discontinuous - with page breaks */
	suggest_optimise = 0,	/* `-O', suggest optimisations -mgr */
#ifdef __riscos
	riscos_thbk = 0,	/* `-T', RISC OS throwback -mep */
#endif
	output_amsdos = 0,	/* `-A', AMSDOS binary file output -mep */
	saveopt;

char	xeq_flag = 0;
int	xeq;

time_t	now;
int	line;
int	page = 1;

int	had_errors = 0;		/* if program had errors, do exit(1) */
#ifdef __riscos
int	riscos_throwback_started = 0;
#endif
int	not_seen_org = 1;
int	first_org_store = 0;

struct stab {
	char	t_name[MAXSYMBOLSIZE+1];
	int	t_value;
	int	t_token;
};

/*
 *  push back character
 */
int	peekc;


/* function prototypes */
int addtoline(int ac);
int iflist(void);
int yylex(void);
int tokenofitem(int deftoken);
int nextchar(void);
int skipline(int ac);
void usage(void);
int main(int argc, char *argv[]);
int getarg(void);
int getm(void);
void yyerror(char *err);
void emit(int num, ...);
void emit1(int opcode,int regvalh,int data16,int type);
void emitdad(int rp1,int rp2);
void emitjr(int opcode,int expr);
void emitjp(int opcode,int expr);
void putbin(int v);
void flushbin(void);
void puthex(char byte, FILE *buf);
void list(int optarg);
void lineout(void);
void eject(void);
void space(int n);
void lsterr1(void);
void lsterr2(int lst);
void errorprt(int errnum);
void warnprt(int warnnum, int warnoff);
void list1(void);
void interchange(int i, int j);
void custom_qsort(int m, int n);
void setvars(void);
void error(char *as);
void fileerror(char *as,char *filename);
void justerror(char *as);
void putsymtab(void);
void erreport(void);
void mlex(void);
void suffix_if_none(char *str,char *suff);
void suffix(char *str,char *suff);
void decanonicalise(char *str);
void putm(char c);
void popsi(void);
char *getlocal(int c, int n);
void insymtab(char *name);
void outsymtab(char *name);
void copyname(char *st1, char *st2);
void next_source(char *sp);
void doatexit (void);
#ifdef __riscos
void riscos_set_csd(char *sp);
void riscos_throwback(int severity, char *file, int line, char *error);
#endif




/*
 *  add a character to the output line buffer
 */
int addtoline(int ac)
{
	/* check for EOF from stdio */
	if (ac == -1)
		ac = 0 ;
	if (inmlex)
		return(ac);
	if (lineptr >= linemax)
		error("line buffer overflow");
	*lineptr++ = ac;
	return(ac);
}


/*
 *  put values in buffer for outputing
 */

void emit(int bytes, ...)
{
	va_list ap;
	unsigned char *oldemitptr=(unsigned char *)emitptr;
	int c;

	va_start(ap,bytes);

	while	(--bytes >= 0)
		if (emitptr >= &emitbuf[EMITBUFFERSIZE])
			error("emit buffer overflow");
		else {
			*emitptr++ = va_arg(ap,int);
		}

	if (output_8080_only) {
		/* test for Z80-specific ops. These start with one of
		 * sixteen byte values, listed below. The values were
		 * taken from "A Z80 Workshop Manual" by E. A. Parr. -rjm
		 */
		/* As far as I can tell from my own literature
		 * review, 0x02, 0x0a, 0x12 and 0x1a are valid
		 * 8080 opcodes (LDAX/STAX B/D) -mgr
		 */
		c=*oldemitptr;
		if (/* c==0x02 || */ c==0x08 || /* c==0x0a || */ c==0x10 ||
		    /* c==0x12 || */ c==0x18 || /* c==0x1a || */ c==0x20 ||
		    c==0x28 || c==0x30 || c==0x38 || c==0xcb ||
		    c==0xd9 || c==0xdd || c==0xed || c==0xfd)
			err[zflag]++;
	}

	va_end(ap);
}

/* for emitted data - as above, without 8080 test.
 * Duplicating the code was easier than putting an extra arg in all
 * those emit()s. :-} Hopefully this isn't too unbearably nasty. -rjm
 */
void dataemit(int bytes, ...)
{
	va_list ap;

	va_start(ap,bytes);

	while	(--bytes >= 0)
		if (emitptr >= &emitbuf[EMITBUFFERSIZE])
			error("emit buffer overflow");
		else {
			*emitptr++ = va_arg(ap,int);
		}
	va_end(ap);
}


void emit1(int opcode,int regvalh,int data16,int type)
{
	if ((regvalh & 0x8000)) {	/* extra brackets to silence -Wall */
		if ((type & 1) == 0 && (disp > 127 || disp < -128))
			err[vflag]++;
		switch(type) {
		case 0:
			if (opcode & 0x8000)
				emit(4, regvalh >> 8, opcode >> 8, disp, opcode);
			else
				emit(3, regvalh >> 8, opcode, disp);
			break;
		case 1:
			emit(2, regvalh >> 8, opcode);
			break;
		case 2:
			if (data16 > 255 || data16 < -128)
				err[vflag]++;
			emit(4, regvalh >> 8, opcode, disp, data16);
			break;
		case 5:
			emit(4, regvalh >> 8, opcode, data16, data16 >> 8);
		}
	} else
		switch(type) {
		case 0:
			if (opcode & 0100000)
				emit(2, opcode >> 8, opcode);
			else
				emit(1, opcode);
			break;
		case 1:
			if (opcode & 0100000)
				emit(2, opcode >> 8, opcode);
			else
				emit(1, opcode);
			break;
		case 2:
			if (data16 > 255 || data16 < -128)
				err[vflag]++;
			emit(2, opcode, data16);
			break;
		case 3:
			if (data16 >255 || data16 < -128)
				err[vflag]++;
			emit(2, opcode, data16);
			break;
		case 5:
			if (opcode & 0100000)
				emit(4, opcode >> 8, opcode, data16, data16 >> 8);
			else
				emit(3, opcode, data16, data16 >> 8);
		}
}




void emitdad(int rp1,int rp2)
{
	if (rp1 & 0x8000)
		emit(2,rp1 >> 8, rp2 + 9);
	else
		emit(1,rp2 + 9);
}


void emitjr(int opcode,int expr)
{
	disp = expr - dollarsign - 2;
	if (disp > 127 || disp < -128)
		err[vflag]++;
	emit(2, opcode, disp);
}



void emitjp(int opcode,int expr)
{
	if (suggest_optimise && pass2 && opcode <= 0xda && !output_8080_only) {
		disp = expr - dollarsign - 2;
		if (disp <= 127 && disp >= -128)
			warnprt (2, 0);
	}
	emit(3, opcode, expr, expr >> 8);
}




/*
 *  put out a byte of binary
 */
void putbin(int v)
{
	if(!pass2 || !bopt) return;
	*outbinp++ = v;
	if (outbinp >= outbinm) flushbin();
}



/*
 *  output one line of binary in INTEL standard form
 */
void flushbin()
{
	char *p;
	int check=outbinp-outbin;

	if (!pass2 || !bopt)
		return;
	nbytes += check;
	if (check) {
		if (output_hex) {
			putc(':', fbuf);
			puthex(check, fbuf);
			puthex(olddollar>>8, fbuf);
			puthex(olddollar, fbuf);
			puthex(0, fbuf);
		}
		check += (olddollar >> 8) + olddollar;
		olddollar += (outbinp-outbin);
		for (p=outbin; p<outbinp; p++) {
			if (output_hex)
				puthex(*p, fbuf);
			else
				fputc(*p, fbuf);
			check += *p;
		}
		if (output_hex) {
			puthex(256-check, fbuf);
			putc('\n', fbuf);
		}
		outbinp = outbin;
	}
}



/*
 *  put out one byte of hex
 */
void puthex(char byte, FILE *buf)
{
	putc(hexadec[(byte >> 4) & 017], buf);
	putc(hexadec[byte & 017], buf);
}

/*
 *  put out a line of output -- also put out binary
 */
void list(int optarg)
{
	char *	p;
	int	i;
	int  lst;

	if (!expptr)
		linecnt++;
	addtoline('\0');
	if (pass2) {
		lst = iflist();
		if (lst) {
			lineout();
			if (nopt)
				fprintf(fout, "%4d:\t", linein[now_in]);
			puthex(optarg >> 8, fout);
			puthex(optarg, fout);
			fputs("  ", fout);
			for (p = emitbuf; (p < emitptr) && (p - emitbuf < 4); p++) {
				puthex(*p, fout);
			}
			for (i = 4 - (p-emitbuf); i > 0; i--)
				fputs("  ", fout);
			putc('\t', fout);
			fputs(linebuf, fout);
		}

		if (bopt) {
			for (p = emitbuf; p < emitptr; p++)
				putbin(*p);
		}


		p = emitbuf+4;
		while (lst && gopt && p < emitptr) {
			lineout();
			if (nopt) putc('\t', fout);
			fputs("      ", fout);
			for (i = 0; (i < 4) && (p < emitptr);i++) {
				puthex(*p, fout);
				p++;
			}
			putc('\n', fout);
		}


		lsterr2(lst);
	} else
		lsterr1();
	dollarsign += emitptr - emitbuf;
	emitptr = emitbuf;
	lineptr = linebuf;
}



/*
 *  keep track of line numbers and put out headers as necessary
 */
void lineout()
{
	if (continuous_listing) {
		line = 1;
		return;
	}
	if (line == 60) {
		if (popt)
			putc('\014', fout);	/* send the form feed */
		else
			fputs("\n\n\n\n\n", fout);
		line = 0;
	}
	if (line == 0) {
		fprintf(fout, "\n\n%s %s\t%s\t Page %d\n\n\n",
			&timp[4], &timp[20], title, page++);
		line = 4;
	}
	line++;
}


/*
 *  cause a page eject
 */
void eject()
{
	if (pass2 && !continuous_listing && iflist()) {
		if (popt) {
			putc('\014', fout);	/* send the form feed */
		} else {
			while (line < 65) {
				line++;
				putc('\n', fout);
			}
		}
	}
	line = 0;
}


/*
 *  space n lines on the list file
 */
void space(int n)
{
	int	i ;
	if (pass2 && iflist())
		for (i = 0; i<n; i++) {
			lineout();
			putc('\n', fout);
		}
}


/*
 *  Error handling - pass 1
 */
void lsterr1()
{
	int i;
	for (i = 0; i <= 4; i++)
		if (err[i]) {
			errorprt(i);
			err[i] = 0;
		}
}


/*
 *  Error handling - pass 2.
 */
void lsterr2(int lst)
{
	int i;
	for (i=0; i<FLAGS; i++)
		if (err[i]) {
			if (lst) {
				lineout();
				/* verbose inline error messages now,
				 * must override with `-t' to get old
				 * behaviour. -rjm
				 */
				if (terse_lst_errors)
					putc(errlet[i], fout);
				else
					fprintf(fout,"*** %s error ***",
							errname[i]);
				putc('\n', fout);
			}
			err[i] = 0;
			keeperr[i]++;
			if (i > 4)
				errorprt(i);
		}

	fflush(fout);	/*to avoid putc(har) mix bug*/
}

/*
 *  print diagnostic to error terminal
 */
void errorprt(int errnum)
{
	had_errors=1;
	fprintf(stderr,"%s:%d: %s error\n",
		src_name[now_in], linein[now_in], errname[errnum]);
	if(show_error_line)
		fprintf(stderr, "%s\n", linebuf);
#ifdef __riscos
	if (riscos_thbk)
		riscos_throwback (1, src_name[now_in], linein[now_in], errname[errnum]);
#endif
}


/*
 *  print warning to error terminal
 */
void warnprt(int warnnum, int warnoff)
{
	fprintf(stderr,"%s:%d: warning: %s\n",
		src_name[now_in], linein[now_in] + warnoff, warnname[warnnum]);
		/* Offset needed if warning issued while line is being parsed */
#ifdef __riscos
	if (riscos_thbk)
		riscos_throwback (0, src_name[now_in], linein[now_in] + warnoff, warnname[warnnum]);
#endif
	/* if(show_error_line)
		Can't show line because it isn't necessarily complete
		fprintf(stderr, "%s\n", linebuf); */
}


/*
 *  list without address -- for comments and if skipped lines
 */
void list1()
{
	int lst;

	addtoline('\0');
	lineptr = linebuf;
	if (!expptr) linecnt++;
	if (pass2)
	{
		if ((lst = iflist())) {
			lineout();
			if (nopt)
				fprintf(fout, "%4d:\t", linein[now_in]);
			fprintf(fout, "\t\t%s", linebuf);
			lsterr2(lst);
		}
	} else
		lsterr1();
}


/*
 *  see if listing is desired
 */
int iflist()
{
	int i, j;

	if (lston)
		return(1) ;
	if (lopt)
		return(0);
	if (*ifptr && !fopt)
		return(0);
	if (!lstoff && !expptr)
		return(1);
	j = 0;
	for (i=0; i<FLAGS; i++)
		if (err[i])
			j++;
	if (expptr)
		return(mopt || j);
	if (eopt && j)
		return(1);
	return(0);
}


/* moved out of %{..%} bit in parse routine because `bison -y'
 * didn't like it... -rjm
 */
char  *cp;

int list_tmp1,list_tmp2;
int equ_bad_label=0;


#line 826 "zmac.y"
typedef union	{
	struct item *itemptr;
	int ival;
	char *cval;
	} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		296
#define	YYFLAG		-32768
#define	YYNTBASE	87

#define YYTRANSLATE(x) ((unsigned)(x) <= 324 ? yytranslate[x] : 119)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    77,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,    84,     2,    71,    83,    81,
    82,    74,    72,    78,    73,    79,    75,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    80,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    85,     2,    86,    70,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    69,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    76
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     4,     6,     9,    12,    15,    19,    24,    29,
    36,    40,    43,    46,    50,    55,    60,    66,    71,    74,
    78,    83,    86,    92,    93,    96,    99,   101,   104,   107,
   110,   113,   118,   121,   126,   129,   134,   137,   142,   145,
   150,   153,   158,   161,   164,   169,   174,   179,   182,   185,
   190,   195,   200,   205,   208,   213,   216,   218,   221,   226,
   231,   238,   243,   250,   255,   260,   265,   270,   275,   280,
   285,   290,   298,   305,   310,   317,   324,   329,   336,   339,
   342,   344,   347,   350,   353,   355,   356,   358,   362,   364,
   365,   367,   371,   373,   375,   377,   379,   381,   383,   387,
   392,   396,   398,   400,   402,   404,   406,   408,   410,   412,
   414,   416,   418,   420,   422,   424,   426,   428,   432,   434,
   436,   438,   440,   444,   446,   448,   450,   454,   456,   458,
   460,   462,   464,   466,   468,   470,   472,   474,   478,   482,
   486,   490,   494,   498,   502,   506,   510,   514,   518,   521,
   524,   527,   529,   531,   533,   535,   537,   539,   540,   541,
   542,   543
};

static const short yyrhs[] = {    88,
     0,     1,     0,    89,     0,    88,    89,     0,    88,     1,
     0,    90,    77,     0,    90,    91,    77,     0,   113,    44,
   112,    77,     0,   113,    45,   112,    77,     0,   113,    60,
   112,    78,   112,    77,     0,    55,   112,    77,     0,    56,
    77,     0,    57,    77,     0,    90,    39,    77,     0,    90,
    39,   112,    77,     0,    90,    42,   112,    77,     0,    58,
   115,    64,   116,    77,     0,    58,   115,    77,   116,     0,
    59,    77,     0,    59,   112,    77,     0,    38,    61,    92,
    77,     0,    63,    61,     0,    90,    62,   114,    94,    77,
     0,     0,    79,   113,     0,   113,    80,     0,     4,     0,
    17,   112,     0,     9,   112,     0,    24,   112,     0,     6,
   112,     0,     6,    26,    78,   112,     0,     5,   112,     0,
     5,    26,    78,   112,     0,     7,   112,     0,     7,    26,
    78,   112,     0,     6,    96,     0,     6,    26,    78,    96,
     0,     5,    96,     0,     5,    26,    78,    96,     0,     7,
    96,     0,     7,    26,    78,    96,     0,    23,    96,     0,
    10,    96,     0,     5,    29,    78,   102,     0,     6,   103,
    78,   101,     0,     6,   103,    78,   103,     0,    10,    99,
     0,    21,   100,     0,     8,   112,    78,    96,     0,    17,
   104,    78,   112,     0,    17,    81,   103,    82,     0,     9,
   104,    78,   112,     0,    18,   112,     0,    18,   105,    78,
   112,     0,    11,   112,     0,    22,     0,    22,   104,     0,
    19,    96,    78,    96,     0,    19,    96,    78,   112,     0,
    19,    96,    78,    81,    28,    82,     0,    19,    96,    78,
   111,     0,    19,    81,    28,    82,    78,    26,     0,    19,
   111,    78,    26,     0,    19,    96,    78,    33,     0,    19,
    33,    78,    26,     0,    19,    99,    78,   110,     0,    19,
    99,    78,   111,     0,    19,   111,    78,    99,     0,    19,
    99,    78,   103,     0,    12,    28,    78,    29,     0,    12,
    31,    78,    31,   117,    83,   118,     0,    12,    81,    32,
    82,    78,   103,     0,    16,    97,    78,   111,     0,    16,
    97,    78,    81,    27,    82,     0,    16,    34,    78,    81,
    27,    82,     0,    20,   111,    78,    26,     0,    20,    81,
    27,    82,    78,    97,     0,    13,   112,     0,    14,   112,
     0,    15,     0,    40,   112,     0,    41,   106,     0,    43,
   108,     0,    65,     0,     0,    93,     0,    92,    78,    93,
     0,    38,     0,     0,    95,     0,    94,    78,    95,     0,
    64,     0,    97,     0,    98,     0,    25,     0,    26,     0,
    27,     0,    81,    29,    82,     0,    81,    30,   112,    82,
     0,    81,    30,    82,     0,   101,     0,   103,     0,    28,
     0,    31,     0,   103,     0,    28,     0,    32,     0,   101,
     0,    29,     0,    29,     0,    30,     0,   105,     0,    35,
     0,    36,     0,    27,     0,   107,     0,   106,    78,   107,
     0,    68,     0,     3,     0,   112,     0,   109,     0,   108,
    78,   109,     0,   112,     0,   112,     0,    68,     0,    81,
   112,    82,     0,     1,     0,    46,     0,    37,     0,    67,
     0,    47,     0,    48,     0,    49,     0,    84,     0,    38,
     0,    50,     0,   112,    72,   112,     0,   112,    73,   112,
     0,   112,    75,   112,     0,   112,    74,   112,     0,   112,
    51,   112,     0,   112,    71,   112,     0,   112,    69,   112,
     0,   112,    70,   112,     0,   112,    52,   112,     0,   112,
    53,   112,     0,    85,   112,    86,     0,    54,   112,     0,
    72,   112,     0,    73,   112,     0,    38,     0,    46,     0,
    50,     0,    47,     0,    48,     0,    49,     0,     0,     0,
     0,     0,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   911,   913,   918,   920,   922,   934,   939,   943,   970,   983,
   998,  1024,  1033,  1039,  1044,  1051,  1070,  1107,  1113,  1119,
  1167,  1176,  1189,  1205,  1208,  1231,  1257,  1260,  1263,  1266,
  1278,  1281,  1284,  1287,  1290,  1293,  1296,  1299,  1302,  1305,
  1308,  1311,  1314,  1323,  1326,  1333,  1336,  1345,  1348,  1351,
  1358,  1361,  1364,  1367,  1370,  1373,  1376,  1379,  1382,  1391,
  1398,  1406,  1415,  1418,  1421,  1430,  1433,  1436,  1444,  1452,
  1462,  1472,  1475,  1478,  1491,  1494,  1497,  1504,  1507,  1515,
  1527,  1537,  1563,  1565,  1567,  1572,  1573,  1575,  1580,  1591,
  1593,  1595,  1600,  1608,  1610,  1613,  1618,  1623,  1629,  1634,
  1640,  1647,  1649,  1652,  1657,  1662,  1665,  1670,  1676,  1678,
  1684,  1689,  1695,  1697,  1703,  1708,  1712,  1714,  1717,  1722,
  1729,  1739,  1741,  1746,  1755,  1757,  1761,  1766,  1772,  1775,
  1777,  1779,  1782,  1794,  1797,  1800,  1807,  1810,  1813,  1816,
  1819,  1822,  1825,  1828,  1831,  1834,  1837,  1840,  1843,  1846,
  1849,  1854,  1856,  1858,  1860,  1862,  1864,  1869,  1882,  1886,
  1890,  1894
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","STRING",
"NOOPERAND","ARITHC","ADD","LOGICAL","BIT","CALL","INCDEC","DJNZ","EX","IM",
"PHASE","DEPHASE","IN","JP","JR","LD","OUT","PUSHPOP","RET","SHIFT","RST","REGNAME",
"ACC","C","RP","HL","INDEX","AF","SP","MISCREG","F","COND","SPCOND","NUMBER",
"UNDECLARED","END","ORG","DEFB","DEFS","DEFW","EQU","DEFL","LABEL","EQUATED",
"WASEQUATED","DEFLED","MULTDEF","MOD","SHL","SHR","NOT","IF","ELSE","ENDIF",
"ARGPSEUDO","LIST","MINMAX","MACRO","MNAME","OLDMNAME","ARG","ENDM","MPARM",
"ONECHAR","TWOCHAR","'|'","'^'","'&'","'+'","'-'","'*'","'/'","UNARY","'\\n'",
"','","'.'","':'","'('","')'","'''","'$'","'['","']'","program","statements",
"statement","label.part","operation","parm.list","parm.element","arg.list","arg.element",
"reg","realreg","mem","evenreg","pushable","bcdesp","bcdehlsp","mar","condition",
"spcondition","db.list","db.list.element","dw.list","dw.list.element","lxexpression",
"parenexpr","expression","symbol","al","arg_on","arg_off","setqf","clrqf", NULL
};
#endif

static const short yyr1[] = {     0,
    87,    87,    88,    88,    88,    89,    89,    89,    89,    89,
    89,    89,    89,    89,    89,    89,    89,    89,    89,    89,
    89,    89,    89,    90,    90,    90,    91,    91,    91,    91,
    91,    91,    91,    91,    91,    91,    91,    91,    91,    91,
    91,    91,    91,    91,    91,    91,    91,    91,    91,    91,
    91,    91,    91,    91,    91,    91,    91,    91,    91,    91,
    91,    91,    91,    91,    91,    91,    91,    91,    91,    91,
    91,    91,    91,    91,    91,    91,    91,    91,    91,    91,
    91,    91,    91,    91,    91,    92,    92,    92,    93,    94,
    94,    94,    95,    96,    96,    97,    97,    97,    98,    98,
    98,    99,    99,   100,   100,   100,   101,   101,   102,   102,
   103,   103,   104,   104,   105,   105,   106,   106,   107,   107,
   107,   108,   108,   109,   110,   110,   111,   112,   112,   112,
   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
   112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
   112,   113,   113,   113,   113,   113,   113,   114,   115,   116,
   117,   118
};

static const short yyr2[] = {     0,
     1,     1,     1,     2,     2,     2,     3,     4,     4,     6,
     3,     2,     2,     3,     4,     4,     5,     4,     2,     3,
     4,     2,     5,     0,     2,     2,     1,     2,     2,     2,
     2,     4,     2,     4,     2,     4,     2,     4,     2,     4,
     2,     4,     2,     2,     4,     4,     4,     2,     2,     4,
     4,     4,     4,     2,     4,     2,     1,     2,     4,     4,
     6,     4,     6,     4,     4,     4,     4,     4,     4,     4,
     4,     7,     6,     4,     6,     6,     4,     6,     2,     2,
     1,     2,     2,     2,     1,     0,     1,     3,     1,     0,
     1,     3,     1,     1,     1,     1,     1,     1,     3,     4,
     3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
     1,     1,     3,     1,     1,     1,     3,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
     2,     1,     1,     1,     1,     1,     1,     0,     0,     0,
     0,     0
};

static const short yydefact[] = {     0,
     2,   152,   153,   155,   156,   157,   154,     0,     0,     0,
   159,     0,     0,     0,     0,     3,     0,     0,    86,   128,
   130,   136,   129,   132,   133,   134,   137,     0,   131,     0,
     0,   135,     0,     0,    12,    13,     0,    19,     0,    22,
   152,    25,     5,     4,    27,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    81,     0,     0,     0,     0,
     0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
   158,    85,     6,     0,     0,     0,     0,    26,    89,     0,
    87,   149,   150,   151,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    11,   160,   160,    20,    96,
    97,    98,     0,     0,    39,    94,    95,    33,    97,   111,
   112,    37,     0,    31,    97,    41,    35,     0,   116,   114,
   115,     0,   113,    29,    97,   107,   108,    44,    48,   102,
   103,    56,     0,     0,     0,    79,    80,     0,     0,     0,
     0,    28,     0,    54,     0,     0,     0,     0,     0,     0,
     0,   104,   105,    49,   106,    58,    43,    30,    14,     0,
    82,   120,   119,    83,   117,   121,     0,    84,   122,   124,
    90,     7,     0,     0,     0,    21,     0,   148,   142,   146,
   147,   144,   145,   143,   138,   139,   141,   140,     0,    18,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    15,     0,    16,     0,    93,
     0,    91,     8,     9,     0,    88,    17,    40,    34,   110,
   109,    45,    99,   101,     0,    38,    32,    46,    47,    42,
    36,    50,    53,    71,   161,     0,     0,     0,    74,    52,
    51,    55,    66,     0,   127,    65,     0,    59,    62,    60,
   126,     0,    70,    67,    68,   125,    64,    69,     0,    77,
   118,   123,    23,     0,     0,   100,     0,     0,     0,     0,
     0,     0,     0,    92,    10,   162,    73,    76,    75,    63,
    61,    78,    72,     0,     0,     0
};

static const short yydefgoto[] = {   294,
    15,    16,    17,    74,    80,    81,   221,   222,   105,   106,
   107,   129,   154,   130,   232,   131,   122,   123,   164,   165,
   168,   169,   264,   149,   210,    18,   171,    37,   189,   277,
   293
};

static const short yypact[] = {   826,
-32768,   -53,-32768,-32768,-32768,-32768,-32768,   667,   -20,   -12,
-32768,    57,     7,   -17,   749,-32768,   902,   -26,    40,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   667,-32768,   667,
   667,-32768,   667,   827,-32768,-32768,   -51,-32768,   929,-32768,
-32768,-32768,-32768,-32768,-32768,   191,    89,   256,   667,   414,
    47,   667,   -14,   667,   667,-32768,    11,   297,   511,   151,
    21,   166,    20,   -15,   667,   554,   667,   539,   667,   667,
-32768,-32768,-32768,    36,   667,   667,   667,-32768,-32768,   -27,
-32768,    48,-32768,-32768,   352,   667,   667,   667,   667,   667,
   667,   667,   667,   667,   667,-32768,-32768,-32768,-32768,-32768,
    39,-32768,    55,    62,-32768,-32768,-32768,   750,    68,-32768,
-32768,-32768,    72,   750,    77,-32768,   750,   658,-32768,-32768,
-32768,    79,-32768,   750,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,   750,    88,    90,    93,   750,   750,    91,    94,   102,
    97,   750,   104,   750,   108,   447,   109,   112,   120,   598,
   121,-32768,-32768,-32768,-32768,-32768,-32768,   750,-32768,   956,
   750,-32768,-32768,   124,-32768,   750,   965,   125,-32768,   750,
    76,-32768,   992,  1001,   917,-32768,    40,-32768,-32768,-32768,
-32768,   315,   315,    48,   172,   172,-32768,-32768,   127,-32768,
   347,   116,   126,   612,   347,    80,   347,   -15,   667,   142,
   176,   128,   131,   133,   139,   667,   667,   183,   140,   877,
   241,   362,   222,   144,   189,-32768,   539,-32768,   667,-32768,
    86,-32768,-32768,-32768,   667,-32768,-32768,-32768,   750,-32768,
-32768,-32768,-32768,-32768,   903,-32768,   750,-32768,-32768,-32768,
   750,-32768,   750,-32768,-32768,   152,   206,   653,-32768,-32768,
   750,   750,-32768,   156,-32768,-32768,   479,-32768,-32768,   750,
-32768,   667,-32768,-32768,-32768,   750,-32768,-32768,   157,-32768,
-32768,-32768,-32768,    76,  1028,-32768,   153,   102,   161,   162,
   223,   171,    71,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,   255,   259,-32768
};

static const short yypgoto[] = {-32768,
-32768,   245,-32768,-32768,-32768,    84,-32768,   -18,   -44,   -56,
-32768,   -55,-32768,  -157,-32768,   -47,   -35,   203,-32768,    52,
-32768,    46,-32768,   -52,    -6,   257,-32768,-32768,   175,-32768,
-32768
};


#define	YYLAST		1105


static const short yytable[] = {   113,
   139,    34,   112,   116,   148,    39,   128,    19,   151,   100,
   125,   102,    97,   133,   155,   147,   134,    75,    76,   157,
    41,    82,   141,    83,    84,    98,    85,   156,     3,     4,
     5,     6,     7,    77,   231,   100,   125,   102,   238,   108,
   114,   117,   118,   124,   138,   132,   119,   136,   137,   176,
   177,   142,   144,    78,   120,   121,    35,    20,   158,   160,
   161,   166,   167,   170,    36,   104,   135,    40,   173,   174,
   175,   100,   125,   102,   126,   110,   111,    79,   127,   179,
   180,   181,   182,   183,   184,   185,   186,   187,   188,    20,
   193,   194,   205,    21,    22,   100,   125,   102,    86,    87,
    88,   150,    23,    24,    25,    26,    27,   126,   110,   111,
    28,   127,   172,   100,   109,   102,   191,   110,   111,    92,
    93,    94,    95,    29,   202,    21,    22,   104,    30,    31,
   110,   111,   192,    38,    23,    24,    25,    26,    27,   220,
    32,    33,    28,   126,   230,   195,   228,   127,   239,   196,
   236,   249,   240,   242,   197,    29,   199,   268,   259,   265,
    30,    31,   273,   274,   263,   200,   258,   201,   203,   104,
   244,   204,    32,    33,   206,   100,   125,   102,   126,   110,
   111,   207,   127,   145,   229,   208,   211,   235,   237,   212,
   241,    20,   243,   152,   110,   111,   153,   213,   215,   251,
   252,   217,   219,   227,   260,   266,   245,   233,   253,   246,
   166,   247,   170,   248,   270,   100,   101,   102,   275,   103,
   250,   254,    86,    87,    88,   269,   292,    21,    22,   278,
   287,   146,   279,   281,   283,   286,    23,    24,    25,    26,
    27,    20,   288,   289,    28,    94,    95,   267,   290,   126,
   110,   111,   291,   127,   295,   284,    20,    29,   296,    44,
   226,   143,    30,    31,   272,   100,   125,   102,   271,     0,
    42,   104,   190,   256,    32,    33,     0,    21,    22,     0,
   100,   115,   102,     0,     0,     0,    23,    24,    25,    26,
    27,     0,    21,    22,    28,     0,     0,    20,     0,     0,
     0,    23,    24,    25,    26,    27,     0,    29,     0,    28,
     0,     0,    30,    31,     0,     0,     0,     0,     0,     0,
     0,   257,    29,   119,    32,    33,     0,    30,    31,     0,
     0,   120,   121,    21,    22,     0,   104,     0,     0,    32,
    33,     0,    23,    24,    25,    26,    27,    20,     0,     0,
    28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    20,    29,     0,    86,    87,    88,    30,    31,
     0,   100,   125,   102,     0,     0,     0,   140,     0,     0,
    32,    33,     0,    21,    22,    91,    92,    93,    94,    95,
   110,   111,    23,    24,    25,    26,    27,     0,    21,    22,
    28,     0,    86,    87,    88,     0,     0,    23,    24,    25,
    26,    27,     0,    29,    20,    28,     0,     0,    30,    31,
    89,    90,    91,    92,    93,    94,    95,   104,    29,   261,
    32,    33,     0,    30,    31,     0,     0,   178,     0,     0,
   119,     0,   262,     0,     0,    32,    33,    20,   120,   121,
    21,    22,     0,     0,     0,     0,     0,     0,     0,    23,
    24,    25,    26,    27,     0,     0,     0,    28,     0,     0,
     0,     0,     0,     0,   209,   193,   194,     0,     0,    20,
    29,     0,     0,    21,    22,    30,    31,     0,     0,     0,
     0,     0,    23,    24,    25,    26,    27,    32,    33,     0,
    28,     0,     0,     0,     0,     0,   282,   193,   194,     0,
     0,    20,     0,    29,     0,    21,    22,     0,    30,    31,
     0,     0,     0,     0,    23,    24,    25,    26,    27,     0,
    32,    33,    28,     0,     0,     0,     0,   119,     0,    20,
     0,   162,     0,     0,     0,    29,   121,    21,    22,     0,
    30,    31,     0,     0,    20,     0,    23,    24,    25,    26,
    27,     0,    32,    33,    28,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    21,    22,    29,     0,     0,
     0,     0,    30,    31,    23,    24,    25,    26,    27,     0,
    21,    22,    28,     0,    32,    33,     0,     0,    20,    23,
    24,    25,    26,    27,     0,    29,   163,    28,     0,     0,
    30,    31,    20,     0,     0,     0,     0,     0,     0,     0,
    29,     0,    32,    33,   214,    30,    31,     0,     0,     0,
   159,     0,     0,     0,    21,    22,     0,    32,    33,     0,
     0,     0,     0,    23,    24,    25,    26,    27,    21,    22,
     0,    28,     0,    20,     0,     0,     0,    23,    24,    25,
    26,    27,     0,     0,    29,    28,     0,    20,     0,    30,
    31,     0,     0,     0,     0,     0,     0,     0,    29,   280,
     0,    32,    33,    30,    31,     0,     0,     0,     0,    21,
    22,     0,     0,   234,     0,    32,    33,     0,    23,    24,
    25,    26,    27,    21,    22,     0,    28,     0,    86,    87,
    88,     0,    23,    24,    25,    26,    27,     0,     0,    29,
    28,     0,     0,     0,    30,    31,    89,    90,    91,    92,
    93,    94,    95,    29,     0,   198,    32,    33,    30,    31,
     0,     0,     0,     0,     0,     0,     0,     0,    -1,    43,
    32,    33,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,
   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,
   -24,   -24,   -24,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     2,   -24,   -24,   -24,
   -24,   -24,     0,     0,     3,     4,     5,     6,     7,     0,
    86,    87,    88,     8,     9,    10,    11,    12,     0,     0,
   -24,    13,     0,   -24,     0,     0,     0,     0,    89,    90,
    91,    92,    93,    94,    95,   -24,     1,    14,     0,   -24,
   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,
   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -24,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     2,   -24,   -24,   -24,   -24,   -24,     0,
     0,     3,     4,     5,     6,     7,     0,    86,    87,    88,
     8,     9,    10,    11,    12,     0,     0,   -24,    13,     0,
   -24,     0,     0,     0,     0,    89,    90,    91,    92,    93,
    94,    95,   -24,    96,    14,    45,    46,    47,    48,    49,
    50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
    60,    61,    62,    63,    64,    65,     0,    86,    87,    88,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    66,    67,    68,    69,    70,    89,    90,    91,    92,    93,
    94,    95,     0,    86,    87,    88,     0,     0,   255,     0,
     0,     0,     0,    71,     0,     0,    72,    86,    87,    88,
     0,    89,    90,    91,    92,    93,    94,    95,    73,    86,
    87,    88,     0,     0,   276,    89,    90,    91,    92,    93,
    94,    95,     0,     0,   225,     0,     0,    89,    90,    91,
    92,    93,    94,    95,     0,    99,    86,    87,    88,     0,
     0,     0,     0,     0,     0,    86,    87,    88,     0,     0,
     0,     0,     0,     0,    89,    90,    91,    92,    93,    94,
    95,     0,   216,    89,    90,    91,    92,    93,    94,    95,
     0,   218,    86,    87,    88,     0,     0,     0,     0,     0,
     0,    86,    87,    88,     0,     0,     0,     0,     0,     0,
    89,    90,    91,    92,    93,    94,    95,     0,   223,    89,
    90,    91,    92,    93,    94,    95,     0,   224,    86,    87,
    88,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    89,    90,    91,    92,
    93,    94,    95,     0,   285
};

static const short yycheck[] = {    47,
    57,     8,    47,    48,    60,    12,    51,    61,    61,    25,
    26,    27,    64,    28,    62,    60,    31,    44,    45,    64,
    38,    28,    58,    30,    31,    77,    33,    63,    46,    47,
    48,    49,    50,    60,   192,    25,    26,    27,   196,    46,
    47,    48,    49,    50,    34,    52,    27,    54,    55,    77,
    78,    58,    59,    80,    35,    36,    77,     1,    65,    66,
    67,    68,    69,    70,    77,    81,    81,    61,    75,    76,
    77,    25,    26,    27,    28,    29,    30,    38,    32,    86,
    87,    88,    89,    90,    91,    92,    93,    94,    95,     1,
    29,    30,   140,    37,    38,    25,    26,    27,    51,    52,
    53,    81,    46,    47,    48,    49,    50,    28,    29,    30,
    54,    32,    77,    25,    26,    27,    78,    29,    30,    72,
    73,    74,    75,    67,    32,    37,    38,    81,    72,    73,
    29,    30,    78,    77,    46,    47,    48,    49,    50,    64,
    84,    85,    54,    28,    29,    78,   191,    32,   196,    78,
   195,   204,   197,   198,    78,    67,    78,   213,   211,   212,
    72,    73,    77,    78,   212,    78,   211,    78,    78,    81,
    29,    78,    84,    85,    78,    25,    26,    27,    28,    29,
    30,    78,    32,    33,   191,    78,    78,   194,   195,    78,
   197,     1,   199,    28,    29,    30,    31,    78,    78,   206,
   207,    78,    78,    77,   211,   212,    31,    82,    26,    82,
   217,    81,   219,    81,    26,    25,    26,    27,   225,    29,
    82,    82,    51,    52,    53,    82,   283,    37,    38,    78,
   278,    81,    27,    78,    78,    83,    46,    47,    48,    49,
    50,     1,    82,    82,    54,    74,    75,    26,    26,    28,
    29,    30,    82,    32,     0,   274,     1,    67,     0,    15,
   177,    59,    72,    73,   219,    25,    26,    27,   217,    -1,
    14,    81,    98,    33,    84,    85,    -1,    37,    38,    -1,
    25,    26,    27,    -1,    -1,    -1,    46,    47,    48,    49,
    50,    -1,    37,    38,    54,    -1,    -1,     1,    -1,    -1,
    -1,    46,    47,    48,    49,    50,    -1,    67,    -1,    54,
    -1,    -1,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    81,    67,    27,    84,    85,    -1,    72,    73,    -1,
    -1,    35,    36,    37,    38,    -1,    81,    -1,    -1,    84,
    85,    -1,    46,    47,    48,    49,    50,     1,    -1,    -1,
    54,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,     1,    67,    -1,    51,    52,    53,    72,    73,
    -1,    25,    26,    27,    -1,    -1,    -1,    81,    -1,    -1,
    84,    85,    -1,    37,    38,    71,    72,    73,    74,    75,
    29,    30,    46,    47,    48,    49,    50,    -1,    37,    38,
    54,    -1,    51,    52,    53,    -1,    -1,    46,    47,    48,
    49,    50,    -1,    67,     1,    54,    -1,    -1,    72,    73,
    69,    70,    71,    72,    73,    74,    75,    81,    67,    68,
    84,    85,    -1,    72,    73,    -1,    -1,    86,    -1,    -1,
    27,    -1,    81,    -1,    -1,    84,    85,     1,    35,    36,
    37,    38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,
    47,    48,    49,    50,    -1,    -1,    -1,    54,    -1,    -1,
    -1,    -1,    -1,    -1,    28,    29,    30,    -1,    -1,     1,
    67,    -1,    -1,    37,    38,    72,    73,    -1,    -1,    -1,
    -1,    -1,    46,    47,    48,    49,    50,    84,    85,    -1,
    54,    -1,    -1,    -1,    -1,    -1,    28,    29,    30,    -1,
    -1,     1,    -1,    67,    -1,    37,    38,    -1,    72,    73,
    -1,    -1,    -1,    -1,    46,    47,    48,    49,    50,    -1,
    84,    85,    54,    -1,    -1,    -1,    -1,    27,    -1,     1,
    -1,     3,    -1,    -1,    -1,    67,    36,    37,    38,    -1,
    72,    73,    -1,    -1,     1,    -1,    46,    47,    48,    49,
    50,    -1,    84,    85,    54,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    37,    38,    67,    -1,    -1,
    -1,    -1,    72,    73,    46,    47,    48,    49,    50,    -1,
    37,    38,    54,    -1,    84,    85,    -1,    -1,     1,    46,
    47,    48,    49,    50,    -1,    67,    68,    54,    -1,    -1,
    72,    73,     1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    67,    -1,    84,    85,    27,    72,    73,    -1,    -1,    -1,
    77,    -1,    -1,    -1,    37,    38,    -1,    84,    85,    -1,
    -1,    -1,    -1,    46,    47,    48,    49,    50,    37,    38,
    -1,    54,    -1,     1,    -1,    -1,    -1,    46,    47,    48,
    49,    50,    -1,    -1,    67,    54,    -1,     1,    -1,    72,
    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    27,
    -1,    84,    85,    72,    73,    -1,    -1,    -1,    -1,    37,
    38,    -1,    -1,    82,    -1,    84,    85,    -1,    46,    47,
    48,    49,    50,    37,    38,    -1,    54,    -1,    51,    52,
    53,    -1,    46,    47,    48,    49,    50,    -1,    -1,    67,
    54,    -1,    -1,    -1,    72,    73,    69,    70,    71,    72,
    73,    74,    75,    67,    -1,    78,    84,    85,    72,    73,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,     1,
    84,    85,     4,     5,     6,     7,     8,     9,    10,    11,
    12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    38,    39,    40,    41,
    42,    43,    -1,    -1,    46,    47,    48,    49,    50,    -1,
    51,    52,    53,    55,    56,    57,    58,    59,    -1,    -1,
    62,    63,    -1,    65,    -1,    -1,    -1,    -1,    69,    70,
    71,    72,    73,    74,    75,    77,     1,    79,    -1,     4,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    38,    39,    40,    41,    42,    43,    -1,
    -1,    46,    47,    48,    49,    50,    -1,    51,    52,    53,
    55,    56,    57,    58,    59,    -1,    -1,    62,    63,    -1,
    65,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
    74,    75,    77,    77,    79,     4,     5,     6,     7,     8,
     9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
    19,    20,    21,    22,    23,    24,    -1,    51,    52,    53,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    39,    40,    41,    42,    43,    69,    70,    71,    72,    73,
    74,    75,    -1,    51,    52,    53,    -1,    -1,    82,    -1,
    -1,    -1,    -1,    62,    -1,    -1,    65,    51,    52,    53,
    -1,    69,    70,    71,    72,    73,    74,    75,    77,    51,
    52,    53,    -1,    -1,    82,    69,    70,    71,    72,    73,
    74,    75,    -1,    -1,    78,    -1,    -1,    69,    70,    71,
    72,    73,    74,    75,    -1,    77,    51,    52,    53,    -1,
    -1,    -1,    -1,    -1,    -1,    51,    52,    53,    -1,    -1,
    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
    75,    -1,    77,    69,    70,    71,    72,    73,    74,    75,
    -1,    77,    51,    52,    53,    -1,    -1,    -1,    -1,    -1,
    -1,    51,    52,    53,    -1,    -1,    -1,    -1,    -1,    -1,
    69,    70,    71,    72,    73,    74,    75,    -1,    77,    69,
    70,    71,    72,    73,    74,    75,    -1,    77,    51,    52,
    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
    73,    74,    75,    -1,    77
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifndef YYPARSE_PARAM
int yyparse (void);
#endif
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 914 "zmac.y"
{	error("file bad");	;
    break;}
case 5:
#line 923 "zmac.y"
{
		fprintf(stderr,"statement error\n");
		err[fflag]++;
		quoteflag = 0;
		while(yychar != '\n' && yychar != '\0') yychar = yylex();
		list(dollarsign);
		yyclearin;yyerrok;
	;
    break;}
case 6:
#line 935 "zmac.y"
{
		if (yyvsp[-1].itemptr) list(dollarsign);
		else  list1();
	;
    break;}
case 7:
#line 940 "zmac.y"
{
		list(dollarsign);
	;
    break;}
case 8:
#line 944 "zmac.y"
{
		/* a forward reference to a label in the expression cannot
		 * be fixed in a forward reference to the EQU;
		 * it would need three passes. -rjm
		 */
		if(!pass2 && equ_bad_label) {
			/* this indicates that the equ has an incorrect
			 * (i.e. pass 1) value.
			 */
			yyvsp[-3].itemptr->i_equbad = 1;
		} else {
			/* but if 2nd pass or no forward reference, it's ok. */
			yyvsp[-3].itemptr->i_equbad = 0;
		}
		equ_bad_label=0;
		switch(yyvsp[-3].itemptr->i_token) {
		case UNDECLARED: case WASEQUATED:
			yyvsp[-3].itemptr->i_token = EQUATED;
			yyvsp[-3].itemptr->i_value = yyvsp[-1].ival;
			break;
		default:
			err[mflag]++;
			yyvsp[-3].itemptr->i_token = MULTDEF;
		}
		list(yyvsp[-1].ival);
	;
    break;}
case 9:
#line 971 "zmac.y"
{
		switch(yyvsp[-3].itemptr->i_token) {
		case UNDECLARED: case DEFLED:
			yyvsp[-3].itemptr->i_token = DEFLED;
			yyvsp[-3].itemptr->i_value = yyvsp[-1].ival;
			break;
		default:
			err[mflag]++;
			yyvsp[-3].itemptr->i_token = MULTDEF;
		}
		list(yyvsp[-1].ival);
	;
    break;}
case 10:
#line 984 "zmac.y"
{
		switch (yyvsp[-5].itemptr->i_token) {
		case UNDECLARED: case DEFLED:
			yyvsp[-5].itemptr->i_token = DEFLED;
			if (yyvsp[-4].itemptr->i_value)	/* max */
				list(yyvsp[-5].itemptr->i_value = (yyvsp[-3].ival > yyvsp[-1].ival? yyvsp[-3].ival:yyvsp[-1].ival));
			else list(yyvsp[-5].itemptr->i_value = (yyvsp[-3].ival < yyvsp[-1].ival? yyvsp[-3].ival:yyvsp[-1].ival));
			break;
		default:
			err[mflag]++;
			yyvsp[-5].itemptr->i_token = MULTDEF;
			list(yyvsp[-5].itemptr->i_value);
		}
	;
    break;}
case 11:
#line 999 "zmac.y"
{
		/* all $2's here were yypc[2].ival before.
		 * I think the idea was perhaps to allow constants
		 * only...? Anyway, it now allows any expression -
		 * which would seem to make sense given the definition
		 * above, right? :-)  -rjm
		 */
		if (ifptr >= ifstmax)
			error("Too many ifs");
		else {
			if (pass2) {
				*++ifptr = *expifp++;
				if (*ifptr != !(yyvsp[-1].ival)) err[pflag]++;
			} else {
				if (expifp >= expifmax)
					error("Too many ifs!");
				*expifp++ = !(yyvsp[-1].ival);
				*++ifptr = !(yyvsp[-1].ival);
			}
		}
		saveopt = fopt;
		fopt = 1;
		list(yyvsp[-1].ival);
		fopt = saveopt;
	;
    break;}
case 12:
#line 1025 "zmac.y"
{
		/* FIXME: it would be nice to spot repeated ELSEs, but how? */
		*ifptr = !*ifptr;
		saveopt = fopt;
		fopt = 1;
		list1();
		fopt = saveopt;
	;
    break;}
case 13:
#line 1034 "zmac.y"
{
		if (ifptr == ifstack) err[bflag]++;
		else --ifptr;
		list1();
	;
    break;}
case 14:
#line 1040 "zmac.y"
{
		list(dollarsign);
		peekc = 0;
	;
    break;}
case 15:
#line 1045 "zmac.y"
{
		xeq_flag++;
		xeq = yyvsp[-1].ival;
		list(yyvsp[-1].ival);
		peekc = 0;
	;
    break;}
case 16:
#line 1052 "zmac.y"
{
		if (yyvsp[-1].ival < 0) err[vflag]++;
		list(dollarsign);
		if (yyvsp[-1].ival) {
			flushbin();
			dollarsign += yyvsp[-1].ival;
			olddollar = dollarsign;

			/* if it's not hex output though, we also need
			 * to output zeroes as appropriate. -rjm
			 */
			if(!output_hex && pass2) {
				int f;
				for (f=0;f<(yyvsp[-1].ival);f++)
					fputc(0, fbuf);
			}
		}
	;
    break;}
case 17:
#line 1071 "zmac.y"
{
		list1();
		switch (yyvsp[-4].itemptr->i_value) {

		case 0:		/* title */
			lineptr = linebuf;
			cp = tempbuf;
			title = titlespace;
			while ((*title++ = *cp++) && (title < &titlespace[TITLELEN]));
			*title = 0;
			title = titlespace;
			break;

		case 1:		/* rsym */
			if (pass2) break;
			insymtab(tempbuf);
			break;

		case 2:		/* wsym */
			strcpy(writesyms, tempbuf);
			break;

		case 3:		/* include file */
			if (*tempbuf == '"' || *tempbuf == '\'')
			{
				if (tempbuf[strlen (tempbuf) - 1] == '"' || tempbuf[strlen (tempbuf) - 1] == '\'')
					tempbuf[strlen (tempbuf) - 1] = 0;
				next_source(tempbuf + 1) ;
			}
			else
			{
				next_source(tempbuf) ;
			}
			break ;
		}
	;
    break;}
case 18:
#line 1108 "zmac.y"
{
		fprintf(stderr,"ARGPSEUDO error\n");
		err[fflag]++;
		list(dollarsign);
	;
    break;}
case 19:
#line 1114 "zmac.y"
{
		list_tmp1=yyvsp[-1].itemptr->i_value;
		list_tmp2=1;
		goto dolopt;
	;
    break;}
case 20:
#line 1120 "zmac.y"
{
		list_tmp1=yyvsp[-2].itemptr->i_value;
		list_tmp2=yyvsp[-1].ival;
	dolopt:
		linecnt++;
		if (pass2) {
			lineptr = linebuf;
			switch (list_tmp1) {
			case 0:	/* list */
				if (list_tmp2 < 0) lstoff = 1;
				if (list_tmp2 > 0) lstoff = 0;
				break;

			case 1:	/* eject */
				if (list_tmp2) eject();
				break;

			case 2:	/* space */
				if ((line + list_tmp2) > 60) eject();
				else space(list_tmp2);
				break;

			case 3:	/* elist */
				eopt = edef;
				if (list_tmp2 < 0) eopt = 0;
				if (list_tmp2 > 0) eopt = 1;
				break;

			case 4:	/* fopt */
				fopt = fdef;
				if (list_tmp2 < 0) fopt = 0;
				if (list_tmp2 > 0) fopt = 1;
				break;

			case 5:	/* gopt */
				gopt = gdef;
				if (list_tmp2 < 0) gopt = 1;
				if (list_tmp2 > 0) gopt = 0;
				break;

			case 6: /* mopt */
				mopt = mdef;
				if (list_tmp2 < 0) mopt = 0;
				if (list_tmp2 > 0) mopt = 1;
			}
		}
	;
    break;}
case 21:
#line 1168 "zmac.y"
{
		yyvsp[-3].itemptr->i_token = MNAME;
		yyvsp[-3].itemptr->i_value = mfptr;
		mfseek(mfile, (long)mfptr, 0);
		list1();
		mlex() ;
		parm_number = 0;
	;
    break;}
case 22:
#line 1177 "zmac.y"
{
		yyvsp[-1].itemptr->i_token = MNAME;
		while (yychar != ENDM && yychar) {
			while (yychar != '\n' && yychar)
				yychar = yylex();
			list1();
			yychar = yylex();
		}
		while (yychar != '\n' && yychar) yychar = yylex();
		list1();
		yychar = yylex();
	;
    break;}
case 23:
#line 1190 "zmac.y"
{
		yyvsp[-3].itemptr->i_uses++ ;
		arg_flag = 0;
		parm_number = 0;
		list(dollarsign);
		expptr++;
		est = est2;
		est[FLOC] = floc;
		est[TEMPNUM] = (char *)exp_number++;
		floc = (char *)(yyvsp[-3].itemptr->i_value);
		mfseek(mfile, (long)floc, 0);
	;
    break;}
case 24:
#line 1207 "zmac.y"
{	yyval.itemptr = NULL;	;
    break;}
case 25:
#line 1209 "zmac.y"
{
		switch(yyvsp[0].itemptr->i_token) {
		case UNDECLARED:
			if (pass2)
				err[pflag]++;
			else {
				yyvsp[0].itemptr->i_token = LABEL;
				yyvsp[0].itemptr->i_value = dollarsign;
			}
			break;
		case LABEL:
			if (!pass2) {
				yyvsp[0].itemptr->i_token = MULTDEF;
				err[mflag]++;
			} else if (yyvsp[0].itemptr->i_value != dollarsign)
				err[pflag]++;
			break;
		default:
			err[mflag]++;
			yyvsp[0].itemptr->i_token = MULTDEF;
		}
	;
    break;}
case 26:
#line 1232 "zmac.y"
{
		switch(yyvsp[-1].itemptr->i_token) {
		case UNDECLARED:
			if (pass2)
				err[pflag]++;
			else {
				yyvsp[-1].itemptr->i_token = LABEL;
				yyvsp[-1].itemptr->i_value = dollarsign;
			}
			break;
		case LABEL:
			if (!pass2) {
				yyvsp[-1].itemptr->i_token = MULTDEF;
				err[mflag]++;
			} else if (yyvsp[-1].itemptr->i_value != dollarsign)
				err[pflag]++;
			break;
		default:
			err[mflag]++;
			yyvsp[-1].itemptr->i_token = MULTDEF;
		}
	;
    break;}
case 27:
#line 1259 "zmac.y"
{ emit1(yyvsp[0].itemptr->i_value, 0, 0, 1); ;
    break;}
case 28:
#line 1262 "zmac.y"
{ emitjp(0303, yyvsp[0].ival); ;
    break;}
case 29:
#line 1265 "zmac.y"
{ emit(3, 0315, yyvsp[0].ival, yyvsp[0].ival >> 8); ;
    break;}
case 30:
#line 1268 "zmac.y"
{ int a = yyvsp[0].ival, doneerr=0;
		/* added support for normal RST form -rjm */
		if (a >= 8) {
			if ((a&7)!=0) doneerr=1,err[vflag]++;
			a >>= 3;
		}
		if ((a > 7 || a < 0) && !doneerr) /* don't give two errs... */
			err[vflag]++;
		emit(1, yyvsp[-1].itemptr->i_value + (a << 3));
	;
    break;}
case 31:
#line 1280 "zmac.y"
{ emit1(0306, 0, yyvsp[0].ival, 3); warnprt (1, 0); ;
    break;}
case 32:
#line 1283 "zmac.y"
{ emit1(0306, 0, yyvsp[0].ival, 3); ;
    break;}
case 33:
#line 1286 "zmac.y"
{ emit1(0306 + (yyvsp[-1].itemptr->i_value << 3), 0, yyvsp[0].ival, 3); warnprt (1, 0); ;
    break;}
case 34:
#line 1289 "zmac.y"
{ emit1(0306 + (yyvsp[-3].itemptr->i_value << 3), 0, yyvsp[0].ival, 3); ;
    break;}
case 35:
#line 1292 "zmac.y"
{ emit1(0306 | (yyvsp[-1].itemptr->i_value << 3), 0, yyvsp[0].ival, 3); ;
    break;}
case 36:
#line 1295 "zmac.y"
{ emit1(0306 | (yyvsp[-3].itemptr->i_value << 3), 0, yyvsp[0].ival, 3); warnprt (1, 0); ;
    break;}
case 37:
#line 1298 "zmac.y"
{ emit1(0200 + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0); warnprt (1, 0); ;
    break;}
case 38:
#line 1301 "zmac.y"
{ emit1(0200 + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0); ;
    break;}
case 39:
#line 1304 "zmac.y"
{ emit1(0200 + (yyvsp[-1].itemptr->i_value << 3) + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0); warnprt (1, 0); ;
    break;}
case 40:
#line 1307 "zmac.y"
{ emit1(0200 + (yyvsp[-3].itemptr->i_value << 3) + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0); ;
    break;}
case 41:
#line 1310 "zmac.y"
{ emit1(0200 + (yyvsp[-1].itemptr->i_value << 3) + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0); ;
    break;}
case 42:
#line 1313 "zmac.y"
{ emit1(0200 + (yyvsp[-3].itemptr->i_value << 3) + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0); warnprt (1, 0); ;
    break;}
case 43:
#line 1316 "zmac.y"
{
			if (suggest_optimise && pass2 && (yyvsp[0].ival & 0377) == 7 && yyvsp[-1].itemptr->i_value <= 4)
				warnprt (yyvsp[-1].itemptr->i_value + 4, 0);
			if (pass2 && yyvsp[-1].itemptr->i_value == 6)
				warnprt (1, 0);
			emit1(0145400 + (yyvsp[-1].itemptr->i_value << 3) + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0);
		;
    break;}
case 44:
#line 1325 "zmac.y"
{ emit1(yyvsp[-1].itemptr->i_value + ((yyvsp[0].ival & 0377) << 3) + 4, yyvsp[0].ival, 0, 0); ;
    break;}
case 45:
#line 1328 "zmac.y"
{ if (yyvsp[-3].itemptr->i_value == 1)
				emit(2,0355,0112+yyvsp[0].ival);
			else
				emit(2,0355,0102+yyvsp[0].ival);
		;
    break;}
case 46:
#line 1335 "zmac.y"
{ emitdad(yyvsp[-2].ival,yyvsp[0].ival); ;
    break;}
case 47:
#line 1338 "zmac.y"
{
			if (yyvsp[-2].ival != yyvsp[0].ival) {
				fprintf(stderr,"ADD mar, mar error\n");
				err[fflag]++;
			}
			emitdad(yyvsp[-2].ival,yyvsp[0].ival);
		;
    break;}
case 48:
#line 1347 "zmac.y"
{ emit1((yyvsp[-1].itemptr->i_value << 3) + (yyvsp[0].ival & 0377) + 3, yyvsp[0].ival, 0, 1); ;
    break;}
case 49:
#line 1350 "zmac.y"
{ emit1(yyvsp[-1].itemptr->i_value + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 1); ;
    break;}
case 50:
#line 1353 "zmac.y"
{
			if (yyvsp[-2].ival < 0 || yyvsp[-2].ival > 7)
				err[vflag]++;
			emit1(yyvsp[-3].itemptr->i_value + ((yyvsp[-2].ival & 7) << 3) + (yyvsp[0].ival & 0377), yyvsp[0].ival, 0, 0);
		;
    break;}
case 51:
#line 1360 "zmac.y"
{ emitjp(0302 + yyvsp[-2].ival, yyvsp[0].ival); ;
    break;}
case 52:
#line 1363 "zmac.y"
{ emit1(0351, yyvsp[-1].ival, 0, 1); ;
    break;}
case 53:
#line 1366 "zmac.y"
{ emit(3, 0304 + yyvsp[-2].ival, yyvsp[0].ival, yyvsp[0].ival >> 8); ;
    break;}
case 54:
#line 1369 "zmac.y"
{ emitjr(030,yyvsp[0].ival); ;
    break;}
case 55:
#line 1372 "zmac.y"
{ emitjr(yyvsp[-3].itemptr->i_value + yyvsp[-2].ival, yyvsp[0].ival); ;
    break;}
case 56:
#line 1375 "zmac.y"
{ emitjr(yyvsp[-1].itemptr->i_value, yyvsp[0].ival); ;
    break;}
case 57:
#line 1378 "zmac.y"
{ emit(1, yyvsp[0].itemptr->i_value); ;
    break;}
case 58:
#line 1381 "zmac.y"
{ emit(1, 0300 + yyvsp[0].ival); ;
    break;}
case 59:
#line 1384 "zmac.y"
{
			if ((yyvsp[-2].ival & 0377) == 6 && (yyvsp[0].ival & 0377) == 6) {
				fprintf(stderr,"LD reg, reg error\n");
				err[fflag]++;
			}
			emit1(0100 + ((yyvsp[-2].ival & 7) << 3) + (yyvsp[0].ival & 7),yyvsp[-2].ival | yyvsp[0].ival, 0, 0);
		;
    break;}
case 60:
#line 1393 "zmac.y"
{
			if (suggest_optimise && pass2 && yyvsp[0].ival == 0 && (yyvsp[-2].ival & 0377) == 7)
				warnprt (3, 0);
			emit1(6 + ((yyvsp[-2].ival & 0377) << 3), yyvsp[-2].ival, yyvsp[0].ival, 2);
		;
    break;}
case 61:
#line 1400 "zmac.y"
{	if (yyvsp[-4].ival != 7) {
				fprintf(stderr,"LD reg, (RP) error\n");
				err[fflag]++;
			}
			else emit(1, 012 + yyvsp[-1].itemptr->i_value);
		;
    break;}
case 62:
#line 1408 "zmac.y"
{
			if (yyvsp[-2].ival != 7) {
				fprintf(stderr,"LD reg, (expr) error\n");
				err[fflag]++;
			}
			else emit(3, 072, yyvsp[0].ival, yyvsp[0].ival >> 8);
		;
    break;}
case 63:
#line 1417 "zmac.y"
{ emit(1, 2 + yyvsp[-3].itemptr->i_value); ;
    break;}
case 64:
#line 1420 "zmac.y"
{ emit(3, 062, yyvsp[-2].ival, yyvsp[-2].ival >> 8); ;
    break;}
case 65:
#line 1423 "zmac.y"
{
			if (yyvsp[-2].ival != 7) {
				fprintf(stderr,"LD reg, MISCREG error\n");
				err[fflag]++;
			}
			else emit(2, 0355, 0127 + yyvsp[0].itemptr->i_value);
		;
    break;}
case 66:
#line 1432 "zmac.y"
{ emit(2, 0355, 0107 + yyvsp[-2].itemptr->i_value); ;
    break;}
case 67:
#line 1435 "zmac.y"
{ emit1(1 + (yyvsp[-2].ival & 060), yyvsp[-2].ival, yyvsp[0].ival, 5); ;
    break;}
case 68:
#line 1438 "zmac.y"
{
			if ((yyvsp[-2].ival & 060) == 040)
				emit1(052, yyvsp[-2].ival, yyvsp[0].ival, 5);
			else
				emit(4, 0355, 0113 + yyvsp[-2].ival, yyvsp[0].ival, yyvsp[0].ival >> 8);
		;
    break;}
case 69:
#line 1446 "zmac.y"
{
			if ((yyvsp[0].ival & 060) == 040)
				emit1(042, yyvsp[0].ival, yyvsp[-2].ival, 5);
			else
				emit(4, 0355, 0103 + yyvsp[0].ival, yyvsp[-2].ival, yyvsp[-2].ival >> 8);
		;
    break;}
case 70:
#line 1454 "zmac.y"
{
			if (yyvsp[-2].ival != 060) {
				fprintf(stderr,"LD evenreg error\n");
				err[fflag]++;
			}
			else
				emit1(0371, yyvsp[0].ival, 0, 1);
		;
    break;}
case 71:
#line 1464 "zmac.y"
{
			if (yyvsp[-2].itemptr->i_value != 020) {
				fprintf(stderr,"EX RP, HL error\n");
				err[fflag]++;
			}
			else
				emit(1, 0353);
		;
    break;}
case 72:
#line 1474 "zmac.y"
{ emit(1, 010); ;
    break;}
case 73:
#line 1477 "zmac.y"
{ emit1(0343, yyvsp[0].ival, 0, 1); ;
    break;}
case 74:
#line 1480 "zmac.y"
{
			if (yyvsp[-2].ival != 7) {
				fprintf(stderr,"IN reg, (expr) error\n");
				err[fflag]++;
			}
			else	{
				if (yyvsp[0].ival < 0 || yyvsp[0].ival > 255)
					err[vflag]++;
				emit(2, yyvsp[-3].itemptr->i_value, yyvsp[0].ival);
			}
		;
    break;}
case 75:
#line 1493 "zmac.y"
{ emit(2, 0355, 0100 + (yyvsp[-4].ival << 3)); ;
    break;}
case 76:
#line 1496 "zmac.y"
{ emit(2, 0355, 0160); ;
    break;}
case 77:
#line 1499 "zmac.y"
{
			if (yyvsp[-2].ival < 0 || yyvsp[-2].ival > 255)
				err[vflag]++;
			emit(2, yyvsp[-3].itemptr->i_value, yyvsp[-2].ival);
		;
    break;}
case 78:
#line 1506 "zmac.y"
{ emit(2, 0355, 0101 + (yyvsp[0].ival << 3)); ;
    break;}
case 79:
#line 1509 "zmac.y"
{
			if (yyvsp[0].ival > 2 || yyvsp[0].ival < 0)
				err[vflag]++;
			else
				emit(2, yyvsp[-1].itemptr->i_value >> 8, yyvsp[-1].itemptr->i_value + ((yyvsp[0].ival + (yyvsp[0].ival > 0)) << 3));
		;
    break;}
case 80:
#line 1517 "zmac.y"
{
			if (phaseflag) {
				err[oflag]++;
			} else {
				phaseflag = 1;
				phdollar = dollarsign;
				dollarsign = yyvsp[0].ival;
				phbegin = dollarsign;
			}
		;
    break;}
case 81:
#line 1529 "zmac.y"
{
			if (!phaseflag) {
				err[oflag]++;
			} else {
				phaseflag = 0;
				dollarsign = phdollar + dollarsign - phbegin;
			}
		;
    break;}
case 82:
#line 1539 "zmac.y"
{
			if (not_seen_org)
				first_org_store=yyvsp[0].ival;
			not_seen_org=0;
			if (phaseflag) {
				err[oflag]++;
				dollarsign = phdollar + dollarsign - phbegin;
				phaseflag = 0;
			}
			if (yyvsp[0].ival-dollarsign) {
				flushbin();
				if (pass2 && !output_hex && dollarsign != 0) {
					if (yyvsp[0].ival < dollarsign) {
						err[orgflag]++;
					} else {
						int f;
						for (f=0;f<(yyvsp[0].ival - dollarsign);f++)
							fputc(0, fbuf);
					}
				}
				olddollar = yyvsp[0].ival;
				dollarsign = yyvsp[0].ival;
			}
		;
    break;}
case 89:
#line 1582 "zmac.y"
{
			yyvsp[0].itemptr->i_token = MPARM;
			if (parm_number >= PARMMAX)
				error("Too many parameters");
			yyvsp[0].itemptr->i_value = parm_number++;
		;
    break;}
case 93:
#line 1602 "zmac.y"
{
			cp = malloc(strlen(tempbuf)+1);
			est2[parm_number++] = cp;
			strcpy(cp, tempbuf);
		;
    break;}
case 96:
#line 1615 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 97:
#line 1620 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 98:
#line 1625 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 99:
#line 1631 "zmac.y"
{
			yyval.ival = 6;
		;
    break;}
case 100:
#line 1636 "zmac.y"
{
			disp = yyvsp[-1].ival;
			yyval.ival = (yyvsp[-2].itemptr->i_value & 0177400) | 6;
		;
    break;}
case 101:
#line 1642 "zmac.y"
{
			disp = 0;
			yyval.ival = (yyvsp[-1].itemptr->i_value & 0177400) | 6;
		;
    break;}
case 104:
#line 1654 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 105:
#line 1659 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 107:
#line 1667 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 108:
#line 1672 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 110:
#line 1680 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 111:
#line 1686 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 112:
#line 1691 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 114:
#line 1699 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 115:
#line 1705 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value;
		;
    break;}
case 116:
#line 1710 "zmac.y"
{	yyval.ival = 030;	;
    break;}
case 119:
#line 1719 "zmac.y"
{
			dataemit(2, yyvsp[0].ival, yyvsp[0].ival>>8);
		;
    break;}
case 120:
#line 1724 "zmac.y"
{
			cp = yyvsp[0].cval;
			while (*cp != '\0')
				dataemit(1,*cp++);
		;
    break;}
case 121:
#line 1731 "zmac.y"
{
			if (yyvsp[0].ival < -128 || yyvsp[0].ival > 255)
					err[vflag]++;
			dataemit(1, yyvsp[0].ival & 0377);
		;
    break;}
case 124:
#line 1748 "zmac.y"
{
			dataemit(2, yyvsp[0].ival, yyvsp[0].ival>>8);
		;
    break;}
case 127:
#line 1763 "zmac.y"
{	yyval.ival = yyvsp[-1].ival;	;
    break;}
case 128:
#line 1768 "zmac.y"
{
			err[eflag]++;
			yyval.ival = 0;
		;
    break;}
case 129:
#line 1774 "zmac.y"
{	yyval.ival = yyvsp[0].itemptr->i_value; yyvsp[0].itemptr->i_uses++ ;	;
    break;}
case 132:
#line 1781 "zmac.y"
{	yyval.ival = yyvsp[0].itemptr->i_value; yyvsp[0].itemptr->i_uses++ ;	;
    break;}
case 133:
#line 1784 "zmac.y"
{
			yyval.ival = yyvsp[0].itemptr->i_value; yyvsp[0].itemptr->i_uses++ ;
			if (yyvsp[0].itemptr->i_equbad) {
				/* forward reference to equ with a forward
				 * reference of its own cannot be resolved
				 * in two passes. -rjm
				 */
				err[frflag]++;
			}
		;
    break;}
case 134:
#line 1796 "zmac.y"
{	yyval.ival = yyvsp[0].itemptr->i_value; yyvsp[0].itemptr->i_uses++ ;	;
    break;}
case 135:
#line 1799 "zmac.y"
{	yyval.ival = dollarsign;	;
    break;}
case 136:
#line 1802 "zmac.y"
{
			err[uflag]++;
			equ_bad_label=1;
			yyval.ival = 0;
		;
    break;}
case 137:
#line 1809 "zmac.y"
{	yyval.ival = yyvsp[0].itemptr->i_value;	;
    break;}
case 138:
#line 1812 "zmac.y"
{	yyval.ival = yyvsp[-2].ival + yyvsp[0].ival;	;
    break;}
case 139:
#line 1815 "zmac.y"
{	yyval.ival = yyvsp[-2].ival - yyvsp[0].ival;	;
    break;}
case 140:
#line 1818 "zmac.y"
{	if (yyvsp[0].ival == 0) err[eflag]++; else yyval.ival = yyvsp[-2].ival / yyvsp[0].ival;	;
    break;}
case 141:
#line 1821 "zmac.y"
{	yyval.ival = yyvsp[-2].ival * yyvsp[0].ival;	;
    break;}
case 142:
#line 1824 "zmac.y"
{	yyval.ival = yyvsp[-2].ival % yyvsp[0].ival;	;
    break;}
case 143:
#line 1827 "zmac.y"
{	yyval.ival = yyvsp[-2].ival & yyvsp[0].ival;	;
    break;}
case 144:
#line 1830 "zmac.y"
{	yyval.ival = yyvsp[-2].ival | yyvsp[0].ival;	;
    break;}
case 145:
#line 1833 "zmac.y"
{	yyval.ival = yyvsp[-2].ival ^ yyvsp[0].ival;	;
    break;}
case 146:
#line 1836 "zmac.y"
{	yyval.ival = yyvsp[-2].ival << yyvsp[0].ival;	;
    break;}
case 147:
#line 1839 "zmac.y"
{	yyval.ival = ((yyvsp[-2].ival >> 1) & 077777) >> (yyvsp[0].ival - 1);	;
    break;}
case 148:
#line 1842 "zmac.y"
{	yyval.ival = yyvsp[-1].ival;	;
    break;}
case 149:
#line 1845 "zmac.y"
{	yyval.ival = ~yyvsp[0].ival;	;
    break;}
case 150:
#line 1848 "zmac.y"
{	yyval.ival = yyvsp[0].ival;	;
    break;}
case 151:
#line 1851 "zmac.y"
{	yyval.ival = -yyvsp[0].ival;	;
    break;}
case 158:
#line 1870 "zmac.y"
{ int i;
		if (expptr >= MAXEXP)
			error("Macro expansion level");
		est2 = (char **) malloc((PARMMAX +4) * sizeof(char *));
		expstack[expptr] = (char *)est2 ;
		for (i=0; i<PARMMAX; i++)
			est2[i] = 0;
		arg_flag++;
	;
    break;}
case 159:
#line 1883 "zmac.y"
{	arg_flag++;	;
    break;}
case 160:
#line 1887 "zmac.y"
{	arg_flag = 0;	;
    break;}
case 161:
#line 1891 "zmac.y"
{	quoteflag++;	;
    break;}
case 162:
#line 1895 "zmac.y"
{	quoteflag = 0;	;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 1899 "zmac.y"

/*extern int	yylval;*/

#define F_END	0
#define OTHER	1
#define SPACE	2
#define DIGIT	3
#define LETTER	4
#define STARTER 5


/*
 *  This is the table of character classes.  It is used by the lexical
 *  analyser. (yylex())
 */
char	charclass[] = {
	F_END,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,
	OTHER,	SPACE,	OTHER,	OTHER,	OTHER,	SPACE,	OTHER,	OTHER,
	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,
	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,
	SPACE,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	DIGIT,	OTHER,
	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,
	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,
	DIGIT,	DIGIT,	OTHER,	OTHER,	OTHER,	OTHER,	OTHER,	STARTER,
	STARTER,LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER,
	LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER,
	LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER,
	LETTER, LETTER, LETTER, OTHER,	OTHER,	OTHER,	OTHER,	LETTER,
	OTHER,	LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER,
	LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER,
	LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER, LETTER,
	LETTER, LETTER, LETTER, OTHER,	OTHER,	OTHER,	OTHER,	OTHER,
};


/*
 *  the following table tells which characters are parts of numbers.
 *  The entry is non-zero for characters which can be parts of numbers.
 */
char	numpart[] = {
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	'&',	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	'0',	'1',	'2',	'3',	'4',	'5',	'6',	'7',
	'8',	'9',	0,	0,	0,	0,	0,	0,
	0,	'A',	'B',	'C',	'D',	'E',	'F',	0,
	'H',	0,	0,	0,	0,	0,	0,	'O',
	0,	'Q',	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	'a',	'b',	'c',	'd',	'e',	'f',	0,
	'h',	0,	0,	0,	0,	0,	0,	'o',
	0,	'q',	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0};




/*
 *  the following table is a list of assembler mnemonics;
 *  for each mnemonic the associated machine-code bit pattern
 *  and symbol type are given.
 */
struct	item	keytab[] = {
	{"a",	7,	ACC,		0},
	{"adc",	1,	ARITHC,		0},
	{"add",	0,	ADD,		0},
	{"af",	060,	AF,		0},
	{"and",	4,	LOGICAL,	0},
	{"ascii",0,	DEFB,		0},
	{"b",	0,	REGNAME,	0},
	{"bc",	0,	RP,		0},
	{"bit",	0145500,BIT,		0},
	{"block",0,	DEFS,		0},
	{"byte",0,	DEFB,		0},
	{"c",	1,	C,		0},
	{"call",0315,	CALL,		0},
	{"ccf",	077,	NOOPERAND,	0},
	{"cmp",	7,	LOGICAL,	0},		/* -cdk */
	{"cp",	7,	LOGICAL,	0},
	{"cpd",	0166651,NOOPERAND,	0},
	{"cpdr",0166671,NOOPERAND,	0},
	{"cpi",	0166641,NOOPERAND,	0},
	{"cpir",0166661,NOOPERAND,	0},
	{"cpl",	057,	NOOPERAND,	0},
	{"d",	2,	REGNAME,	0},
	{"daa",	0047,	NOOPERAND,	0},
	{"db",	0,	DEFB,		0},
	{"de",	020,	RP,		0},
	{"dec",	1,	INCDEC,		0},
	{"defb",0,	DEFB,		0},
	{"defl",0,	DEFL,		0},
	{"defm",0,	DEFB,		0},
	{"defs",0,	DEFS,		0},
	{"defw",0,	DEFW,		0},
	{"dephase",0,	DEPHASE,	0},
	{"di",	0363,	NOOPERAND,	0},
	{"djnz",020,	DJNZ,		0},
	{"ds",	0,	DEFS,		0},
	{"dw",	0,	DEFW,		0},
	{"e",	3,	REGNAME,	0},
	{"ei",	0373,	NOOPERAND,	0},
	{"eject",1,	LIST,		0},
	{"elist",3,	LIST,		0},
	{"else",0,	ELSE,		0},
	{"end",	0,	END,		0},
	{"endif",0,	ENDIF,		0},
	{"endm", 0,	ENDM,		0},
	{"equ",	0,	EQU,		0},
	{"ex",	0,	EX,		0},
	{"exx",	0331,	NOOPERAND,	0},
	{"f",	0,	F,		0},
	{"flist",4,	LIST,		0},
	{"glist",5,	LIST,		0},
	{"h",	4,	REGNAME,	0},
	{"halt",0166,	NOOPERAND,	0},
	{"hl",	040,	HL,		0},
	{"i",	0,	MISCREG,	0},
	{"if",	0,	IF,		0},
	{"im",	0166506,IM,		0},
	{"in",	0333,	IN,		0},
	{"inc",	0,	INCDEC,		0},
	{"include", 3,	ARGPSEUDO,	0},
	{"ind",	0166652,NOOPERAND,	0},
	{"indr",0166672,NOOPERAND,	0},
	{"ini",	0166642,NOOPERAND,	0},
	{"inir",0166662,NOOPERAND,	0},
	{"ix",	0156440,INDEX,		0},
	{"iy",	0176440,INDEX,		0},
	{"jmp",	0303,	JP,		0},		/* -cdk */
	{"jp",	0303,	JP,		0},
	{"jr",	040,	JR,		0},
	{"l",	5,	REGNAME,	0},
	{"ld",	0,	LD,		0},
	{"ldd",	0166650,NOOPERAND,	0},
	{"lddr",0166670,NOOPERAND,	0},
	{"ldi",	0166640,NOOPERAND,	0},
	{"ldir",0166660,NOOPERAND,	0},
	{"list",0,	LIST,		0},
	{"m",	070,	COND,		0},
	{"macro",0,	MACRO,		0},
	{"max",	1,	MINMAX,		0},
	{"min",	0,	MINMAX,		0},
	{"mlist",6,	LIST,		0},
	{"mod",	0,	MOD,		0},
	{"nc",	020,	SPCOND,		0},
	{"neg",	0166504,NOOPERAND,	0},
	{"nolist",-1,	LIST,		0},
	{"nop",	0,	NOOPERAND,	0},
	{"not",	0,	NOT,		0},
	{"nv",	040,	COND,		0},
	{"nz",	0,	SPCOND,		0},
	{"or",	6,	LOGICAL,	0},
	{"org",	0,	ORG,		0},
	{"otdr",0166673,NOOPERAND,	0},
	{"otir",0166663,NOOPERAND,	0},
	{"out",	0323,	OUT,		0},
	{"outd",0166653,NOOPERAND,	0},
	{"outi",0166643,NOOPERAND,	0},
	{"p",	060,	COND,		0},
	{"pe",	050,	COND,		0},
	{"phase",0,	PHASE,		0},
	{"po",	040,	COND,		0},
	{"pop",	0301,	PUSHPOP,	0},
	{"push", 0305,	PUSHPOP,	0},
	{"r",	010,	MISCREG,	0},
	{"read", 3,	ARGPSEUDO,	0},
	{"res",	0145600,BIT,		0},
	{"ret",	0311,	RET,		0},
	{"reti",0166515,NOOPERAND,	0},
	{"retn",0166505,NOOPERAND,	0},
	{"rl",	2,	SHIFT,		0},
	{"rla",	027,	NOOPERAND,	0},
	{"rlc",	0,	SHIFT,		0},
	{"rlca",07,	NOOPERAND,	0},
	{"rld",	0166557,NOOPERAND,	0},
	{"rmem",0,	DEFS,		0},
	{"rr",	3,	SHIFT,		0},
	{"rra",	037,	NOOPERAND,	0},
	{"rrc",	1,	SHIFT,		0},
	{"rrca",017,	NOOPERAND,	0},
	{"rrd",	0166547,NOOPERAND,	0},
	{"rst",	0307,	RST,		0},
	{"rsym",1,	ARGPSEUDO,	0},
	{"sbc",	3,	ARITHC,		0},
	{"scf",	067,	NOOPERAND,	0},
	{"set",	0145700,BIT,		0},
	{"shl",	0,	SHL,		0},
	{"shr",	0,	SHR,		0},
	{"sla",	4,	SHIFT,		0},
	{"sll",	6,	SHIFT,		0}, /* Undocumented */
	{"sp",	060,	SP,		0},
	{"space",2,	LIST,		0},
	{"sra",	5,	SHIFT,		0},
	{"srl",	7,	SHIFT,		0},
	{"sub",	2,	LOGICAL,	0},
	{"text",0,	DEFB,		0},
	{"title",0,	ARGPSEUDO,	0},
	{"v",	050,	COND,		0},
	{"word",0,	DEFW,		0},
	{"wsym",2,	ARGPSEUDO,	0},
	{"xor",	5,	LOGICAL,	0},
	{"z",	010,	SPCOND,		0}
};

/*
 *  user-defined items are tabulated in the following table.
 */

struct item	itemtab[ITEMTABLESIZE];
struct item	*itemmax = itemtab+ITEMTABLESIZE;





/*
 *  lexical analyser, called by yyparse.
 */
int yylex()
{
	int	c;
	char *p;
	int	radix;
	int  limit;
	int leadinghex;

	if (arg_flag)
		return(getarg());
loop switch(charclass[c = nextchar()]) {
	case F_END:
		if (expptr) {
			popsi();
			continue;
		} else return(0);

	case SPACE:
		break;
	case LETTER:
	case STARTER:
		p = tempbuf;
		do {
			if (p >= tempmax)
				error(symlong);
			*p++ = (c >= 'A' && c <= 'Z') ? c + 'a' - 'A' : c;
			while	((c = nextchar()) == '$')
				;
		} while	(charclass[c]==LETTER || charclass[c]==DIGIT);
		if (p - tempbuf > MAXSYMBOLSIZE)
		{
			warnprt (0, 1);
			p = tempbuf + MAXSYMBOLSIZE;
		}
		*p++ = '\0';
		peekc = c;
		return(tokenofitem(UNDECLARED));
	case DIGIT:
		if (*ifptr) return(skipline(c));
		p = tempbuf;
		if (c == '&')
		{
			leadinghex = 1;
			while ((c = nextchar ()) == '$');
		}
		else
		{
			leadinghex = 0;
		}
		do	{
			if (p >= tempmax)
				error(symlong);
			*p++ = (c >= 'A' && c <= 'Z') ? c + 'a' - 'A' : c;
			while	((c = nextchar()) == '$');
			}
			while(numpart[c]);
		peekc = c;
		if (leadinghex)
		{
			*p++ = 'h';
		}
		*p-- = '\0';
		switch(*p)	{
			case 'o':
			case 'q':
				radix = 8;
				limit = 020000;
				*p = '\0';
				break;
			case 'd':
				radix = 10;
				limit = 6553;
				*p = '\0';
				break;
			case 'h':
				radix = 16;
				limit = 010000;
				*p = '\0';
				break;
			case 'b':
				radix = 2;
				limit = 077777;
				*p = '\0';
				break;
			default:
				radix = 10;
				limit = 6553;
				p++;
				break;
			}

		/*
		 *  tempbuf now points to the number, null terminated
		 *  with radix 'radix'.
		 */
		yylval.ival = 0;
		p = tempbuf;
		do	{
			c = *p - (*p > '9' ? ('a' - 10) : '0');
			if (c >= radix)
				{
				err[iflag]++;
				yylval.ival = 0;
				break;
				}
			if (yylval.ival < limit ||
				(radix == 10 && yylval.ival == 6553 && c < 6) ||
				(radix == 2 && yylval.ival == limit))
				yylval.ival = yylval.ival * radix + c;
			else {
				err[vflag]++;
				yylval.ival = 0;
				break;
				}
			}
			while(*++p != '\0');
		return(NUMBER);
	default:
		if (*ifptr)
			return(skipline(c));
		switch(c) {
		int corig;
		case ';':
			return(skipline(c));
		case '\'':
			if (quoteflag) return('\'');
		case '"':
			corig = c;
			p = tempbuf;
			p[1] = 0;
			do	switch(c = nextchar())	{
			case '\0':
			case '\n':
				err[bflag]++;
				goto retstring;
			case '\'':
			case '"':
				if (c == corig && (c = nextchar()) != corig) {
				retstring:
					peekc = c;
					*p = '\0';
					if ((p-tempbuf) >2) {
						yylval.cval = tempbuf;
						return(STRING);
					} else if (p-tempbuf == 2)	{
						p = tempbuf;
						yylval.ival = *p++ ;
						yylval.ival |= *p<<8;
						return(TWOCHAR);
					} else	{
						p = tempbuf;
						yylval.ival = *p++;
						return(ONECHAR);
					}
				}
			default:
				*p++ = c;
			} while (p < tempmax);
			/*
			 *  if we break out here, our string is longer than
			 *  our input line
			 */
			error("string buffer overflow");
		default:
			return(c);
		}
	}
}

/*
 *  return the token associated with the string pointed to by
 *  tempbuf.  if no token is associated with the string, associate
 *  deftoken with the string and return deftoken.
 *  in either case, cause yylval to point to the relevant
 *  symbol table entry.
 */

int tokenofitem(int deftoken)
{
	char *p;
	struct item *	ip;
	int  i;
	int  r, l, u, hash;


#ifdef T_DEBUG
	fputs("'tokenofitem entry'	", stderr) ;
	fputs(tempbuf, stderr) ;
#endif
	if (strcmp (tempbuf, "cmp") == 0 ||
	    strcmp (tempbuf, "jmp") == 0 ||
	    strcmp (tempbuf, "v")   == 0 ||
	    strcmp (tempbuf, "nv")  == 0)
		warnprt (1, 1);
	/*
	 *  binary search
	 */
	l = 0;
	u = (sizeof keytab/sizeof keytab[0])-1;
	while (l <= u) {
		i = (l+u)/2;
		ip = &keytab[i];
		if ((r = strcmp(tempbuf, ip->i_string)) == 0)
			goto found;
		if (r < 0)
			u = i-1;
		else
			l = i+1;
	}

	/*
	 *  hash into item table
	 */
	hash = 0;
	p = tempbuf;
	while (*p) hash += *p++;
	hash %= ITEMTABLESIZE;
	ip = &itemtab[hash];

	loop {
		if (ip->i_token == 0)
			break;
		if (strcmp(tempbuf, ip->i_string) == 0)
			goto found;
		if (++ip >= itemmax)
			ip = itemtab;
	}

	if (!deftoken) {
		i = 0 ;
		goto token_done ;
	}
	if (++nitems > ITEMTABLESIZE-20)
		error("item table overflow");
	ip->i_string = malloc(strlen(tempbuf)+1);
	ip->i_token = deftoken;
	ip->i_uses = 0;
	ip->i_equbad = 0;
	strcpy(ip->i_string, tempbuf);

found:
	if (ip->i_token == LOGICAL && tokeninline >= 2)
	{
		switch (ip->i_value)
		{
		case 4:
			i = '&';
			goto token_done;
		case 5:
			i = '^';
			goto token_done;
		case 6:
			i = '|';
			goto token_done;
		default:
			/* Not really a logical operator; drop through */
			break;
		}
	}
	if (*ifptr) {
		if (ip->i_token == ENDIF) {
			i = ENDIF ;
			goto token_done ;
		}
		if (ip->i_token == ELSE) {
			/* We must only honour the ELSE if it is not
			   in a nested failed IF/ELSE */
			char forbid = 0;
			char *ifstackptr;
			for (ifstackptr = ifstack; ifstackptr != ifptr; ++ifstackptr) {
				if (*ifstackptr) {
					forbid = 1;
					break;
				}
			}
			if (!forbid) {
				i = ELSE;
				goto token_done;
			}
		}
		if (ip->i_token == IF) {
			if (ifptr >= ifstmax)
				error("Too many ifs");
			else *++ifptr = 1;
		}
		i = skipline(' ');
		goto token_done ;
	}
	yylval.itemptr = ip;
	i = ip->i_token;
	if (i == EQU) equ_bad_label=0;
token_done:
#ifdef T_DEBUG
	fputs("\t'tokenofitem exit'\n", stderr) ;
#endif
	return(i) ;
}


/*
 *  interchange two entries in the item table -- used by custom_qsort
 */
void interchange(int i, int j)
{
	struct item *fp, *tp;
	struct item temp;

	fp = &itemtab[i];
	tp = &itemtab[j];
	temp.i_string = fp->i_string;
	temp.i_value = fp->i_value;
	temp.i_token = fp->i_token;
	temp.i_uses = fp->i_uses;
	temp.i_equbad = fp->i_equbad;

	fp->i_string = tp->i_string;
	fp->i_value = tp->i_value;
	fp->i_token = tp->i_token;
	fp->i_uses = tp->i_uses;
	fp->i_equbad = tp->i_equbad;

	tp->i_string = temp.i_string;
	tp->i_value = temp.i_value;
	tp->i_token = temp.i_token;
	tp->i_uses = temp.i_uses;
	tp->i_equbad = temp.i_equbad;
}



/*
 *  quick sort -- used by putsymtab to sort the symbol table
 */
void custom_qsort(int m, int n)
{
	int  i, j;

	if (m < n) {
		i = m;
		j = n+1;
		loop {
			do i++; while(strcmp(itemtab[i].i_string,
					itemtab[m].i_string) < 0);
			do j--; while(strcmp(itemtab[j].i_string,
					itemtab[m].i_string) > 0);
			if (i < j) interchange(i, j); else break;
		}
		interchange(m, j);
		custom_qsort(m, j-1);
		custom_qsort(j+1, n);
	}
}



/*
 *  get the next character
 */
int nextchar()
{
	int c, ch;
	static  char  *earg;

	if (peekc != -1) {
		c = peekc;
		peekc = -1;
		return(c);
	}

start:
	if (earg) {
		if (*earg)
			return(addtoline(*earg++));
		earg = 0;
	}

	if (expptr) {
		if ((ch = getm()) == '\1') {	/*  expand argument  */
			ch = getm() - 'A';
			if (ch >= 0 && ch < PARMMAX && est[ch])
				earg = est[ch];
			goto start;
		}
		if (ch == '\2') {	/*  local symbol  */
			ch = getm() - 'A';
			if (ch >= 0 && ch < PARMMAX && est[ch]) {
				earg = est[ch];
				goto start;
			}
			earg = getlocal(ch, (int)est[TEMPNUM]);
			goto start;
		}

		return(addtoline(ch));
	}
	ch = getc(now_file) ;
	/* if EOF, check for include file */
	if (ch == EOF) {
		while (ch == EOF && now_in) {
			fclose(fin[now_in]) ;
			free(src_name[now_in]) ;
			now_file = fin[--now_in] ;
			ch = getc(now_file) ;
		}
		if (linein[now_in] < 0) {
			lstoff = 1 ;
			linein[now_in] = -linein[now_in] ;
		} else {
			lstoff = 0 ;
		}
		if (pass2 && iflist()) {
			lineout() ;
			fprintf(fout, "**** %s ****\n", src_name[now_in]) ;
		}
	}
	if (ch == '\n')
	{
		linein[now_in]++ ;
		tokeninline = 0;
	}
	else if (charclass[ch] == SPACE)
	{
		++tokeninline;
	}

	return(addtoline(ch)) ;
}


/*
 *  skip to rest of the line -- comments and if skipped lines
 */
int skipline(int ac)
{
	int  c;

	c = ac;
	while (c != '\n' && c != '\0')
		c = nextchar();
	return('\n');
}



void usage()
{
	printf(
"zmac " ZMAC_VERSION ", a Z80 macro cross-assembler.\n"
"Public domain by Bruce Norskog and others.\n"
"\n"
#ifdef __riscos
"usage: zmac [--help] [--version] [-AbcdefghilLmnOpsStTz]\n"
"       [-o outfile] [-x listfile] [filename[/z]]\n"
#else
"usage: zmac [--help] [--version] [-AbcdefghilLmnOpsStz]\n"
"       [-o outfile] [-x listfile] [filename[.z]]\n"
#endif
"\n"
"       --help  give this usage help.\n"
"       --version  report version number.\n"
"       -A      output AMSDOS binary file rather than default binary file.\n"
"       -b      don't generate the m/c output at all.\n"
"       -c      make the listing continuous, i.e. don't generate any\n"
"               page breaks or page headers. (This is the default.)\n"
"       -d      make the listing discontinuous.\n"
"       -e      omit the `error report' section in the listing.\n"
"       -f      list instructions not assembled due to `if' expressions being\n"
"               false. (Normally these are not shown in the listing.)\n"
"       -g      list only the first line of equivalent hex for a source line.\n"
"       -h      output CP/M-ish Intel hex format (using extension `.hex')\n"
"               rather than default binary file (extension `.bin').\n"
"       -i      don't list files included with `include'.\n"
"       -l      don't generate a listing at all.\n"
"       -L      generate listing; overrides any conflicting options.\n"
"       -m      list macro expansions.\n"
"       -n      omit line numbers from listing.\n"
"       -o      assemble output to `outfile'.\n"
"       -O      suggest possible optimisations (as warnings).\n"
"       -p      use linefeeds for page break in listing rather than ^L.\n"
"       -s      omit the symbol table from the listing.\n"
"       -S      show relevant line when reporting errors.\n"
"       -t      give terse (single-letter) error codes in listing.\n"
#ifdef __riscos
"       -T      enable DDE throwback for reporting warnings and errors.\n"
#endif
"       -x      generate listing to `listfile' (`-' for stdout).\n"
"       -z      accept 8080-compatible instructions only; flag any\n"
"               Z80-specific ones as errors.\n");
}



int main(int argc, char *argv[])
{
	struct item *ip;
	int  i, c;

	if(argc==1)
		usage(),exit(0);

	if(argc>=2) {
		if(strcmp(argv[1],"--help")==0)
			usage(),exit(0);
		else if(strcmp(argv[1],"--version")==0)
			puts("zmac " ZMAC_VERSION),exit(0);
	}

	fout = stdout ;
	fin[0] = stdin ;
	now_file = stdin ;

	*bin = *listf = 0;
	optnerr = 0;

	while((c = getoptn(argc,argv,
#ifdef __riscos
		"AbcdefghilLmno:OpsStTx:z"
#else
		"AbcdefghilLmno:OpsStx:z"
#endif
		)) != EOF) {
		switch(c) {

		case 'A':	/*  AMSDOS binary -mep */
			output_amsdos = 1;
			output_hex = 0;
			break;

		case 'b':	/*  no binary  */
			bopt = 0;
			break;

		case 'c':	/*  continuous listing  */
			continuous_listing = 1;
			break;

		case 'd':	/*  discontinuous listing  */
			continuous_listing = 0;
			break;

		case 'e':	/*  error list only  */
			eopt = 0;
			edef = 0;
			break;

		case 'f':	/*  print if skipped lines  */
			fopt++;
			fdef++;
			break;

		case 'g':	/*  do not list extra code  */
			gopt = 0;
			gdef = 0;
			break;

		case 'h':	/* output .hex not .bin -rjm */
			output_hex = 1;
			output_amsdos = 0;
			break;

		case 'i':	/* do not list include files */
			iopt = 1 ;
			break;

		case 'l':	/*  no list  */
			lopt++;
			break;

		case 'L':	/*  force listing of everything */
			lston++;
			break;

		case 'm':	/*  print macro expansions  */
			mdef++;
			mopt++;
			break;

		case 'n':	/*  put line numbers off */
			nopt-- ;
			break;

		case 'o':	/*  specify m/c output file */
			strcpy(bin, optnarg);
			break;

		case 'O':	/*  suggest optimisations  */
			suggest_optimise = 1;
			break;

		case 'p':	/*  put out four \n's for eject */
			popt-- ;
			break;

		case 's':	/*  don't produce a symbol list  */
			sopt++;
			break;

		case 'S':	/*  show line which caused error */
			show_error_line = 1;
			break;

		case 't':	/*  terse error messages in listing  */
			terse_lst_errors = 1;
			break;

#ifdef __riscos
		case 'T':	/*  RISC OS throwback  -mep */
			riscos_thbk = 1;
			break;
#endif

		case 'x':	/*  specify listing file */
			if(strcmp(optnarg, "-") == 0)
				oldoopt++;	/* list to stdout (old `-o') */
			else
				strcpy(listf, optnarg);
			break;

		case 'z':	/*  8080-compatible ops only  */
			output_8080_only = 1;
			break;

		case '?':
		default:	/*  error  */
			justerror("Unknown option or missing argument");
			break;

		}
	}

	if(optnind != argc-1) justerror("Missing, extra or mispositioned argument");

	atexit (doatexit);

	sourcef = argv[optnind];
	strcpy(src, sourcef);

	/* If filename has no pre-existing suffix, then assume .z */
	suffix_if_none (src, "z");
	if ((now_file = fopen(src, "r")) == NULL)
		fileerror("Cannot open source file", src);
	now_in = 0 ;
	fin[now_in] = now_file ;
	src_name[now_in] = src ;
#ifdef __riscos
	riscos_set_csd(src); /* -mep */
#endif

	/* If we haven't got a bin file filename, then create one from the
	 * source filename (.hex extension if option -h is specified).
	 */
	if (*bin == 0) {
		strcpy(bin, sourcef);
		if (output_hex)
			suffix(bin,"hex");
		else
			suffix(bin,"bin");
	}
	if (bopt)
		if (( fbuf = fopen(bin, output_hex ? "w" : "wb")) == NULL)
			fileerror("Cannot create binary file", bin);
	if (output_amsdos)
		for(i=0; i<128; i++)
			putc(0,fbuf); /* -mep */

	if (!lopt && !oldoopt) {
		/* If we've not got a filename for the listing file
		 * (-x option) then create one from the source filename
		 * (.lst extension)
		 */
		if( *listf == 0 ) {
			strcpy(listf, sourcef);
			suffix(listf,"lst");
		}
		if ((fout = fopen(listf, "w")) == NULL)
			fileerror("Cannot create list file", listf);
	} else
		fout = stdout ;

	strcpy(mtmp, sourcef);
	suffix(mtmp,"tmp");
	mfile = mfopen(mtmp,"w+b") ;
	if (mfile == NULL) {
		fileerror("Cannot create temp file", mtmp);
	}

	/*
	 *  get the time
	 */
	time(&now);
	timp = ctime(&now);
	timp[16] = 0;
	timp[24] = 0;

	title = sourcef;
	/*
	 * pass 1
	 */
#ifdef DEBUG
	fputs("DEBUG-pass 1\n", stderr) ;
#endif
	setvars();
	yyparse();
	pass2++;
	ip = &itemtab[-1];
	while (++ip < itemmax) {
		/* reset use count */
		ip->i_uses = 0 ;

		/* set macro names, equated and defined names */
		switch	(ip->i_token) {
		case MNAME:
			ip->i_token = OLDMNAME;
			break;

		case EQUATED:
			ip->i_token = WASEQUATED;
			break;

		case DEFLED:
			ip->i_token = UNDECLARED;
			break;
		}
	}
	setvars();
	fseek(now_file, (long)0, 0);

#ifdef DEBUG
	fputs("DEBUG- pass 2\n", stderr) ;
#endif
	yyparse();


	if (bopt) {
		flushbin();
		if (output_hex) {
			putc(':', fbuf);
			if (xeq_flag) {
				puthex(0, fbuf);
				puthex(xeq >> 8, fbuf);
				puthex(xeq, fbuf);
				puthex(1, fbuf);
				puthex(255-(xeq >> 8)-xeq, fbuf);
			} else
				for	(i = 0; i < 10; i++)
					putc('0', fbuf);
			putc('\n', fbuf);
		}
		if (output_amsdos) {
			char leafname[] = "FILENAMEBIN";
			unsigned int chk;
			unsigned int filelen = dollarsign - first_org_store;
			if (filelen & 0x7f)
			{
				putc (0x1a, fbuf); /* CP/M EOF char */
			}
			rewind(fbuf);
			chk=0;
			putc(0,fbuf);
			for(i=0;i<11;i++) {
				putc(leafname[i],fbuf);
				chk+=leafname[i];
			}
			for(i=0;i<6;i++)
				putc(0,fbuf);
			putc(2,fbuf); /* Unprotected binary */
			chk+=2;
			putc(0,fbuf);
			putc(0,fbuf);
			putc(first_org_store & 0xFF,fbuf);
			chk+=first_org_store & 0xFF;
			putc(first_org_store >> 8,fbuf);
			chk+=first_org_store >> 8;
			putc(0,fbuf);
			putc(filelen & 0xFF,fbuf);
			chk+=filelen & 0xFF;
			putc(filelen >> 8,fbuf);
			chk+=filelen >> 8;
			/* Next bit should be entry address really */
			putc(first_org_store & 0xFF,fbuf);
			chk+=first_org_store & 0xFF;
			putc(first_org_store >> 8,fbuf);
			chk+=first_org_store >> 8;
			for(i=28;i<64;i++)
				putc(0,fbuf);
			putc(filelen & 0xFF,fbuf);
			chk+=filelen & 0xFF;
			putc(filelen >> 8,fbuf);
			chk+=filelen >> 8;
			putc(0,fbuf); /* this would be used if length>64K */
			putc(chk & 0xFF,fbuf);
			putc(chk >> 8,fbuf);
		}
		fflush(fbuf);
	}

	if (!lopt)
		fflush(fout);
	if (*writesyms)
		outsymtab(writesyms);
	if (eopt)
		erreport();
	if (!lopt && !sopt)
		putsymtab();
	if (!lopt) {
		eject();
		fflush(fout);
	}
	exit(had_errors);
}


void doatexit (void)
{
#ifdef __riscos
	if (riscos_throwback_started)
	{
		_swix(DDEUtils_ThrowbackEnd,0);
	}
	_swix(DDEUtils_Prefix,1,0); /* Unset CSD */
#endif
}


/*
 *  set some data values before each pass
 */
void setvars()
{
	int  i;

	peekc = -1;
	linein[now_in] = linecnt = 0;
	exp_number = 0;
	emitptr = emitbuf;
	lineptr = linebuf;
	ifptr = ifstack;
	expifp = expif;
	*ifptr = 0;
	dollarsign = 0;
	olddollar = 0;
	phaseflag = 0;
	for (i=0; i<FLAGS; i++) err[i] = 0;
}



/*
 *  print out an error message and die
 */
void error(char *as)
{
	*linemax = 0;
	fprintf(fout, "%s\n", linebuf);
	fflush(fout);
	fprintf(stderr, "%s\n", as) ;
	exit(1);
}


/*
 *  alternate version
 */
void fileerror(char *as,char *filename)
{
	*linemax = 0;
	if (fout != NULL && fout != stdout)
		fprintf(fout, "%s\n", linebuf);
	fflush(fout);
	fprintf(stderr, "%s `%s'\n", as, filename) ;
	exit(1);
}



/*
 *  alternate alternate version
 */
void justerror(char *as)
{
	fprintf(stderr, "%s\n", as) ;
	exit(1);
}


/*
 *  output the symbol table
 */
void putsymtab()
{
	struct item *tp, *fp;
	int  i, j, k, t, rows;
	char c, c1 ;

	if (!nitems)
		return;

	/* compact the table so unused and UNDECLARED entries are removed */
	tp = &itemtab[-1];
	for (fp = itemtab; fp<itemmax; fp++) {
		if (fp->i_token == UNDECLARED) {
			nitems--;
			continue;
		}
		if (fp->i_token == 0)
			continue;
		tp++;
		if (tp != fp) {
			tp->i_string = fp->i_string;
			tp->i_value = fp->i_value;
			tp->i_token = fp->i_token;
			tp->i_uses = fp->i_uses ;
			tp->i_equbad = fp->i_equbad ;
		}
	}

	tp++;
	tp->i_string = "{";

	/*  sort the table */
	custom_qsort(0, nitems-1);

	title = "**  Symbol Table  **";

	rows = (nitems+3) / 3;
	if (rows+5+line > 60)
		eject();
	lineout();
	fprintf(fout,"\n\n\nSymbol Table:\n\n");
	line += 4;

	for (i=0; i<rows; i++) {
		for(j=0; j<3; j++) {
			k = rows*j+i;
			if (k < nitems) {
				tp = &itemtab[k];
				t = tp->i_token;
				c = ' ' ;
				if (t == EQUATED || t == DEFLED)
					c = '=' ;
				if (tp->i_uses == 0)
					c1 = '+' ;
				else
					c1 = ' ' ;
				fprintf(fout, "%-15s%c%4x%c    ",
					tp->i_string, c, tp->i_value & 0xffff, c1);
			}
		}
		lineout();
		putc('\n', fout);
	}
}




/*
 *  put out error report
 */
void erreport()
{
	int i, numerr;

	if (line > 50) eject();
	lineout();
	numerr = 0;
	for (i=0; i<FLAGS; i++) numerr += keeperr[i];
	if (numerr) {
		fputs("\n\n\nError report:\n\n", fout);
		fprintf(fout, "%6d error%s\n", DO_PLURAL(numerr));
		line += 5;
	} else {
		fputs("\n\n\nStatistics:\n", fout);
		line += 3;
	}

	for (i=0; i<FLAGS; i++)
		if (keeperr[i]) {
			lineout();
			if (terse_lst_errors)
				/* no plural on this because it would
				 * odd, I think. -rjm
				 */
				fprintf(fout, "%6d %c -- %s error\n",
					keeperr[i], errlet[i], errname[i]);
			else
				/* can't use DO_PLURAL for this due to
				 * the %s in the middle... -rjm
				 */
				fprintf(fout, "%6d %s error%s\n",
					keeperr[i], errname[i],
					(keeperr[i]==1)?"":"s");
		}

	if (line > 55) eject();
	lineout();
	fprintf(fout, "\n%6d\tsymbol%s\n", DO_PLURAL(nitems));
	fprintf(fout, "%6d\tbyte%s\n", DO_PLURAL(nbytes));
	line += 2;
	if (mfptr) {
		if (line > 53) eject();
		lineout();
		fprintf(fout, "\n%6d\tmacro call%s\n", DO_PLURAL(exp_number));
		fprintf(fout, "%6d\tmacro byte%s\n", DO_PLURAL(mfptr));
		fprintf(fout, "%6d\tinvented symbol%s\n",
						DO_PLURAL(invented/2));
		line += 3;
	}
}


/*
 *  lexical analyser for macro definition
 */
void mlex()
{
	char  *p;
	int  c;
	int  t;

	/*
	 *  move text onto macro file, changing formal parameters
	 */
#ifdef	M_DEBUG
	fprintf(stderr,"enter 'mlex'\t") ;
#endif
	inmlex++;

	c = nextchar();
loop {
	switch(charclass[c]) {

	case DIGIT:
		while (numpart[c]) {
			putm(c);
			c = nextchar();
		}
		continue;

	case STARTER:
	case LETTER:
		t = 0;
		p = tempbuf+MAXSYMBOLSIZE+2;
		do {
			if (p >= tempmax)
				error(symlong);
			*p++ = c;
			if (t < MAXSYMBOLSIZE)
				tempbuf[t++] = (c >= 'A' && c <= 'Z')  ?
					c+'a'-'A' : c;
			else
				warnprt (0, 1);
			c = nextchar();
		} while (charclass[c]==LETTER || charclass[c]==DIGIT);

		tempbuf[t] = 0;
		*p++ = '\0';
		p = tempbuf+MAXSYMBOLSIZE+2;
		t = tokenofitem(0);
		if (t != MPARM) while (*p) putm(*p++);
		else {
			if (*(yylval.itemptr->i_string) == '?') putm('\2');
			else putm('\1');
			putm(yylval.itemptr->i_value + 'A');
		}
		if (t == ENDM) goto done;
		continue;

	case F_END:
		if (expptr) {
			popsi();
			c = nextchar();
			continue;
		}

		goto done;

	default:
		if (c == '\n') {
			linecnt++;
		}
		if (c != '\1') putm(c);
		c = nextchar();
	}
}

	/*
	 *  finish off the file entry
	 */
done:
	while(c != EOF && c != '\n' && c != '\0') c = nextchar();
	linecnt++;
	putm('\n');
	putm('\n');
	putm(0);

	for (c=0; c<ITEMTABLESIZE; c++)
		if (itemtab[c].i_token == MPARM) {
			itemtab[c].i_token = UNDECLARED;
		}
	inmlex = 0;
#ifdef	M_DEBUG
	fprintf(stderr,"exit 'mlex'\n") ;
#endif
}



/*
 *  lexical analyser for the arguments of a macro call
 */
int getarg()
{
	int c;
	char *p;
	static int comma;

	*tempbuf = 0;
	yylval.cval = tempbuf;
	while(charclass[c = nextchar()] == SPACE);

	switch(c) {

	case '\0':
		popsi();
	case '\n':
	case ';':
		comma = 0;
		return(skipline(c));

	case ',':
		if (comma) {
			comma = 0;
			return(',');
		}
		else {
			comma++;
			return(ARG);
		}

	case '\'':
		p = tempbuf;
		do switch (c = nextchar()) {
			case '\0':
			case '\n':
				peekc = c;
				*p = 0;
				err[bflag]++;
				return(ARG);
			case '\'':
				if ((c = nextchar()) != '\'') {
					peekc = c;
					*p = '\0';
					comma++;
					return(ARG);
				}
			default:
				*p++ = c;
		} while (p < tempmax);
		error(symlong);		/* doesn't return */

	default:  /* unquoted string */
		p = tempbuf;
		peekc = c;
		do switch(c = nextchar()) {
			case '\0':
			case '\n':
			case '\t':
			case ' ':
			case ',':
				peekc = c;
				*p = '\0';
				comma++;
				return(ARG);
			default:
				*p++ = c;
		} while (p < tempmax);
	}

	/* in practice it can't get here, but FWIW and to satisfy
	 * -Wall... -rjm */
	error("can't happen - in zmac.y:getarg(), infinite unquoted string!?");
	return(0);
}



/*
 * Add suffix to pathname if leafname doesn't already have a suffix.
 * The suffix passed should not include an extension separator.
 * The pathname passed should be in local format.
 */
void suffix_if_none (char *str, char *suff)
{
	char *leafname, *extension;

	leafname = strrchr (str, OS_DIR_SEP);
	if (leafname == NULL)
	{
		leafname = str;
	}

	extension = strchr (leafname, OS_EXT_SEP);
	if (extension == NULL)
	{
		size_t leafsize = strlen (leafname);

		leafname[leafsize] = OS_EXT_SEP;
		strcpy (leafname + leafsize + 1, suff);
	}
}



/*
 * Add or change pathname suffix.
 * The suffix passed should not include an extension separator.
 * The pathname passed should be in local format.
 * If the leafname passed has more than one extension, the last is changed.
 */
void suffix (char *str, char *suff)
{
	char *leafname, *extension;

	leafname = strrchr (str, OS_DIR_SEP);
	if (leafname == NULL)
	{
		leafname = str;
	}

	extension = strrchr (leafname, OS_EXT_SEP);
	if (extension == NULL)
	{
		extension = leafname + strlen (leafname);
	}

	*extension = OS_EXT_SEP;
	strcpy (extension + 1, suff);
}



/*
 * Decanonicalise a canonical pathname.
 * A canonical pathname uses '/' as the directory separator,
 * '.' as the extension separator, ".." as the parent directory,
 * "." as the current directory, and a leading '/' as the root
 * directory (it would be more user-friendly not to use this!).
 */
void decanonicalise (char *pathname)
{
#if defined (MSDOS)

	char *directory = pathname;

	/* Just need to change all '/'s to '\'s */

	while ((directory = strchr (directory, '/')) != NULL)
	{
		*directory = OS_DIR_SEP;
	}

#elif defined (__riscos)

	char *directory = pathname, *dirend;

	/* First deal with leading '/' */

	if (*directory == '/')
	{
		memmove (directory + 1, directory, strlen (directory) + 1);
		*directory = '$';
		++directory;
	}

	/* Then deal with non-leaf ".."s and "."s */

	while (1)
	{
		dirend = strchr (directory, '/');
		if (dirend == NULL)
		{
			break;
		}

		*dirend = '\0';

		if (strcmp (directory, "..") == 0)
		{
			*directory = '^';
			memmove (directory + 2, directory + 3, strlen (directory + 3) + 1);
			dirend = directory + 1;
		}
		else if (strcmp (directory, ".") == 0)
		{
			memmove (directory, directory + 2, strlen (directory + 2) + 1);
			continue;
		}

		*dirend = '/';
		directory = dirend + 1;
	}

	directory = pathname;

	/* Finally, swap '/' and '.' */

	while ((directory = strpbrk (directory, "/.")) != NULL)
	{
		if (*directory == '/')
		{
			*directory = OS_DIR_SEP;
		}
		else
		{
			*directory = OS_EXT_SEP;
		}
		++directory;
	}

#endif
}



/*
 *  put out a byte to the macro file, keeping the offset
 */
void putm(char c)
{
	mfptr++;
	mfputc(c,mfile) ;
}



/*
 *  get a byte from the macro file
 */
int getm()
{
	int ch;

	floc++;
	ch = mfgetc(mfile) ;
	if (ch == EOF) {
		ch = 0;
		fprintf(stderr,"bad macro read\n") ;
	}
	return(ch);
}



/*
 *  pop standard input
 */
void popsi()
{
	int  i;

	for (i=0; i<PARMMAX; i++) {
		if (est[i]) free(est[i]);
	}
	floc = est[FLOC];
	free(est);
	expptr--;
	est = expptr ? (char **) expstack[expptr-1] : (char **) 0;
	mfseek(mfile, (long)floc, 0);
	if (lineptr > linebuf) lineptr--;
}



/*
 *  return a unique name for a local symbol
 *  c is the parameter number, n is the macro number.
 */

char *getlocal(int c, int n)
{
	static char local_label[10];

	invented++;
	if (c >= 26)
		c += 'a' - '0';
	sprintf(local_label, "?%c%04d", c+'a', n) ;
	return(local_label);
}



/*
 *  read in a symbol table
 */
void insymtab(char *name)
{
	struct stab *t;
	int  s, i;
	FILE *sfile;

	t = (struct stab *) tempbuf;
	decanonicalise (name);
	if ((sfile = fopen(name, "rb")) == NULL)
		return;
	fread((char *)t, 1, sizeof *t, sfile);
	if (t->t_value != SYMMAJIC)
	{
		fclose (sfile);
		return;
	}

	s = t->t_token;
	for (i=0; i<s; i++) {
		fread((char *)t, 1, sizeof *t, sfile);
		if (tokenofitem(UNDECLARED) != UNDECLARED)
			continue;
		yylval.itemptr->i_token = t->t_token;
		yylval.itemptr->i_value = t->t_value;
		if (t->t_token == MACRO)
			yylval.itemptr->i_value += mfptr;
	}

	while ((s = fread(tempbuf, 1, TEMPBUFSIZE, sfile)) > 0) {
		mfptr += s;
		mfwrite(tempbuf, 1, s, mfile) ;
	}

	fclose (sfile);
}



/*
 *  write out symbol table
 */
void outsymtab(char *name)
{
	struct stab *t;
	struct item *ip;
	int  i;
	FILE *sfile;

	t = (struct stab *) tempbuf;
	decanonicalise (name);
	if ((sfile = fopen(name, "wb")) == NULL)
		return;
	for (ip=itemtab; ip<itemmax; ip++) {
		if (ip->i_token == UNDECLARED) {
			ip->i_token = 0;
			nitems--;
		}
	}

	copyname(title, (char *)t);
	t->t_value = SYMMAJIC;
	t->t_token = nitems;
	fwrite((char *)t, 1, sizeof *t, sfile);

	for (ip=itemtab; ip<itemmax; ip++) {
		if (ip->i_token != 0) {
			t->t_token = ip->i_token;
			t->t_value = ip->i_value;
			copyname(ip->i_string, (char *)t);
			fwrite((char *)t, 1, sizeof *t, sfile);
		}
	}

	mfseek(mfile, (long)0, 0);
	while((i = mfread(tempbuf, 1, TEMPBUFSIZE, mfile) ) > 0)
		fwrite(tempbuf, 1, i, sfile);

	fclose (sfile);
}



/*
 *  copy a name into the symbol file
 */
void copyname(char *st1, char *st2)
{
	char  *s1, *s2;
	int  i;

	i = (MAXSYMBOLSIZE+2) & ~01;
	s1 = st1;
	s2 = st2;

	while((*s2++ = *s1++)) i--;		/* -Wall-ishness :-) -RJM */
	while(--i > 0) *s2++ = '\0';
}

/* get the next source file */
void next_source(char *sp)
{

	if(now_in == NEST_IN -1)
		error("Too many nested includes") ;
	decanonicalise (sp);
	if ((now_file = fopen(sp, "r")) == NULL) {
#ifdef __riscos
		if (riscos_thbk)
			riscos_throwback(2,src_name[now_in],linein[now_in],"Cannot open include file");
#endif
		fileerror("Cannot open include file", sp) ;
	}
	if (pass2 && iflist()) {
		lineout() ;
		fprintf(fout, "**** %s ****\n",sp) ;
	}

	/* save the list control flag with the current line number */
	if (lstoff)
		linein[now_in] = - linein[now_in] ;

	/* no list if include files are turned off */
	lstoff |= iopt ;

	/* save the new file descriptor. */
	fin[++now_in] = now_file ;
	/* start with line 0 */
	linein[now_in] = 0 ;
	/* save away the file name */
	src_name[now_in] = malloc(strlen(sp)+1) ;
	strcpy(src_name[now_in],sp) ;
}

#ifdef __riscos
/*On entry sp should point to the full pathname of a file in RISC OS form.
  Searches for the last dot, and sets the local CSD to that path.
  Does not corrupt the string.
*/
void riscos_set_csd(char *sp)
{
	char *s1 = strrchr (sp, '.');

	if (s1 != NULL)
	{
		*s1=0;
		_swix(DDEUtils_Prefix,1,sp);
		*s1='.';
	}
}

void riscos_throwback(int severity, char *file, int line, char *error)
{
	if (riscos_throwback_started==0)
	{
		riscos_throwback_started=1;
		*riscos_thbkf=0;
		_swix(DDEUtils_ThrowbackStart,0);
	}
	if (strcmp(file, riscos_thbkf)!=0)
	{
		_swix(DDEUtils_ThrowbackSend,4+1,0,file); /* Notify of a change of file */
		strcpy(riscos_thbkf,file);
	}
	_swix(DDEUtils_ThrowbackSend,32+16+8+4+1,1,file,line,severity,error);
}
#endif
