/*
  Optimizer
  GloblEntry C++ file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include "GloblEntry.h"
#include "Data.h"
#include "Misc.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

//
//	Method name : GloblEntry
//
//	Description : Constructor to GloblEntry
//	Input : ---
//	Output : ---
//
GloblEntry::GloblEntry(char *s1) {
  unsigned int length;

  this->next = (PGloblEntry) NULL;
  this->size = NOSIZE;
  this->FownData = (PData) NULL;
  this->LownData = (PData) NULL;
  if (strcmp(s1,"")) {
    length = strlen(s1) + 1;
    this->name = new char[length];
    if (!this->name) alloc_error();
    strcpy(this->name,s1);
  } else {
    length = 1;
    this->name = new char[length];
    if (!this->name) alloc_error();
    strcpy(this->name,"");
  }
}


//
//	Method name : ~GloblEntry
//
//	Description : Destructor to GloblEntry
//	Input : ---
//	Output : ---
//
GloblEntry::~GloblEntry() {
  PData tmp;
  
  delete[] this->name; 

  while (FownData != NULL) {
    tmp = FownData;
    FownData = tmp->next;
    delete tmp;
  }
}

//
//	Method name : getname
//
//	Description : Returns the name
//	Input : ---
//	Output : The name
//
char *GloblEntry::getname(void){
  return this->name;
}

//
//	Method name : setsize
//
//	Description : Sets the size
//	Input : The size 
//	Output : ---
//
void GloblEntry::setsize(unsigned int s){
  this->size = s;
}

//	Method name : getsize
//
//	Description : Gets the size
//	Input : --- 
//	Output : The Size
//
unsigned int GloblEntry::getsize(void){
  return this->size;
}

//
//	Method name : getalign
//
//	Description : Returns the aligncode
//	Input : ---
//	Output : The aligncode
//
char *GloblEntry::getalign(void){
  char *tmpstr = new char[MaxSize];

  if (!tmpstr) alloc_error();

  sprintf(tmpstr,"%i",this->size);
  return tmpstr;
}


//
//	Method name : insert
//
//	Description : Inserts a data field
//	Input : The data-name
//	Output : ---
//
void GloblEntry::insert(char *s) {
  PData newEntry;

  newEntry = new Data(s);
  if (!newEntry) alloc_error();

  if (FownData == NULL) {
    FownData = newEntry;
    LownData = newEntry;
  } else {
    LownData->next = newEntry;
    LownData = newEntry;
  }
}

//
//	Method name : isEmpty
//
//	Description : Check if ownData is empty
//	Input : ---
//	Output : TRUE if empty else FALSE
//
bool GloblEntry::isEmpty(void) {
  if (FownData == NULL) {
    return true;
  } else {
    return false;
  }
}

//
//	Method name : putvars
//
//	Description : 
//	Input : 
//	Output : 
//
void GloblEntry::putvars(void) {
  extern FILE *yyout;
  PData tmp;
  char *tmpstr = new char[MaxSize];

  if (!tmpstr) alloc_error();
    
  tmp = FownData;
  fputs("\t\talign ", yyout);
  fputs(this->getalign(),yyout);
  fputs(",db 0\n", yyout);
  fputs("$", yyout);
  strcpy(tmpstr,this->getname());
  fputs(tmpstr, yyout);
  fputs(":", yyout);
  if (size == BYTE) {
    if (strlen(tmpstr) > 5) {
      fputs("\tdb\t", yyout);
    } else {
      fputs("\t\tdb\t", yyout);
    }
  } else if (size == WORD) {
    if (strlen(tmpstr) > 5) {
      fputs("\tdw\t", yyout);
    } else {
      fputs("\t\tdw\t", yyout);
    }
  } else if (size == LONG) {
    if (strlen(tmpstr) > 5) {
      fputs("\tdd\t", yyout);
    } else {
      fputs("\t\tdd\t", yyout);
    }
  } else if (size == SHORT) {
    if (strlen(tmpstr) > 5) {
      fputs("\t??\t", yyout);
    } else {
      fputs("\t\t??\t", yyout);
    }
  } else if (size == QUAD) {
    if (strlen(tmpstr) > 5) {
      fputs("\t??\t", yyout);
    } else {
      fputs("\t\t??\t", yyout);
    }
  } else if (size == TERA) {
    if (strlen(tmpstr) > 5) {
      fputs("\t??\t", yyout);
    } else {
      fputs("\t\t??\t", yyout);
    }
  } else {
    cout << "Size not defined." << endl;
    this->print();
  }
  strcpy(tmpstr,"");
  while (tmp != NULL) {
    strcat(tmpstr,tmp->getname());
    if (tmp->next != NULL) {
      strcat(tmpstr,", ");
    }
    if (strlen(tmpstr) > 60) {
      strcat(tmpstr,"\n");
      fputs(tmpstr, yyout);
      if (tmp->next != NULL) {
	if (size == BYTE) {
	  strcpy(tmpstr,"\t\tdb\t");
	} else if (size == WORD) {
	  strcpy(tmpstr,"\t\tdw\t");
	} else if (size == LONG) {
	  strcpy(tmpstr,"\t\tdd\t");
	} else if (size == SHORT) {
	  strcpy(tmpstr,"\t\t??\t");
	} else if (size == QUAD) {
	  strcpy(tmpstr,"\t\t??\t");
	} else if (size == TERA) {
	  strcpy(tmpstr,"\t\t??\t");
	}
      } else {
	strcpy(tmpstr,"");
      }
    }
    tmp = tmp->next;
  }
  if (strcmp(tmpstr,"")){
    if (tmpstr[strlen(tmpstr)-2] == ',') {
      tmpstr[strlen(tmpstr)-2] = ' ';
    }
    fputs(tmpstr, yyout);
    fputs("\n.end:\n\n", yyout);
  } else {
    fputs(".end:\n\n", yyout);
  }
  delete[] tmpstr;
}


//
//	Method name : print
//
//	Description : Prints the GloblEntry
//	Input : ---
//	Output : ---
//
void GloblEntry::print(void) {
  PData tmp;

  cout << "GloblEntry name  : " << this->name << endl;
  cout << "GloblEntry size  : " << this->size << endl;
  tmp = FownData;
  while (tmp != NULL) {
    tmp->print();
    tmp = tmp->next;
  }
  cout << endl;
}
