;STRUCTURED MACROS CAN BE FREELY NESTED AND MIXED AS YOU WISH.

;Now we can put comments in the same line as the macros, but they will not be
;printed in the output file.
		CSEG

		ORG     0000H

;comment in string
	.db		"mov a,#';'"

;comments after normal instructions
		mov	R1,#'A'

;comments in normal instruction		
		mov		r1,#';'

	;internal macro
		MOV_A(#';')	;check for surprises
		MOV_A(R0)	;check comments
		MOV_A(#35H)
		MOV_A(@R0)

	;MOV A,ACC is an illegal instruction, it should be trapped here.
		MOV_A(ACC)
		MOV_A(A)
		MOV_A(acc)
		MOV_A(a)

    ;TEST JNE_A (internal macro)
        JNE_A(#0,L1)
		JNE_A(#35H,L2)

    ;TEST ANL_A (internal macro)
        ANL_A(MASK_BITS)

    ;TEST ANL_A
	;When no mask is needed, use as shown below.
        %M_SWITCH(R1,)
        %M_SW_END		;End switch macro

    ;TEST ANL_A
	;When no mask is needed, test the macro with one parameter
        %M_SWITCH(R1)
        %M_SW_END

    ;TEST ANL_A
    ;This is wrong, shouldn't have space for 2nd argument.
        %M_SWITCH(R1, )
        %M_SW_END

    ;NULL TEST
        JEQ_A(#NULL,NULL_TEST)
        JEQ_A(#null,NULL_TEST)
        JEQ_A(#00H,NULL_TEST)
        JEQ_A(#00h,NULL_TEST)
        JEQ_A(#0,NULL_TEST)
        nop
NULL_TEST:

DIRECT_ADDRESS  EQU 20H
		JEQ_A(DIRECT_ADDRESS,L2)
L1:
		NOP
L2:
		MOV		R1,#1

        ;-------------------------
		;DO
		%M_DO		;Comment M_DO

			MOV		R2,#2
			;DO
			%M_DO

				;TEST OF TWO FOLLOWING DO LOOPS INSIDE
				;A BIGGER DO LOOP.
				%M_DO
				%M_DO_WHILE (R2,!=,0) ;comment M_DO_WHILE
				MOV		R3,#3
				
				;DO
				%M_DO
				
					;BREAK
					%M_DO_BREAK

					;REDO
					%M_REDO

				;WHILE (R3,!=,0)
				%M_DO_WHILE (R3,!=,0)

				;OTHER
				;BREAK
				%M_DO_BREAK

			;WHILE (R2,!=,0)
			%M_DO_WHILE (R2,!=,0)

			;TEST OF TWO FOLLOWING DO LOOPS INSIDE
			;A BIGGER DO LOOP.
			%M_DO
			%M_DO_WHILE (R2,!=,0)			

			;TEST OF THREE FOLLOWING DO LOOPS INSIDE
			;A BIGGER DO LOOP.
			%M_DO
			%M_DO_WHILE (R2,!=,0)

			;OTHER
			;BREAK
			%M_DO_BREAK
			
		;WHILE (R1,!=,0)
		%M_DO_WHILE (R1,!=,0)
        ;----------------------------
        MOV     R2,#4
		;DO
		%M_DO

		;WHILE (R2,!=,0)
		%M_DO_WHILE (R2,!=,0)
        ;----------------------------
        ;M_IF_BIT       LEVEL 1
        %M_IF_BIT(ACC.7)

            ;M_IF_NOT_BIT  LEVEL 2
            %M_IF_NOT_BIT(Counter.7)

			;M_ELSE		LEVEL 2
            %M_ELSE

			;M_ENDIF	LEVEL 2
			%M_ENDIF

			;TEST OF TWO FOLLOWING IF INSIDE ANOTHER
			%M_IF_BIT(ACC.6)
			%M_ENDIF

		;M_ELSE		LEVEL 1
		%M_ELSE

            ;M_IF_BIT   LEVEL 2
            %M_IF_BIT(REG.3)

			;M_ELSE		LEVEL 2
			%M_ELSE

			;M_ENDIF	LEVEL 2
			%M_ENDIF

		;M_ENDIF	LEVEL 1
		%M_ENDIF

VALUE_MASK 	EQU		0FH

        ;----------------------------
		%M_SWITCH(R1,#VALUE_MASK)

		%M_CASE (#1)
            ;CODE CASE 1
			%M_SW_BREAK

		%M_CASE_OR2(#2,#3)
            ;CODE CASE 2 OR 3

                ;NO MASK
                %M_SWITCH(R2,)

                %M_CASE(#0AH)
                ;CODE CASE A
                %M_SW_BREAK

                %M_CASE(#0BH)
                ;CODE CASE B
                %M_SW_BREAK

                %M_SW_DEFAULT
                ;CODE DEFAULT
                %M_SW_END

            %M_SW_BREAK
	
		%M_CASE_OR3(#4,#5,#6)
            ;CODE CASE 4,5 OR 6

			;test two following SWITCH inside another
			%M_SWITCH(R2,)
				%M_SW_BREAK
			%M_SW_END

			;test two following SWITCH inside another
			%M_SWITCH(R2,)
				%M_SW_BREAK
			%M_SW_END

			%M_SW_BREAK
	
		%M_SW_DEFAULT
			;CODE
		%M_SW_END

        ;----------------------------
		;IF CMP TESTS

        ;R0 < R1
        %M_IF_CMP(R0,<,R1)
        %M_ENDIF

        ;R0 <= R1
        %M_IF_CMP(R0,<=,R1)
        %M_ENDIF

        ;R0 > R1
        %M_IF_CMP(R0,>,R1)
			
			MOV		R2,#12H
			%M_DO  

				INC		R2

			%M_DO_WHILE(R2,!=,#15)

		%M_ELSE

			%M_SWITCH(R2,#7FH)

				%M_CASE(#12)
					MOV		A,20H
					ADD		A,R2
					MOV		R2,A
				%M_SW_BREAK

				%M_CASE_OR2(#13,#14)
					MOV		R2,#0FFH
				%M_BREAK

				%M_DEFAULT
					MOV		R2,#45H

			%M_SW_END

	    %M_ENDIF

        ;R0 >= R1
        %M_IF_CMP(R0,>=,R1)
        %M_ENDIF

        ;R0 < A
        %M_IF_CMP(R0,<,A)
        %M_ENDIF

        ;R0 <= A
        %M_IF_CMP(R0,<=,A)
        %M_ENDIF

        ;R0 > A
        %M_IF_CMP(R0,>,A)
        %M_ENDIF

        ;R0 >= A
        %M_IF_CMP(R0,>=,A)
        %M_ENDIF

        ;A < R1
        %M_IF_CMP(A,<,R1)
        %M_ENDIF

        ;A <= R1
        %M_IF_CMP(A,<=,R1)
        %M_ENDIF

        ;A > R1
        %M_IF_CMP(A,>,R1)
        %M_ENDIF

        ;A >= R1
        %M_IF_CMP(A,>=,R1)
        %M_ENDIF

        ;R0 = R1
        %M_IF_CMP(R0,=,R1)
        %M_ENDIF

        ;R0 = R1
        %M_IF_CMP(R0,==,R1)
        %M_ENDIF

        ;R0 != R1
        %M_IF_CMP(R0,!=,R1)
        %M_ENDIF

        ;R0 != R1
        %M_IF_CMP(R0,<>,R1)
        %M_ENDIF

        ;----------------------------
		;WHILE/WH_END TESTS

        ;R0 >= R1
        %M_WHILE(R0,>=,R1)
        %M_WH_END

        ;R0 < A
        %M_WHILE(R0,<,A)
        %M_WH_END

        ;R0 <= A
        %M_WHILE(R0,<=,A)
        %M_WH_END

        ;R0 > A
        %M_WHILE(R0,>,A)
        %M_WH_END

        ;R0 >= A
        %M_WHILE(R0,>=,A)
        %M_WH_END

        ;A < R1
        %M_WHILE(A,<,R1)
        %M_WH_END

        ;A <= R1
        %M_WHILE(A,<=,R1)
        %M_WH_END

        ;A > R1
        %M_WHILE(A,>,R1)
        %M_WH_END

        ;A >= R1
        %M_WHILE(A,>=,R1)
        %M_WH_END

        ;R0 = R1
        %M_WHILE(R0,=,R1)
        %M_WH_END

        ;R0 = R1
        %M_WHILE(R0,==,R1)
        %M_WH_END

        ;R0 != R1
        %M_WHILE(R0,!=,R1)
        %M_WH_END

        ;R0 != R1
        %M_WHILE(R0,<>,R1)

			;TEST OF TWO FOLLOWING WHILE INSIDE ANOTHER
    	    %M_WHILE(R0,<>,R1)
        	%M_WH_END

	        %M_WHILE(R0,<>,R1)
    	    %M_WH_END

        %M_WH_END

        ;----------------------------
		;DO/DO_WHILE TESTS

        ;R0 >= R1
        %M_DO
        %M_DO_WHILE(R0,>=,R1)

        ;R0 < A
        %M_DO
        %M_DO_WHILE(R0,<,A)

        ;R0 <= A
        %M_DO
        %M_DO_WHILE(R0,<=,A)

        ;R0 > A
        %M_DO
        %M_DO_WHILE(R0,>,A)

        ;R0 >= A
        %M_DO
        %M_DO_WHILE(R0,>=,A)

        ;A < R1
        %M_DO
        %M_DO_WHILE(A,<,R1)

        ;A <= R1
        %M_DO
        %M_DO_WHILE(A,<=,R1)

        ;A > R1
        %M_DO
        %M_DO_WHILE(A,>,R1)

        ;A >= R1
        %M_DO
        %M_DO_WHILE(A,>=,R1)

        ;R0 = R1
        %M_DO
        %M_DO_WHILE(R0,=,R1)

        ;R0 = R1
        %M_DO
        %M_DO_WHILE(R0,==,R1)

        ;R0 != R1
        %M_DO
        %M_DO_WHILE(R0,!=,R1)

        ;R0 != R1
        %M_DO
        %M_DO_WHILE(R0,<>,R1)

        ;----------------------------
		;DJNZ TEST
		%M_DO
		%M_DO
		%M_DO
		%M_DO
		%M_DO
		%M_DO
		%M_DO
		%M_DO
		%M_DO_WHILE(--R0,!=,#0)
		%M_DO_WHILE(--R1,NZ,#0)
		%M_DO_WHILE(--R2,<>,#0)
		%M_DO_WHILE(--R3,>,#0)
		%M_DO_WHILE(--R4,!=,#0)
		%M_DO_WHILE(--R5,!=,#0)
		%M_DO_WHILE(--R6,!=,#0)
		%M_DO_WHILE(--R7,!=,#0)

        ;----------------------------
		;BIT/CARRY TEST
		%M_DO
		%M_DO_WHILE_BIT(ACC.7)

		%M_DO
		%M_DO_WHILE_BIT(CY)

		%M_DO
		%M_DO_WHILE_NOT_BIT(ACC.7)

		%M_DO
		%M_DO_WHILE_NOT_BIT(CY)

		%M_WHILE_BIT(ACC.7)
        %M_WH_END

		%M_WHILE_BIT(CY)
        %M_WH_END

		%M_WHILE_NOT_BIT(ACC.7)
        %M_WH_END

		%M_WHILE_NOT_BIT(CY)
        %M_WH_END

        ;----------------------------
		;IF BIT/ELSE IF BIT TEST
		%M_IF_BIT(ACC.7)
		;M_ELSE_IF_BIT(ACC.6)
		%M_ELSE_IF_BIT(ACC.6)
		;M_ELSE_IF_BIT(ACC.5)
		%M_ELSE_IF_BIT(ACC.5)
		;M_ELSE_IF_BIT(ACC.4)
		%M_ELSE_IF_BIT(ACC.4)
		;M_ELSE
		%M_ELSE
		;M_ENDIF
		%M_ENDIF

        ;----------------------------
		;IF EQU OR TESTS

		;M_IF_EQU
		%M_IF_EQU(R0,#3FH,#20H)
			;M_IF_EQU_OR2
			%M_IF_EQU_OR2(R1,#1FH,#11H,#12H)
			;M_ENDIF
			%M_ENDIF
		;M_ELSE_IF_EQU
		%M_ELSE_IF_EQU (#20-AH)
		;M_ELSE_IF_NOT_EQU
		%M_ELSE_IF_NOT_EQU (#20-BH)		;comment
		;M_ELSE_IF_EQU_OR2
		%M_ELSE_IF_EQU_OR2(#21H,#22H)	;comment
		;M_ELSE_IF_EQU_OR3
		%M_ELSE_IF_EQU_OR3(#31H,#32H,#33H)	;comment
		;M_ELSE_IF_EQU_OR4
		%M_ELSE_IF_EQU_OR4(#41H,#42H,#43H,#44H)	;comment
		;M_ELSE
		%M_ELSE
		;M_ENDIF
		%M_ENDIF

		;if !(Counter_Expired)
		;if (Counter_Expired == 0)
		%M_IF_NOT(Counter_Expired)
		%M_ENDIF

		%M_IF_NOT_BIT(Counter_Expired)
		%M_ENDIF

		%M_WHILE_EQU(R0,,#23H)
			NOP
		%M_WH_END

		%M_WHILE_NOT_EQU(R0,#MASK,#34H)
			NOP
		%M_WH_END

		%M_DO
			NOP
		%M_DO_WHILE_NOT_EQU(R0,#MASK,#56H)

		%M_DO
			NOP
		%M_DO_WHILE_EQU(R0,#MASK,#78H)

		%M_DO
			NOP
		%M_DO_WHILE_DPTR_NE(#3F,#0FFH)

        END




