/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| December 12, 1996                                                           
|                                                                              
| Module:  Create an FSK data file for testing
|                                                                              
| $Id: make_fsk_file.C,v 1.1 2001/03/04 00:08:31 tonycu Exp $
|                                                                              
| $Log: make_fsk_file.C,v $
| Revision 1.1  2001/03/04 00:08:31  tonycu
| initial check-in at sourceforge...
|
| Revision 1.4  2000/05/24 03:19:08  tony
| Updated all copyright dates.
|
| Revision 1.3  1999/09/13 01:21:06  tony
|
| Updated copyright notice date
|
 * Revision 1.2  1997/03/08  03:47:48  tony
 *      1) remove new-lines (using trimright) in event, state, and action-block
 *         edit windows
 *      2) the nextState value was not being incremented in the action-blocks
 *         when a state was inserted before it if the nextState value was 0
 *      3) the copy buffer was not being update when states were deleted
 *      4) if the function called in the action-block is vAbortFsk, don't
 *         enclose it in a return(), i.e. return(vAbortFsk)
 *      5) remove leading and trailing spaces from event and state names
 *      6) change no_op function to take a parameter and return it; also,
 *         rename it uiNoOp
 *      7) change vPrintFskHistory to take a parameter and return it; also,
 *         rename it uiPrintFskHistory
 *      8) add check for duplicate event and state names
 *      9) rename "recursive" variables to "iterative"
 *
 * Revision 1.1  1997/03/01  23:11:29  tony
 *      initial check-in
 *
|                                                                              
\*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include <common.h>
#include <fsk.h>
#include <fsk.C>
#include <virtual_page.h>

STATIC CHAR *pchMakeFakFileId = "@(#) $Id: make_fsk_file.C,v 1.1 2001/03/04 00:08:31 tonycu Exp $";


#define CHECK_RESULT()                                             \
   {                                                               \
      printf("------ ERROR ------ %s, %d\n",                       \
              __FILE__, __LINE__);                                 \
      return(1);                                                   \
   }                                                               

#define NUM_EVENTS       6
#define NUM_STATES       6


main()
{
   UINT  uiLoop;
   UINT  uiLoop2;
   UINT  uiNumStates;
   UINT  uiNumEvents;
   CHAR  achTempString[60]; 


   FskEvent        cFskEvent;
   FskEvent        cFskEvent2;
   FskState        cFskState;
   FskState        cFskState2;
   FskActionBlock  cFskActionBlock;
   FskActionBlock  cFskActionBlock2;
   Fsk*            pcFsk;
   Fsk             cFsk2;
   Fsk*            pcFsk2;

                              // create objects and load test data
   pcFsk = new Fsk(NUM_EVENTS, NUM_STATES);
   pcFsk2 = &cFsk2;


                              // load events

                              // event 1
   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      sprintf(achTempString, "EVENT_NAME_%d", uiLoop);
      if (cFskEvent.iSetName(achTempString))
         CHECK_RESULT();

      sprintf(achTempString, "DESCRIPTION_%d", uiLoop);
      if (cFskEvent.iSetDescription(achTempString))
         CHECK_RESULT();

      if (pcFsk->iSetEventData(uiLoop, &cFskEvent)) 
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      sprintf(achTempString, "STATE_NAME_%d", uiLoop);
      if (cFskState.iSetName(achTempString))
         CHECK_RESULT();

      sprintf(achTempString, "DESCRIPTION_%d", uiLoop);
      if (cFskState.iSetDescription(achTempString))
         CHECK_RESULT();

      if (pcFsk->iSetStateData(uiLoop, &cFskState)) 
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {

         cFskActionBlock.vSetIterative(uiLoop2%2);
         cFskActionBlock.vSetNextState(uiLoop);

         sprintf(achTempString, "function_%d_%d(int p%d)", uiLoop, uiLoop2, uiLoop);
         if (cFskActionBlock.iSetFunction(achTempString))
            CHECK_RESULT();

         sprintf(achTempString, "DESCRIPTION_%d_%d", uiLoop, uiLoop2);
         if (cFskActionBlock.iSetDescription(achTempString))
            CHECK_RESULT();

         if (pcFsk->iSetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
      }
   }

                              // write the file
   if (pcFsk->iWriteFile("fsk_dat_6_6.fsk", 1))
      CHECK_RESULT();

   if (pcFsk2->iReadFile("fsk_dat_6_6.fsk"))
      CHECK_RESULT();


                              // check-out the entire FSK
   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      
      if (pcFsk->iGetEventData(uiLoop, &cFskEvent))
         CHECK_RESULT();
      if (pcFsk2->iGetEventData(uiLoop, &cFskEvent2))
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchName,
                 cFskEvent2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchDescription,
                 cFskEvent2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      
      if (pcFsk->iGetStateData(uiLoop, &cFskState))
         CHECK_RESULT();
      if (pcFsk2->iGetStateData(uiLoop, &cFskState2))
         CHECK_RESULT();

      if (strcmp(cFskState.pchName,
                 cFskState2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskState.pchDescription,
                 cFskState2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {


         if (pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
         if (pcFsk2->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock2))
            CHECK_RESULT();

         if (*(cFskActionBlock.piIterative) != 
             *(cFskActionBlock2.piIterative))
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchFunction,
                    cFskActionBlock2.pchFunction) != 0)
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchDescription,
                    cFskActionBlock2.pchDescription) != 0)
            CHECK_RESULT();

      }
   }

 
                              // print the data
   for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
   {
      pcFsk->iGetStateData(uiLoop2, &cFskState);

      printf("State = %u\n", uiLoop2);
      cFskState.vPrintData();
      printf("\n");
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      pcFsk->iGetEventData(uiLoop, &cFskEvent);

      printf("Event = %u\n", uiLoop);
      cFskEvent.vPrintData();
      printf("\n");
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {
         pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock);

         printf("ActionBlock = %u, %u\n", uiLoop, uiLoop2);
         cFskActionBlock.vPrintData();
         printf("\n");
         
      }
   }

   delete pcFsk;

   return(0);
}

