################################################################################
#
# Copyright (C) 1997, 2000  James A. Cureington
#                           tonyc@acm.org
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
# $Id: global_vars.tcl,v 1.1 2001/03/04 00:08:31 tonycu Exp $
#
# $Log: global_vars.tcl,v $
# Revision 1.1  2001/03/04 00:08:31  tonycu
# initial check-in at sourceforge...
#
# Revision 1.10  2000/05/24 03:19:08  tony
# Updated all copyright dates.
#
# Revision 1.9  1999/09/13 01:21:06  tony
#
# Updated copyright notice date
#
# Revision 1.8  1997/03/22  17:29:27  tony
#      1) changed FSM_BIN_DIR to FSKC_BIN_DIR
#      2) upcased state and event name in find window, so user can
#         enter the names in upper or lower case
#      3) move find from file to edit menu
#
# Revision 1.7  1997/03/01  23:23:54  tony
#      Made the following changes:
#           - Add version to FSK file for validation when reading in
#           - Check for " in parameter list
#           - Add CVS Id to source and header file
#           - Add copyright notice to header files
#           - Add EDIT menu item and associated entries
#           - Make mouse button 3 cause the commnad pop-up to be displayed
#             instead of mouse button 2
#           - Add box to insert header files into
#           - Changed pchz to pch
#           - Allow macros to be used in parameter list
#           - Add function and associated calls to check for infinite state
#             condition; this is a warning, not an error condition
#           - Add over-ride abort function capability to GUI
#           - Changed "modified save pop-up" window to be displayed before
#             any window is displayed to read and RSK, or create a new one
#
# Revision 1.6  1997/02/08  22:50:12  tony
#      1) added info window
#      2) changed text to fixed width
#      3) validate fsk before running
#      4) added fsk filename to top of main window
#      5) all path names were not being updated on a "save as"
#      6) added code to print various reports...
#
# Revision 1.5  1997/01/26  04:52:24  tony
# Made changes to:
#      - clear, copy, paste, and undo action blocks
#      - comment out Edit menu option
#      - add ".fsk" to files as needed
#      - insert user defined default function next state when a state or
#        event is inserted
#      - check for invalid number of states and events in newFsk
#      - add "save if modified" to quit menu item
#      - add "processing" and "not selectable" cursors
#      - add procs to position state and event rows, positionState &
#        positionEvent
#      - add find state, event, and function commands
#      - add generate "C" code command
#      - add "print" Fsk command
#      - add run Fsk command
#
# Revision 1.4  1997/01/14  06:25:24  tony
# added code to:
#        - copy state to internal buffer for later pasting
#        - paste the internal buffer before or after a given state
#        - add capability to initialize FSK action-blocks to default values
#        - Remove vSetModifiedFlag member function from FSK class.  The
#          modified flag will be maintained by the FSK class itself.  When
#          the FSK is modified, it is set to true.  When the FSK is read
#          or written, it is set to false.
#
# Revision 1.3  1997/01/13  08:21:25  tony
# added code to:
#        - delete states
#        - insert states
#
# Revision 1.2  1997/01/11  22:29:43  tony
#   Added code to edit state, event, and action blocks.
#
# Revision 1.1  1997/01/06  06:32:25  tony
# Initial check-in of PRODUCTION code.
#
# Revision 1.3  1996/12/13  05:23:37  tony
# Made minor comment and format changes
#
# Revision 1.2  1996/05/01  03:04:04  tony
# added global variables for action block text and next state.....
#
# Revision 1.1  1996/04/28  20:52:22  tony
# this file contains all the global variables used...  it also contains a
# procedure to be invoked when a new FSK is created or opened.....
#
#
################################################################################

######
# global variables that don't change from from one edit to another
# see initGlobalVars for global variables that must be initialized on a 
# per file bases
######

# like #defines.....

# set STATE_BLOCK        1
# set EVENT_BLOCK        2

# size of blocks (state, event, and action)
set BLOCK_SIZE              3
# set BLOCK_SIZE              4

# set initial number of rows to *display* in canvas
set DISPLAY_NUM_EVENTS       3

# set initial number of columns to *display* in canvas
set DISPLAY_NUM_STATES       4

# name of state mouse menu window
set STATE_MENU  .state_menu

# name of event mouse menu window
set EVENT_MENU  .event_menu

# name of action-block mouse menu window
set ACTION_BLOCK_MENU  .action_block_menu

# setup the fonts
## set fsk(Font1) -bitstream-courier-medium-r-normal--0-0-0-0-m-0-iso8859-1
## set fsk(Font1) -adobe-courier-medium-r-normal--0-0-75-75-m-0-iso8859-1
set fsk(Font1) -adobe-courier-medium-r-normal--10-100-75-75-m-60-iso8859-1
## set fsk(Font1) -adobe-courier-medium-r-normal--11-80-100-100-m-60-iso8859-1

set fsk(Font2) -adobe-courier-medium-r-normal--14-100-100-100-m-90-iso8859-1

set notSelectableCursor pirate
set processingCursor watch


################################################################################
# NAME    : initGlobalVars
#
# PURPOSE : This procedure initializes the global variables that must be 
#           initialized when fsmcase.tcl is run
#
################################################################################
proc initGlobalVars {} {

   # set variable to indicate if a mouse menu is active
   global mouseMenuActive
   set mouseMenuActive       0

   # if the mouse menu is activated for a block, this variable
   # contains the id of the block that the mouse menu was activated
   # for.  this variable is needed so we can un-highlight the block
   global highlightedBlockID
   set highlightedBlockID       0

   global fsk
   set fsk(defaultFunction)   "vAbortFsk();"
   set fsk(defaultNextState)  "UNASSIGNED_STATE"

   global numFuncLines
   global numDescLines
   global numHeaderLines

   global numFuncChars
   global numDescChars
   global numHeaderChars

   # number of lines for function name and parms
   set numFuncLines  8

   # number of lines for function description text
   set numDescLines  8

   # number of lines for headers
   set numHeaderLines  8

   # number of characters per function line
   set numFuncChars  48

   # number of characters per function description line
   set numDescChars  48

   # number of characters per header line
   set numHeaderChars  48

   # used by the processEditCmd proc
   global blockEditType
   set blockTypeToEdit NONE

}

