/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000, 2001  James A. Cureington
|                                 tonycu@users.sourceforge.net
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|
| $Id: fsmcase.C,v 1.1 2001/03/04 00:08:31 tonycu Exp $
|
| $Log: fsmcase.C,v $
| Revision 1.1  2001/03/04 00:08:31  tonycu
| initial check-in at sourceforge...
|
| Revision 1.5  2001/02/18 23:11:11  tony
| updated contact info and version number
|
| Revision 1.4  2000/05/24 03:19:08  tony
| Updated all copyright dates.
|
| Revision 1.3  1999/09/13 01:21:06  tony
|
| Updated copyright notice date
|
 * Revision 1.2  1997/03/22  17:29:26  tony
 *      1) changed FSM_BIN_DIR to FSKC_BIN_DIR
 *      2) upcased state and event name in find window, so user can
 *         enter the names in upper or lower case
 *      3) move find from file to edit menu
 *
 * Revision 1.1  1997/03/02  19:42:31  tony
 *      initial check-in
 *
|
\*----------------------------------------------------------------------------*/
#include <common.h>
#include <fsk.h>

STATIC CHAR *pchFsmCaseId = "@(#) $Id: fsmcase.C,v 1.1 2001/03/04 00:08:31 tonycu Exp $";


/*----------------------------------------------------------------------------*\
|                                                                              |
| Function:  Launch the fsm case tool.                                         |
|                                                                              |
| Returns:   INT                                                               |
|            0 = success                                                       |
|           !0 = failure, and error message is printed to the screen           |
|                                                                              |
\*----------------------------------------------------------------------------*/
INT
main(int iArgCount, char **ppchArgVector)
{
   CHAR* pchCommand;
   CHAR* pchBinDir;
   CHAR* pchEnvVar;

   printf("\n\n");
   printf("Finite State Kernel Creator (FSKC), version: %s\n",
          pchFskVersion);
   printf("Copyright (C) 1997, 2000, 2001  James A. Cureington\n");
   printf("                                tonycu@users.sourceforge.net\n");
   printf("\n");
   printf("FSKC comes with NO WARRANTY, to the extent permitted by law.\n");
   printf("You may redistribute copies of FSKC under the terms of the\n");
   printf("GNU General Public License.  For more information about these\n");
   printf("matters, see the file named gpl.txt.  If you can't locate the\n");
   printf("file, write to the Free Software Foundation, Inc.\n");
   printf("675 Mass Ave, Cambridge, MA 02139, USA.\n");
   printf("\n");

   if (iArgCount != 1)
   {
      printf("usage: %s\n", ppchArgVector[0]);
      printf("\n\n");
      return(0);
   }
                         // get the FSKC binaries directory
   if ((pchEnvVar = getenv("FSKC_BIN_DIR")) == NULL)
   {
      printf("\n");
      printf("ERROR: FSKC_BIN_DIR envirionment variable not set.\n");
      printf("       This envirionment variable must be set to the\n");
      printf("       directory containing the FSKC CASE Tool\n");
      printf("       binary/executable file and Tcl/Tk scripts.\n");
      printf("\n");
      return(1);
   }

   pchBinDir = (CHAR*) malloc(strlen(pchEnvVar)+1);
   CHECK_MALLOC(pchBinDir);

   strcpy(pchBinDir, pchEnvVar);

                         // remove the last "/" if it exists
   if (pchBinDir[strlen(pchBinDir)] == '/')
   {
      pchBinDir[strlen(pchBinDir)] = '\0';
   }

   pchCommand = (CHAR*) malloc((strlen(pchBinDir)*2) + 50);
   CHECK_MALLOC(pchCommand);

   sprintf(pchCommand, "%s/fsm_wish %s/fsmcase.tcl &",
           pchBinDir, pchBinDir);

   system(pchCommand);

   free(pchBinDir);
   free(pchCommand);
}

