################################################################################
#
# Copyright (C) 1997, 2000  James A. Cureington
#                           tonyc@acm.org
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
# $Id: cmd_palette.tcl,v 1.1 2001/03/04 00:08:31 tonycu Exp $
#
# $Log: cmd_palette.tcl,v $
# Revision 1.1  2001/03/04 00:08:31  tonycu
# initial check-in at sourceforge...
#
# Revision 1.12  2000/05/24 03:19:08  tony
# Updated all copyright dates.
#
# Revision 1.11  1999/09/13 01:21:05  tony
#
# Updated copyright notice date
#
# Revision 1.10  1997/03/26  07:04:06  tony
#      Fixed defects uncovered from test plan
#
# Revision 1.9  1997/03/22  17:29:25  tony
#      1) changed FSM_BIN_DIR to FSKC_BIN_DIR
#      2) upcased state and event name in find window, so user can
#         enter the names in upper or lower case
#      3) move find from file to edit menu
#
# Revision 1.8  1997/03/08  03:47:47  tony
#      1) remove new-lines (using trimright) in event, state, and action-block
#         edit windows
#      2) the nextState value was not being incremented in the action-blocks
#         when a state was inserted before it if the nextState value was 0
#      3) the copy buffer was not being update when states were deleted
#      4) if the function called in the action-block is vAbortFsk, don't
#         enclose it in a return(), i.e. return(vAbortFsk)
#      5) remove leading and trailing spaces from event and state names
#      6) change no_op function to take a parameter and return it; also,
#         rename it uiNoOp
#      7) change vPrintFskHistory to take a parameter and return it; also,
#         rename it uiPrintFskHistory
#      8) add check for duplicate event and state names
#      9) rename "recursive" variables to "iterative"
#
# Revision 1.7  1997/03/02  19:49:13  tony
#      - Added code to allow user defined error handler
#      - Added call to infinite state check
#
# Revision 1.6  1997/03/01  23:23:53  tony
#      Made the following changes:
#           - Add version to FSK file for validation when reading in
#           - Check for " in parameter list
#           - Add CVS Id to source and header file
#           - Add copyright notice to header files
#           - Add EDIT menu item and associated entries
#           - Make mouse button 3 cause the commnad pop-up to be displayed
#             instead of mouse button 2
#           - Add box to insert header files into
#           - Changed pchz to pch
#           - Allow macros to be used in parameter list
#           - Add function and associated calls to check for infinite state
#             condition; this is a warning, not an error condition
#           - Add over-ride abort function capability to GUI
#           - Changed "modified save pop-up" window to be displayed before
#             any window is displayed to read and RSK, or create a new one
#
# Revision 1.5  1997/02/10  04:00:39  tony
#      1) added code to generate C source code
#      2) added trace history
#
# Revision 1.4  1997/02/08  22:50:11  tony
#      1) added info window
#      2) changed text to fixed width
#      3) validate fsk before running
#      4) added fsk filename to top of main window
#      5) all path names were not being updated on a "save as"
#      6) added code to print various reports...
#
# Revision 1.3  1997/01/26  04:52:23  tony
# Made changes to:
#      - clear, copy, paste, and undo action blocks
#      - comment out Edit menu option
#      - add ".fsk" to files as needed
#      - insert user defined default function next state when a state or
#        event is inserted
#      - check for invalid number of states and events in newFsk
#      - add "save if modified" to quit menu item
#      - add "processing" and "not selectable" cursors
#      - add procs to position state and event rows, positionState &
#        positionEvent
#      - add find state, event, and function commands
#      - add generate "C" code command
#      - add "print" Fsk command
#      - add run Fsk command
#
# Revision 1.2  1997/01/11  22:29:42  tony
#   Added code to edit state, event, and action blocks.
#
# Revision 1.1  1997/01/06  06:32:24  tony
# Initial check-in of PRODUCTION code.
#
# Revision 1.3  1996/12/13  05:23:37  tony
# Made minor comment and format changes
#
# Revision 1.2  1996/04/28  20:48:22  tony
# moved global vars to single file;  added unit test flag to prevent more than
# one unit test from running at a time..
#
# Revision 1.1  1996/04/28  18:31:06  tony
# re-named "bmp.tcl" to "cmd_palette.tcl", a more meaningful name...
#
# Revision 1.3  1996/04/28  04:20:50  tony
# added command windows for print and run.  also, made the find and generate
# "C" code windows more user friendly....
#
# Revision 1.2  1996/04/27  07:01:08  tony
# added a pop-up window to pop-up when the find bitmap is pressed.  this pop-up
# gets the name and has state, event, and cancel push-buttons.
#
# Revision 1.1  1996/04/27  03:13:37  tony
# a prototype of creating the command palette using bitmaps....
#
#
################################################################################


################################################################################
# NAME    : runFsk
#
# PURPOSE : This procedure "runs" the FSK by user provided input...
#
################################################################################
proc runFsk {} {

   global fsk
   global fsm_window
   global tmpRFWin
   global currentStateNumber
   global currentEventNumber
   global currentStateName
   global currentEventName
   global tmpEventNumber
   global tmpEventName
   global firstTime
   global notSelectableCursor
   global processingCursor

   set tmpRFWin .tmpRFWin

   catch {destroy .tmpRFWin}


   # make sure we are working with a valid FSK before raising a window...
   ValidateFsk
   processEventArray
   if {$fsk(validateFailed) == 1} then {
      return
   }


   toplevel $tmpRFWin
   wm title $tmpRFWin "RUN FSK"
   grab set $tmpRFWin

   $fsm_window configure -cursor $processingCursor

   positionWindow $tmpRFWin  100 150

   set firstTime       1
   set tmpEventNumber ""
   set tmpEventName   ""
   set currentEventNumber ""
   set currentEventName   ""
   set currentStateNumber ""
   set currentStateName   ""
   set fsk(currentEventNumber) 0
   set fsk(currentEventName)   ""
   set fsk(currentStateNumber) 0
   set fsk(currentStateName)   ""

   ######
   # create text entry
   ######
   frame $tmpRFWin.currentState
   pack $tmpRFWin.currentState -side top

   label $tmpRFWin.currentState.label -text "Initial State :" \
         -font $fsk(Font2)
   pack $tmpRFWin.currentState.label -side left -anchor e

   entry $tmpRFWin.currentState.number -relief sunken \
        -textvariable currentStateNumber -width 5 
   pack $tmpRFWin.currentState.number -side left -pady 5 -fill x

   entry $tmpRFWin.currentState.name -relief flat \
        -textvariable currentStateName -width 30 -state disabled
   pack $tmpRFWin.currentState.name -side left -pady 5 -fill x



   frame $tmpRFWin.currentEvent
   pack $tmpRFWin.currentEvent -side top

   label $tmpRFWin.currentEvent.label -text "        Event :" \
         -font $fsk(Font2)
   pack $tmpRFWin.currentEvent.label -side left -anchor e

   entry $tmpRFWin.currentEvent.number -relief sunken \
        -textvariable currentEventNumber -width 5
   pack $tmpRFWin.currentEvent.number -side left -pady 5 -fill x

   entry $tmpRFWin.currentEvent.name -relief sunken \
        -textvariable currentEventName -width 30
   pack $tmpRFWin.currentEvent.name -side left -pady 5 -fill x

   focus $tmpRFWin.currentState.number


   ######
   # create buttons
   ######
   frame $tmpRFWin.buttons
   pack $tmpRFWin.buttons -side bottom

   set transitionCommand                                                      \
                   {                                                          \
                      if {$currentEventNumber == "" &&                        \
                          $currentEventName == "" } then {                    \
                         return;                                              \
                      };                                                      \
                                                                              \
                      if {$firstTime == 1} then {                             \
                            set firstTime 1;                                  \
                            $tmpRFWin.currentState.label configure            \
                                          -text "Current State :";            \
                            $tmpRFWin.currentState.number configure           \
                                          -state disabled;                    \
                            $tmpRFWin.currentState.name configure             \
                                  -relief sunken -state disabled;             \
                            focus $tmpRFWin.currentEvent.number;              \
                      };                                                      \
                                                                              \
                      if {$tmpEventNumber != $currentEventNumber} then {      \
                         GetNextStateByNumber $currentEventNumber             \
                                              $currentStateNumber;            \
                         focus $tmpRFWin.currentEvent.number;                 \
                         processEventArray;                                   \
                      } elseif {$tmpEventName != $currentEventName} then {    \
                         set currentEventName                                 \
                               [string toupper $currentEventName];            \
                         GetNextStateByName $currentEventName                 \
                                            $currentStateNumber;              \
                         focus $tmpRFWin.currentEvent.name;                   \
                         processEventArray;                                   \
                      };                                                      \
                                                                              \
                      positionState $fsk(currentStateNumber);                 \
                      set currentEventNumber "";                              \
                      set currentEventName "";                                \
                      set currentStateNumber $fsk(currentStateNumber);        \
                      set currentStateName $fsk(currentStateName);            \
                      set tmpEventNumber $currentEventNumber;                 \
                      set tmpEventName $currentEventName;                     \
                   }


   button $tmpRFWin.buttons.transition -text "TRANSITION"                     \
          -command $transitionCommand

   pack $tmpRFWin.buttons.transition -side left

   button $tmpRFWin.buttons.cancel -text "CANCEL" \
          -command {destroy $tmpRFWin}

   pack $tmpRFWin.buttons.cancel -side left 

   bind $tmpRFWin <Return> $transitionCommand

   $fsm_window configure -cursor $notSelectableCursor

}



################################################################################
# NAME    : printFSK
#
# PURPOSE : This procedure determines what to print (state table, state names,
#           or event names) and where to print it
#
################################################################################
proc printFsk {} {

   global fsk
   global fsm_window
   global tmpPFWin
   global tempFileName
   global notSelectableCursor
   global processingCursor

   set tmpPFWin .tmpPFWin

   catch {destroy .tmpPFWin}

   toplevel $tmpPFWin
   wm title $tmpPFWin "PRINT"
   grab set $tmpPFWin

   positionWindow $tmpPFWin  100 150

   $fsm_window configure -cursor $processingCursor


   # save name in case user cancels command so we can restore it
   set tempPrintTableName $fsk(printTableName)
   set tempStateFileName  $fsk(printStateFileName) 
   set tempEventFileName  $fsk(printEventFileName) 
   set tempPrintTablePath $fsk(stateTablePrintPath)
   set tempEventPath      $fsk(eventDescriptionPath)
   set tempStatePath      $fsk(stateDescriptionPath)

   set printStateTable 0
   set printStateDesc  0
   set printEventDesc  0

   ######
   # create text entry for state table filename and path
   ######
   frame $tmpPFWin.top
   pack $tmpPFWin.top -side top

   checkbutton $tmpPFWin.top.checkButton                                      \
               -text "Print State Transition Table"                           \
                      -variable printStateTable                               \
               -font $fsk(Font2)                                              \
               -command {                                                     \
                           if {$printStateTable == 1} then {                  \
                              $tmpPFWin.top.printTableName.entry              \
                                    config -state normal;                     \
                              $tmpPFWin.top.printTablePath.entry              \
                                    config -state normal;                     \
                              focus $tmpPFWin.top.printTableName.entry;       \
                                                                              \
                           } else {                                           \
                              $tmpPFWin.top.printTableName.entry              \
                                    config -state disabled;                   \
                              $tmpPFWin.top.printTablePath.entry              \
                                    config -state disabled;                   \
                              focus $tmpPFWin;                                \
                           };                                                 \
                        }

   pack $tmpPFWin.top.checkButton -side top -anchor w

   frame $tmpPFWin.top.printTableName
   pack $tmpPFWin.top.printTableName -side top -anchor w

   label $tmpPFWin.top.printTableName.label \
         -text "          File Name :"      \
         -font $fsk(Font2)
   pack $tmpPFWin.top.printTableName.label -side left
 
   entry $tmpPFWin.top.printTableName.entry -relief sunken 
   $tmpPFWin.top.printTableName.entry config -width 25 \
         -textvariable fsk(printTableName) 
   pack $tmpPFWin.top.printTableName.entry -side left \
         -pady 4 -padx 10 -fill x


   frame $tmpPFWin.top.printTablePath
   pack $tmpPFWin.top.printTablePath -side top -anchor w

   label $tmpPFWin.top.printTablePath.label  \
         -text "          Path      :"       \
         -font $fsk(Font2) 
   pack $tmpPFWin.top.printTablePath.label -side left
 
   entry $tmpPFWin.top.printTablePath.entry -relief sunken 
   $tmpPFWin.top.printTablePath.entry config -width 35 \
         -textvariable fsk(stateTablePrintPath) 
   pack $tmpPFWin.top.printTablePath.entry -side left \
         -pady 4 -padx 10 -fill x

   $tmpPFWin.top.printTableName.entry config -state disabled;
   $tmpPFWin.top.printTablePath.entry config -state disabled;



   ######
   # create text entry for event description file and path
   ######
   frame $tmpPFWin.mid
   pack $tmpPFWin.mid -side top -pady 8

   checkbutton $tmpPFWin.mid.checkButton                                      \
               -text "Print Event Descriptions" -variable printEventDesc      \
               -font $fsk(Font2)                                              \
               -command {                                                     \
                           if {$printEventDesc == 1} then {                   \
                              $tmpPFWin.mid.printEventDescName.entry          \
                                    config -state normal;                     \
                              $tmpPFWin.mid.printEventDescPath.entry          \
                                    config -state normal;                     \
                              focus $tmpPFWin.mid.printEventDescName.entry;   \
                                                                              \
                           } else {                                           \
                              $tmpPFWin.mid.printEventDescName.entry          \
                                    config -state disabled;                   \
                              $tmpPFWin.mid.printEventDescPath.entry          \
                                    config -state disabled;                   \
                              focus $tmpPFWin;                                \
                           };                                                 \
                        }

   pack $tmpPFWin.mid.checkButton -side top -anchor w

   frame $tmpPFWin.mid.printEventDescName
   pack $tmpPFWin.mid.printEventDescName -side top -anchor w

   label $tmpPFWin.mid.printEventDescName.label \
         -text "          File Name :"          \
         -font $fsk(Font2) 
   pack $tmpPFWin.mid.printEventDescName.label -side left
 
   entry $tmpPFWin.mid.printEventDescName.entry -relief sunken 
   $tmpPFWin.mid.printEventDescName.entry config -width 25 \
         -textvariable fsk(printEventFileName) 
   pack $tmpPFWin.mid.printEventDescName.entry -side left \
         -pady 4 -padx 10 -fill x


   frame $tmpPFWin.mid.printEventDescPath
   pack $tmpPFWin.mid.printEventDescPath -side top -anchor w

   label $tmpPFWin.mid.printEventDescPath.label  \
         -text "          Path      :"           \
         -font $fsk(Font2) 
   pack $tmpPFWin.mid.printEventDescPath.label -side left
 
   entry $tmpPFWin.mid.printEventDescPath.entry -relief sunken 
   $tmpPFWin.mid.printEventDescPath.entry config -width 35 \
         -textvariable fsk(eventDescriptionPath) 
   pack $tmpPFWin.mid.printEventDescPath.entry -side left \
         -pady 4 -padx 10 -fill x

   $tmpPFWin.mid.printEventDescName.entry config -state disabled;
   $tmpPFWin.mid.printEventDescPath.entry config -state disabled;


   ######
   # create text entry for state description file and path
   ######
   frame $tmpPFWin.bot
   pack $tmpPFWin.bot -side top -pady 8

   checkbutton $tmpPFWin.bot.checkButton                                      \
               -text "Print State Descriptions" -variable printStateDesc      \
               -font $fsk(Font2)                                              \
               -command {                                                     \
                           if {$printStateDesc == 1} then {                   \
                              $tmpPFWin.bot.printStateDescName.entry          \
                                    config -state normal;                     \
                              $tmpPFWin.bot.printStateDescPath.entry          \
                                    config -state normal;                     \
                              focus $tmpPFWin.bot.printStateDescName.entry;   \
                                                                              \
                           } else {                                           \
                              $tmpPFWin.bot.printStateDescName.entry          \
                                    config -state disabled;                   \
                              $tmpPFWin.bot.printStateDescPath.entry          \
                                    config -state disabled;                   \
                              focus $tmpPFWin;                                \
                           };                                                 \
                        }

   pack $tmpPFWin.bot.checkButton -side top -anchor w

   frame $tmpPFWin.bot.printStateDescName
   pack $tmpPFWin.bot.printStateDescName -side top -anchor w

   label $tmpPFWin.bot.printStateDescName.label \
         -text "          File Name :"          \
         -font $fsk(Font2) 
   pack $tmpPFWin.bot.printStateDescName.label -side left
 
   entry $tmpPFWin.bot.printStateDescName.entry -relief sunken 
   $tmpPFWin.bot.printStateDescName.entry config -width 25 \
         -textvariable fsk(printStateFileName) 
   pack $tmpPFWin.bot.printStateDescName.entry -side left \
         -pady 4 -padx 10 -fill x


   frame $tmpPFWin.bot.printStateDescPath
   pack $tmpPFWin.bot.printStateDescPath -side top -anchor w

   label $tmpPFWin.bot.printStateDescPath.label  \
         -text "          Path      :"           \
         -font $fsk(Font2) 
   pack $tmpPFWin.bot.printStateDescPath.label -side left
 
   entry $tmpPFWin.bot.printStateDescPath.entry -relief sunken 
   $tmpPFWin.bot.printStateDescPath.entry config -width 35 \
         -textvariable fsk(stateDescriptionPath) 
   pack $tmpPFWin.bot.printStateDescPath.entry -side left \
         -pady 4 -padx 10 -fill x

   $tmpPFWin.bot.printStateDescName.entry config -state disabled;
   $tmpPFWin.bot.printStateDescPath.entry config -state disabled;


   ######
   # create buttons
   ######
   frame $tmpPFWin.buttons
   pack $tmpPFWin.buttons -side bottom

   # TODO, need to change OVERWRITE_OK below to OVERWRITE_NOT_OK and
   #       handle it...
   button $tmpPFWin.buttons.print -text "PRINT"        \
          -command {
                     $tmpPFWin configure -cursor $processingCursor;        \
                     PrintFsk $printStateTable                               \
                              $printEventDesc                                \
                              $printStateDesc                                \
                              OVERWRITE_OK;                                  \
                     destroy $tmpPFWin;                                    \
                     processEventArray                                       \
                   }

   pack $tmpPFWin.buttons.print -side left

   button $tmpPFWin.buttons.cancel -text "CANCEL"                   \
          -command "set fsk(printTableName) $tempPrintTableName;      \
                    set fsk(printStateFileName) $tempStateFileName;   \
                    set fsk(printEventFileName) $tempEventFileName;   \
                    set fsk(stateTablePrintPath) $tempPrintTablePath; \
                    set fsk(eventDescriptionPath) $tempEventPath;     \
                    set fsk(stateDescriptionPath) $tempStatePath;     \
                    destroy $tmpPFWin"

   pack $tmpPFWin.buttons.cancel -side left 
   $tmpPFWin.top.checkButton deselect
   $tmpPFWin.mid.checkButton deselect
   $tmpPFWin.bot.checkButton deselect
   $fsm_window configure -cursor $notSelectableCursor
   focus $tmpPFWin
}



################################################################################
# NAME    : generateCode
#
# PURPOSE : This procedure creates "C" code for the Finite State Kernel
#
################################################################################
proc generateCode {} {

   global fsk
   global fsm_window
   global tmpGCWin
   global notSelectableCursor
   global processingCursor
   global transitionHistory

   set tmpGCWin .tmpGCWin

   catch {destroy .tmpGCWin}

   # make sure we are working with a valid FSK before raising a window...
   ValidateFsk
   processEventArray
   if {$fsk(validateFailed) == 1} then {
      return
   }

   InfiniteStateCheck
   processEventArray
   waitOnDisplayScrollMessage $tmpGCWin
   if {$fsk(validateFailed) == 1} then {
      return
   }

   toplevel $tmpGCWin
   wm title $tmpGCWin "GENERATE C CODE"
   grab set $tmpGCWin

   positionWindow $tmpGCWin  100 150

   $fsm_window configure -cursor $processingCursor


   ######
   # create text entry for filename
   ######

   # save name in case user cancels command so we can restore it
   set tempFileName $fsk(sourceFileName)

   frame $tmpGCWin.fileName
   pack $tmpGCWin.fileName -side top -anchor w

   label $tmpGCWin.fileName.label -text "File Name :" \
         -font $fsk(Font2)
   pack $tmpGCWin.fileName.label -side left
 
   entry $tmpGCWin.fileName.entry -relief sunken 
   $tmpGCWin.fileName.entry config -width 25 \
         -textvariable fsk(sourceFileName) 
   pack $tmpGCWin.fileName.entry -side left -pady 5 -padx 10 -fill x


   ######
   # create text entry path
   ######
   set tempFileNamePath $fsk(sourceFilePath)

   frame $tmpGCWin.pathName
   pack $tmpGCWin.pathName -side top -anchor w

   label $tmpGCWin.pathName.label -text "Path      :" \
         -font $fsk(Font2)
   pack $tmpGCWin.pathName.label -side left
 
   entry $tmpGCWin.pathName.entry -relief sunken 
   $tmpGCWin.pathName.entry config -width 35 \
         -textvariable fsk(sourceFilePath) 
   pack $tmpGCWin.pathName.entry -side left -pady 5 -padx 10 -fill x

   focus $tmpGCWin.fileName.entry


   # ADD, if entry field above is blank, only allow cancel to be selected...

   ######
   # create text entry for transition history
   ######
   frame $tmpGCWin.transitionHistory
   pack $tmpGCWin.transitionHistory -side top -anchor w

   label $tmpGCWin.transitionHistory.label -text "Transition History :" \
         -font $fsk(Font2)
   pack $tmpGCWin.transitionHistory.label -side left
 
   entry $tmpGCWin.transitionHistory.entry -relief sunken 
   $tmpGCWin.transitionHistory.entry config -width 3 \
         -textvariable transitionHistory
   pack $tmpGCWin.transitionHistory.entry -side left -pady 5 -padx 10 -fill x


   ######
   # create buttons
   ######
   frame $tmpGCWin.buttons
   pack $tmpGCWin.buttons -side bottom

   # TODO, need to change OVERWRITE_OK below to OVERWRITE_NOT_OK and
   #       handle it...
   # make sure we are working with a valid FSK before attempting to gen source
   button $tmpGCWin.buttons.generate -text "GENERATE"                         \
          -command {                                                          \
                     $tmpGCWin configure -cursor $processingCursor;           \
                     set iLen [string length $fsk(sourceFileName)];           \
                     set index [expr $iLen-2];                                \
                     set tmpStr [string range $fsk(sourceFileName)            \
                                      $index end];                            \
                     if {$tmpStr != ".c"  &&                                  \
                         $tmpStr != ".C"} then {                              \
                             set fsk(sourceFileName)                          \
                                     $fsk(sourceFileName).c;                  \
                     };                                                       \
                     GenerateSourceCode $transitionHistory OVERWRITE_OK;      \
                     destroy $tmpGCWin;                                       \
                     processEventArray;                                       \
                   }

   pack $tmpGCWin.buttons.generate -side left

   button $tmpGCWin.buttons.cancel -text "CANCEL"             \
          -command "set fsk(sourceFileName) $tempFileName;      \
                    set fsk(sourceFilePath) $tempFileNamePath;  \
                    destroy $tmpGCWin"

   pack $tmpGCWin.buttons.cancel -side left 
   $fsm_window configure -cursor $notSelectableCursor
}



################################################################################
# NAME    : positionEvent
#
# PURPOSE : This procedure positions a given event block at the top of the
#           event block scroll region.
#
################################################################################
proc positionEvent {eventNumber} {

   global action_block_canvas
   global event_block_canvas

   $action_block_canvas yview moveto 0.0
   $event_block_canvas yview moveto 0.0
   $action_block_canvas yview scroll $eventNumber units
   $event_block_canvas yview scroll $eventNumber units
}



################################################################################
# NAME    : positionState
#
# PURPOSE : This procedure positions a given state block at the left of the
#           state block scroll region.
#
################################################################################
proc positionState {stateNumber} {
 
   global action_block_canvas
   global state_block_canvas

   $action_block_canvas xview moveto 0.0
   $state_block_canvas xview moveto 0.0
   $action_block_canvas xview scroll $stateNumber units
   $state_block_canvas xview scroll $stateNumber units

}



################################################################################
# NAME    : findFskItem
#
# PURPOSE : This procedure displays a window to gather the information needed
#           to find a state, event, or function
#
################################################################################
proc findFskItem {} {

   # must make tempWindow a global in order to destroy it using the "button 
   # -command"
   global fsk
   global fsm_window
   global tmpFFIWin
   set tmpFFIWin .tmpFFIWin
   global notSelectableCursor
   global processingCursor

   catch {destroy .tmpFFIWin}

   toplevel $tmpFFIWin
   wm title $tmpFFIWin "FIND"
   grab set $tmpFFIWin

   $fsm_window configure -cursor $processingCursor


   set itemNameToFind ""

   ######
   # create text entry field
   ######

   frame $tmpFFIWin.entry
   pack $tmpFFIWin.entry -side top

   label $tmpFFIWin.entry.label -text "Name :" 
   pack $tmpFFIWin.entry.label -side left

   entry $tmpFFIWin.entry.blockName -relief sunken \
         -textvariable itemNameToFind -width 25
   pack $tmpFFIWin.entry.blockName -side left -pady 5 -padx 10 -fill x
   $tmpFFIWin.entry.blockName delete 0 end 
   
   focus $tmpFFIWin.entry.blockName

   # ADD, if entry field above is blank, only allow cancel to be selected...

   ######
   # create buttons
   ######
   frame $tmpFFIWin.buttons
   pack $tmpFFIWin.buttons -side top

   button $tmpFFIWin.buttons.state -text "Find STATE"                        \
          -command {                                                         \
                       set itemNameToFind [string toupper $itemNameToFind];  \
                       FindFskItem STATE $itemNameToFind;                    \
                       destroy $tmpFFIWin;                                   \
                       processEventArray;                                    \
                   }
   pack $tmpFFIWin.buttons.state -side left

   button $tmpFFIWin.buttons.event -text "Find EVENT"                        \
          -command {                                                         \
                       set itemNameToFind [string toupper $itemNameToFind];  \
                       FindFskItem EVENT $itemNameToFind;                    \
                       destroy $tmpFFIWin;                                   \
                       processEventArray;                                    \
                   }
   pack $tmpFFIWin.buttons.event -side left 

   button $tmpFFIWin.buttons.function -text "Find FUNCTION"  \
          -command {                                          \
                       FindFskItem FUNCTION $itemNameToFind;  \
                       destroy $tmpFFIWin;                   \
                       processEventArray;                     \
                   }
   pack $tmpFFIWin.buttons.function -side left 

   frame $tmpFFIWin.bottom
   pack $tmpFFIWin.bottom -side bottom

   button $tmpFFIWin.bottom.cancel -text "CANCEL" \
          -command {destroy $tmpFFIWin}
   pack $tmpFFIWin.bottom.cancel -side bottom

   positionWindow $tmpFFIWin  100 150
   raise $tmpFFIWin 
   $fsm_window configure -cursor $notSelectableCursor
}



################################################################################
# NAME    : createCommandPalette
#
# PURPOSE : This procedure creates the command palette..           
#
################################################################################
proc createCommandPalette {} {

   global fsk
   global fsmFileName
   set commandPalette .commandPaletteWindow

   ######
   # only allow one command palette to exist for each main FSK window
   ######
   if [winfo exists $commandPalette] {
      raise $commandPalette
      return
   }


   toplevel $commandPalette
   wm title $commandPalette "COMMAND PALETTE"

   image create bitmap find_bmp -file $fsk(binDirectory)/find.bmp
   image create bitmap code_bmp -file $fsk(binDirectory)/code.bmp
   image create bitmap print_bmp -file $fsk(binDirectory)/print.bmp
   image create bitmap run_bmp -file $fsk(binDirectory)/run.bmp
   image create bitmap save_bmp -file $fsk(binDirectory)/save.bmp

   ######
   # create canvas rows for commands
   ######
   canvas $commandPalette.row1
   canvas $commandPalette.row2
   canvas $commandPalette.row3

   pack $commandPalette.row1 -side top
   pack $commandPalette.row2 -side top
   pack $commandPalette.row3 -side top

   ######
   # create buttons in row 1
   ######
   button $commandPalette.row1.find_bmp -image find_bmp \
          -command  {findFskItem}
   pack $commandPalette.row1.find_bmp -side left

   button $commandPalette.row1.code_bmp -image code_bmp \
          -command  {generateCode}
   pack $commandPalette.row1.code_bmp -side right

   ######
   # create buttons in row 2
   ######
   button $commandPalette.row2.print_bmp -image print_bmp \
          -command  {printFsk}
   pack $commandPalette.row2.print_bmp -side left

   button $commandPalette.row2.run_bmp -image run_bmp \
          -command  {runFsk}
   pack $commandPalette.row2.run_bmp -side right 

   ######
   # create buttons in row 3
   ######
   button $commandPalette.row3.save_bmp -image save_bmp                     \
          -command  {                                                       \
                       SaveFsk $fsk(completeFileName) OVERWRITE_OK;         \
                       processEventArray;                                   \
                    }
   pack $commandPalette.row3.save_bmp -side right 

   positionWindow $commandPalette  100 150
   raise $commandPalette 

}


