/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| January 26, 1997                                                             
|                                                                              
| Module:  unit test for VirtualPage class                  
|                                                                              
| $Id: virtual_page_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $
|                                                                              
| $Log: virtual_page_ut.C,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.4  2000/05/24 03:19:02  tony
| Updated all copyright dates.
|
| Revision 1.3  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
 * Revision 1.2  1997/03/26  07:07:16  tony
 *      Fixed defects uncovered from test plan
 *
 * Revision 1.1  1997/03/01  23:12:42  tony
 *      initial check-in
 *
|                                                                              
\*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include <common.h>
#include <virtual_page.h>

CHAR achAppErrorString[ERROR_STRING_LEN];

STATIC CHAR *pchVirtualPageUtId = "@(#) $Id: virtual_page_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

INT iTestNum = 0;

#define CHECK_RESULT()                                             \
   {                                                               \
      printf("------ ERROR ------ %s, %d  -- test %d\n",           \
              __FILE__, __LINE__, ++iTestNum);                     \
      return(1);                                                   \
   }                                                               \
   printf("------ GOOD ------ %s, %d  -- test %d\n",               \
           __FILE__, __LINE__, ++iTestNum);





main()
{
   UINT   uiLoop;
   UINT   uiNumLines     = 50;
   UINT   uiCharsPerLine = 80;
   CHAR   achLine[90];
   VirtualPage* pcVirtualPage;


                              // simple tests
   pcVirtualPage = new VirtualPage(uiNumLines, uiCharsPerLine);

   if (uiNumLines != *pcVirtualPage->puiNumLines)
      CHECK_RESULT();

   if (uiCharsPerLine != *pcVirtualPage->puiNumCharsPerLine)
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(0, "first line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(2, 5, "second line offset 5"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines-1, "last line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines-2, 10, 
                                 "next to last line offset 10"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines-2, uiCharsPerLine-1, "-"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(1, uiCharsPerLine-2, "--"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(4, 0, "LINE4XXXXXXXXXXXXXXXXXXXXXXXXXXX"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(4, 8, " 9 "))
      CHECK_RESULT();


   for (uiLoop=0; uiLoop<uiCharsPerLine; uiLoop++)
   {
      sprintf(achLine, "%d", uiLoop%10);
      if (pcVirtualPage->iWriteLine(3, uiLoop, achLine))
         CHECK_RESULT();
   }

   if (pcVirtualPage->iWriteLine(11, "CENTERED LINES..."))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteCenteredLine(12, "1"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteCenteredLine(13, "22"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteCenteredLine(14, "333"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteCenteredLine(15, "This is a centerd line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteCenteredLine(16, "Another centerd line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteRightJustifiedLine(18, "Right justified line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteRightJustifiedLine(19, "1"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteRightJustifiedLine(20, 
                                              "Another right justifie line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLeftJustifiedLine(18, "Left justified line"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLeftJustifiedLine(19, "1"))
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLeftJustifiedLine(20, 
                                              "Another left justifie line"))
      CHECK_RESULT();




                                  // test errors, boundary conditions
   if (pcVirtualPage->iWriteLine(uiNumLines, "last line +1") == 0)
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines-1, uiCharsPerLine, 
       "last line, num chars +1") == 0)
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines, uiCharsPerLine-1, 
       "last line +1 , num chars") == 0)
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines, uiCharsPerLine, 
       "last line +1, num chars +1") == 0)
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines-8, uiCharsPerLine-2, "---") == 0)
      CHECK_RESULT();

   if (pcVirtualPage->iWriteLine(uiNumLines-8, uiCharsPerLine-1, "--") == 0)
      CHECK_RESULT();

   if (pcVirtualPage->iPrintPage("page.out", REPLACE, OVERWRITE))
      CHECK_RESULT();

   if (pcVirtualPage->iPrintPage("page.out", APPEND, OVERWRITE))
      CHECK_RESULT();

   pcVirtualPage->vClearPage();

   if (pcVirtualPage->iPrintPage("page.out", APPEND, OVERWRITE))
      CHECK_RESULT();



   return(0);
}

