/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| January, 26, 1997                                                            
|                                                                              
| Module:  Virtual page class.  Allows entire page to be modified at  
|          random locations, then printed to a file.             
|                                                                              
| $Id: virtual_page.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $
|                                                                              
| $Log: virtual_page.h,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.5  2000/05/24 03:19:02  tony
| Updated all copyright dates.
|
| Revision 1.4  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
 * Revision 1.3  1997/03/01  23:20:52  tony
 *      added copyright notice
 *
 * Revision 1.2  1997/02/08  22:43:08  tony
 *      1) made changes to return ERROR instead of 1 when an error is detected
 *      2) changed makefile to make unit tests seperate, make UT
 *      3) fixed bug in virtual_page.C
 *      4) added MAX and MIN macros
 *      5) added set last modified date function
 *
 * Revision 1.1  1997/01/29  04:21:08  tony
 * initial check-in of virtual page class
 *
|                                                                              
\*----------------------------------------------------------------------------*/
#ifndef D_VIRTUAL_PAGE_H
#define D_VIRTUAL_PAGE_H

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>

#include <common.h>


STATIC CHAR *pchVirtualPageHId = "@(#) $Id: virtual_page.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

/*----------------------------------------------------------------------------*\
|                                                                              |
| Virtual page class definitions                                               |
|                                                                              |
\*----------------------------------------------------------------------------*/
class 
VirtualPage 
{
   public:

      VirtualPage(UINT uiNumLines=1, UINT uiNumCharsPerLine=1);

      virtual ~VirtualPage();

                                     // write the contents of the given string
                                     // to the specified virtual page line
      INT iWriteLine(UINT uiLineNumber, CHAR* pchTextString);

                                     // write the contents of the given string
                                     // to the specified virtual page line
                                     // at the given offset number of chars,
                                     // the offset is zero based
      INT iWriteLine(UINT uiLineNumber, UINT uiOffset, CHAR* pchTextString);

                                     // write the string centered in the 
                                     // specified line of the page
      INT iWriteCenteredLine(UINT uiLineNumber, CHAR* pchTextString);

                                     // right justify the string on the 
                                     // specified line                    
      INT iWriteRightJustifiedLine(UINT uiLineNumber, CHAR* pchTextString);

                                     // left justify the string on the 
                                     // specified line                    
      INT iWriteLeftJustifiedLine(UINT uiLineNumber, CHAR* pchTextString);

                                     // clear the contents of the virtual page
      VOID vClearPage();

                                  // set the max lines on any given page, used 
                                  // to determine if a page feed is needed;
                                  // hence, if the iMaxLinesPerPage line is
                                  // blank, we need a page feed              
      VOID vSetMaxLinesPerPage(UINT uiMaxLines);

                                     // print the virtual page to  the 
                                     // specified file, replacing or appending
                                     // the page to the file
      INT iPrintPage(CHAR* pchOutputFile, INT iAppendOrReplace, 
                     INT iOverWrite);


      const UINT*  puiNumLines;
      const UINT*  puiNumCharsPerLine;

   protected:

   private:
      UINT   uiMaxLinesPerPage;   // max lines on any given page, used to
                                  // determine if a page feed is needed;
                                  // hence, if the iMaxLinesPerPage line is
                                  // blank, we need a page feed              
      UINT    uiNumLines;
      UINT    uiNumCharsPerLine;

      CHAR**  ppchVirtualPage; 

};

#endif /* D_VIRTUAL_PAGE_H */
