/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| September 28, 1996                                                           
|                                                                              
| Module:  unit test for Fsk class                          
|                                                                              
| $Id: fsk_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $
|                                                                              
| $Log: fsk_ut.C,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.8  2000/05/24 03:19:02  tony
| Updated all copyright dates.
|
| Revision 1.7  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
 * Revision 1.6  1997/03/08  03:48:04  tony
 *      1) remove new-lines (using trimright) in event, state, and action-block
 *         edit windows
 *      2) the nextState value was not being incremented in the action-blocks
 *         when a state was inserted before it if the nextState value was 0
 *      3) the copy buffer was not being update when states were deleted
 *      4) if the function called in the action-block is vAbortFsk, don't
 *         enclose it in a return(), i.e. return(vAbortFsk)
 *      5) remove leading and trailing spaces from event and state names
 *      6) change no_op function to take a parameter and return it; also,
 *         rename it uiNoOp
 *      7) change vPrintFskHistory to take a parameter and return it; also,
 *         rename it uiPrintFskHistory
 *      8) add check for duplicate event and state names
 *      9) rename "recursive" variables to "iterative"
 *
 * Revision 1.5  1997/03/01  23:24:16  tony
 *      Made the following changes:
 *           - Add version to FSK file for validation when reading in
 *           - Check for " in parameter list
 *           - Add CVS Id to source and header file
 *           - Add copyright notice to header files
 *           - Add EDIT menu item and associated entries
 *           - Make mouse button 3 cause the commnad pop-up to be displayed
 *             instead of mouse button 2
 *           - Add box to insert header files into
 *           - Changed pchz to pch
 *           - Allow macros to be used in parameter list
 *           - Add function and associated calls to check for infinite state
 *             condition; this is a warning, not an error condition
 *           - Add over-ride abort function capability to GUI
 *           - Changed "modified save pop-up" window to be displayed before
 *             any window is displayed to read and RSK, or create a new one
 *
 * Revision 1.4  1997/01/26  04:57:19  tony
 * Made changes to:
 *      - insert user defined default function next state when a state or
 *        event is inserted
 *      - stub out future functions
 *      - change tabs to spaces
 *
 * Revision 1.3  1996/12/13  05:54:44  tony
 * Changed iCopyEvent and iCopyState to use the "this" pointer
 * Stubbed out un-implemented member functions
 *
 * Revision 1.2  1996/12/13  04:16:22  tony
 * 1. Moved public arrays in classes to private and added const pointers to
 *    the private members
 *
 * 2. Added assignment operators to classes
 *
 * 3. Changed the dynamic array class - replaced malloc/free with new/delete
 *    so it could work with all objects
 *
 * Revision 1.1  1996/11/27  06:18:25  tony
 * Initial unit test for FSK class.
 *
|                                                                              
\*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include <common.h>
#include <fsk.h>
#include <fsk.C>

STATIC CHAR *pchFskUtId = "@(#) $Id: fsk_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

INT iTestNum = 0;

#define CHECK_RESULT()                                             \
   {                                                               \
      printf("------ ERROR ------ %s, %d  -- test %d\n",           \
              __FILE__, __LINE__, ++iTestNum);                     \
      return(1);                                                   \
   }                                                               \
   printf("------ GOOD ------ %s, %d  -- test %d\n",               \
           __FILE__, __LINE__, ++iTestNum);





main()
{
   UINT   uiLoop;
   UINT   uiLoop2;
   UINT  uiNumStates;
   UINT  uiNumEvents;
   CHAR  achTempString[60]; 
   Fsk*  pcFsk;
   Fsk*  pcFsk2;

   FskEvent cFskEvent;
   FskState cFskState;
   FskActionBlock  cFskActionBlock;

   FskEvent cFskEvent2;
   FskState cFskState2;
   FskActionBlock  cFskActionBlock2;

                              // simple tests
   pcFsk = new Fsk(5,5);

   uiNumStates = pcFsk->uiGetNumStates();
   uiNumEvents = pcFsk->uiGetNumEvents();

   if (uiNumStates != 5)
      CHECK_RESULT();

   if (uiNumEvents != 5)
      CHECK_RESULT();

   if (pcFsk->iInsertState(2, AFTER))
      CHECK_RESULT();
   uiNumStates = pcFsk->uiGetNumStates();
   if (uiNumStates != 6)
      CHECK_RESULT();

   if (pcFsk->iInsertEvent(2, AFTER))
      CHECK_RESULT();
   uiNumEvents = pcFsk->uiGetNumEvents();
   if (uiNumEvents != 6)
      CHECK_RESULT();


   if (pcFsk->iDeleteState(3))
      CHECK_RESULT();
   uiNumStates = pcFsk->uiGetNumStates();
   if (uiNumStates != 5)
      CHECK_RESULT();

   if (pcFsk->iDeleteEvent(3))
      CHECK_RESULT();
   uiNumEvents = pcFsk->uiGetNumEvents();
   if (uiNumEvents != 5)
      CHECK_RESULT();

   delete pcFsk;



                              // test setting data in FSK states, events
                              // and action blocks
   pcFsk = new Fsk(3,3);
   pcFsk2 = new Fsk(3,3);

   if (pcFsk->uiGetNumEvents() != pcFsk2->uiGetNumEvents())
      CHECK_RESULT();

   if (pcFsk->uiGetNumStates() != pcFsk2->uiGetNumStates())
      CHECK_RESULT();

   srand(1942);

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      sprintf(achTempString, "%d", rand());
      if (cFskEvent.iSetName(achTempString))
         CHECK_RESULT();

      sprintf(achTempString, "%d %d", rand(), rand());
      if (cFskEvent.iSetDescription(achTempString))
         CHECK_RESULT();

      if (pcFsk->iSetEventData(uiLoop, &cFskEvent)) 
         CHECK_RESULT();
      if (pcFsk2->iSetEventData(uiLoop, &cFskEvent)) 
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      sprintf(achTempString, "%d", rand());
      if (cFskState.iSetName(achTempString))
         CHECK_RESULT();

      sprintf(achTempString, "%d %d", rand(), rand());
      if (cFskState.iSetDescription(achTempString))
         CHECK_RESULT();

      if (pcFsk->iSetStateData(uiLoop, &cFskState)) 
         CHECK_RESULT();
      if (pcFsk2->iSetStateData(uiLoop, &cFskState)) 
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {

         cFskActionBlock.vSetIterative(uiLoop2%2);

         sprintf(achTempString, "%d", rand());
         if (cFskActionBlock.iSetFunction(achTempString))
            CHECK_RESULT();

         sprintf(achTempString, "%d %d", rand(), rand());
         if (cFskActionBlock.iSetDescription(achTempString))
            CHECK_RESULT();

         if (pcFsk->iSetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
         if (pcFsk2->iSetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
      }
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      
      if (pcFsk->iGetEventData(uiLoop, &cFskEvent))
         CHECK_RESULT();
      if (pcFsk2->iGetEventData(uiLoop, &cFskEvent2))
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchName,
                 cFskEvent2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchDescription,
                 cFskEvent2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      
      if (pcFsk->iGetStateData(uiLoop, &cFskState))
         CHECK_RESULT();
      if (pcFsk2->iGetStateData(uiLoop, &cFskState2))
         CHECK_RESULT();

      if (strcmp(cFskState.pchName,
                 cFskState2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskState.pchDescription,
                 cFskState2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {


         if (pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
         if (pcFsk2->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock2))
            CHECK_RESULT();

         if (*(cFskActionBlock.piIterative) != 
             *(cFskActionBlock2.piIterative))
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchFunction,
                    cFskActionBlock2.pchFunction) != 0)
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchDescription,
                    cFskActionBlock2.pchDescription) != 0)
            CHECK_RESULT();

      }
   }

   if (pcFsk->iWriteFile("output1a", 1))
      CHECK_RESULT();

   if (pcFsk2->iWriteFile("output2a", 1))
      CHECK_RESULT();


                              // test copying events
   if (pcFsk->iCopyEvent(0, 2))
      CHECK_RESULT();
   if (pcFsk2->iCopyEvent(0, 1))
      CHECK_RESULT();

   if (pcFsk->iGetEventData(2, &cFskEvent))
      CHECK_RESULT();
   if (pcFsk2->iGetEventData(1, &cFskEvent2))
      CHECK_RESULT();

   if (strcmp(cFskEvent.pchName,
              cFskEvent2.pchName) != 0)
      CHECK_RESULT();

   if (strcmp(cFskEvent.pchDescription,
              cFskEvent2.pchDescription) != 0)
      CHECK_RESULT();

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      if (pcFsk->iGetActionBlockData(2, uiLoop, &cFskActionBlock))
         CHECK_RESULT();
      if (pcFsk2->iGetActionBlockData(1, uiLoop, &cFskActionBlock2))
         CHECK_RESULT();

      if (*(cFskActionBlock.piIterative) != 
          *(cFskActionBlock2.piIterative))
         CHECK_RESULT();

      if (strcmp(cFskActionBlock.pchFunction,
                 cFskActionBlock2.pchFunction) != 0)
         CHECK_RESULT();

      if (strcmp(cFskActionBlock.pchDescription,
                 cFskActionBlock2.pchDescription) != 0)
         CHECK_RESULT();
   }


                              // now, put the fsk back to the way it was
   if (pcFsk2->iCopyEvent(2, pcFsk, 2))
      CHECK_RESULT();
   if (pcFsk->iCopyEvent(1, pcFsk2, 1))
      CHECK_RESULT();


                              // check-out the entire FSK
   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      
      if (pcFsk->iGetEventData(uiLoop, &cFskEvent))
         CHECK_RESULT();
      if (pcFsk2->iGetEventData(uiLoop, &cFskEvent2))
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchName,
                 cFskEvent2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchDescription,
                 cFskEvent2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      
      if (pcFsk->iGetStateData(uiLoop, &cFskState))
         CHECK_RESULT();
      if (pcFsk2->iGetStateData(uiLoop, &cFskState2))
         CHECK_RESULT();

      if (strcmp(cFskState.pchName,
                 cFskState2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskState.pchDescription,
                 cFskState2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {


         if (pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
         if (pcFsk2->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock2))
            CHECK_RESULT();

         if (*(cFskActionBlock.piIterative) != 
             *(cFskActionBlock2.piIterative))
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchFunction,
                    cFskActionBlock2.pchFunction) != 0)
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchDescription,
                    cFskActionBlock2.pchDescription) != 0)
            CHECK_RESULT();

      }
   }

                              // test copying states

   if (pcFsk->iCopyState(0, 2))
      CHECK_RESULT();
   if (pcFsk2->iCopyState(0, 1))
      CHECK_RESULT();

   if (pcFsk->iGetStateData(2, &cFskState))
      CHECK_RESULT();
   if (pcFsk2->iGetStateData(1, &cFskState2))
      CHECK_RESULT();

   if (strcmp(cFskState.pchName,
              cFskState2.pchName) != 0)
      CHECK_RESULT();

   if (strcmp(cFskState.pchDescription,
              cFskState2.pchDescription) != 0)
      CHECK_RESULT();

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      if (pcFsk->iGetActionBlockData(uiLoop, 2, &cFskActionBlock))
         CHECK_RESULT();
      if (pcFsk2->iGetActionBlockData(uiLoop, 1,  &cFskActionBlock2))
         CHECK_RESULT();

      if (*(cFskActionBlock.piIterative) != 
          *(cFskActionBlock2.piIterative))
         CHECK_RESULT();

      if (strcmp(cFskActionBlock.pchFunction,
                 cFskActionBlock2.pchFunction) != 0)
         CHECK_RESULT();

      if (strcmp(cFskActionBlock.pchDescription,
                 cFskActionBlock2.pchDescription) != 0)
         CHECK_RESULT();
   }


                              // now, put the fsk back to the way it was
   if (pcFsk2->iCopyState(2, pcFsk, 2))
      CHECK_RESULT();
   if (pcFsk->iCopyState(1, pcFsk2, 1))
      CHECK_RESULT();


                              // check-out the entire FSK
   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      
      if (pcFsk->iGetEventData(uiLoop, &cFskEvent))
         CHECK_RESULT();
      if (pcFsk2->iGetEventData(uiLoop, &cFskEvent2))
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchName,
                 cFskEvent2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchDescription,
                 cFskEvent2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      
      if (pcFsk->iGetStateData(uiLoop, &cFskState))
         CHECK_RESULT();
      if (pcFsk2->iGetStateData(uiLoop, &cFskState2))
         CHECK_RESULT();

      if (strcmp(cFskState.pchName,
                 cFskState2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskState.pchDescription,
                 cFskState2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {


         if (pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
         if (pcFsk2->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock2))
            CHECK_RESULT();

         if (*(cFskActionBlock.piIterative) != 
             *(cFskActionBlock2.piIterative))
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchFunction,
                    cFskActionBlock2.pchFunction) != 0)
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchDescription,
                    cFskActionBlock2.pchDescription) != 0)
            CHECK_RESULT();

      }
   }


   if (pcFsk->iWriteFile("output1b", 1))
      CHECK_RESULT();

   if (pcFsk->iCopyState(1, pcFsk2, 2))
      CHECK_RESULT();

   if (pcFsk2->iWriteFile("output2b", 1))
      CHECK_RESULT();

   if (pcFsk->iReadFile("output2b"))
      CHECK_RESULT();



                              // check-out the entire FSK
   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      
      if (pcFsk->iGetEventData(uiLoop, &cFskEvent))
         CHECK_RESULT();
      if (pcFsk2->iGetEventData(uiLoop, &cFskEvent2))
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchName,
                 cFskEvent2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskEvent.pchDescription,
                 cFskEvent2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumStates(); uiLoop++)
   {
      
      if (pcFsk->iGetStateData(uiLoop, &cFskState))
         CHECK_RESULT();
      if (pcFsk2->iGetStateData(uiLoop, &cFskState2))
         CHECK_RESULT();

      if (strcmp(cFskState.pchName,
                 cFskState2.pchName) != 0)
         CHECK_RESULT();

      if (strcmp(cFskState.pchDescription,
                 cFskState2.pchDescription) != 0)
         CHECK_RESULT();
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {


         if (pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock))
            CHECK_RESULT();
         if (pcFsk2->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock2))
            CHECK_RESULT();

         if (*(cFskActionBlock.piIterative) != 
             *(cFskActionBlock2.piIterative))
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchFunction,
                    cFskActionBlock2.pchFunction) != 0)
            CHECK_RESULT();

         if (strcmp(cFskActionBlock.pchDescription,
                    cFskActionBlock2.pchDescription) != 0)
            CHECK_RESULT();

      }
   }


   if (pcFsk->iWriteFile("output1b", 1))
      CHECK_RESULT();



#ifdef DUMP_DATA

   for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
   {
      pcFsk->iGetStateData(uiLoop2, &cFskState);
      pcFsk2->iGetStateData(uiLoop2, &cFskState2);

      printf("State = %u\n", uiLoop2);
      cFskState.vPrintData();
      cFskState2.vPrintData();
      printf("\n");
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      pcFsk->iGetEventData(uiLoop, &cFskEvent);
      pcFsk2->iGetEventData(uiLoop, &cFskEvent2);

      printf("Event = %u\n", uiLoop);
      cFskEvent.vPrintData();
      cFskEvent2.vPrintData();
      printf("\n");
   }

   for (uiLoop=0; uiLoop<pcFsk->uiGetNumEvents(); uiLoop++)
   {
      for (uiLoop2=0; uiLoop2<pcFsk->uiGetNumStates(); uiLoop2++)
      {
         pcFsk->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock);
         pcFsk2->iGetActionBlockData(uiLoop, uiLoop2, &cFskActionBlock2);

         printf("ActionBlock = %u, %u\n", uiLoop, uiLoop2);
         cFskActionBlock.vPrintData();
         cFskActionBlock2.vPrintData();
         printf("\n");
         
      }
   }
#endif


   return(0);
}

