/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| September 21, 1996                                                           
|                                                                              
| unit tests for DynamicMatrix templates                                       
|                                                                              
| $Id: d_matrix_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $                      
|                                                                              
| $Log: d_matrix_ut.C,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.8  2000/05/24 03:19:01  tony
| Updated all copyright dates.
|
| Revision 1.7  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
 * Revision 1.6  1997/03/30  20:48:21  tony
 *      The unit test testing the reading past the last cell in iGetMatrixCell,
 *      was checking for "-1" and not "ERROR".  Changed it so if the call
 *      returns 0, an error is reported.
 *
 * Revision 1.5  1997/03/01  23:24:15  tony
 *      Made the following changes:
 *           - Add version to FSK file for validation when reading in
 *           - Check for " in parameter list
 *           - Add CVS Id to source and header file
 *           - Add copyright notice to header files
 *           - Add EDIT menu item and associated entries
 *           - Make mouse button 3 cause the commnad pop-up to be displayed
 *             instead of mouse button 2
 *           - Add box to insert header files into
 *           - Changed pchz to pch
 *           - Allow macros to be used in parameter list
 *           - Add function and associated calls to check for infinite state
 *             condition; this is a warning, not an error condition
 *           - Add over-ride abort function capability to GUI
 *           - Changed "modified save pop-up" window to be displayed before
 *             any window is displayed to read and RSK, or create a new one
 *
 * Revision 1.4  1997/01/26  04:57:19  tony
 * Made changes to:
 *      - insert user defined default function next state when a state or
 *        event is inserted
 *      - stub out future functions
 *      - change tabs to spaces
 *
 * Revision 1.3  1997/01/13  08:22:57  tony
 * added code to:
 *        - delete states
 *        - insert states
 *        - search dynamic matrix diagonally
 *        - iGetMatrixCell, to chain through the matrix cells using the links
 *
 * Revision 1.2  1996/11/27  06:16:04  tony
 * added more member functions to classes and cleaned up code a bit
 *
|* Revision 1.1  1996/09/28  16:41:47  tony
|* initial check-in
|*                                                                      
|                                                                              
\*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <common.h>
#include <d_matrix.h>
#include <d_matrix.C>

STATIC CHAR *pchDmatrixUtId = "@(#) $Id: d_matrix_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

INT iTestNum = 0;

#define CHECK_RESULT()                                             \
   {                                                               \
      printf("------ ERROR ------ %s, %d  -- test %d\n",           \
              __FILE__, __LINE__, ++iTestNum);                     \
      return(1);                                                   \
   }                                                               \
   printf("------ GOOD ------ %s, %d  -- test %d\n",               \
           __FILE__, __LINE__, ++iTestNum);


INT
main()
{


   INT ulLoop;
   INT ulLoop2;
   INT iValue;
   INT iValue2;

   UINT uiState;
   UINT uiEvent;

   DynamicMatrix<INT>   iMatrix(3,5);
   DynamicMatrix<INT>   *pcIntMatrix;
   DynamicMatrix<INT>   *pcIntMatrix2;

   MatrixCell<INT>      *pcIntMatrixCell;

  
   if (iMatrix.ulGetNumRows() != 3)
      CHECK_RESULT();

   if (iMatrix.ulGetNumColumns() != 5)
      CHECK_RESULT();


   pcIntMatrix = new DynamicMatrix<INT> (10,13);

   if (pcIntMatrix->ulGetNumRows() != 10)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 13)
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<10; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<13; ulLoop2++)
      {
         pcIntMatrix->rxCellData(ulLoop, ulLoop2) = ulLoop*ulLoop2; 
      }
   }

   printf("\n");
   for (ulLoop=0; ulLoop<10; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<13; ulLoop2++)
      {
         printf("%3d ", pcIntMatrix->rxCellData(ulLoop, ulLoop2));

         if (pcIntMatrix->rxCellData(ulLoop, ulLoop2) != ulLoop*ulLoop2)
         {
            printf("------ ERROR ------ %s, %d\n", __FILE__, __LINE__);
            return(1);
         }
      }
      printf("\n");
   }
   printf("------ GOOD ------ %s, %d\n", __FILE__, __LINE__);


   iValue = pcIntMatrix->rxCellData(9, 12);

   pcIntMatrix->rxCellData(0, 0) = pcIntMatrix->rxCellData(9, 12);
   pcIntMatrix->rxCellData(9, 12) = pcIntMatrix->rxCellData(5, 5);

   if (pcIntMatrix->rxCellData(0, 0) != iValue)
      CHECK_RESULT();


   if (pcIntMatrix->rxCellData(9, 12) != pcIntMatrix->rxCellData(5, 5))
      CHECK_RESULT();

                              // insert row before and after a 1X1 matrix
   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (1,1);
   pcIntMatrix->rxCellData(0,0) = 100;

   if (pcIntMatrix->iInsertRow(0, BEFORE))
      CHECK_RESULT();

   if (pcIntMatrix->rxCellData(1,0) != 100)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 2)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (1,1);
   pcIntMatrix->rxCellData(0,0) = 200;

   if (pcIntMatrix->iInsertRow(0, AFTER))
      CHECK_RESULT();

   if (pcIntMatrix->rxCellData(0,0) != 200)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 2)
      CHECK_RESULT();



                              // insert row before and after a 3X3 matrix
   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertRow(0, BEFORE))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(1,0) != 100) ||
       (pcIntMatrix->rxCellData(2,1) != 200) ||
       (pcIntMatrix->rxCellData(3,2) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 3)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertRow(0, AFTER))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(2,1) != 200) ||
       (pcIntMatrix->rxCellData(3,2) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertRow(2, BEFORE))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,1) != 200) ||
       (pcIntMatrix->rxCellData(3,2) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertRow(2, AFTER))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,1) != 200) ||
       (pcIntMatrix->rxCellData(2,2) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();



   pcIntMatrix->rxCellData(3,2) = 400;

   if (pcIntMatrix->iInsertRow(3, AFTER))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,1) != 200) ||
       (pcIntMatrix->rxCellData(2,2) != 300) ||
       (pcIntMatrix->rxCellData(3,2) != 400))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 5)
      CHECK_RESULT();



                              // insert column before and after a 1X1 matrix
   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (1,1);
   pcIntMatrix->rxCellData(0,0) = 100;

   if (pcIntMatrix->iInsertColumn(0, BEFORE))
      CHECK_RESULT();

   if (pcIntMatrix->rxCellData(0,1) != 100)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 2)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (1,1);
   pcIntMatrix->rxCellData(0,0) = 200;

   if (pcIntMatrix->iInsertColumn(0, AFTER))
      CHECK_RESULT();

   if (pcIntMatrix->rxCellData(0,0) != 200)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 2)
      CHECK_RESULT();



                              // insert column before and after a 3X3 matrix
   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertColumn(0, BEFORE))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,1) != 100) ||
       (pcIntMatrix->rxCellData(1,2) != 200) ||
       (pcIntMatrix->rxCellData(2,3) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 4)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 3)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertColumn(0, AFTER))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,2) != 200) ||
       (pcIntMatrix->rxCellData(2,3) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 4)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertColumn(2, BEFORE))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,1) != 200) ||
       (pcIntMatrix->rxCellData(2,3) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 4)
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertColumn(2, AFTER))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,1) != 200) ||
       (pcIntMatrix->rxCellData(2,2) != 300))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 4)
      CHECK_RESULT();



   pcIntMatrix->rxCellData(2,3) = 400;

   if (pcIntMatrix->iInsertColumn(3, AFTER))
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,1) != 200) ||
       (pcIntMatrix->rxCellData(2,2) != 300) ||
       (pcIntMatrix->rxCellData(2,3) != 400))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 5)
      CHECK_RESULT();


                              // insert a column and row in a 3X3 matrix
   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (3,3);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;

   if (pcIntMatrix->iInsertColumn(0, BEFORE))
      CHECK_RESULT();

   pcIntMatrix->rxCellData(2,0) = 400;

   if (pcIntMatrix->iInsertRow(0, BEFORE))
      CHECK_RESULT();

   pcIntMatrix->rxCellData(0,3) = 500;

   if ((pcIntMatrix->rxCellData(1,1) != 100) ||
       (pcIntMatrix->rxCellData(2,2) != 200) ||
       (pcIntMatrix->rxCellData(3,3) != 300) ||
       (pcIntMatrix->rxCellData(3,0) != 400) ||
       (pcIntMatrix->rxCellData(0,3) != 500))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 4)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();

   delete pcIntMatrix;




                              // test deleting rows...
   pcIntMatrix = new DynamicMatrix<INT> (5,1);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,0) = 200;
   pcIntMatrix->rxCellData(2,0) = 300;
   pcIntMatrix->rxCellData(3,0) = 400;
   pcIntMatrix->rxCellData(4,0) = 500;

   if (pcIntMatrix->iDeleteRow(0))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 200) ||
       (pcIntMatrix->rxCellData(1,0) != 300) ||
       (pcIntMatrix->rxCellData(2,0) != 400) ||
       (pcIntMatrix->rxCellData(3,0) != 500))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteRow(3))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 3)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 200) ||
       (pcIntMatrix->rxCellData(1,0) != 300) ||
       (pcIntMatrix->rxCellData(2,0) != 400))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteRow(1))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 2)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 200) ||
       (pcIntMatrix->rxCellData(1,0) != 400))
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (5,10);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;
   pcIntMatrix->rxCellData(3,8) = 400;
   pcIntMatrix->rxCellData(4,9) = 500;

   if (pcIntMatrix->iDeleteRow(1))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 4)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,2) != 300) ||
       (pcIntMatrix->rxCellData(2,8) != 400) ||
       (pcIntMatrix->rxCellData(3,9) != 500))
      CHECK_RESULT();


   if (pcIntMatrix->iDeleteRow(2))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 3)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 10)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(1,2) != 300) ||
       (pcIntMatrix->rxCellData(2,9) != 500))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteRow(0))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteRow(0))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteRow(0))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 0)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 0)
      CHECK_RESULT();

   delete pcIntMatrix;


                              // test deleting columns...
   pcIntMatrix = new DynamicMatrix<INT> (1,5);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(0,1) = 200;
   pcIntMatrix->rxCellData(0,2) = 300;
   pcIntMatrix->rxCellData(0,3) = 400;
   pcIntMatrix->rxCellData(0,4) = 500;

   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 4)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 200) ||
       (pcIntMatrix->rxCellData(0,1) != 300) ||
       (pcIntMatrix->rxCellData(0,2) != 400) ||
       (pcIntMatrix->rxCellData(0,3) != 500))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteColumn(3))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 3)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 200) ||
       (pcIntMatrix->rxCellData(0,1) != 300) ||
       (pcIntMatrix->rxCellData(0,2) != 400))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteColumn(1))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 2)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 200) ||
       (pcIntMatrix->rxCellData(0,1) != 400))
      CHECK_RESULT();


   delete pcIntMatrix;
   pcIntMatrix = new DynamicMatrix<INT> (5,10);
   pcIntMatrix->rxCellData(0,0) = 100;
   pcIntMatrix->rxCellData(1,1) = 200;
   pcIntMatrix->rxCellData(2,2) = 300;
   pcIntMatrix->rxCellData(3,8) = 400;
   pcIntMatrix->rxCellData(4,9) = 500;

   if (pcIntMatrix->iDeleteColumn(1))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 9)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(2,1) != 300) ||
       (pcIntMatrix->rxCellData(3,7) != 400) ||
       (pcIntMatrix->rxCellData(4,8) != 500))
      CHECK_RESULT();


   if (pcIntMatrix->iDeleteColumn(2))
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 8)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumRows() != 5)
      CHECK_RESULT();

   if ((pcIntMatrix->rxCellData(0,0) != 100) ||
       (pcIntMatrix->rxCellData(2,1) != 300) ||
       (pcIntMatrix->rxCellData(3,6) != 400) ||
       (pcIntMatrix->rxCellData(4,7) != 500))
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteColumn(2))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(1))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();
   if (pcIntMatrix->iDeleteColumn(0))
      CHECK_RESULT();


   if (pcIntMatrix->ulGetNumRows() != 0)
      CHECK_RESULT();

   if (pcIntMatrix->ulGetNumColumns() != 0)
      CHECK_RESULT();

   delete pcIntMatrix;



                              // test copying rows...
   pcIntMatrix = new DynamicMatrix<INT> (8,5);

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      pcIntMatrix->rxCellData(0, ulLoop) = ulLoop;
   }

   if (pcIntMatrix->iCopyRow(0,7))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(0, ulLoop) != 
          pcIntMatrix->rxCellData(7, ulLoop))
         CHECK_RESULT();
   }

   if (pcIntMatrix->iCopyRow(7,3))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(7, ulLoop) != 
          pcIntMatrix->rxCellData(3, ulLoop))
         CHECK_RESULT();
   }

   if (pcIntMatrix->iCopyRow(3,3))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(0, ulLoop) != 
          pcIntMatrix->rxCellData(3, ulLoop))
         CHECK_RESULT();
   }

   delete pcIntMatrix;

                              // test copying columns...
   pcIntMatrix = new DynamicMatrix<INT> (8,5);

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      pcIntMatrix->rxCellData(ulLoop, 0) = ulLoop;
   }

   if (pcIntMatrix->iCopyColumn(0,4))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 0) != 
          pcIntMatrix->rxCellData(ulLoop, 4))
         CHECK_RESULT();
   }

   if (pcIntMatrix->iCopyColumn(4,2))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 0) != 
          pcIntMatrix->rxCellData(ulLoop, 2))
         CHECK_RESULT();
   }

   if (pcIntMatrix->iCopyColumn(2,2))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 0) != 
          pcIntMatrix->rxCellData(ulLoop, 2))
         CHECK_RESULT();
   }

   delete pcIntMatrix;



                              // test copying rows between different matrixes
   pcIntMatrix = new DynamicMatrix<INT> (8,5);
   pcIntMatrix2 = new DynamicMatrix<INT> (8,5);

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      pcIntMatrix->rxCellData(0, ulLoop) = ulLoop;
   }

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 0, pcIntMatrix2, 4))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(0, ulLoop) != 
          pcIntMatrix2->rxCellData(4, ulLoop))
         CHECK_RESULT();
   }



   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<8; ulLoop2++)
      {
         pcIntMatrix->rxCellData(ulLoop2, ulLoop) = ulLoop*ulLoop2;
      }
   }

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      if (pcIntMatrix->iCopyRow(pcIntMatrix, ulLoop, pcIntMatrix2, ulLoop))
         CHECK_RESULT();
   }

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<8; ulLoop2++)
      {
         if (pcIntMatrix->rxCellData(ulLoop2, ulLoop) != 
             pcIntMatrix2->rxCellData(ulLoop2, ulLoop))
            CHECK_RESULT();
      }
   }


   delete pcIntMatrix;
   delete pcIntMatrix2;


   pcIntMatrix = new DynamicMatrix<INT> (1,1);
   pcIntMatrix2 = new DynamicMatrix<INT> (1,1);

   pcIntMatrix->rxCellData(0, 0) = 500;

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 0, pcIntMatrix2, 0))
      CHECK_RESULT();

   if (pcIntMatrix->rxCellData(0, 0) != pcIntMatrix2->rxCellData(0, 0))
      CHECK_RESULT();

   delete pcIntMatrix;
   delete pcIntMatrix2;


   pcIntMatrix = new DynamicMatrix<INT> (5,5);
   pcIntMatrix2 = new DynamicMatrix<INT> (7,5);

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      pcIntMatrix->rxCellData(ulLoop, ulLoop) = ulLoop;
      if (pcIntMatrix->iCopyRow(pcIntMatrix, ulLoop, pcIntMatrix2, ulLoop))
         CHECK_RESULT();
      if (pcIntMatrix->rxCellData(ulLoop, ulLoop) != 
          pcIntMatrix2->rxCellData(ulLoop, ulLoop))
         CHECK_RESULT();
   }

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      pcIntMatrix->rxCellData(1, ulLoop) = ulLoop*2;
      pcIntMatrix->rxCellData(3, ulLoop) = ulLoop*3;
   }

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 1, pcIntMatrix2, 5))
      CHECK_RESULT();

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 3, pcIntMatrix2, 6))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(1, ulLoop) != 
          pcIntMatrix2->rxCellData(5, ulLoop))
         CHECK_RESULT();

      if (pcIntMatrix->rxCellData(3, ulLoop) != 
          pcIntMatrix2->rxCellData(6, ulLoop))
         CHECK_RESULT();
   }

   delete pcIntMatrix;
   delete pcIntMatrix2;




                              // test copying columns between different 
                              // matrixes
   pcIntMatrix = new DynamicMatrix<INT> (8,5);
   pcIntMatrix2 = new DynamicMatrix<INT> (8,5);

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      pcIntMatrix->rxCellData(ulLoop, 0) = ulLoop;
   }

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 0, pcIntMatrix2, 4))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<8; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 0) != 
          pcIntMatrix2->rxCellData(ulLoop, 4))
         CHECK_RESULT();
   }



   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<8; ulLoop2++)
      {
         pcIntMatrix->rxCellData(ulLoop2, ulLoop) = ulLoop*ulLoop2;
      }
   }

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->iCopyColumn(pcIntMatrix, ulLoop, pcIntMatrix2, ulLoop))
         CHECK_RESULT();
   }

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<8; ulLoop2++)
      {
         if (pcIntMatrix->rxCellData(ulLoop2, ulLoop) != 
             pcIntMatrix2->rxCellData(ulLoop2, ulLoop))
            CHECK_RESULT();
      }
   }


   delete pcIntMatrix;
   delete pcIntMatrix2;


   pcIntMatrix = new DynamicMatrix<INT> (1,1);
   pcIntMatrix2 = new DynamicMatrix<INT> (1,1);

   pcIntMatrix->rxCellData(0, 0) = 500;

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 0, pcIntMatrix2, 0))
      CHECK_RESULT();

   if (pcIntMatrix->rxCellData(0, 0) != pcIntMatrix2->rxCellData(0, 0))
      CHECK_RESULT();

   delete pcIntMatrix;
   delete pcIntMatrix2;


   pcIntMatrix = new DynamicMatrix<INT> (5,5);
   pcIntMatrix2 = new DynamicMatrix<INT> (5,7);

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      pcIntMatrix->rxCellData(ulLoop, ulLoop) = ulLoop;
      if (pcIntMatrix->iCopyColumn(pcIntMatrix, ulLoop, pcIntMatrix2, ulLoop))
         CHECK_RESULT();
      if (pcIntMatrix->rxCellData(ulLoop, ulLoop) != 
          pcIntMatrix2->rxCellData(ulLoop, ulLoop))
         CHECK_RESULT();
   }

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      pcIntMatrix->rxCellData(ulLoop, 1) = ulLoop*2;
      pcIntMatrix->rxCellData(ulLoop, 3) = ulLoop*3;
   }

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 1, pcIntMatrix2, 5))
      CHECK_RESULT();

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 3, pcIntMatrix2, 6))
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 1) != 
          pcIntMatrix2->rxCellData(ulLoop, 5))
         CHECK_RESULT();

      if (pcIntMatrix->rxCellData(ulLoop, 3) != 
          pcIntMatrix2->rxCellData(ulLoop, 6))
         CHECK_RESULT();
   }

   delete pcIntMatrix;
   delete pcIntMatrix2;


                              // the following unit test can only be run
                              // when pxGetMatrixRow and pxGetMatrixColumn
                              // are moved from the protected area into 
                              // the public area in d_matrix.h          
#ifdef DONT_DO_PROTECTED
                              // test getting a matrix row

   pcIntMatrix = new DynamicMatrix<INT> (5,5);

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<5; ulLoop2++)
      {
         pcIntMatrix->rxCellData(ulLoop, ulLoop2) = ulLoop * ulLoop2;
      }
   }

   pcIntMatrixCell = pcIntMatrix->pxGetMatrixRow(3);
   if (pcIntMatrixCell == NULL)
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(3, ulLoop) != pcIntMatrixCell->CellData)
         CHECK_RESULT();
      pcIntMatrixCell = pcIntMatrixCell->pNextColumn;
   }
   

   pcIntMatrixCell = pcIntMatrix->pxGetMatrixRow(2);
   if (pcIntMatrixCell == NULL)
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(2, ulLoop) != pcIntMatrixCell->CellData)
         CHECK_RESULT();
      pcIntMatrixCell = pcIntMatrixCell->pNextColumn;
   }

   delete pcIntMatrix;



                              // test getting a matrix columns

   pcIntMatrix = new DynamicMatrix<INT> (5,5);

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<5; ulLoop2++)
      {
         pcIntMatrix->rxCellData(ulLoop, ulLoop2) = ulLoop * ulLoop2;
      }
   }

   pcIntMatrixCell = pcIntMatrix->pxGetMatrixColumn(3);
   if (pcIntMatrixCell == NULL)
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 3) != pcIntMatrixCell->CellData)
         CHECK_RESULT();
      pcIntMatrixCell = pcIntMatrixCell->pNextRow;
   }
   

   pcIntMatrixCell = pcIntMatrix->pxGetMatrixColumn(2);
   if (pcIntMatrixCell == NULL)
      CHECK_RESULT();

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      if (pcIntMatrix->rxCellData(ulLoop, 2) != pcIntMatrixCell->CellData)
         CHECK_RESULT();
      pcIntMatrixCell = pcIntMatrixCell->pNextRow;
   }

   delete pcIntMatrix;


#endif /* DONT_DO_PROTECTED */

   


                              // test some error conditions...
   pcIntMatrix = new DynamicMatrix<INT> (1,1);

   if (pcIntMatrix->iInsertRow(1, BEFORE) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iInsertRow(1, AFTER) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iInsertColumn(1, BEFORE) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iInsertColumn(1, AFTER) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteRow(1) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iDeleteColumn(1) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyRow(0,1) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyRow(1,0) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyColumn(0,1) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyColumn(1,0) == 0)
      CHECK_RESULT();


                              // test copying rows between different matrixes
   pcIntMatrix2 = new DynamicMatrix<INT> (1,2);

                              // different size columns...
   pcIntMatrix2 = new DynamicMatrix<INT> (1,2);
   if (pcIntMatrix->iCopyRow(pcIntMatrix, 0, pcIntMatrix2, 0) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 0, pcIntMatrix2, 3) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 3, pcIntMatrix2, 0) == 0)
      CHECK_RESULT();



   delete pcIntMatrix2;
   pcIntMatrix2 = new DynamicMatrix<INT> (1,1);

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 0, pcIntMatrix2, 4) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyRow(pcIntMatrix, 1, pcIntMatrix2, 0) == 0)
      CHECK_RESULT();



   delete pcIntMatrix2;
                              // test copying columns between different 
                              // matrixes
   pcIntMatrix2 = new DynamicMatrix<INT> (1,2);

                              // different size rows...
   pcIntMatrix2 = new DynamicMatrix<INT> (2,1);
   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 0, pcIntMatrix2, 0) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 0, pcIntMatrix2, 3) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 3, pcIntMatrix2, 0) == 0)
      CHECK_RESULT();



   delete pcIntMatrix2;
   pcIntMatrix2 = new DynamicMatrix<INT> (1,1);

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 0, pcIntMatrix2, 4) == 0)
      CHECK_RESULT();

   if (pcIntMatrix->iCopyColumn(pcIntMatrix, 1, pcIntMatrix2, 0) == 0)
      CHECK_RESULT();

   delete pcIntMatrix;
   delete pcIntMatrix2;


                              // test traversing the matrix
   pcIntMatrix = new DynamicMatrix<INT> (5,5);
   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<5; ulLoop2++)
      {
         pcIntMatrix->rxCellData(ulLoop, ulLoop2) = ulLoop%2; 
      }
   }

   for (ulLoop=0; ulLoop<5; ulLoop++)
   {
      for (ulLoop2=0; ulLoop2<5; ulLoop2++)
      {
         if ((ulLoop == 0) && (ulLoop2 == 0))
         {
            if (pcIntMatrix->iGetMatrixCell(FIRST_CELL_IN_MATRIX, 
                             iValue2, &uiEvent, &uiState) != 0)
            CHECK_RESULT();
         }
         else
         {
            if (pcIntMatrix->iGetMatrixCell(NEXT_CELL_IN_MATRIX,
                             iValue2, &uiEvent, &uiState) != 0)
            CHECK_RESULT();
         }

         if (iValue2 != (ulLoop%2))
            CHECK_RESULT();
      }
   }

                              // test end of matrix
   for (ulLoop=0; ulLoop<3; ulLoop++)
   {
      if (pcIntMatrix->iGetMatrixCell(NEXT_CELL_IN_MATRIX, 
                       iValue2, &uiEvent, &uiState) == 0)
      CHECK_RESULT();
   }



                              // the following unit test can only be run
                              // when pxGetMatrixRow and pxGetMatrixColumn
                              // are moved from the protected area into 
                              // the public area in d_matrix.h          
#ifdef DONT_DO_PROTECTED

   pcIntMatrix = new DynamicMatrix<INT> (1,1);

   pcIntMatrixCell = pcIntMatrix->pxGetMatrixColumn(1);
   if (pcIntMatrixCell != NULL)
      CHECK_RESULT();

   pcIntMatrixCell = pcIntMatrix->pxGetMatrixRow(1);
   if (pcIntMatrixCell != NULL)
      CHECK_RESULT();

#endif /* DONT_DO_PROTECTED */



   delete pcIntMatrix;
   delete pcIntMatrix2;
   delete pcIntMatrix2;


   pcIntMatrix = new DynamicMatrix<INT> (3,7);

   printf("\n\n**************************************************\n");
   printf("We are going to step outside the allocated matrix,\n");
   printf("this should cause an ASSERT...this is GOOD        \n");
   pcIntMatrix->rxCellData(0, 7) = 4;
 
                              // we have an error if we make it to here         
   printf("------ ERROR ------ %s, %d\n", __FILE__, __LINE__);



   return(0);
}
