/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| September 21, 1996                                                           
|                                                                              
| Module:  DynamicMatrix template definitions                                  
|          This file contains definitions for the DynamicMatrix templates.     
|                                                                              
| $Id: d_matrix.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $                         
|                                                                              
| $Log: d_matrix.h,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.9  2000/05/24 03:19:01  tony
| Updated all copyright dates.
|
| Revision 1.8  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
| Revision 1.7  1999/09/12 22:03:56  tony
|
| Changed #defines to const and inline functions...
|
 * Revision 1.6  1997/03/01  23:20:52  tony
 *      added copyright notice
 *
 * Revision 1.5  1997/01/26  04:57:18  tony
 * Made changes to:
 *      - insert user defined default function next state when a state or
 *        event is inserted
 *      - stub out future functions
 *      - change tabs to spaces
 *
 * Revision 1.4  1997/01/13  08:22:57  tony
 * added code to:
 *        - delete states
 *        - insert states
 *        - search dynamic matrix diagonally
 *        - iGetMatrixCell, to chain through the matrix cells using the links
 *
 * Revision 1.3  1996/12/13  04:16:21  tony
 * 1. Moved public arrays in classes to private and added const pointers to
 *    the private members
 *
 * 2. Added assignment operators to classes
 *
 * 3. Changed the dynamic array class - replaced malloc/free with new/delete
 *    so it could work with all objects
 *
 * Revision 1.2  1996/11/27  06:16:30  tony
 * added more member functions to classes and cleaned up code a bit
 *
|* Revision 1.1  1996/09/28  16:41:46  tony
|* initial check-in
|*                                                                      
|                                                                              
\*----------------------------------------------------------------------------*/
#ifndef D_MATRIX_H
#define D_MATRIX_H

#include <stdio.h>
#include <errno.h>
#include <assert.h>
#include <string.h>

#include <common.h>

STATIC CHAR *pchDmatrixHId = "@(#) $Id: d_matrix.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

CONST INT FIRST_CELL_IN_MATRIX    = 1;
CONST INT NEXT_CELL_IN_MATRIX     = 2;


template <class DataType>
class 
MatrixCell
{

   public:
      MatrixCell() {  pxNextRow = NULL;
                      pxPreviousRow = NULL;
                      pxNextColumn = NULL;
                      pxPreviousColumn = NULL; 
                   }

      virtual ~MatrixCell() {  pxNextRow = NULL;
                               pxPreviousRow = NULL;
                               pxNextColumn = NULL;
                               pxPreviousColumn = NULL; 
                            }

      MatrixCell<DataType>* pxNextRow;
      MatrixCell<DataType>* pxPreviousRow;
      MatrixCell<DataType>* pxNextColumn;
      MatrixCell<DataType>* pxPreviousColumn;

      DataType xCellData;

   protected:
   private:

};


/*----------------------------------------------------------------------------*\
|                                                                              |
| DynamicMatrix template definitions                                           |
|                                                                              |
\*----------------------------------------------------------------------------*/
template <class DataType>
class 
DynamicMatrix
{
   public:

      DynamicMatrix(ULONG ulNumRows=0, ULONG ulNumColumns=0);


      virtual ~DynamicMatrix();

                                     // get number of rows    
      ULONG ulGetNumRows();

                                     // get number of columns    
      ULONG ulGetNumColumns();

                                     // return a reference to the data element
                                     // in the matrix at the given row/column 
      DataType& rxCellData(ULONG ulRow, ULONG ulColumn);

                                     // insert a new row in the matrix        
      INT iInsertRow(ULONG ulRow, INT iInsertDirection);

                                     // insert a new column in the matrix
      INT iInsertColumn(ULONG ulIndex, INT iInsertDirection);

                                     // delete a matrix row
      INT iDeleteRow(ULONG ulRowToDelete);

                                     // delete a matrix column
      INT iDeleteColumn(ULONG ulColumnToDelete);

                                     // copy a row to another row in the matrix
      INT iCopyRow(ULONG ulFromRow, ULONG ulToRow);

                                     // copy a column to another column in the
                                     // matrix
      INT iCopyColumn(ULONG ulFromColumn, ULONG ulToColumn);

                                     // copy a row from one matrix to a row in 
                                     // another matrix
      INT iCopyRow(DynamicMatrix<DataType>* pxFromMatrix, 
                   ULONG ulFromRow,
                   DynamicMatrix<DataType>* pxToMatrix,   
                   ULONG ulToRow);

                                     // copy a column from one matrix to a 
                                     // column in another matrix
      INT iCopyColumn(DynamicMatrix<DataType>* pxFromMatrix, 
                      ULONG ulFromColumn,
                      DynamicMatrix<DataType>* pxToMatrix,   
                      ULONG ulToColumn);

                                     // get the first or next matrix cell
                                     // if iFirstOrNext == FIRST_CELL_IN_MATRIX
                                     // get the first cell in the matrix  
                                     // if iFirstOrNext == NEXT_CELL_IN_MATRIX
                                     // get the next cell in the matrix
      INT iGetMatrixCell(INT iFirstOrNext, DataType& rxCellData,
                         UINT* puiEvent, UINT* puiState);

                                     // return a pointer to the specified
                                     // matrix row
      MatrixCell<DataType>* pxGetRow(ULONG ulMatrixRow);

                                     // return a pointer to the specified
                                     // matrix column
      MatrixCell<DataType>* pxGetColumn(ULONG ulMatrixColumn);

   protected:


   private:
      ULONG       ulNumMatrixRows;
      ULONG       ulNumMatrixColumns;

                                     // pointer to first row/column of matrix
      MatrixCell<DataType>* pxMatrixStart;

};

#endif /* D_MATRIX_H */
