/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| September 14, 1996                                                           
|                                                                              
| unit tests for DynamicArray templates                                        
|                                                                              
| $Id: d_array_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $                       
|                                                                              
| $Log: d_array_ut.C,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.7  2000/05/24 03:19:01  tony
| Updated all copyright dates.
|
| Revision 1.6  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
 * Revision 1.5  1997/03/01  23:24:14  tony
 *      Made the following changes:
 *           - Add version to FSK file for validation when reading in
 *           - Check for " in parameter list
 *           - Add CVS Id to source and header file
 *           - Add copyright notice to header files
 *           - Add EDIT menu item and associated entries
 *           - Make mouse button 3 cause the commnad pop-up to be displayed
 *             instead of mouse button 2
 *           - Add box to insert header files into
 *           - Changed pchz to pch
 *           - Allow macros to be used in parameter list
 *           - Add function and associated calls to check for infinite state
 *             condition; this is a warning, not an error condition
 *           - Add over-ride abort function capability to GUI
 *           - Changed "modified save pop-up" window to be displayed before
 *             any window is displayed to read and RSK, or create a new one
 *
 * Revision 1.4  1997/01/26  04:57:18  tony
 * Made changes to:
 *      - insert user defined default function next state when a state or
 *        event is inserted
 *      - stub out future functions
 *      - change tabs to spaces
 *
 * Revision 1.3  1996/12/13  04:16:21  tony
 * 1. Moved public arrays in classes to private and added const pointers to
 *    the private members
 *
 * 2. Added assignment operators to classes
 *
 * 3. Changed the dynamic array class - replaced malloc/free with new/delete
 *    so it could work with all objects
 *
 * Revision 1.2  1996/11/27  06:16:03  tony
 * added more member functions to classes and cleaned up code a bit
 *
|* Revision 1.1  1996/09/28  16:41:45  tony
|* initial check-in
|*                                                                      
|                                                                              
\*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <malloc.h>

#include <common.h>
#include <d_array.h>
#include <d_array.C>

STATIC CHAR *pchDarrayUtId = "@(#) $Id: d_array_ut.C,v 1.1 2001/03/04 00:05:14 tonycu Exp $";


/* NOTE: these should be set to the values of uiArrayIncreaseAmount, and */
/*       uiArrayHysteresis found in d_array.C                            */

#define ARRAY_INCREASE_AMOUNT   30
#define ARRAY_HYSTERESIS        15


INT iTestNum = 0;


#define DUMP_INT_ARRAY(array)                                          \
                     {                                                 \
                        int i;                                         \
                        for (i=0; i<((array).uiGetSize()); i++)        \
                        {                                              \
                           printf("%d == %d\n", i, (array)[i]);        \
                        }                                              \
                     }


#define CHECK_RESULT(array)                                            \
   {                                                                   \
      printf("------ ERROR ------ %s, %d  -- test %d\n",               \
              __FILE__, __LINE__, ++iTestNum);                         \
      DUMP_INT_ARRAY(array);                                           \
      return(1);                                                       \
   }                                                                   \
   printf("------ GOOD ------ %s, %d -- test %d\n",                    \
           __FILE__, __LINE__, ++iTestNum);



INT
main()
{

   INT iLoop;
   INT iTemp;

   DynamicArray<int>   acIntValues(2);
   DynamicArray<char>  acCharValues(6);
   DynamicArray<float> acFloatValues(9);

   acIntValues[0] = 0;
   acCharValues[0] = 'T';
   acFloatValues[0] = 3.14;
 
   printf("acIntValues[0] = %d\n", acIntValues[0]);
   printf("acCharValues[0] = %c\n", acCharValues[0]);
   printf("acFloatValues[0] = %f\n", acFloatValues[0]);
 

                              //************************************************
                              // test simple assignments                        
                              //************************************************

                              // initial array values 0, 2                      
   acIntValues[1] = 2;
   if ((acIntValues[0] != 0) ||
       (acIntValues[1] != 2))
      CHECK_RESULT(acIntValues);

   
   acIntValues[0] = -1;
   acIntValues[1] = acIntValues[0] * (-1);
    
                              // array values -1, 1                             
   if ((acIntValues[0] != -1) ||
       (acIntValues[1] != 1))
      CHECK_RESULT(acIntValues);
 
 
                              //**********************************************
                              // test inserting cells at boundaries           
                              //**********************************************
   acIntValues[0] = 0;
   acIntValues[1] = 1;

                              // initial array values 0, 1
   if (acIntValues.iInsertCell(0, BEFORE))
      CHECK_RESULT(acIntValues);
 
   acIntValues[0] = -1;
                              // array values -1, 0, 1                         
   if ((acIntValues[0] != -1) ||
       (acIntValues[1] != 0) ||
       (acIntValues[2] != 1))
      CHECK_RESULT(acIntValues);
 
 
 
   if (acIntValues.iInsertCell(0, AFTER))
      CHECK_RESULT(acIntValues);
 
   acIntValues[1] = -2;

                              // array values -1, -2, 0, 1                      
   if ((acIntValues[0] != -1) ||
       (acIntValues[1] != -2) ||
       (acIntValues[2] != 0) ||
       (acIntValues[3] != 1))
      CHECK_RESULT(acIntValues);
 
 
 
   if (acIntValues.iInsertCell((acIntValues.uiGetSize()-1), BEFORE))
      CHECK_RESULT(acIntValues);
 
   acIntValues[acIntValues.uiGetSize()-2] = -3;

                              // array values -1, -2, 0, -3, 1      
   if ((acIntValues[0] != -1) ||
       (acIntValues[1] != -2) ||
       (acIntValues[2] != 0) ||
       (acIntValues[3] != -3) ||
       (acIntValues[4] != 1))
      CHECK_RESULT(acIntValues);
 
 
 
   if (acIntValues.iInsertCell((acIntValues.uiGetSize()-1), AFTER))
      CHECK_RESULT(acIntValues);
 
   acIntValues[acIntValues.uiGetSize()-1] = -4;


                              // array values -1, -2, 0, -3, 1, -4
   if ((acIntValues[0] != -1) ||
       (acIntValues[1] != -2) ||
       (acIntValues[2] != 0)  ||
       (acIntValues[3] != -3) ||
       (acIntValues[4] != 1)  ||
       (acIntValues[5] != -4))
      CHECK_RESULT(acIntValues);
 
 
   acIntValues[acIntValues.uiGetSize()-1] = acIntValues[1];

                              // array values -1, -2, 0, -3, 1, -2
 
   if (acIntValues[1] != acIntValues[acIntValues.uiGetSize()-1])
      CHECK_RESULT(acIntValues);
 
                              // this should cause an error, trying to insert 
                              // one cell past the last one         
   printf("This SHOULD return an error...\n");
   if (acIntValues.iInsertCell(acIntValues.uiGetSize(), AFTER) == 0)
      CHECK_RESULT(acIntValues);
 
                              // array values -1, -2, 0, -3, 1, -2      
                              // make sure the size is correct       
   if (acIntValues.uiGetSize() != 6)
      CHECK_RESULT(acIntValues);
 
                              //**********************************************
                              // test deleting array cells, making sure the  
                              // hysteresis works...                      
                              //**********************************************
   
                              // the array size is 6, ARRAY_INCREASE_AMOUNT is
                              // 10, and ARRAY_HYSTERESIS is 5           

                              // array values -1, -2, 0, -3, 1, -2   
   for (iLoop=acIntValues.uiGetSize(); 
        iLoop<((3 * ARRAY_INCREASE_AMOUNT) + ARRAY_HYSTERESIS);
        iLoop++)
   {
      if (acIntValues.iInsertCell(0, BEFORE))
         CHECK_RESULT(acIntValues);

      acIntValues[0] = 0;
   }


                              // array values   0,  0,  0,  0,  0
                              //                0,  0,  0,  0,  0
                              //                0,  0,  0,  0,  0
                              //                0,  0,  0,  0,  0
                              //                0,  0,  0,  0,  0
                              //                0,  0,  0,  0, -1
                              //               -2,  0, -3,  1, -2

   iTemp = (3 * ARRAY_INCREASE_AMOUNT) + ARRAY_HYSTERESIS;
   if (acIntValues.uiGetSize() != iTemp)
      CHECK_RESULT(acIntValues);


   for (iLoop=0; iLoop<(iTemp-7); iLoop++)
   {
      if (acIntValues[iLoop]  != 0)
         CHECK_RESULT(acIntValues);
   }


   if ((acIntValues[iTemp-6] != -1) ||
       (acIntValues[iTemp-5] != -2) ||
       (acIntValues[iTemp-4] != 0)  ||
       (acIntValues[iTemp-3] != -3) ||
       (acIntValues[iTemp-2] != 1)  ||
       (acIntValues[iTemp-1] != -2))
      CHECK_RESULT(acIntValues);

                              // delete one from the back, iTemp-10 from 
                              // the front, then another from the back and 
                              // check the values
   if (acIntValues.iDeleteCell(acIntValues.uiGetSize()-1))
      CHECK_RESULT(acIntValues);

   for (iLoop=0; iLoop<(iTemp-10); iLoop++)
   {
      if (acIntValues.iDeleteCell(0))
         CHECK_RESULT(acIntValues);
   }


   if (acIntValues.iDeleteCell(acIntValues.uiGetSize()-1))
      CHECK_RESULT(acIntValues);


                              // array values   0,  0,  0,  0, -1
                              //               -2,  0, -3
   if ((acIntValues[0] != 0) ||
       (acIntValues[1] != 0) ||
       (acIntValues[2] != 0) ||
       (acIntValues[3] != 0) ||
       (acIntValues[4] != -1)  ||
       (acIntValues[5] != -2) ||
       (acIntValues[6] != 0) ||
       (acIntValues[7] != -3))
      CHECK_RESULT(acIntValues);



   if (acIntValues.uiGetSize() != 8)
      CHECK_RESULT(acIntValues);

 

                              //**********************************************
                              // test re-sizing the array...               
                              //**********************************************
   if (acIntValues.iSetSize(3))
      CHECK_RESULT(acIntValues);
   
   if (acIntValues.uiGetSize() != 3)
      CHECK_RESULT(acIntValues);


   printf("\n\n**************************************************\n");
   printf("We are going to step outside the allocated memory,\n");
   printf("the over-loaded operator should catch this and    \n");
   printf("cause an ASSERT...this is GOOD                    \n\n");
   acIntValues[acIntValues.uiGetSize()] = 5;
 
                              // we have an error if we make it to here         
   printf("------ ERROR ------ %s, %d\n", __FILE__, __LINE__);
   DUMP_INT_ARRAY(acIntValues);
 
   return(0);
 
}
  
