/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| September 14, 1996                                                           
|                                                                              
| Module:  DynamicArray template definitions                                   
|          This file contains definitions for the DynamicArray templates.      
|                                                                              
| $Id: d_array.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $                          
|                                                                              
| $Log: d_array.h,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.9  2000/05/24 03:19:01  tony
| Updated all copyright dates.
|
| Revision 1.8  1999/09/13 01:21:13  tony
|
| Updated copyright notice date
|
 * Revision 1.7  1997/03/26  07:07:14  tony
 *      Fixed defects uncovered from test plan
 *
 * Revision 1.6  1997/03/01  23:20:51  tony
 *      added copyright notice
 *
 * Revision 1.5  1997/01/26  04:57:18  tony
 * Made changes to:
 *      - insert user defined default function next state when a state or
 *        event is inserted
 *      - stub out future functions
 *      - change tabs to spaces
 *
 * Revision 1.4  1997/01/13  08:22:57  tony
 * added code to:
 *        - delete states
 *        - insert states
 *        - search dynamic matrix diagonally
 *        - iGetMatrixCell, to chain through the matrix cells using the links
 *
 * Revision 1.3  1996/12/13  04:16:21  tony
 * 1. Moved public arrays in classes to private and added const pointers to
 *    the private members
 *
 * 2. Added assignment operators to classes
 *
 * 3. Changed the dynamic array class - replaced malloc/free with new/delete
 *    so it could work with all objects
 *
 * Revision 1.2  1996/11/27  06:16:30  tony
 * added more member functions to classes and cleaned up code a bit
 *
|* Revision 1.1  1996/09/28  16:41:44  tony
|* initial check-in
|*                                                                      
|                                                                              
\*----------------------------------------------------------------------------*/
#ifndef D_ARRAY_H
#define D_ARRAY_H

#include <stdio.h>
#include <errno.h>
#include <assert.h>
#include <string.h>
#include <malloc.h>

#include <common.h>

STATIC CHAR *pchDarrayHId = "@(#) $Id: d_array.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

/* we won't use new and delete in the DynamicArray class due to the way */
/* they allocate memory and the way we want to efficiently move         */
/* memory around...                                                     */

/*----------------------------------------------------------------------------*\
|                                                                              |
| Definitions for the DynamicArray template                                    |
|                                                                              |
|                                                                              |
\*----------------------------------------------------------------------------*/
template <class DataType>
class 
DynamicArray 
{
   public:

      DynamicArray(size_t uiNewArraySize=0);

      virtual ~DynamicArray();

      virtual DataType& operator[](size_t uiIndex);

                                     // destory current array and allocate
                                     // memory for new array                   
      INT iSetSize(size_t uiNewArraySize);   

                                     // get the usr array size
      UINT uiGetSize();

                                     // insert a new array cell into the array
                                     // shifting all cells after the 
                                     // insertion point to the right by one     
      INT iInsertCell(size_t uiIndex, 
                      INT iInsertDirection);

                                     // delete an array cell from the array
                                     // shifting all cells to the left by one
      INT iDeleteCell(size_t uiIndex);


   protected:

   private:
                                     // amount to increase the array by when
                                     // more memory is allocated for it     
      UINT uiArrayIncreaseAmount;
                                     // hysteresis prevents bouncing back and 
                                     // forth on the boundry
      UINT uiArrayHysteresis;
                                     // pointer to first element of array
      DataType* pxArray;
                                     // array element initialized by default
                                     // constructor, used to set inserted   
                                     // array cells to the default value
      DataType* pxInitializedArrayCell;
                                     // the number of array cell available
                                     // to the user
      size_t uiUserArraySize;
                                     // the amount of memory allocated for 
                                     // the array
      size_t uiActualArraySize;

};

#endif /* D_ARRAY_H */
