/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997, 2000  James A. Cureington
|                           tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|                                                                              
| Tony Cureington                                                              
| September 14, 1996                                                           
|                                                                              
| Module:  This header file contains common macros that are used by all other  
|          modules.  It should be included in all source files.                
|                                                                              
| $Id: common.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $                           
|                                                                              
| $Log: common.h,v $
| Revision 1.1  2001/03/04 00:05:14  tonycu
| initial check-in at sourceforge...
|
| Revision 1.13  2000/05/24 03:19:01  tony
| Updated all copyright dates.
|
| Revision 1.12  1999/09/13 01:21:12  tony
|
| Updated copyright notice date
|
| Revision 1.11  1999/09/12 22:03:56  tony
|
| Changed #defines to const and inline functions...
|
 * Revision 1.10  1997/03/26  07:07:14  tony
 *      Fixed defects uncovered from test plan
 *
 * Revision 1.9  1997/03/01  23:20:51  tony
 *      added copyright notice
 *
 * Revision 1.8  1997/02/08  22:43:06  tony
 *      1) made changes to return ERROR instead of 1 when an error is detected
 *      2) changed makefile to make unit tests seperate, make UT
 *      3) fixed bug in virtual_page.C
 *      4) added MAX and MIN macros
 *      5) added set last modified date function
 *
 * Revision 1.7  1997/01/26  04:57:18  tony
 * Made changes to:
 *      - insert user defined default function next state when a state or
 *        event is inserted
 *      - stub out future functions
 *      - change tabs to spaces
 *
 * Revision 1.6  1997/01/15  00:50:57  tony
 * changed check malloc and new macros to abort instead of return 1
 *
 * Revision 1.5  1997/01/11  22:30:11  tony
 *   Added code to support editing states, events, and action-blocks.
 *
 * Revision 1.4  1997/01/06  06:36:13  tony
 * Initial check-in of PRODUCTION code.
 *
 * Revision 1.3  1996/12/13  04:16:20  tony
 * 1. Moved public arrays in classes to private and added const pointers to
 *    the private members
 *
 * 2. Added assignment operators to classes
 *
 * 3. Changed the dynamic array class - replaced malloc/free with new/delete
 *    so it could work with all objects
 *
 * Revision 1.2  1996/11/27  06:16:29  tony
 * added more member functions to classes and cleaned up code a bit
 *
|* Revision 1.1  1996/09/28  16:41:43  tony
|* initial check-in
|*                                                                      
|                                                                              
\*----------------------------------------------------------------------------*/
#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <errno.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <time.h>
#include <sys/stat.h>


#define VOID          void
#define CHAR          char
#define UCHAR         unsigned char
#define SHORT         short
#define USHORT        unsinged short
#define INT           int
#define UINT          unsigned int
#define LONG          long
#define ULONG         unsigned long
#define FLOAT         float
#define DOUBLE        double
#define STATIC        static
#define ENUM          enum
#define CONST         const
#define INLINE        inline

CONST INT ERROR_STRING_LEN = 500;


STATIC CHAR achErrorString[ERROR_STRING_LEN];

template<class DataType>
INLINE DataType& MAX(DataType& val1, DataType& val2)
   { return((val1 > val2) ? val1 : val2);}

template<class DataType>
INLINE DataType& MIN(DataType& val1, DataType& val2)
   { return((val1 < val2) ? val1 : val2);}

template<class DataType>
INLINE VOID ASSERT(DataType value)
   { 
      if (value == (DataType)0) 
      {
         assert(value); 
      }
   }

#define LOG_ERROR(pchMessage)                               \
   {                                                        \
      printf("ERROR: file %s: line %d\n errno=%d\n%s\n",    \
             __FILE__, __LINE__, errno, (pchMessage));      \
   }

#define LOG_DEBUG(pchMessage)                               \
   {                                                        \
      printf("DEBUG: file %s: line %d\n errno=%d\n%s\n",    \
             __FILE__, __LINE__, errno, (pchMessage));      \
   }


template<class DataType>
INLINE VOID CHECK_MALLOC(DataType& pstrMem)
   { 
      if (pstrMem == (DataType)0)
      {
         LOG_ERROR("malloc failed, out of memory");
         abort();
      }
   }


template<class DataType>
INLINE VOID CHECK_NEW(DataType& pstrMem)
   { 
      if (pstrMem == (DataType)0)
      {
         LOG_ERROR("new failed, out of memory");
         abort();
      }
   }



CONST INT TRUE                   =  1;
CONST INT FALSE                  =  0;

CONST INT BEFORE                 =  1;
CONST INT AFTER                  =  2;

CONST INT OVERWRITE              =  1;
CONST INT DONT_OVERWRITE         =  2;
CONST INT REPLACE                =  3;
CONST INT APPEND                 =  4;

CONST INT WARNING                = -1;
CONST INT ERROR                  = -2;
CONST INT FILE_EXISTS            = -3;


STATIC CHAR *pchCommonHId = "@(#) $Id: common.h,v 1.1 2001/03/04 00:05:14 tonycu Exp $";

#endif /* COMMON_H */
