#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "unix_process.h"

/* DEBUG */
   static int iNumTransitions = 0;
/* DEBUG */

/*------------------------------------*/
int
iPrintEvent(char* pchFunctionName, unsigned int uiEvent)
{
   return(0);
}

/******
int
iPrintEvent(char* pchFunctionName, unsigned int uiEvent)
{
   char achEventName[50];

   switch (uiEvent)
   {
      case CREATE_PROCESS :
      {
         strcpy(achEventName, "CREATE_PROCESS");
         break;
      }

      case SYS_CALL :
      {
         strcpy(achEventName, "SYS_CALL");
         break;
      }

      case INTERRUPT :
      {
         strcpy(achEventName, "INTERRUPT");
         break;
      }

      case RETURN :
      {
         strcpy(achEventName, "RETURN");
         break;
      }

      case RETURN_TO_USER :
      {
         strcpy(achEventName, "RETURN_TO_USER");
         break;
      }

      case PREEMPT :
      {
         strcpy(achEventName, "PREEMPT");
         break;
      }

      case SLEEP :
      {
         strcpy(achEventName, "SLEEP");
         break;
      }

      case WAKEUP :
      {
         strcpy(achEventName, "WAKEUP");
         break;
      }

      case RESCHEDULE_PROCESS :
      {
         strcpy(achEventName, "RESCHEDULE_PROCESS");
         break;
      }

      case SWAP_OUT :
      {
         strcpy(achEventName, "SWAP_OUT");
         break;
      }

      case SWAP_IN :
      {
         strcpy(achEventName, "SWAP_IN");
         break;
      }

      case ENOUGH_MEM :
      {
         strcpy(achEventName, "ENOUGH_MEM");
         break;
      }

      case NOT_ENOUGH_MEM :
      {
         strcpy(achEventName, "NOT_ENOUGH_MEM");
         break;
      }

      case EXIT :
      {
         strcpy(achEventName, "EXIT");
         break;
      }

      default :
      {
         printf("INTERNAL ERROR: undefined event %u\n", uiEvent);
         return(-1);
      }

   }

   printf("%-30s %-30s %u\n", pchFunctionName, achEventName, uiEvent);
   return(0);
}
*******/



/*------------------------------------*/
int
iIncStateTransition()
{
/*
   static int iNumTransitions = 0;
*/
   return(iNumTransitions++);
}



/*------------------------------------*/
unsigned int
uiEnoughMem()
{
   int iNumEvents = 2;
   int iEvents[2] = {ENOUGH_MEM, NOT_ENOUGH_MEM};
   int iEvent;

   iIncStateTransition();
   iEvent = iEvents[(rand()%iNumEvents)];
   iPrintEvent("uiEnoughMem", iEvent);
   return((unsigned int) iEvent);
}



/*------------------------------------*/
unsigned int
uiRunKernel()
{
   int iNumEvents = 3;
   int iEvents[3] = {PREEMPT, SLEEP, EXIT};
   int iEvent;

   iIncStateTransition();
   iEvent = iEvents[(rand()%iNumEvents)];
   iPrintEvent("uiRunKernel", iEvent);
   return((unsigned int) iEvent);
}



/*------------------------------------*/
unsigned int
uiRunUsrProcess(pid_t iProcId)
{
   int iNumEvents = 2;
   int iEvents[2] = {SYS_CALL, INTERRUPT};
   int iEvent;

   iIncStateTransition();
   iEvent = iEvents[(rand()%iNumEvents)];
   iPrintEvent("uiRunUsrProcess", iEvent);
   return((unsigned int) iEvent);
}



/*------------------------------------*/
unsigned int
uiPreempt(pid_t iProcId)
{

   iIncStateTransition();
   iPrintEvent("uiPreempt", RETURN_TO_USER);
   return((unsigned int) RETURN_TO_USER);
}



/*------------------------------------*/
unsigned int
uiSleepInMem(pid_t iProcId)
{
   int iNumEvents = 2;
   int iEvents[2] = {WAKEUP, SWAP_OUT};
   int iEvent;

   iIncStateTransition();
   iEvent = iEvents[(rand()%iNumEvents)];
   iPrintEvent("uiSleepInMem", iEvent);
   return((unsigned int) iEvent);
}



/*------------------------------------*/
unsigned int
uiSwappedOutReadyToRun(pid_t iProcId)
{
   iIncStateTransition();

   iPrintEvent("uiSwappedOutReadyToRun", SWAP_IN);
   return((unsigned int) SWAP_IN);
}


/*------------------------------------*/
unsigned int
uiInMemAndReadyToRun(pid_t iProcId)
{
   int iNumEvents = 2;
   int iEvents[2] = {RESCHEDULE_PROCESS, SWAP_OUT};
   int iEvent;

   iIncStateTransition();
   iEvent = iEvents[(rand()%iNumEvents)];
   iPrintEvent("uiInMemAndReadyToRun", iEvent);
   return((unsigned int) iEvent);
}



/*------------------------------------*/
unsigned int
uiSwapSleepingProcToDisk(pid_t iProcId)
{
   iIncStateTransition();

   iPrintEvent("uiSwapSleepingProcToDisk", WAKEUP);
   return((unsigned int) WAKEUP);
}



/*------------------------------------*/
unsigned int
uiZombieProcess(pid_t iProcId)
{
   iIncStateTransition();

   iPrintEvent("uiZombieProcess", EXIT);
   return((unsigned int) EXIT);
}

/*------------------------------------*/
int
main(int  iArgCount,
     char **ppchArgVector)
{
   unsigned int uiEvent;

   if (iArgCount != 2)
   {
      printf("\n\nUSAGE: %s <random number>\n", *ppchArgVector);
      return(-1);
   }

   srand(atoi(ppchArgVector[1]));

   printf("%-30s %-30s %s\n", 
          "FUNCTION NAME", "EVENT RETURNED", "EVENT NUMBER");
   printf("%-30s %-30s %s\n", 
          "-------------", "--------------", "------------");

   unix_process(CREATE_PROCESS);


   printf("\n\n%d state transitions\n", iIncStateTransition());

   {
      unsigned int i;
      FILE* fp;
      
      fp = fopen("output", "a");
      if (fp == NULL)
      {
         printf("fopen failed, %d\n", errno);
         return(errno);
      }
      
      for (i=0; i<999999; i++)
      {
         iNumTransitions = 0;
         srand(i);
         unix_process(CREATE_PROCESS);
         if (iNumTransitions > 100)
         {
            fprintf(fp, "%d, %d\n", i, iNumTransitions);
            fflush(fp);
         }
      }


      fclose(fp);
   }

   return(0);
}


