/*----------------------------------------------------------------------------*\
|
| Copyright (C) 1997  James A. Cureington
|                     tonyc@acm.org
| 
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or any later version.
| 
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
| 
| You should have received a copy of the GNU General Public License
| along with this program; if not, write to the Free Software
| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
|
|
| Driver for the forklift.fsk FSK.  Compile the FSK then the driver.
|       gcc -c forklift.c -o forklift.o
|       gcc forklift_driver.c forklift.o -o flift
|
| enter flift to run the program
|
|
| $Id: forklift_driver.c,v 1.1 2001/03/04 00:00:33 tonycu Exp $
|
| $Log: forklift_driver.c,v $
| Revision 1.1  2001/03/04 00:00:33  tonycu
| initial check-in at sourceforge...
|
| Revision 1.1  2000/07/23 20:54:14  tony
| initial check-in.
|
|
\*----------------------------------------------------------------------------*/

#include <stdio.h>


/*--------------------------------------------------------------------------*/
int
iInvalidEvent()
{
   printf("Invalid event detected, call the forklift dealer\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iInFailSafeMode()
{
   printf("in fail safe mode, must reset first by entering 1\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iLowerLiftBadEvent()
{
   printf("bad event in LIFT_LOWERING\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iRaiseLiftBadEvent()
{
   printf("bad event in LIFT_RAISING\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iBrakeAppliedInReverseBadEvent()
{
   printf("bad event in BRAKE_APPLIED_IN_REVERSE\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iMovingBackwardsBadEvent()
{
   printf("bad event in MOVING_BACKWARDS\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iBrakeAppliedInDriveBadEvent()
{
   printf("bad event in BRAKE_APPLIED_IN_DRIVE\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iMovingForwardBadEvent()
{
   printf("bad event in MOVING_FORWARD\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iBrakeAppliedBadEvent()
{
   printf("Bad event for BRAKE_APPLIED\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iEngineRunningBadEvent()
{
   printf("Bad event for ENGINE_RUNNING\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iEngineOffBadEvent()
{
   printf("Bad event for ENGINE_OFF\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iResetForklift()
{
   printf("-- forklift has been reset - engine off, lift off, and in park\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iStartEngine()
{
   printf("-- engine started\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iEnterFailSafeMode()
{
   printf("-- entering fail safe mode\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iStopEngine()
{
   printf("-- engine stopped\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iBrakeApplied()
{
   printf("-- brake applied\n");
   return(0);
}




/*--------------------------------------------------------------------------*/
int
iMovingBackwards()
{
   printf("-- moving backwards\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iReleaseBrake()
{
   printf("-- brake released\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iPark()
{
   printf("-- we're parked\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iDrive()
{
   printf("-- going forward\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iReverse()
{
   printf("-- going backwards\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iRaiseLift()
{
   printf("-- lift is being raised\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iLowerLift()
{
   printf("-- lift is being lowered\n");
   return(0);
}



/*--------------------------------------------------------------------------*/
int
iStopLift()
{
   printf("-- lift has stopped\n");
   return(0);
}



int
main()
{
   unsigned int uiEvent;
   char achBuffer[200];


   while (1)
   {
      printf("enter event : ");
      gets(achBuffer);

      if ((strncmp(achBuffer, "e", 1) == 0) ||
          (strncmp(achBuffer, "q", 1) == 0))
      {
         printf("ending state machine\n");
         return(0);
      }

      uiEvent = atoi(achBuffer);
      forklift(uiEvent);
   }

   return(0);
}


