/*
 * Definitions for generic ELF note handling code
 *
 * This software is being released under the GNU Public Licence.
 *
 * Copyright 1999, Jeremy Fitzhardinge <jeremy@goop.org>
 */

/* An in-core note */
struct note {
	struct note *next;
	const char *name;
	int type;
	int datasz;
	void *data;
};

int notesize(struct note *note);
int notefmt(struct note *, char *, int);
struct note *noteparse(const char *, int, struct note *);

#if 0
typedef struct {
	Elf32_Word	n_namesz;	/* Name size */
	Elf32_Word	n_descsz;	/* Content size */
	Elf32_Word	n_type;		/* Content type */
} Elf32_Nhdr;

#endif
