static char rcsid[] = "$Id: mxgdb.c,v 1.4 1992/03/25 17:48:22 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  mxgdb.c
 *
 *    Contain main program and initialization, command line options handling,
 *    and resource database management.
 *
 *    Syntax():		Print an error message if mxgdb is invoked with an
 *			incorrect number of arguments (static).
 *    main_init():	Initialization routine (static).
 *    gdboptions():	Construct command line arguments for gdb (static).
 *    main():		Main program.
 */

#   include <stdio.h>
#   include <sys/param.h>
#include "global.h"
#include "bitmaps.h"

#define Offset(field) (XtOffset(MxgdbResources*, field))

static void Syntax(char*);
static void main_init(void);
static char** gdboptions(int*, char**, MxgdbResources*);

char            cwd[MAXPATHLEN];        /* The current working directory */
XtAppContext  	app_context; 		/* application context */
Widget  	toplevel; 		/* top level widget */
Display		*display;		/* connection to X server */
MxgdbResources 	app_resources;		/* application resources of mxgdb */
char 		mxgdbinit[LINESIZ];	/* initialization file name */
Boolean		Tstartup = False;	/* if True, remove mxgdbinit */
#ifdef DEBUG
Boolean		debug = False;		/* debug mode for mxgdb */
#endif

static XtResource resources[] = {
  { "useCommandDialog", "UseCommandDialog", XtRBoolean, sizeof(Boolean),
      Offset(useCommandDialog), XtRImmediate, (caddr_t)False },
  { "bell", "Bell", XtRBoolean, sizeof(Boolean), 
     Offset(bell), XtRImmediate, (caddr_t)False },
  { "delimiters", "Delimiters", XtRString, sizeof(char *), 
     Offset(delimiters), XtRImmediate, (caddr_t)NULL },
  { "prompt", "Prompt", XtRString, sizeof(char *), 
     Offset(prompt), XtRImmediate, (caddr_t)NULL },
  { "button_color", "ButtonColor", XtRPixel, sizeof(Pixel),
     Offset(button_color), XtRString, "Black" },
  { "stop_color", "StopColor", XtRPixel, sizeof(Pixel), 
     Offset(stop_color), XtRString, "Red" },
  { "arrow_color", "ArrowColor", XtRPixel, sizeof(Pixel), 
     Offset(arrow_color), XtRString, "Blue" },
  { "updown_color", "UpdownColor", XtRPixel, sizeof(Pixel), 
     Offset(updown_color), XtRString, "Blue" },
  { "bomb_color", "bombColor", XtRPixel, sizeof(Pixel), 
     Offset(bomb_color), XtRString, "Red" },
  { "bigicon", "Mxgdboptions", XtRBoolean, sizeof(Boolean), 
     Offset(bigicon), XtRImmediate, (caddr_t)False },
#ifdef DEBUG
  { "debug", "Mxgdboptions", XtRBoolean, sizeof(Boolean), 
     Offset(debug), XtRImmediate, (caddr_t)False },
#endif
  { "includeDir", "Gdboptions", XtRString, sizeof(char *), 
     Offset(includeDir), XtRImmediate, (caddr_t)NULL},
  { "cfile", "Gdboptions", XtRString, sizeof(char *), 
     Offset(cfile), XtRImmediate, (caddr_t)NULL },
  { "startup", "Gdboptions", XtRString, sizeof(char *), 
     Offset(startup), XtRImmediate, (caddr_t)NULL },
  { "tstartup", "Gdboptions", XtRString, sizeof(char *), 
     Offset(tstartup), XtRImmediate, (caddr_t)NULL },
};


static XrmOptionDescRec options[] = {
    { "-bigicon","bigicon",	XrmoptionNoArg, "True" },
#ifdef DEBUG
    { "-debug",	"debug",	XrmoptionNoArg, "True" },
#endif
    { "-d",	"includeDir",	XrmoptionSepArg, NULL },
    { "-cmdd",  "useCommandDialog", XrmoptionNoArg, "True" },
};

static void Syntax(call)
char *call;
{
    fprintf(stderr,
	    "Usage: %s [-toolkitoptions] [-gdboptions] [objfile [corefile]]\n",
	    call);
    exit(1);
}

Cursor xterm, top_left_arrow;

/*  Set window manager hints to indicate display accepts input.
 *  Initialize routines in source.c, signs.c and parser.c.
 *  Disable window resize of fileWindow.
 *  Get the name of the gdb command initialization file.
 */
static void main_init()
{
    XWMHints	wmhints;
    char	title[100];

    display = XtDisplay(toplevel);

    sprintf(title, "mxgdb 1.2");
    XStoreName(display, XtWindow(toplevel), title);
    XSetIconName(display, XtWindow(toplevel), "mxgdb");

    xterm = XCreateFontCursor(display, XC_xterm);
    top_left_arrow = XCreateFontCursor(display, XC_top_left_arrow);
    XDefineCursor(display, XtWindow(sourceWindow), xterm);
    XDefineCursor(display, XtWindow(dialogWindow), xterm);

    wmhints.input = True;
    if (app_resources.bigicon)
	wmhints.icon_pixmap = XCreateBitmapFromData(display, XtWindow(toplevel),
	    mxgdb64_bits, mxgdb64_width, mxgdb64_height);
    else
	wmhints.icon_pixmap = XCreateBitmapFromData(display, XtWindow(toplevel),
	    mxgdb48_bits, mxgdb48_width, mxgdb48_height);
    wmhints.flags = IconPixmapHint | InputHint;
    XSetWMHints(display, XtWindow(toplevel), &wmhints);

    if (!app_resources.delimiters || 
	!strcmp(app_resources.delimiters, ""))
	app_resources.delimiters = XtNewString(DELIMITERS);
    if (app_resources.prompt && strcmp(app_resources.prompt, ""))
	mxgdbprompt = app_resources.prompt;
    else
	mxgdbprompt = MXGDBPROMPT;
#ifdef DEBUG
    debug = app_resources.debug;
#endif

    strcpy(mxgdbinit, ".gdbinit");
    if (access(mxgdbinit, R_OK) == -1) {
    	sprintf(mxgdbinit, "%s/%s", (char *) getenv("HOME"), ".gdbinit");
    	if (access(mxgdbinit, R_OK) == -1) {
	    strcpy(mxgdbinit, "");
	}
    }
	
    source_init();
    signs_init();
    parser_init();
}


/*  Reconstruct command line arguments for calling gdb.
 *  Return the argument list for gdb and new value of argc.
 */
static char **gdboptions(argc, argv, app_resources)
     int  *argc;
     char **argv;
     MxgdbResources *app_resources;
{
  char **gdbargv;
  char *temp = "mxgdb.XXXXXX";
  int  i=0;

  gdbargv = (char **) XtMalloc (MAXARGS * sizeof(char *));
  for (i=0; i < *argc; i++)
    gdbargv[i] = argv[i];
  gdbargv[i++] = "-fullname";                   /* see gdb_regex.h */
  if (app_resources->includeDir)                /* Include directory */
    {
      gdbargv[i++] = "-d ";
      gdbargv[i++] = app_resources->includeDir;
    }
  if (app_resources->cfile)                     /* Core file */ 
    {
      gdbargv[i++] = "-c";
      gdbargv[i++] = app_resources->cfile;
    }
  if (strcmp(mxgdbinit, ""))                    /* .gdbinit or ~/.gdbinit 
						   exists */ 
    {
      gdbargv[i++] = "-nx";
    }
  if (app_resources->startup)                   /* overwrites gdbinit */ 
    {
      Tstartup = False;
      strcpy(mxgdbinit, app_resources->startup);
    }
  if (app_resources->tstartup)                  /* overwrites gdbinit */ 
    {
      Tstartup = True;
      strcpy(mxgdbinit, app_resources->tstartup);
    }
  gdbargv[i] = NULL;
  *argc = i;
  return gdbargv;
}

void main(argc, argv)
int argc;
char **argv;
{
    char 	**gdbargv;
    Arg args[10];

    getcwd((char *)cwd, MAXPATHLEN);
    trap_signals();


    XtSetArg(args[0], XmNkeyboardFocusPolicy, XmPOINTER);
    toplevel = XtAppInitialize(&app_context, "Mxgdb", options, XtNumber(options), &argc, argv, NULL, args, 1);

    if (argc > 3) Syntax(argv[0]);
    
    XtGetApplicationResources(toplevel, &app_resources, resources,
                              XtNumber(resources), NULL, 0);

    CreateSubWindows(toplevel);
    XtRealizeWidget(toplevel);

    main_init();

    AppendDialogText("MXGDB Beta-version 1.2\nMXGDB comes with ABSOLUTELY NO WARRANTY.\n");

   
    gdbargv = gdboptions(&argc, argv, &app_resources);
    callgdb(argc, gdbargv);
    
    if(app_resources.useCommandDialog)
      XtManageChild(commandDialog);

    XtAppMainLoop(app_context);
}


