/* $Id: gdb_regex.h,v 1.1.1.1 1992/01/10 18:30:31 jtsillas Exp $ */

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  
 *  gdb_regex.h:
 *
 *  Regular expression pattern matching for GNU gdb.
 *  
 *  The reg_token array indicates the register no. for each token type.
 *      reg_token[0] : message
 *      reg_token[1] : stop number
 *      reg_token[2] : function name
 *      reg_token[3] : line number
 *      reg_token[4] : file name
 *      reg_token[5] : display command output
 */

#define	TK_MESG 	0
#define TK_STOP		1
#define TK_FUNC 	2
#define TK_LINE 	3
#define TK_FILE 	4
#define TK_DISP 	5

#define	O_EXEC_MESS_AFTER	0
#define	O_EXEC_MESS_BEFORE	1
#define	O_EXEC			2
#define O_DONE			3
#define O_BREAK 		4   /* Instead of O_STOPAT & O_STOPIN */
#define O_INFO_DIR  		5   /* NEW for GDB */
#define O_FRAME_CURR		6   /* O_FRAME_CURR = O_UPDOWN */
#define O_UPDOWN                6
#define O_BELL			7
#define O_SEARCH		8
#define O_INFO_LINE		9   /* Instead of O_FILE */
#define O_PRINT			10
#define O_DEBUG			11
#define O_DIRECTORY		12			
#define O_LIST			13  /* for gdb, O_LIST = O_SEARCH */
#define O_DISPLAY		14
#define O_DISPLAY_INFO		15
#define O_PWD			16
#define O_CD			16  /* O_PWD = O_CD */
#define O_RECEIVED_SIGNAL	17  /* test program received signal */
#define O_EXEC_DISPLAY		18  /* special for filter_display_info  */
#define O_READING_SYMBOLS	19  /* special for filter_reading_symbols */
#define O_INFO_SOURCE		20  /* to get compilation directory */

#define	C_ANY			-1
#define C_EXEC			0
#define C_BREAK			1   /* Instead of C_STOPAT & C_STOPIN */
#define C_INFO_DIR		2   /* NEW for GDB */
#define C_FRAME_CURR	        3
#define C_UPDOWN		4
#define C_CLEAR 		5
#define C_FINISH		6   /* Instead of C_FUNC */
#define C_INFO_LINE		7   /* Instead of C_FILE */
#define C_SYMBOL_FILE	        8
#define C_CD			9
#define C_DIRECTORY		10  /* Instead of C_USE */
#define C_PWD			11
#define C_LIST			12
#define C_SEARCH		13
#define C_DISPLAY_INFO	        14  /* must be BEFORE C_DISPLAY ! */
#define C_DISPLAY		15
#define C_UNDISPLAY		16
#define C_PRINT			17
#define C_INFO_BREAK	        18
#define C_SOURCE		19
#define C_EXEC_FILE		20
#define C_CORE_FILE             21
#define C_DEFINE                22
#define C_DOCUMENT              23
#define C_END                   24
#define C_HELP                  25
#define C_INFO_SOURCE		26  /* to get compilation directory */

extern PatternRec command_pattern[];
extern PatternRec output_pattern[];








