static char rcsid[] = "$Id: filemenu.c,v 1.1.1.1 1992/01/10 18:30:16 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/* filemenu.c
 *
 *  Construct a file menu (directory browser) which allows a user to go
 *  up and down the directory tree, to select text files to display, and
 *  to select executable files to debug.  The file menu is popped up by
 *  the 'file' command button.
 *  Duane Voth (duanev@mcc.com) contributed to the layout of the file menu, 
 *  plus some code and ideas.
 *
 *  File():		Command callback for the 'file' command button.
 *  CancelCallback():   Removes the dialog.
 *  OKCallBack():       Selects the file from the dialog.
 */

#include <ctype.h>
#include <X11/Xos.h>
#include <sys/stat.h>
#include <stdio.h>
#include "global.h"
#include <Xm/Xm.h>
#include <Xm/FileSB.h>

void CancelCallBack(w, client_data, call_data)
     Widget w;
     XtPointer client_data;
     XtPointer call_data;
{
  XtUnmanageChild(fileSel);
}

void OKCallBack(w, client_data, call_data)
     Widget w;
     XtPointer client_data;
     XtPointer call_data;
{
  Widget TextW;

  char *string;
  char command[LINESIZ];
  Arg args[5];
  struct stat statbuf;

  TextW = XmFileSelectionBoxGetChild(w, XmDIALOG_TEXT);
  string = (char *)XmTextGetString(TextW);

  XtUnmanageChild(fileSel);
#if !defined(SCO) && !defined(ISC)
  if(lstat(string, &statbuf) == -1)
#else
  if(stat(string, &statbuf) == -1)
#endif
    {
      UpdateMessageWindow("Could not stat file or directory", NULL);
      if(string) XtFree(string);
      return;
    }
  if (statbuf.st_mode & S_IFDIR)
    sprintf(command, "dir %s\n", string);
  else
    if (statbuf.st_mode & S_IEXEC)             /* is executable */
      {
	sprintf(command, "exec-file %s\n", string);
	send_command(command);
	AppendDialogText(command);
	
	Echo = True;
	Parse = True;
	Prompt = False;
	while (!Prompt)
	  read_from_gdb();
	
	sprintf(command, "symbol-file %s\n", string);
      }
    else
      {
				/* Normalize the filename to the last */
				/* part of the path. Gdb doesn't like */
				/* full pathnames in its list calls.  */
	int tmpindex;
	for(tmpindex = strlen(string) + 1; string[tmpindex] != '/' && 
	    tmpindex; tmpindex--);
	sprintf(command, "list %s:1\n", &string[tmpindex+1]);
      }
  send_command(command);
  AppendDialogText(command);
  XtFree(string);
}


/*  File command button callback.
 */
void File(w, client_data, call_data)
    Widget w;
    XtPointer client_data;
    XtPointer call_data;
{
    Arg 	args[MAXARGS];
    Cardinal	n;
    Position	x, y, x_offset;
    Dimension	fileMenu_width, fileMenuLabel_width, border_width,
		width, dialog_width;

    XtManageChild(fileSel);

    UpdateMessageWindow("Select a file or directory", NULL);
}




