// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhLap.hh
//   List of auto pointers.
//   This is a template.
//
// File Created:	28 Oct 1995		Michael Chastain
// Last Edited:		30 Oct 1995		Michael Chastain

#if !defined(WH_LAP_HH)
#define WH_LAP_HH

#include <ErRange.hh>



template <class T> class WhLap
{
    // Life cycle methods.
    public:
				WhLap		(		   );
				~WhLap		(		   );

    // Forbidden copiers.
    private:
				WhLap		( const WhLap<T> & );
	void			operator =	( const WhLap<T> & );

    // Accessors.
    public:
	const T &		operator []	( int		   ) const;
	T &			refNonConst	( int		   );
	int			count		(		   ) const;

    // Mutators.
    public:
	void			remove		( int		   );
	void			reset		(		   );
	void			reset		( int		   );

    // Appenders.
    public:
	void			appendAp	( T * & pData	   );

    // Helpers.
    private:
	void			expand		( int		   );

    // Instance data.
    private:
	int			nData_;		// # data items.
	int			nDataMax_;	// # items allocated.
	T **			ppData_;	// The data.
};



// Inline methods.

template <class T> inline WhLap<T>::WhLap( )
    : nData_	( 0 )
    , nDataMax_	( 0 )
    , ppData_	( 0 )
{
    ;
}

template <class T> inline const T & WhLap<T>::operator [] ( int iData ) const
{
    if ( iData < 0 || iData >= nData_ )
	ErRange( );
    return *ppData_[iData];
}

template <class T> inline T & WhLap<T>::refNonConst( int iData )
{
    if ( iData < 0 || iData >= nData_ )
	ErRange( );
    return *ppData_[iData];
}

template <class T> inline int WhLap<T>::count( ) const
{
    return nData_;
}



#endif
