// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhFlatOut.hh
//   Flat data.
//   This is a concrete class.
//
// File Created:	25 Oct 1995		Michael Chastain
// Last Edited:		29 Oct 1995		Michael Chastain

#if !defined(WH_FLAT_OUT_HH)
#define WH_FLAT_OUT_HH

#include <MmType.hh>
#include <WhList.hh>

class	WhString;



class	WhFlatOut
{
    // Life cycle methods.
    public:
				WhFlatOut	( int		   );
				~WhFlatOut	(		   );

    // Forbidden copiers.
    private:
				WhFlatOut	( const WhFlatOut& );
	void			operator =	( const WhFlatOut& );

    // Accessors.
    public:
	const char *		address		(		   ) const;
	int			count		(		   ) const;

    // Mutators.
    public:
	void			clear		(		   );

    // Writers.
    public:
	void			putAddr		( MmAddr	   );
	void			putBool		( bool		   );
	void			putChar		( char		   );
	void			putInt		( int		   );
	void			putArrayChar	( const char*, int );
	void			putListWord	( const WhList
						  <MmWord> &	   );
	void			putString	( const WhString & );
	void			putWord		( MmWord	   );

    // Helpers.
    private:
	void			expand		( int		   );

    // Instance data.
    private:
    	int			ncData_;	// Count.
    	int			ncDataMax_;	// Allocation.
    	char *			pcData_;	// Data.
};



// Inline methods.

inline const char * WhFlatOut::address( ) const
{
    return pcData_;
}

inline int WhFlatOut::count( ) const
{
    return ncData_;
}

inline void WhFlatOut::clear( )
{
    ncData_ = 0;
}



#endif
