// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhFlatIn.cc
//   Input buffer.
//   This is a concrete class.
//
// File Created:	25 Oct 1995		Michael Chastain
// Last Edited:		08 Nov 1995		Michael Chastain

#include <ErAbort.hh>
#include <ErFatal.hh>
#include <ErPtr.hh>
#include <WhFlatIn.hh>
#include <WhImage.hh>
#include <WhString.hh>



// Constructor.
//   Takes a buffer by linear pointer.
WhFlatIn::WhFlatIn( char * & pcData, int ncData )
    : icData_		( 0		)
    , pcData_		( 0		)
    , ncData_		( 0		)
    , pcOwn_		( pcData	)
    , pimageOwn_	( 0		)
{
    if ( pcData == 0 )
	ErPtr( );
    if ( ncData < 0 )
	ErAbort( "negative count." );
    pcData_ = pcData;
    ncData_ = ncData;
    pcData  = 0;
}



// Constructor.
//   Takes an image by linear pointer.
WhFlatIn::WhFlatIn( WhImage * & pimageData )
    : icData_		( 0		)
    , pcData_		( 0		)
    , ncData_		( 0		)
    , pcOwn_		( 0		)
    , pimageOwn_	( pimageData	)
{
    if ( pimageData == 0 )
	ErPtr( );
    pcData_    = pimageData->address ( );
    ncData_    = pimageData->count   ( );
    pimageData = 0;
}



// Destructor.
WhFlatIn::~WhFlatIn( )
{
    finalize( );
}



// Finalizer.
void WhFlatIn::finalize( )
{
    pcData_ = 0;

    if ( pcOwn_ != 0 )
	delete [] pcOwn_;
    pcOwn_ = 0;

    if ( pimageOwn_ != 0 )
	delete pimageOwn_;
    pimageOwn_ = 0;
}



// Get an address.
void WhFlatIn::getAddr( MmAddr & addrGet )
{
    while ( icData_ % sizeof(MmAddr) != 0 )
	++icData_;
    if ( ncData_ - icData_ < int( sizeof(MmAddr) ) )
	ErFatal( "WhFlatIn::getAddr: end of flat." );
    addrGet  = * (const MmAddr *) (pcData_ + icData_);
    icData_ += sizeof(MmAddr);
}



// Get a boolean.
void WhFlatIn::getBool( bool & fGet )
{
    while ( icData_ % sizeof(bool) != 0 )
	++icData_;
    if ( ncData_ - icData_ < int( sizeof(bool) ) )
	ErFatal( "WhFlatIn::getBool: end of flat." );
    fGet     = * (const bool *) (pcData_ + icData_);
    icData_ += sizeof(bool);
}



// Get a ccs.
//   Warning: this points into the flat!
void WhFlatIn::getCcs( const char * & pcGet )
{
    // Get # of chars.
    int ncGet;
    getInt( ncGet );
    if ( ncGet < 0 )
	ErFatal( "WhFlatIn::getCcs: negative count." );
    while ( icData_ % sizeof(char) != 0 )
	++icData_;
    if ( ncData_ - icData_ < ncGet * int( sizeof(char) ) )
	ErFatal( "WhFlatIn::getCcs: end of flat." );

    // Check chars.
    if ( ncGet == 0 )
	ErFatal( "WhFlatIn::getCcs: not ccs." );
    for ( int icGet = 0; icGet < ncGet; ++icGet )
    {
	if ( ( pcData_[icData_+icGet] == '\0' ) != ( icGet == ncGet - 1 ) )
	    ErFatal( "WhFlatIn::getCcs: not ccs." );
    }

    // Get pointer.
    pcGet = (const char *) (pcData_ + icData_);
    icData_ += ncGet * sizeof(char);
}



// Get a character.
void WhFlatIn::getChar( char & cGet )
{
    while ( icData_ % sizeof(char) != 0 )
	++icData_;
    if ( ncData_ - icData_ < int( sizeof(char) ) )
	ErFatal( "WhFlatIn::getChar: end of flat." );
    cGet     = * (const char *) (pcData_ + icData_);
    icData_ += sizeof(char);
}



// Get an integer.
void WhFlatIn::getInt( int & iGet )
{
    while ( icData_ % sizeof(int) != 0 )
	++icData_;
    if ( ncData_ - icData_ < int( sizeof(int) ) )
	ErFatal( "WhFlatIn::getInt: end of flat." );
    iGet     = * (const int *) (pcData_ + icData_);
    icData_ += sizeof(int);
}



// Get a list of characters.
void WhFlatIn::getListChar( WhList <char> & lcGet )
{
    // Get # of chars.
    int ncGet;
    getInt( ncGet );
    if ( ncGet < 0 )
	ErFatal( "WhFlatIn::getListChar: negative count." );
    while ( icData_ % sizeof(char) != 0 )
	++icData_;
    if ( ncData_ - icData_ < ncGet * int( sizeof(char) ) )
	ErFatal( "WhFlatIn::getListChar: end of flat." );

    // Get chars.
    lcGet.clear( ncGet );
    lcGet.appendArray( (const char *) (pcData_ + icData_), ncGet );
    icData_ += ncGet * sizeof(char);
}



// Get a list of words.
void WhFlatIn::getListWord( WhList <MmWord> & lwGet )
{
    // Get # of words.
    int nwGet;
    getInt( nwGet );
    if ( nwGet < 0 )
	ErFatal( "WhFlatIn::getListWord: negative count." );
    while ( icData_ % sizeof(MmWord) != 0 )
	++icData_;
    if ( ncData_ - icData_ < nwGet * int( sizeof(MmWord) ) )
	ErFatal( "WhFlatIn::getListWord: end of flat." );

    // Get words.
    lwGet.clear( nwGet );
    lwGet.appendArray( (const MmWord *) (pcData_ + icData_), nwGet );
    icData_ += nwGet * sizeof(MmWord);
}



// Get a string.
void WhFlatIn::getString( WhString & strGet )
{
    // Get # of chars.
    int ncGet;
    getInt( ncGet );
    if ( ncGet < 0 )
	ErFatal( "WhFlatIn::getString: negative count." );
    while ( icData_ % sizeof(char) != 0 )
	++icData_;
    if ( ncData_ - icData_ < ncGet * int( sizeof(char) ) )
	ErFatal( "WhFlatIn::getString: end of flat." );

    // Get chars.
    strGet.clear( );
    for ( int icGet = 0; icGet < ncGet; ++icGet )
	strGet.appChrRaw( ((const char *) (pcData_ + icData_))[icGet] );
    icData_ += ncGet * sizeof(char);
}



// Get a word.
void WhFlatIn::getWord( MmWord & wGet )
{
    while ( icData_ % sizeof(MmWord) != 0 )
	++icData_;
    if ( ncData_ - icData_ < int( sizeof(MmWord) ) )
	ErFatal( "WhFlatIn::getWord: end of flat." );
    wGet     = * (const MmWord *) (pcData_ + icData_);
    icData_ += sizeof(MmWord);
}
