// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhFileOut.hh
//   File output class.
//   This is an external resource handler class.
//
// File Created:	25 Oct 1995		Michael Chastain
// Last Edited:		29 Oct 1995		Michael Chastain

#if !defined(WH_FILE_OUT_HH)
#define WH_FILE_OUT_HH

#include <WhString.hh>



class	WhFileOut
{
    // File open type.
    public:
	enum	TyOpen
	{
	    tyOpenWriteData,	// Write a data file.
	    tyOpenWriteExe	// Write an exe file.
	};

    // Life cycle methods.
    public:
    				WhFileOut	( const WhString &,
						  TyOpen	   );
	bool			isError		(		   ) const;
	const WhString &	getError	(		   ) const;
    				~WhFileOut	(		   );
	void			finalize	(		   );

    // Forbidden copiers.
    private:
    				WhFileOut	( const WhFileOut& );
	void			operator =	( const WhFileOut& );

    // File interface.
    public:
	void			writeArrayChar	( const char*, int );

    // Instance data.
    private:
	WhString		strError_;	// Error string.
	bool			fFile_;		// Has a file.
	int			fdFile_;	// Unix file descriptor.
};



// Inline methods.

inline bool WhFileOut::isError( ) const
{
    return strError_.count( ) > 0;
}

inline const WhString & WhFileOut::getError( ) const
{
    return strError_;
}



#endif
