// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ScLineLix.cc
//   System call line.
//   This is a struct.
//
// This is the data table.
//
// File Created:	10 Apr 1995		Michael Chastain
// File Reviewed:	21 Oct 1995		Michael Chastain
// Last Edited:		14 Nov 1995		Michael Chastain



// System header files.
#include <linux/types.h>
#include <linux/cdrom.h>
#include <linux/dirent.h>
#include <linux/fcntl.h>
#include <linux/fd.h>
#include <linux/if.h>
#include <linux/if_eql.h>
#include <linux/if_ppp.h>
#include <linux/kd.h>
#include <linux/mman.h>
#include <linux/net.h>
#include <linux/ppp-comp.h>
#include <linux/ptrace.h>
#include <linux/random.h>
#include <linux/route.h>
#include <linux/scsi.h>
#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/termios.h>
#include <linux/uio.h>
#include <linux/unistd.h>


// More system header files.
#define  __KERNEL__
#include <linux/linkage.h>
#include <linux/ipc.h>
#include <linux/msg.h>
#include <linux/sem.h>
#include <linux/shm.h>
#undef   __KERNEL__



// My header files.
#include <CxFetch.hh>
#include <ErFatal.hh>
#include <ErMem.hh>
#include <ErPtr.hh>
#include <EvBase.hh>
#include <EvSci.hh>
#include <EvSco.hh>
#include <MmArea.hh>
#include <MmSeg.hh>
#include <MmSpace.hh>
#include <MmType.hh>
#include <MsLine.hh>
#include <PrProc.hh>
#include <RiLine.hh>
#include <ScLine.hh>
#include <TySegLix.hh>
#include <WhCount.hh>
#include <WhList.hh>
#include <WhString.hh>



// Seg fetchers.
static void FetchAllArea	( CxFetch &, EvBase & );
static void FetchInAccept	( CxFetch &, EvBase & );
static void FetchOutAccept	( CxFetch &, EvBase & );
static void FetchOutBdflush	( CxFetch &, EvBase & );
static void FetchOutBrk		( CxFetch &, EvBase & );
static void FetchOutChdir	( CxFetch &, EvBase & );
static void FetchOutChroot	( CxFetch &, EvBase & );
static void FetchInExecve	( CxFetch &, EvBase & );
static void FetchOutExecve	( CxFetch &, EvBase & );
static void FetchOutFchdir	( CxFetch &, EvBase & );
static void FetchInFcntl	( CxFetch &, EvBase & );
static void FetchOutFcntl	( CxFetch &, EvBase & );
static void FetchInInitModule	( CxFetch &, EvBase & );
static void FetchInIoctl	( CxFetch &, EvBase & );
static void FetchOutIoctl	( CxFetch &, EvBase & );
static void FetchOutMmap	( CxFetch &, EvBase & );
static void FetchInModifyLdt	( CxFetch &, EvBase & );
static void FetchOutModifyLdt	( CxFetch &, EvBase & );
static void FetchInMount	( CxFetch &, EvBase & );
static void FetchInMsgctl	( CxFetch &, EvBase & );
static void FetchOutMsgctl	( CxFetch &, EvBase & );
static void FetchOutMsgrcv0	( CxFetch &, EvBase & );
static void FetchOutMsgrcv1	( CxFetch &, EvBase & );
static void FetchInMsgsnd	( CxFetch &, EvBase & );
static void FetchOutMunmap	( CxFetch &, EvBase & );
static void FetchOutPtrace	( CxFetch &, EvBase & );
static void FetchOutReaddir	( CxFetch &, EvBase & );
static void FetchOutReadv	( CxFetch &, EvBase & );
static void FetchOutRecvfrom	( CxFetch &, EvBase & );
static void FetchInRecvmsg	( CxFetch &, EvBase & );
static void FetchOutRecvmsg	( CxFetch &, EvBase & );
static void FetchInSemctl	( CxFetch &, EvBase & );
static void FetchOutSemctl	( CxFetch &, EvBase & );
static void FetchInSendmsg	( CxFetch &, EvBase & );
static void FetchInShmctl	( CxFetch &, EvBase & );
static void FetchOutShmctl	( CxFetch &, EvBase & );
static void FetchInSigreturn	( CxFetch &, EvBase & );
static void FetchInSysfs	( CxFetch &, EvBase & );
static void FetchOutSysfs	( CxFetch &, EvBase & );
static void FetchOutSyslog	( CxFetch &, EvBase & );
static void FetchOutUselib	( CxFetch &, EvBase & );
static void FetchInWritev	( CxFetch &, EvBase & );



// Make initializers available.
#define F			false
#define T			true
#define tyAddrArg		MsLine::tyAddrArg
#define tyAddrArgNz		MsLine::tyAddrArgNz
#define tyArgMem		ScLine::tyArgMem
#define tyArgNone		ScLine::tyArgNone
#define tyArgReg		ScLine::tyArgReg
#define tyCountArg		MsLine::tyCountArg
#define tyCountMem		MsLine::tyCountMem
#define tyCountOne		MsLine::tyCountOne
#define tyCountRet		MsLine::tyCountRet
#define tyCountSel		MsLine::tyCountSel
#define tyDsNone		ScLine::tyDsNone
#define tyDsExecve		ScLine::tyDsExecve
#define tyDsUselib		ScLine::tyDsUselib
#define tyScrAddr		MmScr::tyScrAddr
#define tyScrHex		MmScr::tyScrHex
#define tyScrInt		MmScr::tyScrInt
#define tyScrNot		MmScr::tyScrNot
#define tyScrOct		MmScr::tyScrOct
#define tySmashCant		ScLine::tySmashCant
#define tySmashDef		ScLine::tySmashDef
#define tySmashFile		ScLine::tySmashFile
#define tySmashMmap		ScLine::tySmashMmap
#define tySmashMpi0		ScLine::tySmashMpi0
#define tySmashNop		ScLine::tySmashNop
#define tySmashPair		ScLine::tySmashPair
#define tySmashReplay		ScLine::tySmashReplay
#define tySmashWrite		ScLine::tySmashWrite
#define tySmashZero		ScLine::tySmashZero



// System call lines.

static const MsLine	amsAccept		[ ] =
{
    { T, T, T,	tySegMmWord,		tyAddrArg, 2,	tyCountOne, 1	},
    { F, T, T,	tySegListMmByte,	tyAddrArg, 1,	tyCountMem, 2	}
};

static const ScLine	sclAccept		=
{
    "accept", true, tyArgMem, 1, "DPP", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInAccept, FetchOutAccept
};



static const MsLine	amsAccess		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclAccess		=
{
    "access", true, tyArgReg, 0, "PD", tySmashDef, tyDsNone, tyScrInt,
    amsAccess, WhCount(amsAccess), 0, 0
};



static const MsLine	amsAcct			[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclAcct			=
{
    "acct", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsAcct, WhCount(amsAcct), 0, 0
};



static const MsLine	amsAdjtimex		[ ] =
{
    { T, T, T,	tySegTimex,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclAdjtimex		=
{
    "adjtimex", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsAdjtimex, WhCount(amsAdjtimex), 0, 0
};



// Linux 1.3.35: not implemented in kernel.

static const ScLine	sclAfsSyscall		=
{
    "afs_syscall", false, tyArgNone, 0, "", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclAlarm		=
{
    "alarm", true, tyArgReg, 0, "D", tySmashZero, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsBdflush		[ ] =
{
    { F, T, T,	tySegMmWord,		tyAddrArg, 1,	tyCountArg, 1	}
};

static const ScLine	sclBdflush		=
{
    "bdflush", true, tyArgReg, 0, "DP", tySmashMpi0, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutBdflush
};



static const MsLine	amsBind			[ ] =
{
    { T, F, F,	tySegListMmByte,	tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclBind			=
{
    "bind", true, tyArgMem, 1, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsBind, WhCount(amsBind), 0, 0
};



static const ScLine	sclBreak		=
{
    "break", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclBrk			=
{
    "brk", true, tyArgReg, 0, "P", tySmashReplay, tyDsNone, tyScrAddr,
    0, 0, 0, FetchOutBrk
};



static const MsLine	amsChdir		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChdir		=
{
    "chdir", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsChdir, WhCount(amsChdir), 0, FetchOutChdir
};



static const MsLine	amsChmod		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChmod		=
{
    "chmod", true, tyArgReg, 0, "PO", tySmashDef, tyDsNone, tyScrInt,
    amsChmod, WhCount(amsChmod), 0, 0
};



static const MsLine	amsChown		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChown		=
{
    "chown", true, tyArgReg, 0, "PDD", tySmashDef, tyDsNone, tyScrInt,
    amsChown, WhCount(amsChown), 0, 0
};



static const MsLine	amsChroot		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChroot		=
{
    "chroot", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsChroot, WhCount(amsChroot), 0, FetchOutChroot
};



static const ScLine	sclClone		=
{
    "clone", true, tyArgReg, 0, "PX", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclClose		=
{
    "close", true, tyArgReg, 0, "D", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsConnect		[ ] =
{
    { T, F, F,	tySegListMmByte,	tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclConnect		=
{
    "connect", true, tyArgMem, 1, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsConnect, WhCount(amsConnect), 0, 0
};



static const MsLine	amsCreat		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclCreat		=
{
    "creat", true, tyArgReg, 0, "PO", tySmashDef, tyDsNone, tyScrInt,
    amsCreat, WhCount(amsCreat), 0, 0
};



static const MsLine	amsCreateModule		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclCreateModule		=
{
    "create_module", true, tyArgReg, 0, "PD", tySmashDef, tyDsNone, tyScrInt,
    amsCreateModule, WhCount(amsCreateModule), 0, 0
};



static const MsLine	amsDeleteModule		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclDeleteModule		=
{
    "delete_module", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsDeleteModule, WhCount(amsDeleteModule), 0, 0
};



static const ScLine	sclDup			=
{
    "dup", true, tyArgReg, 0, "D", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclDup2			=
{
    "dup2", true, tyArgReg, 0, "DD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsExecve		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg,   0,	tyCountOne, 1	},
    { T, F, F,	tySegListExecAddr,	tyAddrArgNz, 1,	tyCountOne, 1	},
    { T, F, F,	tySegListExecAddr,	tyAddrArgNz, 2,	tyCountOne, 1	}
};

static const ScLine	sclExecve		=
{
    "execve", true, tyArgReg, 0, "PPP", tySmashFile, tyDsExecve, tyScrInt,
    amsExecve, WhCount(amsExecve), FetchInExecve, FetchOutExecve
};



static const ScLine	sclExit			=
{
    "exit", true, tyArgReg, 0, "D", tySmashReplay, tyDsNone, tyScrNot,
    0, 0, 0, 0
};



static const ScLine	sclFchdir		=
{
    "fchdir", true, tyArgReg, 0, "D", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutFchdir
};



static const ScLine	sclFchmod		=
{
    "fchmod", true, tyArgReg, 0, "DO", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFchown		=
{
    "fchown", true, tyArgReg, 0, "DDD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsFcntlFlock		[ ] =
{
    { T, T, T,	tySegFlock,		tyAddrArg, 2,	tyCountOne, 1	}
};

static const ScLine	sclFcntl		=
{
    "fcntl", true, tyArgReg, 0, "DDP", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInFcntl, FetchOutFcntl
};



static const ScLine	sclFlock		=
{
    "flock", true, tyArgReg, 0, "DX", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFork			=
{
    "fork", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsFstat		[ ] =
{
    { F, T, T,	tySegNewStat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclFstat		=
{
    "fstat", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsFstat, WhCount(amsFstat), 0, 0
};



static const MsLine	amsFstatfs		[ ] =
{
    { F, T, T,	tySegStatfs,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclFstatfs		=
{
    "fstatfs", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsFstatfs, WhCount(amsFstatfs), 0, 0
};



static const ScLine	sclFsync		=
{
    "fsync", true, tyArgReg, 0, "D", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFtime		=
{
    "ftime", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFtruncate		=
{
    "ftruncate", true, tyArgReg, 0, "DD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsGetdents		[ ] =
{
    { F, T, F,	tySegListDirent,	tyAddrArg, 1,	tyCountRet, 1	},
    { F, F, T,	tySegAny,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclGetdents		=
{
    "getdents", true, tyArgReg, 0, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsGetdents, WhCount(amsGetdents), 0, 0
};



static const MsLine	amsGetKernelSyms	[ ] =
{
    { F, T, F,	tySegListKernelSym,	tyAddrArgNz, 0,	tyCountRet, 1	},
};

static const ScLine	sclGetKernelSyms	=
{
    "get_kernel_syms", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsGetKernelSyms, WhCount(amsGetKernelSyms), 0, 0
};



static const ScLine	sclGetegid		=
{
    "getegid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGeteuid		=
{
    "geteuid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetgid		=
{
    "getgid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsGetgroups		[ ] =
{
    { F, T, T,	tySegListGidT,		tyAddrArg, 1,	tyCountArg, 0	}
};

static const ScLine	sclGetgroups		=
{
    "getgroups", true, tyArgReg, 0, "DP", tySmashZero, tyDsNone, tyScrInt,
    amsGetgroups, WhCount(amsGetgroups), 0, 0
};



static const MsLine	amsGetitimer		[ ] =
{
    { F, T, T,	tySegItimerval,		tyAddrArgNz, 1,	tyCountOne, 1	}
};

static const ScLine	sclGetitimer		=
{
    "getitimer", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsGetitimer, WhCount(amsGetitimer), 0, 0
};



static const MsLine	amsGetpeername		[ ] =
{
    { T, T, T,	tySegMmWord,		tyAddrArg, 2,	tyCountOne, 1	},
    { F, T, T,	tySegListMmByte,	tyAddrArg, 1,	tyCountMem, 2	}
};

static const ScLine	sclGetpeername		=
{
    "getpeername", true, tyArgMem, 1, "DPP", tySmashDef, tyDsNone, tyScrInt,
    amsGetpeername, WhCount(amsGetpeername), 0, 0
};



static const ScLine	sclGetpgid		=
{
    "getpgid", true, tyArgReg, 0, "D", tySmashZero, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetpgrp		=
{
    "getpgrp", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetpid		=
{
    "getpid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetppid		=
{
    "getppid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetpriority		=
{
    "getpriority", true, tyArgReg, 0, "DD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsGetrlimit		[ ] =
{
    { F, T, T,	tySegRlimit,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclGetrlimit		=
{
    "getrlimit", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsGetrlimit, WhCount(amsGetrlimit), 0, 0
};



static const MsLine	amsGetrusage		[ ] =
{
    { F, T, T,	tySegRusage,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclGetrusage		=
{
    "getrusage", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsGetrusage, WhCount(amsGetrusage), 0, 0
};



static const MsLine	amsGetsockname		[ ] =
{
    { T, T, T,	tySegMmWord,		tyAddrArg, 2,	tyCountOne, 1	},
    { F, T, T,	tySegListMmByte,	tyAddrArg, 1,	tyCountMem, 2	}
};

static const ScLine	sclGetsockname		=
{
    "getsockname", true, tyArgMem, 1, "DPP", tySmashDef, tyDsNone, tyScrInt,
    amsGetsockname, WhCount(amsGetsockname), 0, 0
};



static const MsLine	amsGetsockopt		[ ] =
{
    { T, T, T,	tySegMmWord,		tyAddrArg, 4,	tyCountOne, 1	},
    { F, T, T,	tySegListMmByte,	tyAddrArg, 3,	tyCountMem, 4	}
};

static const ScLine	sclGetsockopt		=
{
    "getsockopt", true, tyArgMem, 1, "DDDPP", tySmashDef, tyDsNone, tyScrInt,
    amsGetsockopt, WhCount(amsGetsockopt), 0, 0
};



static const MsLine	amsGettimeofday		[ ] =
{
    { F, T, T,	tySegTimeval,		tyAddrArgNz, 0,	tyCountOne, 1	},
    { F, T, T,	tySegTimezone,		tyAddrArgNz, 1,	tyCountOne, 1	}
};

static const ScLine	sclGettimeofday		=
{
    "gettimeofday", true, tyArgReg, 0, "PP", tySmashPair, tyDsNone, tyScrInt,
    amsGettimeofday, WhCount(amsGettimeofday), 0, 0
};



static const ScLine	sclGetuid		=
{
    "getuid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGtty			=
{
    "gtty", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclIdle			=
{
    "idle", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



// Linux 1.3.35: code block to be inserted does come from data segment.

static const MsLine	amsInitModule		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg,   0,	tyCountOne, 1	},
    { T, F, F,	tySegListInsn,		tyAddrArg,   1,	tyCountArg, 2	},
    { T, F, F,	tySegModRoutines,	tyAddrArg,   3,	tyCountOne, 1	}
};

static const MsLine	amsInitModuleSymtab	[ ] =
{
    { T, F, F,	tySegSymbolTable,	tyAddrArgNz, 4,	tyCountMem, 4	}
};

static const ScLine	sclInitModule		=
{
    "init_module", true, tyArgReg, 0, "PPDPP", tySmashDef, tyDsNone, tyScrInt,
    amsInitModule, WhCount(amsInitModule), FetchInInitModule, 0
};



static const ScLine	sclIoctl		=
{
    "ioctl", true, tyArgReg, 0, "DRP", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInIoctl, FetchOutIoctl
};



static const ScLine	sclIoperm		=
{
    "ioperm", true, tyArgReg, 0, "XDD", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclIopl			=
{
    "iopl", true, tyArgReg, 0, "D", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclKill			=
{
    "kill", true, tyArgReg, 0, "DD", tySmashPair, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsLink			[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { T, F, F,	tySegStrNul,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclLink			=
{
    "link", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsLink, WhCount(amsLink), 0, 0
};



static const ScLine	sclListen		=
{
    "listen", true, tyArgMem, 1, "DD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsLlseek		[ ] =
{
    { F, T, T,	tySegMmLoff,		tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclLlseek		=
{
    "llseek", true, tyArgReg, 0, "DXXPD", tySmashDef, tyDsNone, tyScrInt,
    amsLlseek, WhCount(amsLlseek), 0, 0
};



static const ScLine	sclLock			=
{
    "lock", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclLseek		=
{
    "lseek", true, tyArgReg, 0, "DXD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsLstat		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { F, T, T,	tySegNewStat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclLstat		=
{
    "lstat", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsLstat, WhCount(amsLstat), 0, 0
};



static const MsLine	amsMkdir		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclMkdir		=
{
    "mkdir", true, tyArgReg, 0, "PO", tySmashDef, tyDsNone, tyScrInt,
    amsMkdir, WhCount(amsMkdir), 0, 0
};



static const MsLine	amsMknod		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclMknod		=
{
    "mknod", true, tyArgReg, 0, "POX", tySmashDef, tyDsNone, tyScrInt,
    amsMknod, WhCount(amsMknod), 0, 0
};



static const ScLine	sclMmap			=
{
    "mmap", true, tyArgMem, 0, "PDDDDD", tySmashMmap, tyDsNone, tyScrAddr,
    0, 0, 0, FetchOutMmap
};



static const MsLine	amsModifyLdt		[ ] =
{
    { T, F, F,	tySegModifyLdtLdtS,	tyAddrArg,   1,	tyCountArg, 2	},
    { F, T, F,	tySegModifyLdtLdtS,	tyAddrArgNz, 1,	tyCountRet, 1	}
};

static const ScLine	sclModifyLdt		=
{
    "modify_ldt", true, tyArgReg, 0, "DP", tySmashCant, tyDsNone, tyScrInt,
    0, 0, FetchInModifyLdt, FetchOutModifyLdt
};



static const MsLine	amsMount		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArgNz, 0,	tyCountOne, 1  },
    { T, F, F,	tySegStrNul,		tyAddrArg,   1,	tyCountOne, 1  },
    { T, F, F,	tySegStrNul,		tyAddrArgNz, 2,	tyCountOne, 1  }
};

static const ScLine	sclMount		=
{
    "mount", true, tyArgReg, 0, "PPPXP", tySmashDef, tyDsNone, tyScrInt,
    amsMount, WhCount(amsMount), FetchInMount, 0
};



static const ScLine	sclMprotect		=
{
    "mprotect", true, tyArgReg, 0, "PDD", tySmashReplay, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclMpx			=
{
    "mpx", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsMsgctlMsqidDs	[ ] =
{
    { T, T, T,	tySegMsqidDs,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const MsLine	amsMsgctlMsginfo	[ ] =
{
    { T, T, T,	tySegMsginfo,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const ScLine	sclMsgctl		=
{
    "msgctl", true, tyArgReg, 0, "-DD-P", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInMsgctl, FetchOutMsgctl
};



static const ScLine	sclMsgget		=
{
    "msgget", true, tyArgReg, 0, "-XD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsMsgrcv0		[ ] =
{
    { T, F, F,	tySegIpcKludge,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const ScLine	sclMsgrcv0		=
{
    "msgrcv-0", true, tyArgReg, 0, "-DDDP", tySmashDef, tyDsNone, tyScrInt,
    amsMsgrcv0, WhCount(amsMsgrcv0), 0, FetchOutMsgrcv0
};



static const ScLine	sclMsgrcv1		=
{
    "msgrcv-1", true, tyArgReg, 0, "-DDDPD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutMsgrcv1
};



static const ScLine	sclMsgsnd		=
{
    "msgsnd", true, tyArgReg, 0, "-DDDP", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInMsgsnd, 0
};



// Linux 1.3.35: I don't grok this.  Hope this works.

static const ScLine	sclMsync		=
{
    "msync", true, tyArgReg, 0, "PDX", tySmashReplay, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclMunmap		=
{
    "munmap", true, tyArgReg, 0, "PD", tySmashReplay, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutMunmap
};



static const MsLine	amsNewselect		[ ] =
{
    { T, T, T,	tySegAny,		tyAddrArgNz, 1,	tyCountSel, 0	},
    { T, T, T,	tySegAny,		tyAddrArgNz, 2,	tyCountSel, 0   },
    { T, T, T,	tySegAny,		tyAddrArgNz, 3,	tyCountSel, 0	},
    { T, T, T,	tySegTimeval,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const ScLine	sclNewselect		=
{
    "newselect", true, tyArgReg, 0, "DPPPP", tySmashDef, tyDsNone, tyScrInt,
    amsNewselect, WhCount(amsNewselect), 0, 0
};



static const ScLine	sclNice			=
{
    "nice", true, tyArgReg, 0, "D", tySmashZero, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsOldfstat		[ ] =
{
    { F, T, T,	tySegOldStat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclOldfstat		=
{
    "oldfstat", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsOldfstat, WhCount(amsOldfstat), 0, 0
};



static const MsLine	amsOldlstat		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { F, T, T,	tySegOldStat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclOldlstat		=
{
    "oldlstat", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsOldlstat, WhCount(amsOldlstat), 0, 0
};



static const MsLine	amsOldolduname		[ ] =
{
    { F, T, T,	tySegOldoldUtsname,	tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclOldolduname		=
{
    "oldolduname", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsOldolduname, WhCount(amsOldolduname), 0, 0
};



static const MsLine	amsOldstat		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { F, T, T,	tySegOldStat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclOldstat		=
{
    "oldstat", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsOldstat, WhCount(amsOldstat), 0, 0
};



static const MsLine	amsOlduname		[ ] =
{
    { F, T, T,	tySegOldUtsname,	tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclOlduname		=
{
    "olduname", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsOlduname, WhCount(amsOlduname), 0, 0
};



static const MsLine	amsOpen			[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclOpen			=
{
    "open", true, tyArgReg, 0, "POO", tySmashDef, tyDsNone, tyScrInt,
    amsOpen, WhCount(amsOpen), 0, 0
};



static const ScLine	sclPause		=
{
    "pause", true, tyArgNone, 0, "", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclPersonality		=
{
    "personality", true, tyArgReg, 0, "D", tySmashReplay, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclPhys			=
{
    "phys", true, tyArgReg, 0, "DPDP", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsPipe			[ ] =
{
    { F, T, T,	tySegMmWord2,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclPipe			=
{
    "pipe", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsPipe, WhCount(amsPipe), 0, 0
};



static const ScLine	sclProf			=
{
    "prof", true, tyArgNone, 0, "", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



// Linux 1.3.35: not implemented in kernel.

static const ScLine	sclProfil		=
{
    "profil", true, tyArgReg, 0, "PDPX", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsPtraceWord		[ ] =
{
    { F, T, T,	tySegMmWord,		tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclPtrace		=
{
    "ptrace", true, tyArgReg, 0, "DDPP", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutPtrace
};



// Linux 1.3.35: not implemented in kernel.

static const ScLine	sclQuotactl		=
{
    "quotactl", false, tyArgNone, 0, "", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsRead			[ ] =
{
    { F, T, F,	tySegStrCount,		tyAddrArg, 1,	tyCountRet, 1	},
    { F, F, T,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclRead			=
{
    "read", true, tyArgReg, 0, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsRead, WhCount(amsRead), 0, 0
};



static const ScLine	sclReaddir		=
{
    "readdir", true, tyArgReg, 0, "DPD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutReaddir
};



static const MsLine	amsReadlink		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { F, T, F,	tySegStrCount,		tyAddrArg, 1,	tyCountRet, 1	},
    { F, F, T,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclReadlink		=
{
    "readlink", true, tyArgReg, 0, "PPD", tySmashDef, tyDsNone, tyScrInt,
    amsReadlink, WhCount(amsReadlink), 0, 0
};



static const MsLine	amsReadv		[ ] =
{
    { T, F, F,	tySegListIovec,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclReadv		=
{
    "readv", true, tyArgReg, 0, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsReadv, WhCount(amsReadv), 0, FetchOutReadv
};



static const ScLine	sclReboot		=
{
    "reboot", true, tyArgReg, 0, "XDX", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsRecv			[ ] =
{
    { F, T, F,	tySegStrCount,		tyAddrArg, 1,	tyCountRet, 1	},
    { F, F, T,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclRecv			=
{
    "recv", true, tyArgMem, 1, "DPDD", tySmashDef, tyDsNone, tyScrInt,
    amsRecv, WhCount(amsRecv), 0, 0
};



static const MsLine	amsRecvfromData		[ ] =
{
    { F, T, F,	tySegStrCount,		tyAddrArg, 1,	tyCountRet, 1	},
    { F, F, T,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const MsLine	amsRecvfromAddr		[ ] =
{
    { T, T, T,	tySegMmWord,		tyAddrArg, 5,	tyCountOne, 1	},
    { F, T, T,	tySegListMmByte,	tyAddrArg, 4,	tyCountMem, 5	}
};

static const ScLine	sclRecvfrom		=
{
    "recvfrom", true, tyArgMem, 1, "DPDDPP", tySmashDef, tyDsNone, tyScrInt,
    amsRecvfromData, WhCount(amsRecvfromData), 0, FetchOutRecvfrom
};



static const MsLine	amsRecvmsg		[ ] =
{
    { T, T, T,	tySegMsghdr,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclRecvmsg		=
{
    "recvmsg", true, tyArgMem, 1, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsRecvmsg, WhCount(amsRecvmsg), FetchInRecvmsg, FetchOutRecvmsg
};



static const MsLine	amsRename		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { T, F, F,	tySegStrNul,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclRename		=
{
    "rename", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsRename, WhCount(amsRename), 0, 0
};



static const MsLine	amsRmdir		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclRmdir		=
{
    "rmdir", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsRmdir, WhCount(amsRmdir), 0, 0
};



static const MsLine	amsSelect		[ ] =
{
    { T, T, T,	tySegAny,		tyAddrArgNz, 1,	tyCountSel, 0	},
    { T, T, T,	tySegAny,		tyAddrArgNz, 2,	tyCountSel, 0   },
    { T, T, T,	tySegAny,		tyAddrArgNz, 3,	tyCountSel, 0	},
    { T, T, T,	tySegTimeval,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const ScLine	sclSelect		=
{
    "select", true, tyArgMem, 0, "DPPPP", tySmashDef, tyDsNone, tyScrInt,
    amsSelect, WhCount(amsSelect), 0, 0
};



static const MsLine	amsSemctl		[ ] =
{
    { T, F, F,	tySegSemun,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const ScLine	sclSemctl		=
{
    "semctl", true, tyArgReg, 0, "-DDDP", tySmashDef, tyDsNone, tyScrInt,
    amsSemctl, WhCount(amsSemctl), FetchInSemctl, FetchOutSemctl
};



static const ScLine	sclSemget		=
{
    "semget", true, tyArgReg, 0, "-XDO", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSemop		[ ] =
{
    { T, F, F,	tySegListSembuf,	tyAddrArgNz, 0,	tyCountArg, 2	}
};

static const ScLine	sclSemop		=
{
    "semop", true, tyArgReg, 0, "-DD-P", tySmashDef, tyDsNone, tyScrInt,
    amsSemop, WhCount(amsSemop), 0, 0
};



static const MsLine	amsSend			[ ] =
{
    { T, F, F,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclSend			=
{
    "send", true, tyArgMem, 1, "DPDD", tySmashDef, tyDsNone, tyScrInt,
    amsSend, WhCount(amsSend), 0, 0
};



static const MsLine	amsSendmsg		[ ] =
{
    { T, F, F,	tySegMsghdr,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSendmsg		=
{
    "sendmsg", true, tyArgMem, 1, "DPD", tySmashDef, tyDsNone, tyScrInt,
    amsSendmsg, WhCount(amsSendmsg), FetchInSendmsg, 0
};



static const MsLine	amsSendto		[ ] =
{
    { T, F, F,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	},
    { T, F, F,	tySegListMmByte,	tyAddrArg, 4,	tyCountArg, 5	}
};

static const ScLine	sclSendto		=
{
    "sendto", true, tyArgMem, 1, "DPDDPD", tySmashDef, tyDsNone, tyScrInt,
    amsSendto, WhCount(amsSendto), 0, 0
};



static const MsLine	amsSetdomainname	[ ] =
{
    { T, F, F,	tySegStrCount,		tyAddrArg, 0,	tyCountArg, 1	}
};

static const ScLine	sclSetdomainname	=
{
    "setdomainname", true, tyArgReg, 0, "PD", tySmashDef, tyDsNone, tyScrInt,
    amsSetdomainname, WhCount(amsSetdomainname), 0, 0
};



static const ScLine	sclSetfsgid		=
{
    "setfsgid", true, tyArgReg, 0, "D", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetfsuid		=
{
    "setfsuid", true, tyArgReg, 0, "D", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetgid		=
{
    "setgid", true, tyArgReg, 0, "D", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSetgroups		[ ] =
{
    { T, F, F,	tySegListGidT,		tyAddrArg, 1,	tyCountArg, 0	}
};

static const ScLine	sclSetgroups		=
{
    "setgroups", true, tyArgReg, 0, "DP", tySmashMpi0, tyDsNone, tyScrInt,
    amsSetgroups, WhCount(amsSetgroups), 0, 0
};



static const MsLine	amsSethostname		[ ] =
{
    { T, F, F,	tySegStrCount,		tyAddrArgNz, 0,	tyCountArg, 1	}
};

static const ScLine	sclSethostname		=
{
    "sethostname", true, tyArgReg, 0, "PD", tySmashDef, tyDsNone, tyScrInt,
    amsSethostname, WhCount(amsSethostname), 0, 0
};



static const MsLine	amsSetitimer		[ ] =
{
    { T, F, F,	tySegItimerval,		tyAddrArgNz, 1,	tyCountOne, 1	},
    { F, T, T,	tySegItimerval,		tyAddrArgNz, 2,	tyCountOne, 1	}
};

static const ScLine	sclSetitimer		=
{
    "setitimer", true, tyArgReg, 0, "DPP", tySmashDef, tyDsNone, tyScrInt,
    amsSetitimer, WhCount(amsSetitimer), 0, 0
};



static const ScLine	sclSetpgid		=
{
    "setpgid", true, tyArgReg, 0, "DD", tySmashPair, tyDsNone, tyScrInt,
    0, 0, 0, 0
};




static const ScLine	sclSetpriority		=
{
    "setpriority", true, tyArgReg, 0, "DDD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetregid		=
{
    "setregid", true, tyArgReg, 0, "DD", tySmashPair, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetreuid		=
{
    "setreuid", true, tyArgReg, 0, "DD", tySmashPair, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSetrlimit		[ ] =
{
    { T, F, F,	tySegRlimit,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSetrlimit		=
{
    "setrlimit", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrInt,
    amsSetrlimit, WhCount(amsSetrlimit), 0, 0
};



static const ScLine	sclSetsid		=
{
    "setsid", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSetsockopt		[ ] =
{
    { T, F, F,	tySegListMmByte,	tyAddrArg, 3,	tyCountArg, 4	}
};

static const ScLine	sclSetsockopt		=
{
    "setsockopt", true, tyArgMem, 1, "DDDPD", tySmashDef, tyDsNone, tyScrInt,
    amsSetsockopt, WhCount(amsSetsockopt), 0, 0
};



static const MsLine	amsSettimeofday		[ ] =
{
    { T, F, F,	tySegTimeval,		tyAddrArgNz, 0,	tyCountOne, 1	},
    { T, F, F,	tySegTimezone,		tyAddrArgNz, 1,	tyCountOne, 1	}
};

static const ScLine	sclSettimeofday		=
{
    "settimeofday", true, tyArgReg, 0, "PP", tySmashPair, tyDsNone, tyScrInt,
    amsSettimeofday, WhCount(amsSettimeofday), 0, 0
};



static const ScLine	sclSetuid		=
{
    "setuid", true, tyArgReg, 0, "D", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetup		=
{
    "setup", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSgetmask		=
{
    "sgetmask", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrHex,
    0, 0, 0, 0
};



static const MsLine	amsShmat		[ ] =
{
    { F, T, T,	tySegMmAddr,		tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclShmat		=
{
    "shmat", true, tyArgReg, 0, "-DOPP", tySmashCant, tyDsNone, tyScrInt,
    amsShmat, WhCount(amsShmat), 0, 0
};



static const MsLine	amsShmctlShmidDs	[ ] =
{
    { T, T, T,	tySegShmidDs,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const MsLine	amsShmctlShminfo	[ ] =
{
    { T, T, T,	tySegShminfo,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const MsLine	amsShmctlShmInfo	[ ] =
{
    { T, T, T,	tySegShmInfo,		tyAddrArgNz, 4,	tyCountOne, 1	}
};

static const ScLine	sclShmctl		=
{
    "shmctl", true, tyArgReg, 0, "-DD-P", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInShmctl, FetchOutShmctl
};



static const ScLine	sclShmdt		=
{
    "shmdt", true, tyArgReg, 0, "----P", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclShmget		=
{
    "shmget", true, tyArgReg, 0, "-XDO", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclShutdown		=
{
    "shutdown", true, tyArgMem, 1, "DD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSigaction		[ ] =
{
    { T, F, F,	tySegSigaction,		tyAddrArgNz, 1,	tyCountOne, 1	},
    { F, T, T,	tySegSigaction,		tyAddrArgNz, 2,	tyCountOne, 1	}
};

static const ScLine	sclSigaction		=
{
    "sigaction", true, tyArgReg, 0, "DPP", tySmashDef, tyDsNone, tyScrInt,
    amsSigaction, WhCount(amsSigaction), 0, 0
};



static const ScLine	sclSignal		=
{
    "signal", true, tyArgReg, 0, "DP", tySmashDef, tyDsNone, tyScrAddr,
    0, 0, 0, 0
};



static const MsLine	amsSigpending		[ ] =
{
    { F, T, T,	tySegSigsetT,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSigpending		=
{
    "sigpending", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsSigpending, WhCount(amsSigpending), 0, 0
};



static const MsLine	amsSigprocmask		[ ] =
{
    { T, F, F,	tySegSigsetT,		tyAddrArgNz, 1,	tyCountOne, 1	},
    { F, T, T,	tySegSigsetT,		tyAddrArgNz, 2,	tyCountOne, 1	}
};

static const ScLine	sclSigprocmask		=
{
    "sigprocmask", true, tyArgReg, 0, "DPP", tySmashDef, tyDsNone, tyScrInt,
    amsSigprocmask, WhCount(amsSigprocmask), 0, 0
};



static const ScLine	sclSigreturn		=
{
    "sigreturn", true, tyArgNone, 0, "", tySmashCant, tyDsNone, tyScrInt,
    0, 0, FetchInSigreturn, 0
};



static const ScLine	sclSigsuspend		=
{
    "sigsuspend", true, tyArgReg, 0, "DXX", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSocket		=
{
    "socket", true, tyArgMem, 1, "DDD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSocketpair		[ ] =
{
    { F, T, T,	tySegMmWord2,		tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclSocketpair		=
{
    "socketpair", true, tyArgMem, 1, "DDDP", tySmashDef, tyDsNone, tyScrInt,
    amsSocketpair, WhCount(amsSocketpair), 0, 0
};



static const ScLine	sclSsetmask		=
{
    "ssetmask", true, tyArgReg, 0, "X", tySmashNop, tyDsNone, tyScrHex,
    0, 0, 0, 0
};



static const MsLine	amsStat			[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { F, T, T,	tySegNewStat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclStat			=
{
    "stat", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsStat, WhCount(amsStat), 0, 0
};



static const MsLine	amsStatfs		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { F, T, T,	tySegStatfs,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclStatfs		=
{
    "statfs", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsStatfs, WhCount(amsStatfs), 0, 0
};



static const MsLine	amsStime		[ ] =
{
    { T, F, F,	tySegTimeT,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclStime		=
{
    "stime", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsStime, WhCount(amsStime), 0, 0
};



static const ScLine	sclStty			=
{
    "stty", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSwapoff		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSwapoff		=
{
    "swapoff", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsSwapoff, WhCount(amsSwapoff), 0, 0
};



static const MsLine	amsSwapon		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSwapon		=
{
    "swapon", true, tyArgReg, 0, "PX", tySmashDef, tyDsNone, tyScrInt,
    amsSwapon, WhCount(amsSwapon), 0, 0
};



static const MsLine	amsSymlink		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	},
    { T, F, F,	tySegStrNul,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSymlink		=
{
    "symlink", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsSymlink, WhCount(amsSymlink), 0, 0
};



static const ScLine	sclSync			=
{
    "sync", true, tyArgNone, 0, "", tySmashNop, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsSysfsOne		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const MsLine	amsSysfsTwo		[ ] =
{
    { F, T, T,	tySegStrNul,		tyAddrArg, 2,	tyCountOne, 1	}
};

static const ScLine	sclSysfs		=
{
    "sysfs", true, tyArgReg, 0, "DPP", tySmashDef, tyDsNone, tyScrInt,
    0, 0, FetchInSysfs, FetchOutSysfs
};



static const MsLine	amsSysinfo		[ ] =
{
    { F, T, T,	tySegSysinfo,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSysinfo		=
{
    "sysinfo", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsSysinfo, WhCount(amsSysinfo), 0, 0
};



static const MsLine	amsSyslogStr		[ ] =
{
    { F, T, F,	tySegStrCount,		tyAddrArgNz, 1,	tyCountRet, 1	},
    { F, F, T,	tySegStrCount,		tyAddrArgNz, 1,	tyCountArg, 2	}
};

static const ScLine	sclSyslog		=
{
    "syslog", true, tyArgReg, 0, "DPD", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, FetchOutSyslog
};



static const MsLine	amsTime			[ ] =
{
    { F, T, T,	tySegTimeT,		tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclTime			=
{
    "time", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsTime, WhCount(amsTime), 0, 0
};



static const MsLine	amsTimes		[ ] =
{
    { F, T, T,	tySegTms,		tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclTimes		=
{
    "times", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsTimes, WhCount(amsTimes), 0, 0
};



static const MsLine	amsTruncate		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclTruncate		=
{
    "truncate", true, tyArgReg, 0, "PD", tySmashDef, tyDsNone, tyScrInt,
    amsTruncate, WhCount(amsTruncate), 0, 0
};



// Linux 1.3.35: not implemented in kernel.

static const ScLine	sclUlimit		=
{
    "ulimit", true, tyArgNone, 0, "", tySmashDef, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclUmask		=
{
    "umask", true, tyArgReg, 0, "O", tySmashNop, tyDsNone, tyScrOct,
    0, 0, 0, 0
};



static const MsLine	amsUmount		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUmount		=
{
    "umount", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsUmount, WhCount(amsUmount), 0, 0
};



static const MsLine	amsUname		[ ] =
{
    { F, T, T,	tySegNewUtsname,	tyAddrArgNz, 0,	tyCountOne, 1	}
};

static const ScLine	sclUname		=
{
    "uname", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsUname, WhCount(amsUname), 0, 0
};



static const MsLine	amsUnlink		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUnlink		=
{
    "unlink", true, tyArgReg, 0, "P", tySmashDef, tyDsNone, tyScrInt,
    amsUnlink, WhCount(amsUnlink), 0, 0
};



static const MsLine	amsUselib		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUselib		=
{
    "uselib", true, tyArgReg, 0, "P", tySmashFile, tyDsUselib, tyScrInt,
    amsUselib, WhCount(amsUselib), 0, FetchOutUselib
};



static const MsLine	amsUstat		[ ] =
{
    { F, T, T,	tySegUstat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclUstat		=
{
    "ustat", true, tyArgReg, 0, "DP", tySmashPair, tyDsNone, tyScrInt,
    amsUstat, WhCount(amsUstat), 0, 0
};



static const MsLine	amsUtime		[ ] =
{
    { T, F, F,	tySegStrNul,		tyAddrArg,   0,	tyCountOne, 1	},
    { T, F, F,	tySegUtimbuf,		tyAddrArgNz, 1,	tyCountOne, 1	}
};

static const ScLine	sclUtime		=
{
    "utime", true, tyArgReg, 0, "PP", tySmashDef, tyDsNone, tyScrInt,
    amsUtime, WhCount(amsUtime), 0, 0
};



static const ScLine	sclVhangup		=
{
    "vhangup", true, tyArgNone, 0, "", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	amsVm86			[ ] =
{
    { T, T, T,	tySegVm86Struct,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclVm86			=
{
    "vm86", true, tyArgReg, 0, "P", tySmashCant, tyDsNone, tyScrInt,
    amsVm86, WhCount(amsVm86), 0, 0
};



static const MsLine	amsWait4		[ ] =
{
    { F, T, T,	tySegMmWord,		tyAddrArgNz, 1,	tyCountOne, 1	},
    { F, T, T,	tySegRusage,		tyAddrArgNz, 3,	tyCountOne, 1	}
};

static const ScLine	sclWait4		=
{
    "wait4", true, tyArgReg, 0, "DPDP", tySmashPair, tyDsNone, tyScrInt,
    amsWait4, WhCount(amsWait4), 0, 0
};



static const MsLine	amsWaitpid		[ ] =
{
    { F, T, T,	tySegMmWord,		tyAddrArgNz, 1,	tyCountOne, 1	}
};

static const ScLine	sclWaitpid		=
{
    "waitpid", true, tyArgReg, 0, "DPD", tySmashPair, tyDsNone, tyScrInt,
    amsWaitpid, WhCount(amsWaitpid), 0, 0
};



static const MsLine	amsWrite		[ ] =
{
    { T, F, F,	tySegStrCount,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclWrite		=
{
    "write", true, tyArgReg, 0, "DPD", tySmashWrite, tyDsNone, tyScrInt,
    amsWrite, WhCount(amsWrite), 0, 0
};



static const MsLine	amsWritev		[ ] =
{
    { T, F, F,	tySegListIovec,		tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclWritev		=
{
    "writev", true, tyArgReg, 0, "DPD", tySmashWrite, tyDsNone, tyScrInt,
    amsWritev, WhCount(amsWrite), FetchInWritev, 0
};



// System call line for unknowns.
static const ScLine	sclUnknown		=
{
    "", false, tyArgReg, 0, "XXXXX", tySmashCant, tyDsNone, tyScrInt,
    0, 0, 0, 0
};



// Init a sys call line by system call entry.
void ScLine::initFromSce( MmWord wSysEntry, MmWord wSubEntry )
{
    switch ( wSysEntry )
    {
    default:			*this = sclUnknown;		break;
    case __NR_access:		*this = sclAccess;		break;
    case __NR_acct:		*this = sclAcct;		break;
    case __NR_adjtimex:		*this = sclAdjtimex;		break;
    case __NR_afs_syscall:	*this = sclAfsSyscall;		break;
    case __NR_alarm:		*this = sclAlarm;		break;
    case __NR_bdflush:		*this = sclBdflush;		break;
    case __NR_break:		*this = sclBreak;		break;
    case __NR_brk:		*this = sclBrk;			break;
    case __NR_chdir:		*this = sclChdir;		break;
    case __NR_chmod:		*this = sclChmod;		break;
    case __NR_chown:		*this = sclChown;		break;
    case __NR_chroot:		*this = sclChroot;		break;
    case __NR_clone:		*this = sclClone;		break;
    case __NR_close:		*this = sclClose;		break;
    case __NR_creat:		*this = sclCreat;		break;
    case __NR_create_module:	*this = sclCreateModule;	break;
    case __NR_delete_module:	*this = sclDeleteModule;	break;
    case __NR_dup:		*this = sclDup;			break;
    case __NR_dup2:		*this = sclDup2;		break;
    case __NR_execve:		*this = sclExecve;		break;
    case __NR_exit:		*this = sclExit;		break;
    case __NR_fchdir:		*this = sclFchdir;		break;
    case __NR_fchmod:		*this = sclFchmod;		break;
    case __NR_fchown:		*this = sclFchown;		break;
    case __NR_fcntl:		*this = sclFcntl;		break;
    case __NR_flock:		*this = sclFlock;		break;
    case __NR_fork:		*this = sclFork;		break;
    case __NR_fstat:		*this = sclFstat;		break;
    case __NR_fstatfs:		*this = sclFstatfs;		break;
    case __NR_fsync:		*this = sclFsync;		break;
    case __NR_ftime:		*this = sclFtime;		break;
    case __NR_ftruncate:	*this = sclFtruncate;		break;
    case __NR_get_kernel_syms:	*this = sclGetKernelSyms;	break;
    case __NR_getdents:		*this = sclGetdents;		break;
    case __NR_getegid:		*this = sclGetegid;		break;
    case __NR_geteuid:		*this = sclGeteuid;		break;
    case __NR_getgid:		*this = sclGetgid;		break;
    case __NR_getgroups:	*this = sclGetgroups;		break;
    case __NR_getitimer:	*this = sclGetitimer;		break;
    case __NR_getpgid:		*this = sclGetpgid;		break;
    case __NR_getpgrp:		*this = sclGetpgrp;		break;
    case __NR_getpid:		*this = sclGetpid;		break;
    case __NR_getppid:		*this = sclGetppid;		break;
    case __NR_getpriority:	*this = sclGetpriority;		break;
    case __NR_getrlimit:	*this = sclGetrlimit;		break;
    case __NR_getrusage:	*this = sclGetrusage;		break;
    case __NR_gettimeofday:	*this = sclGettimeofday;	break;
    case __NR_getuid:		*this = sclGetuid;		break;
    case __NR_gtty:		*this = sclGtty;		break;
    case __NR_idle:		*this = sclIdle;		break;
    case __NR_init_module:	*this = sclInitModule;		break;
    case __NR_ioctl:		*this = sclIoctl;		break;
    case __NR_ioperm:		*this = sclIoperm;		break;
    case __NR_iopl:		*this = sclIopl;		break;
    case __NR_ipc:
	switch ( wSubEntry & 0xFFFF )
	{
	default:		*this = sclUnknown;		break;
	case MSGCTL:		*this = sclMsgctl;		break;
	case MSGGET:		*this = sclMsgget;		break;
	case MSGRCV:
	    switch ( wSubEntry >> 16 )
	    {
	    default:		*this = sclUnknown;		break;
	    case 0:		*this = sclMsgrcv0;		break;
	    case 1:		*this = sclMsgrcv1;		break;
	    }
	    break;
	case MSGSND:		*this = sclMsgsnd;		break;
	case SEMCTL:		*this = sclSemctl;		break;
	case SEMGET:		*this = sclSemget;		break;
	case SEMOP:		*this = sclSemop;		break;
	case SHMAT:		*this = sclShmat;		break;
	case SHMCTL:		*this = sclShmctl;		break;
	case SHMDT:		*this = sclShmdt;		break;
	case SHMGET:		*this = sclShmget;		break;
	}
	break;
    case __NR_kill:		*this = sclKill;		break;
    case __NR_link:		*this = sclLink;		break;
    case __NR__llseek:		*this = sclLlseek;		break;
    case __NR_lock:		*this = sclLock;		break;
    case __NR_lseek:		*this = sclLseek;		break;
    case __NR_lstat:		*this = sclLstat;		break;
    case __NR_mkdir:		*this = sclMkdir;		break;
    case __NR_mknod:		*this = sclMknod;		break;
    case __NR_mmap:		*this = sclMmap;		break;
    case __NR_modify_ldt:	*this = sclModifyLdt;		break;
    case __NR_mount:		*this = sclMount;		break;
    case __NR_mprotect:		*this = sclMprotect;		break;
    case __NR_mpx:		*this = sclMpx;			break;
    case __NR_msync:		*this = sclMsync;		break;
    case __NR_munmap:		*this = sclMunmap;		break;
    case __NR__newselect:	*this = sclNewselect;		break;
    case __NR_nice:		*this = sclNice;		break;
    case __NR_oldfstat:		*this = sclOldfstat;		break;
    case __NR_oldlstat:		*this = sclOldlstat;		break;
    case __NR_oldolduname:	*this = sclOldolduname;		break;
    case __NR_oldstat:		*this = sclOldstat;		break;
    case __NR_olduname:		*this = sclOlduname;		break;
    case __NR_open:		*this = sclOpen;		break;
    case __NR_pause:		*this = sclPause;		break;
    case __NR_personality:	*this = sclPersonality;		break;
    case __NR_phys:		*this = sclPhys;		break;
    case __NR_pipe:		*this = sclPipe;		break;
    case __NR_prof:		*this = sclProf;		break;
    case __NR_profil:		*this = sclProfil;		break;
    case __NR_ptrace:		*this = sclPtrace;		break;
    case __NR_quotactl:		*this = sclQuotactl;		break;
    case __NR_read:		*this = sclRead;		break;
    case __NR_readdir:		*this = sclReaddir;		break;
    case __NR_readlink:		*this = sclReadlink;		break;
    case __NR_readv:		*this = sclReadv;		break;
    case __NR_reboot:		*this = sclReboot;		break;
    case __NR_rename:		*this = sclRename;		break;
    case __NR_rmdir:		*this = sclRmdir;		break;
    case __NR_select:		*this = sclSelect;		break;
    case __NR_setdomainname:	*this = sclSetdomainname;	break;
    case __NR_setfsgid:		*this = sclSetfsgid;		break;
    case __NR_setfsuid:		*this = sclSetfsuid;		break;
    case __NR_setgid:		*this = sclSetgid;		break;
    case __NR_setgroups:	*this = sclSetgroups;		break;
    case __NR_sethostname:	*this = sclSethostname;		break;
    case __NR_setitimer:	*this = sclSetitimer;		break;
    case __NR_setpgid:		*this = sclSetpgid;		break;
    case __NR_setpriority:	*this = sclSetpriority;		break;
    case __NR_setregid:		*this = sclSetregid;		break;
    case __NR_setreuid:		*this = sclSetreuid;		break;
    case __NR_setrlimit:	*this = sclSetrlimit;		break;
    case __NR_setsid:		*this = sclSetsid;		break;
    case __NR_settimeofday:	*this = sclSettimeofday;	break;
    case __NR_setuid:		*this = sclSetuid;		break;
    case __NR_setup:		*this = sclSetup;		break;
    case __NR_sgetmask:		*this = sclSgetmask;		break;
    case __NR_sigaction:	*this = sclSigaction;		break;
    case __NR_signal:		*this = sclSignal;		break;
    case __NR_sigpending:	*this = sclSigpending;		break;
    case __NR_sigprocmask:	*this = sclSigprocmask;		break;
    case __NR_sigreturn:	*this = sclSigreturn;		break;
    case __NR_sigsuspend:	*this = sclSigsuspend;		break;
    case __NR_socketcall:
	switch ( wSubEntry )
	{
	default:		*this = sclUnknown;		break;
	case SYS_ACCEPT:	*this = sclAccept;		break;
	case SYS_BIND:		*this = sclBind;		break;
	case SYS_CONNECT:	*this = sclConnect;		break;
	case SYS_GETPEERNAME:	*this = sclGetpeername;		break;
	case SYS_GETSOCKNAME:	*this = sclGetsockname;		break;
	case SYS_GETSOCKOPT:	*this = sclGetsockopt;		break;
	case SYS_LISTEN:	*this = sclListen;		break;
	case SYS_RECV:		*this = sclRecv;		break;
	case SYS_RECVFROM:	*this = sclRecvfrom;		break;
	case SYS_RECVMSG:	*this = sclRecvmsg;		break;
	case SYS_SEND:		*this = sclSend;		break;
	case SYS_SENDMSG:	*this = sclSendmsg;		break;
	case SYS_SENDTO:	*this = sclSendto;		break;
	case SYS_SETSOCKOPT:	*this = sclSetsockopt;		break;
	case SYS_SHUTDOWN:	*this = sclShutdown;		break;
	case SYS_SOCKET:	*this = sclSocket;		break;
	case SYS_SOCKETPAIR:	*this = sclSocketpair;		break;
	}
	break;
    case __NR_ssetmask:		*this = sclSsetmask;		break;
    case __NR_stat:		*this = sclStat;		break;
    case __NR_statfs:		*this = sclStatfs;		break;
    case __NR_stime:		*this = sclStime;		break;
    case __NR_stty:		*this = sclStty;		break;
    case __NR_swapoff:		*this = sclSwapoff;		break;
    case __NR_swapon:		*this = sclSwapon;		break;
    case __NR_symlink:		*this = sclSymlink;		break;
    case __NR_sync:		*this = sclSync;		break;
    case __NR_sysfs:		*this = sclSysfs;		break;
    case __NR_sysinfo:		*this = sclSysinfo;		break;
    case __NR_syslog:		*this = sclSyslog;		break;
    case __NR_time:		*this = sclTime;		break;
    case __NR_times:		*this = sclTimes;		break;
    case __NR_truncate:		*this = sclTruncate;		break;
    case __NR_ulimit:		*this = sclUlimit;		break;
    case __NR_umask:		*this = sclUmask;		break;
    case __NR_umount:		*this = sclUmount;		break;
    case __NR_uname:		*this = sclUname;		break;
    case __NR_unlink:		*this = sclUnlink;		break;
    case __NR_uselib:		*this = sclUselib;		break;
    case __NR_ustat:		*this = sclUstat;		break;
    case __NR_utime:		*this = sclUtime;		break;
    case __NR_vhangup:		*this = sclVhangup;		break;
    case __NR_vm86:		*this = sclVm86;		break;
    case __NR_wait4:		*this = sclWait4;		break;
    case __NR_waitpid:		*this = sclWaitpid;		break;
    case __NR_write:		*this = sclWrite;		break;
    case __NR_writev:		*this = sclWritev;		break;
    }
}



// Fetch all segments in map (helper).
static void FetchAllArea( CxFetch & cxFetch, EvBase & evTarget )
{
    for ( int iarea = 0; iarea < cxFetch.getMap( ).countArea( ); ++iarea )
    {
	const MmArea & areaFetch = cxFetch.getMap( ).getArea( iarea );
	if ( areaFetch.getTyMmSpace( ) != tyMmBlank
	&&   areaFetch.getTyMmSpace( ) != tyMmUser )
	{
	    // Fetch segment.
	    MmSeg * psegFetch = new MmSeg;
	    if ( psegFetch == 0 )
		ErMem( );
	    psegFetch->fetchProc( cxFetch.getProc( ), areaFetch.getTyMmSpace( ),
		tySegArea, areaFetch.getAddrMin( ), areaFetch.count( ) );
	    if ( !psegFetch->hasArea( ) || !psegFetch->hasData( ) )
		ErFatal( "FetchAllArea: failed fetch." );

	    // Compare against matching input segment.
	    bool fMatch = false;
	    for ( int isegIn = 0; isegIn < cxFetch.getEvSci( ).countSeg( ); ++isegIn )
	    {
#if 0
		if ( psegFetch->matchSeg( cxFetch.getEvSci( ).getSeg( isegIn ) ) )
		{
		    fMatch = true;
		    break;
		}
#endif
	    }

	    // Append if no match.
	    if ( !fMatch )
		evTarget.appSeg( psegFetch );
	    else
		delete psegFetch;
	}
    }
}



// Fetch segin's (combiner).
static void FetchInAccept( CxFetch & cxFetch, EvBase & evTarget )
{
    if ( MmAddr( cxFetch.getEvSci( ).getArg( 1 ) ) != 0 )
    {
	MsLine::fetchArraySeg( amsAccept, WhCount(amsAccept),
	    cxFetch, evTarget );
    }
}



// Fetch segin's (combiner).
static void FetchInExecve( CxFetch & cxFetch, EvBase & evTarget )
{
    // Fetch argv strings.
    const MmSeg & segInAddrArg = cxFetch.getEvSci( ).getSeg( 1 );
    if ( segInAddrArg.hasArea( ) && segInAddrArg.hasData( ) )
    {
	segInAddrArg.checkCountList ( sizeof(MmAddr) );
	segInAddrArg.checkCountMin  ( sizeof(MmAddr) );
	const MmAddr * paddrArg = (const MmAddr *) segInAddrArg.address( );
	const int naddrArg = segInAddrArg.count( ) / sizeof(MmAddr);
	for ( int iaddrArg = 0; iaddrArg < naddrArg - 1; ++iaddrArg )
	{
	    MmSeg * psegInArg = new MmSeg;
	    if ( psegInArg == 0 )
		ErMem( );
	    psegInArg->fetchProc( cxFetch.getProc( ), tyMmData, tySegStrNul,
		paddrArg[iaddrArg], 1 );
	    evTarget.appSeg( psegInArg );
	}
    }

    // Fetch envp strings.
    const MmSeg & segInAddrEnv = cxFetch.getEvSci( ).getSeg( 2 );
    if ( segInAddrEnv.hasArea( ) && segInAddrEnv.hasData( ) )
    {
	segInAddrEnv.checkCountList ( sizeof(MmAddr) );
	segInAddrEnv.checkCountMin  ( sizeof(MmAddr) );
	const MmAddr * paddrEnv = (const MmAddr *) segInAddrEnv.address( );
	const int naddrEnv = segInAddrEnv.count( ) / sizeof(MmAddr);
	for ( int iaddrEnv = 0; iaddrEnv < naddrEnv - 1; ++iaddrEnv )
	{
	    MmSeg * psegInEnv = new MmSeg;
	    if ( psegInEnv == 0 )
		ErMem( );
	    psegInEnv->fetchProc( cxFetch.getProc( ), tyMmData, tySegStrNul,
		paddrEnv[iaddrEnv], 1 );
	    evTarget.appSeg( psegInEnv );
	}
    }
}



// Fetch segin's (combiner).
static void FetchInFcntl( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 1 ) )
    {
    default:
	evTarget.setModelFail( WhString( "fcntl: unknown mode" ) );
	break;

    case F_DUPFD:
    case F_GETFD:
    case F_GETFL:
    case F_GETOWN:
    case F_SETFD:
    case F_SETFL:
    case F_SETOWN:
	break;

    case F_GETLK:
    case F_SETLK:
    case F_SETLKW:
	MsLine::fetchArraySeg( amsFcntlFlock, WhCount(amsFcntlFlock),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segin's (combiner).
static void FetchInInitModule( CxFetch & cxFetch, EvBase & evTarget )
{
    // Linux 1.3.35: kernel has special address check.
    const MmAddr addrSymtab = MmAddr( cxFetch.getEvSci( ).getArg( 4 ) );
    if ( addrSymtab != 0 && addrSymtab <= MmAddr( 0xB0000000 ) )
    {
	MsLine::fetchArraySeg(
	    amsInitModuleSymtab, WhCount(amsInitModuleSymtab),
	    cxFetch, evTarget );
    }
}



// Fetch segin's (combiner).
static void FetchInIoctl( CxFetch & cxFetch, EvBase & evTarget )
{
    // Get values from ingoing.
    const MmWord wRequest = cxFetch.getEvSci( ).getArg( 1 );
    const MmAddr addrIn   = MmAddr( cxFetch.getEvSci( ).getArg( 2 ) );

    if ( wRequest == TIOCLINUX )
    {
	// Fetch the distinguishing byte.
	//   Linux 1.3.35: see 'tty_ioctl' in 'drivers/char/tty_io.c'.
	{
	    MmSeg * psegInRequestSub = new MmSeg;
	    if ( psegInRequestSub == 0 )
		ErMem( );
	    psegInRequestSub->fetchProc( cxFetch.getProc( ), tyMmData,
		tySegMmByte, addrIn, 1 );
	    evTarget.appSeg( psegInRequestSub );
	}

	// Get matching RI lines.
	WhList <const RiLine *> lpri;
	const MmSeg & segInRequestSub = evTarget.getSeg( 0 );
	if ( segInRequestSub.hasArea( ) && segInRequestSub.hasData( ) )
	{
	    segInRequestSub.checkCountOne( sizeof(MmByte) );
	    const MmByte bRequestSub =
		* (const MmByte *) segInRequestSub.address( );
	    RiLineGetTlx( bRequestSub, lpri );
	}

	if ( lpri.count( ) == 0 )
	    evTarget.setModelFail( WhString( "ioctl: unknown request" ) );

	// Fetch all matching segments.
	for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	{
	    // Grab the RI line.
	    const RiLine * pri = lpri[ipri];
	    if ( pri == 0 )
		ErPtr( );

	    if ( pri->itySegIn != tySegNil )
	    {
		// Fetch the segment.
		MmSeg * psegIn = new MmSeg;
		if ( psegIn == 0 )
		    ErMem( );
		psegIn->fetchProc( cxFetch.getProc( ), tyMmData,
		    pri->itySegIn, addrIn, 1 );
		evTarget.appSeg( psegIn );
	    }
	}
    }
    else if ( wRequest >= SIOCDEVPRIVATE && wRequest <= SIOCDEVPRIVATE+15 )
    {
	FetchAllArea( cxFetch, evTarget );
    }
    else if ( wRequest >= SIOCPROTOPRIVATE && wRequest <= SIOCPROTOPRIVATE+15 )
    {
	FetchAllArea( cxFetch, evTarget );
    }
    else
    {
	// Get matching RI lines.
	WhList <const RiLine *> lpri;
	RiLineGet( wRequest, lpri );

	if ( lpri.count( ) == 0 )
	    evTarget.setModelFail( WhString( "ioctl: unknown request" ) );

	// Fetch all matching segments.
	for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	{
	    // Grab the RI line.
	    const RiLine * pri = lpri[ipri];
	    if ( pri == 0 )
		ErPtr( );

	    if ( pri->itySegIn != tySegNil )
	    {
		// Fetch the segment.
		MmSeg * psegIn = new MmSeg;
		if ( psegIn == 0 )
		    ErMem( );
		psegIn->fetchProc( cxFetch.getProc( ), tyMmData,
		    pri->itySegIn, addrIn, 1 );
		evTarget.appSeg( psegIn );
	    }
	}

	// Fetch any special segment.
	switch ( wRequest )
	{
	default:
	    break;

#if 0
	case EQL_ENSLAVE:
	case EQL_EMANCIPATE:
	    {
		MmSeg * psegInSlavingRequest = new MmSeg;
		if ( psegInSlavingRequest == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegInSlavingRequest->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegSlavingRequest,
			MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegInSlavingRequest );
	    }
	    break;

	case EQL_GETSLAVECFG:
	case EQL_SETSLAVECFG:
	    {
		MmSeg * psegInSlaveConfig = new MmSeg;
		if ( psegInSlaveConfig == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegInSlaveConfig->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegSlaveConfig,
			MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegInSlaveConfig );
	    }
	    break;

	case EQL_SETMASTRCFG:
	    {
		MmSeg * psegInMasterConfig = new MmSeg;
		if ( psegInMasterConfig == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegInMasterConfig->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegMasterConfig,
			MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegInMasterConfig );
	    }
	    break;
#endif

	case FDRAWCMD:
	    for ( MmAddr addrInFloppyRawCmd  = addrIn;
			 ;
	                 addrInFloppyRawCmd += sizeof(struct floppy_raw_cmd) )
	    {
		bool fMore = false;
		MmSeg * psegInFloppyRawCmd = new MmSeg;
		if ( psegInFloppyRawCmd == 0 )
		    ErMem( );
		psegInFloppyRawCmd->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegFloppyRawCmd, addrInFloppyRawCmd, 1 );
		MmSeg * psegInData = new MmSeg;
		if ( psegInData == 0 )
		    ErMem( );
		if ( psegInFloppyRawCmd->hasArea( )
		&&   psegInFloppyRawCmd->hasData( ) )
		{
		    const struct floppy_raw_cmd & floppy_raw_cmd =
			* (const struct floppy_raw_cmd *) psegInFloppyRawCmd->address( );
		    if ( ( floppy_raw_cmd.flags & (FD_RAW_READ|FD_RAW_WRITE ) ) != 0
		    &&   floppy_raw_cmd.length > 0 )
		    {
			psegInData->fetchProc( cxFetch.getProc( ), tyMmData,
			    tySegAny, MmAddr( floppy_raw_cmd.data ),
			    floppy_raw_cmd.length );
		    }
		    if ( ( floppy_raw_cmd.flags & FD_RAW_MORE ) != 0 )
			fMore = true;
		}
		evTarget.appSeg( psegInFloppyRawCmd );
		evTarget.appSeg( psegInData         );
		if ( !fMore )
		    break;
	    }
	    break;

	case PIO_FONTX:
	    {
		MmSeg * psegInData = new MmSeg;
		if ( psegInData == 0 )
		    ErMem( );
		const MmSeg & segInConsolefontdesc = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInConsolefontdesc.hasArea( )
		&&   segInConsolefontdesc.hasData( ) )
		{
		    segInConsolefontdesc.checkCountOne( sizeof(struct consolefontdesc) );
		    const struct consolefontdesc & consolefontdesc =
			* (const struct consolefontdesc *)
			segInConsolefontdesc.address( );
		    const int nChar = consolefontdesc.charcount;
		    if ( nChar >= 0 )
		    {
			psegInData->fetchProc( cxFetch.getProc( ), tyMmData,
			    tySegAny, MmAddr( consolefontdesc.chardata ),
			    nChar * sizeof(MmByte) );
		    }
		}
		evTarget.appSeg( psegInData );
	    }
	    break;

	case PIO_UNIMAP:
	    {
		MmSeg * psegInListUnipair = new MmSeg;
		if ( psegInListUnipair == 0 )
		    ErMem( );
		const MmSeg & segInUnimapdesc = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInUnimapdesc.hasArea( ) && segInUnimapdesc.hasData( ) )
		{
		    segInUnimapdesc.checkCountOne( sizeof(struct unimapdesc) );
		    const struct unimapdesc & unimapdesc =
			* (const struct unimapdesc *)
			segInUnimapdesc.address( );
		    const int nEntry = unimapdesc.entry_ct;
		    if ( nEntry >= 0 )
		    {
			psegInListUnipair->fetchProc( cxFetch.getProc( ),
			    tyMmData, tySegListUnipair,
			    MmAddr( unimapdesc.entries ), nEntry );
		    }
		}
		evTarget.appSeg( psegInListUnipair );
	    }
	    break;

	case PPPIOCSCOMPRESS:
	    {
		MmSeg * psegInData = new MmSeg;
		if ( psegInData == 0 )
		    ErMem( );
		const MmSeg & segInPppOptionData = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInPppOptionData.hasArea( )
		&&   segInPppOptionData.hasData( ) )
		{
		    segInPppOptionData.checkCountOne( sizeof(struct ppp_option_data) );
		    const struct ppp_option_data & ppp_option_data =
			* (const struct ppp_option_data *)
			segInPppOptionData.address( );
		    unsigned int nbData = ppp_option_data.length;
		    if ( nbData > CCP_MAX_OPTION_LENGTH )
			nbData = CCP_MAX_OPTION_LENGTH;
		    {
			psegInData->fetchProc( cxFetch.getProc( ), tyMmData,
			    tySegListMmByte, MmAddr( ppp_option_data.ptr ),
			    nbData );
		    }
		}
		evTarget.appSeg( psegInData );
	    }
	    break;

	case SIOCADDRT:
	case SIOCDELRT:
	    // Linux 1.3.24: args are variable and some are indirect.
	    {
#if 1
		FetchAllArea( cxFetch, evTarget );
#else
		MmSeg * psegInName = new MmSeg;
		if ( psegInName == 0 )
		    ErMem( );
		const MmSeg & segInRtentry = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInRtentry.hasArea( ) && segInRtentry.hasData( ) )
		{
		    segInRtentry.checkCountOne( sizeof(struct rtentry) );
		    const struct rtentry & rtentry = * (const struct rtentry *)
			segInRtentry.address( );
		    psegInName->fetchProc( cxFetch.getProc( ), tyMmData,
			tySegStrNul, MmAddr( rtentry.rt_dev ), 1 );
		}
		evTarget.appSeg( psegInName );
#endif
	    }
	    break;

	case SIOCSIFHWADDR:
	    // Linux 1.3.35: args are variable.
#if 1
	    FetchAllArea( cxFetch, evTarget );
#endif
	    break;
	}
    }
}



// Fetch segin's (combiner).
static void FetchInModifyLdt( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 0 ) )
    {
    default:
	evTarget.setModelFail( WhString( "modify_ldt: unknown mode" ) );
	break;

    case 0:
	break;

    case 1:
	MsLine::fetchArraySeg( amsModifyLdt, WhCount(amsModifyLdt),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segin's (combiner).
static void FetchInMount( CxFetch & cxFetch, EvBase & evTarget )
{
    MmSeg * psegInData = new MmSeg;
    if ( psegInData == 0 )
	ErMem( );
    const MmAddr addrInData = MmAddr( cxFetch.getEvSci( ).getArg( 4 ) );
    if ( addrInData != 0 )
    {
	// Linux 1.3.35: size is unspecified but up to one page.
	int nData;
	for ( nData = 0; nData < 4096; nData += sizeof(MmWord) )
	{
	    MmWord wData;
	    if ( !cxFetch.getProc( ).fetchWord( tyMmData, addrInData + nData, wData ) )
		break;
	}

	// Fetch the segment.
	psegInData->fetchProc( cxFetch.getProc( ), tyMmData,
	    tySegAny, addrInData, nData );
	if ( !psegInData->hasArea( ) || !psegInData->hasData( ) )
	    ErFatal( "FetchInMount: failed fetch." );
    }
    evTarget.appSeg( psegInData );
}



// Fetch segin's (combiner).
static void FetchInMsgctl( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 2 ) )
    {
    default:
	evTarget.setModelFail( WhString( "msgctl: unknown mode" ) );
	break;

    case IPC_INFO:
    case IPC_RMID:
    case IPC_STAT:
    case MSG_INFO:
    case MSG_STAT:
	break;

    case IPC_SET:
	MsLine::fetchArraySeg( amsMsgctlMsqidDs, WhCount(amsMsgctlMsqidDs),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segin's (combiner).
static void FetchInMsgsnd( CxFetch & cxFetch, EvBase & evTarget )
{
    MmSeg * psegInMsgbuf = new MmSeg;
    if ( psegInMsgbuf == 0 )
	ErMem( );
    const int sMsg = int( cxFetch.getEvSci( ).getArg( 2 ) );
    if ( sMsg >= 0 )
    {
	struct msgbuf msgbufForSize;
	psegInMsgbuf->fetchProc( cxFetch.getProc( ), tyMmData, tySegMsgbuf,
	    MmAddr( cxFetch.getEvSci( ).getArg( 4 ) ),
	    MmAddr( &msgbufForSize.mtext[sMsg] ) - MmAddr( &msgbufForSize ) );
    }
    evTarget.appSeg( psegInMsgbuf );
}



// Fetch segin's (combiner).
static void FetchInRecvmsg( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInMsghdr = cxFetch.getEvSci( ).getSeg( 0 );
    if ( segInMsghdr.hasArea( ) && segInMsghdr.hasData( ) )
    {
	segInMsghdr.checkCountOne( sizeof(struct msghdr) );
	const struct msghdr & msghdr = * (const struct msghdr *)
	    segInMsghdr.address( );

	// Fetch socket name.
	{
	    MmSeg * psegInName = new MmSeg;
	    if ( psegInName == 0 )
		ErMem( );
	    if ( MmAddr( msghdr.msg_name ) != 0 && msghdr.msg_namelen >= 0 )
	    {
		psegInName->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegListMmByte, MmAddr( msghdr.msg_name ),
		    msghdr.msg_namelen );
	    }
	    evTarget.appSeg( psegInName );
	}

	// Fetch iovec list.
	{
	    MmSeg * psegInListIovec = new MmSeg;
	    if ( psegInListIovec == 0 )
		ErMem( );
	    if ( msghdr.msg_iovlen >= 0 )
	    {
		psegInListIovec->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegListIovec, MmAddr( msghdr.msg_iov ),
		    msghdr.msg_iovlen );
	    }
	    evTarget.appSeg( psegInListIovec );
	}

	// Fetch accrights.
	{
	    MmSeg * psegInAccrights = new MmSeg;
	    if ( psegInAccrights == 0 )
		ErMem( );
	    if ( MmAddr( msghdr.msg_accrights ) != 0
	    &&   msghdr.msg_accrightslen >= 0 )
	    {
		psegInAccrights->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, MmAddr( msghdr.msg_accrights ),
		    msghdr.msg_accrightslen );
	    }
	    evTarget.appSeg( psegInAccrights );
	}
    }
}



// Fetch segin's (combiner).
static void FetchInSemctl( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInSemun = cxFetch.getEvSci( ).getSeg( 0 );

    switch ( cxFetch.getEvSci( ).getArg( 3 ) )
    {
    default:
	evTarget.setModelFail( WhString( "semctl: unknown mode" ) );
	break;

    case GETALL:
    case GETNCNT:
    case GETPID:
    case GETVAL:
    case GETZCNT:
    case IPC_RMID:
    case IPC_INFO:
    case IPC_STAT:
    case SEM_INFO:
    case SEM_STAT:
    case SETVAL:
	break;

    case IPC_SET:
	{
	    MmSeg * psegInSemidDs = new MmSeg;
	    if ( psegInSemidDs == 0 )
		ErMem( );
	    if ( segInSemun.hasArea( ) && segInSemun.hasData( ) )
	    {
		const union semun & semun =
		    * (const union semun *) segInSemun.address( );
		psegInSemidDs->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegSemidDs, MmAddr( semun.buf ), 1 );
	    }
	    evTarget.appSeg( psegInSemidDs );
	}
	break;

    case SETALL:
	{
	    MmSeg * psegInListMmShort = new MmSeg;
	    if ( psegInListMmShort == 0 )
		ErMem( );
	    if ( segInSemun.hasArea( ) && segInSemun.hasData( ) )
	    {
		const union semun & semun =
		    * (const union semun *) segInSemun.address( );
		psegInListMmShort->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegListMmShort, MmAddr( semun.array ), SEMMSL );
	    }
	    evTarget.appSeg( psegInListMmShort );
	}
	break;
    }
}



// Fetch segin's (combiner).
static void FetchInSendmsg( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInMsghdr = cxFetch.getEvSci( ).getSeg( 0 );
    if ( segInMsghdr.hasArea( ) && segInMsghdr.hasData( ) )
    {
	segInMsghdr.checkCountOne( sizeof(struct msghdr) );
	const struct msghdr & msghdr = * (const struct msghdr *)
	    segInMsghdr.address( );

	// Fetch socket name.
	{
	    MmSeg * psegInName = new MmSeg;
	    if ( psegInName == 0 )
		ErMem( );
	    if ( MmAddr( msghdr.msg_name ) != 0 && msghdr.msg_namelen >= 0 )
	    {
		psegInName->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegListMmByte, MmAddr( msghdr.msg_name ),
		    msghdr.msg_namelen );
	    }
	    evTarget.appSeg( psegInName );
	}

	// Fetch iovec list.
	{
	    MmSeg * psegInListIovec = new MmSeg;
	    if ( psegInListIovec == 0 )
		ErMem( );
	    if ( msghdr.msg_iovlen >= 0 )
	    {
		psegInListIovec->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegListIovec, MmAddr( msghdr.msg_iov ),
		    msghdr.msg_iovlen );
	    }
	    evTarget.appSeg( psegInListIovec );
	}

	// Fetch accrights.
	{
	    MmSeg * psegInAccrights = new MmSeg;
	    if ( psegInAccrights == 0 )
		ErMem( );
	    if ( MmAddr( msghdr.msg_accrights ) != 0
	    &&   msghdr.msg_accrightslen >= 0 )
	    {
		psegInAccrights->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, MmAddr( msghdr.msg_accrights ),
		    msghdr.msg_accrightslen );
	    }
	    evTarget.appSeg( psegInAccrights );
	}

	// Fetch data.
	const MmSeg & segInListIovec = evTarget.getSeg( 2 );
	if ( segInListIovec.hasArea( ) && segInListIovec.hasData( ) )
	{
	    segInListIovec.checkCountList( sizeof(struct iovec) );
	    const struct iovec * plIovec =
		(const struct iovec *) segInListIovec.address( );
	    for ( int iIovec = 0; iIovec < msghdr.msg_iovlen; ++iIovec )
	    {
		MmSeg * psegInData = new MmSeg;
		if ( psegInData == 0 )
		    ErMem( );
		psegInData->fetchProc( cxFetch.getProc( ), tyMmData, tySegAny,
		    MmAddr( plIovec[iIovec].iov_base ),
		    plIovec[iIovec].iov_len );
		evTarget.appSeg( psegInData );
	    }
	}
    }
}



// Fetch segin's (combiner).
static void FetchInShmctl( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 2 ) )
    {
    default:
	evTarget.setModelFail( WhString( "shmctl: unknown mode" ) );
	break;

    case IPC_INFO:
    case IPC_RMID:
    case IPC_STAT:
    case SHM_INFO:
    case SHM_LOCK:
    case SHM_STAT:
    case SHM_UNLOCK:
	break;

    case IPC_SET:
	MsLine::fetchArraySeg( amsShmctlShmidDs, WhCount(amsShmctlShmidDs),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segin's (combiner).
static void FetchInSigreturn( CxFetch & cxFetch, EvBase & evTarget )
{
    MmSeg * psegInSigcontextStruct = new MmSeg;
    if ( psegInSigcontextStruct == 0 )
	ErMem( );
    psegInSigcontextStruct->fetchProc( cxFetch.getProc( ), tyMmData,
	tySegSigcontextStruct, MmAddr( cxFetch.getProc( ).fetchRegSp( ) ), 1 );
    evTarget.appSeg( psegInSigcontextStruct );
}



// Fetch segin's (combiner).
static void FetchInSysfs( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 0 ) )
    {
    default:
	evTarget.setModelFail( WhString( "sysfs: unknown mode" ) );
	break;

    case 1:
	MsLine::fetchArraySeg( amsSysfsOne, WhCount(amsSysfsOne),
	    cxFetch, evTarget );
	break;

    case 2:
    case 3:
	break;
    }
}



// Fetch segout's (combiner).
static void FetchInWritev( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInListIovec = cxFetch.getEvSci( ).getSeg( 0 );
    if ( segInListIovec.hasArea( ) && segInListIovec.hasData( ) )
    {
	segInListIovec.checkCountList( sizeof(struct iovec) );
	const struct iovec * plIovec = (const struct iovec *)
	    segInListIovec.address( );
	const int nIovec = segInListIovec.count( ) / sizeof(struct iovec);
	for ( int iIovec = 0; iIovec < nIovec; ++iIovec )
	{
	    MmSeg * psegInData = new MmSeg;
	    if ( psegInData == 0 )
		ErMem( );
	    if ( plIovec[iIovec].iov_len >= 0 )
	    {
		psegInData->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, MmAddr( plIovec[iIovec].iov_base ),
		    plIovec[iIovec].iov_len );
	    }
	    evTarget.appSeg( psegInData );
	}
    }
}



// Fetch segin's (combiner).
static void FetchOutAccept( CxFetch & cxFetch, EvBase & evTarget )
{
    if ( MmAddr( cxFetch.getEvSci( ).getArg( 1 ) ) != 0 )
    {
	MsLine::fetchArraySeg( amsAccept, WhCount(amsAccept),
	    cxFetch, evTarget );
    }
}



// Fetch segout's (combiner).
static void FetchOutBdflush( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmWord wFunc = cxFetch.getEvSci( ).getArg( 0 );
    if ( int( wFunc ) >= 2 && ( wFunc & 1 ) == 0 )
    {
	MsLine::fetchArraySeg( amsBdflush, WhCount(amsBdflush),
	    cxFetch, evTarget );
    }
}



// Fetch segout's (combiner).
static void FetchOutBrk( CxFetch & cxFetch, EvBase & evTarget )
{
    if ( !cxFetch.getEvSco( ).isScrError( ) )
    {
	const MmAddr addrBrkOld = cxFetch.getMap( ).getAddrBrk( );
	const MmAddr addrBrkNew = MmAddr(
	    cxFetch.getEvSco( ).getScrWord( 0 ) + (4096-1) & ~(4096-1) );
	if ( addrBrkOld < addrBrkNew )
	{
	    MmSeg * psegOutBrk = new MmSeg;
	    if ( psegOutBrk == 0 )
		ErMem( );
	    psegOutBrk->fetchProc( cxFetch.getProc( ), tyMmBrk,
		tySegBrk, addrBrkOld, addrBrkNew - addrBrkOld );
	    MmArea * pareaBrk = new MmArea( psegOutBrk->getArea( ) );
	    if ( pareaBrk == 0 )
		ErMem( );
	    cxFetch.getMap( ).mergeArea ( *pareaBrk  );
	    evTarget.appArea            (  pareaBrk  );
	    evTarget.appSeg             ( psegOutBrk );
	}
	else
	{
	    MmArea * pareaBlank = new MmArea( tyMmBlank, addrBrkNew, addrBrkOld );
	    if ( pareaBlank == 0 )
		ErMem( );
	    cxFetch.getMap( ).mergeArea ( *pareaBlank );
	    evTarget.appArea            (  pareaBlank );
	}
    }
}



// Fetch segout's (combiner).
static void FetchOutChdir( CxFetch & cxFetch, EvBase & )
{
    if ( !cxFetch.getEvSco( ).isScrError( ) )
	cxFetch.getDir( ).trackChdir( cxFetch.getEvSci( ).getSeg( 0 ) );
}



// Fetch segout's (combiner).
static void FetchOutChroot( CxFetch & cxFetch, EvBase & )
{
    if ( !cxFetch.getEvSco( ).isScrError( ) )
	cxFetch.getDir( ).trackChroot( cxFetch.getEvSci( ).getSeg( 0 ) );
}



// Fetch segout's (combiner).
static void FetchOutExecve( CxFetch & cxFetch, EvBase & evTarget )
{
    if ( !cxFetch.getEvSco( ).isScrError( ) )
    {
	// Look for NNO.
	const MmSeg & segInName = cxFetch.getEvSci( ).getSeg( 0 );
	if ( segInName.hasOverlap( cxFetch.getEvSci( ).getSeg( 1 ) )
	||   segInName.hasOverlap( cxFetch.getEvSci( ).getSeg( 2 ) ) )
	    evTarget.setModelFail( WhString( "execve: nasty name overlap" ) );

	// Fetch the initial stack for restoration (replay injects changes).
	const MmAddr addrSp    = MmAddr( cxFetch.getProc( ).fetchRegSp( ) );
	const MmAddr addrSpMax = cxFetch.getMap( ).getAddrStackMax( );
	if ( addrSp > addrSpMax )
	    ErFatal( "FetchOutExecve: bad stack." );
	MmSeg * psegOutStack = new MmSeg;
	if ( psegOutStack == 0 )
	    ErMem( );
	psegOutStack->fetchProc( cxFetch.getProc( ), tyMmStack,
	    tySegAny, addrSp, addrSpMax - addrSp );
	if ( !psegOutStack->hasArea( ) || !psegOutStack->hasData( ) )
	    ErFatal( "FetchOutExecve: failed fetch." );
	MmArea * pareaStack = new MmArea( psegOutStack->getArea( ) );
	if ( pareaStack == 0 )
	    ErMem( );
	cxFetch.getMap( ).mergeArea ( *pareaStack  );
	evTarget.appArea            (  pareaStack  );
	evTarget.appSeg             ( psegOutStack );
    }
}



// Fetch segout's (combiner).
static void FetchOutFchdir( CxFetch & cxFetch, EvBase & )
{
    if ( !cxFetch.getEvSco( ).isScrError( ) )
	cxFetch.getDir( ).trackFchdir( cxFetch.getEvSci( ).getArg( 0 ) );
}



// Fetch segout's (combiner).
static void FetchOutFcntl( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 1 ) )
    {
    default:
	evTarget.setModelFail( WhString( "fcntl: unknown mode" ) );
	break;

    case F_DUPFD:
    case F_GETFD:
    case F_GETFL:
    case F_GETOWN:
    case F_SETFD:
    case F_SETFL:
    case F_SETLK:
    case F_SETLKW:
    case F_SETOWN:
	break;

    case F_GETLK:
	MsLine::fetchArraySeg( amsFcntlFlock, WhCount(amsFcntlFlock),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutIoctl( CxFetch & cxFetch, EvBase & evTarget )
{
    // Get values from ingoing.
    const MmWord wRequest = cxFetch.getEvSci( ).getArg( 1 );
    const MmAddr addrIn   = MmAddr( cxFetch.getEvSci( ).getArg( 2 ) );

    if ( wRequest == TIOCLINUX )
    {
	// Get sub-request byte.
	const MmSeg & segInSub = cxFetch.getEvSci( ).getSeg( 0 );
	if ( segInSub.hasArea( ) && segInSub.hasData( ) )
	{
	    segInSub.checkCountOne( sizeof(MmByte) );
	    const MmByte bRequestSub = * (const MmByte *) segInSub.address( );

	    // Get matching RI lines.
	    WhList <const RiLine *> lpri;
	    RiLineGetTlx( bRequestSub, lpri );

	    if ( lpri.count( ) == 0 )
		evTarget.setModelFail( WhString( "ioctl: unknown request" ) );

	    // Fetch all matching segments.
	    for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	    {
		// Get the RI line.
		const RiLine * pri = lpri[ipri];
		if ( pri == 0 )
		    ErPtr( );

		if ( pri->itySegOut != tySegNil )
		{
		    // Fetch the segment.
		    MmSeg * psegOut = new MmSeg;
		    if ( psegOut == 0 )
			ErMem( );
		    psegOut->fetchProc( cxFetch.getProc( ), tyMmData,
			pri->itySegOut, addrIn, 1 );
		    evTarget.appSeg( psegOut );
		}
	    }
	}
    }
    else if ( wRequest >= SIOCDEVPRIVATE && wRequest <= SIOCDEVPRIVATE+15 )
    {
	FetchAllArea( cxFetch, evTarget );
    }
    else if ( wRequest >= SIOCPROTOPRIVATE && wRequest <= SIOCPROTOPRIVATE+15 )
    {
	FetchAllArea( cxFetch, evTarget );
    }
    else
    {
	// Get matching RI lines.
	WhList <const RiLine *> lpri;
	RiLineGet( wRequest, lpri );

	// Mark unknown ioctls as unstoreable.
	if ( lpri.count( ) == 0 )
	    evTarget.setModelFail( WhString( "ioctl: unknown request" ) );

	// Fetch all matching segments.
	for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	{
	    // Get the RI line.
	    const RiLine * pri = lpri[ipri];
	    if ( pri == 0 )
		ErPtr( );

	    if ( pri->itySegOut != tySegNil )
	    {
		// Fetch the segment.
		MmSeg * psegOut = new MmSeg;
		if ( psegOut == 0 )
		    ErMem( );
		psegOut->fetchProc( cxFetch.getProc( ), tyMmData,
		    pri->itySegOut, addrIn, 1 );
		evTarget.appSeg( psegOut );
	    }
	}

	// Fetch any special segment.
	switch ( wRequest )
	{
	default:
	    break;

	case CDROMREADAUDIO:
	    {
		MmSeg * psegOutListCdromFrame = new MmSeg;
		if ( psegOutListCdromFrame == 0 )
		    ErMem( );
		const MmSeg & segInCdromReadAudio = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInCdromReadAudio.hasArea( )
		&&   segInCdromReadAudio.hasData( ) )
		{
		    segInCdromReadAudio.checkCountOne( sizeof(struct cdrom_read_audio) );
		    const struct cdrom_read_audio & cdrom_read_audio =
			* (const struct cdrom_read_audio *)
			segInCdromReadAudio.address( );
		    if ( cdrom_read_audio.nframes >= 0 )
		    {
			psegOutListCdromFrame->fetchProc( cxFetch.getProc( ),
			    tyMmData, tySegListCdromFrame,
			    MmAddr( cdrom_read_audio.buf ),
			    cdrom_read_audio.nframes );
		    }
		}
		evTarget.appSeg( psegOutListCdromFrame );
	    }
	    break;

	case CDROMREADCOOKED:
	    {
		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, addrIn, CD_FRAMESIZE );
		evTarget.appSeg( psegOutData );
	    }
	    break;

	case CDROMREADMODE1:
	    {
		// Linux 1.3.24: size can vary by CD driver.
		const int OPT_BLOCKSIZE = 2048;
		const int sData = OPT_BLOCKSIZE > CD_FRAMESIZE
				    ? OPT_BLOCKSIZE : CD_FRAMESIZE;

		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, addrIn, sData );
		evTarget.appSeg( psegOutData );
	    }
	    break;

	case CDROMREADMODE2:
	    {
		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, addrIn, CD_FRAMESIZE_RAW0 );
		evTarget.appSeg( psegOutData );
	    }
	    break;

	case CDROMREADRAW:
	    {
		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, addrIn, CD_FRAMESIZE_RAW );
		evTarget.appSeg( psegOutData );
	    }
	    break;

#if 0
	case EQL_GETSLAVECFG:
	    {
		MmSeg * psegOutSlaveConfig = new MmSeg;
		if ( psegOutSlaveConfig == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegOutSlaveConfig->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegSlaveConfig,
			MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegOutSlaveConfig );
	    }
	    break;

	case EQL_GETMASTRCFG:
	    {
		MmSeg * psegOutMasterConfig = new MmSeg;
		if ( psegOutMasterConfig == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegOutMasterConfig->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegMasterConfig,
			MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegOutMasterConfig );
	    }
	    break;
#endif

	case FDRAWCMD:
	    {
		// Follow the input segments.
		const int nsegIn = cxFetch.getEvSci( ).countSeg( );
		for ( int isegIn = 0; isegIn < nsegIn; ++isegIn )
		{
		    const MmSeg & segIn = cxFetch.getEvSci( ).getSeg( isegIn );
		    MmSeg * psegOut = new MmSeg;
		    if ( psegOut == 0 )
			ErMem( );
		    if ( segIn.hasArea( ) )
			psegOut->fetchCopy( cxFetch.getProc( ), segIn );
		    evTarget.appSeg( psegOut );
		}
	    }
	    break;


	case GIO_FONTX:
	    {
		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		const MmSeg & segInConsolefontdesc = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInConsolefontdesc.hasArea( )
		&&   segInConsolefontdesc.hasData( ) )
		{
		    segInConsolefontdesc.checkCountOne( sizeof(struct consolefontdesc) );
		    const struct consolefontdesc & consolefontdesc =
			* (const struct consolefontdesc *)
			segInConsolefontdesc.address( );
		    const int nChar = consolefontdesc.charcount;
		    if ( MmAddr( consolefontdesc.chardata ) != 0 && nChar >= 0 )
		    {
			psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
			    tySegAny, MmAddr( consolefontdesc.chardata ),
			    nChar * sizeof(MmByte) );
		    }
		}
		evTarget.appSeg( psegOutData );
	    }
	    break;

	case GIO_UNIMAP:
	    {
		MmSeg * psegOutListUnipair = new MmSeg;
		if ( psegOutListUnipair == 0 )
		    ErMem( );
		const MmSeg & segInUnimapdesc = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInUnimapdesc.hasArea( ) && segInUnimapdesc.hasData( ) )
		{
		    segInUnimapdesc.checkCountOne( sizeof(struct unimapdesc) );
		    const struct unimapdesc & unimapdesc =
			* (const struct unimapdesc *) segInUnimapdesc.address( );
		    const int nEntry = unimapdesc.entry_ct;
		    if ( nEntry >= 0 )
		    {
			psegOutListUnipair->fetchProc( cxFetch.getProc( ),
			    tyMmData, tySegListUnipair,
			    MmAddr( unimapdesc.entries ), nEntry );
		    }
		}
		evTarget.appSeg( psegOutListUnipair );
	    }
	    break;

	case KDADDIO:
	case KDDELIO:
	case KDDISABIO:
	case KDENABIO:
	case KDMAPDISP:
	case KDUNMAPDISP:
	    // These enable and disable direct port access.
	    evTarget.setModelFail( WhString( "ioctl: direct port access" ) );
	    break;

	case RNDGETPOOL:
	    {
		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		const MmSeg & segInData = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInData.hasArea( ) && segInData.hasData( ) )
		{
		    segInData.checkCountOne( sizeof(MmWord [2]) );
		    const MmWord * pwData = (const MmWord *) segInData.address( );
		    int nData = int( pwData[1] );
		    if ( nData > 128 )
			nData = 128;
		    if ( nData >= 0 )
		    {
			psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
			    tySegListMmWord, addrIn + 2 * sizeof(MmWord),
			    nData );
		    }
		}
		evTarget.appSeg( psegOutData );
	    }
	    break;

	case SCSI_IOCTL_PROBE_HOST:
	    {
		MmSeg * psegOutData = new MmSeg;
		if ( psegOutData == 0 )
		    ErMem( );
		const MmSeg & segInLen = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInLen.hasArea( ) && segInLen.hasData( ) )
		{
		    segInLen.checkCountOne( sizeof(MmWord) );
		    const MmWord & sData = * (const MmWord *) segInLen.address( );
		    if ( int( sData ) >= 0 )
		    {
			psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
			    tySegAny, addrIn, sData );
		    }
		}
		evTarget.appSeg( psegOutData );
	    }
	    break;

	case SIOCGIFCONF:
	    {
		MmSeg * psegOutListIfreq = new MmSeg;
		if ( psegOutListIfreq == 0 )
		    ErMem( );
		const MmSeg & segInIfconf = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfconf.hasArea( ) && segInIfconf.hasData( ) )
		{
		    segInIfconf.checkCountOne( sizeof(struct ifconf) );
		    const struct ifconf & ifconf = * (const struct ifconf *)
			segInIfconf.address( );
		    if ( ifconf.ifc_len >= 0 )
		    {
			psegOutListIfreq->fetchProc( cxFetch.getProc( ),
			    tyMmData, tySegListIfreq,
			    MmAddr( ifconf.ifc_buf ), ifconf.ifc_len );
		    }
		}
		evTarget.appSeg( psegOutListIfreq );
	    }
	    break;

#if 0
	case SIOCGPPPCSTATS:
	    {
		MmSeg * psegOutPppCompStats = new MmSeg;
		if ( psegOutPppCompStats == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegOutPppCompStats->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegPppCompStats,
			MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegOutPppCompStats );
	    }
	    break;

	case SIOCGPPPSTATS:
	    {
		MmSeg * psegOutPppStats = new MmSeg;
		if ( psegOutPppStats == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegOutPppStats->fetchProc( cxFetch.getProc( ), tyMmData,
			tySegPppStats, MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegOutPppStats );
	    }
	    break;

	case SIOCGPPPVER:
	    {
		MmSeg * psegOutStr = new MmSeg;
		if ( psegOutStr == 0 )
		    ErMem( );
		const MmSeg & segInIfreq = cxFetch.getEvSci( ).getSeg( 0 );
		if ( segInIfreq.hasArea( ) && segInIfreq.hasData( ) )
		{
		    segInIfreq.checkCountOne( sizeof(struct ifreq) );
		    const struct ifreq & ifreq = * (const struct ifreq *)
			segInIfreq.address( );
		    psegOutStr->fetchProc( cxFetch.getProc( ), tyMmData,
			tySegStrNul, MmAddr( ifreq.ifr_data ), 1 );
		}
		evTarget.appSeg( psegOutStr );
	    }
	    break;
#endif

	}
    }
}



// Fetch segout's (combiner).
static void FetchOutMmap( CxFetch & cxFetch, EvBase & evTarget )
{
    // Fetch argument segment for restoration.
    {
	MmSeg * psegListArg = new MmSeg;
	if ( psegListArg == 0 )
	    ErMem( );
	psegListArg->fetchProc( cxFetch.getProc( ), tyMmData,
	    tySegListMmWord, MmAddr( cxFetch.getProc( ).fetchReg( 0 ) ), 6 );
	evTarget.appSeg( psegListArg );
    }

    // Fetch the mapped segment.
    if ( !cxFetch.getEvSco( ).isScrError( ) )
    {
	// Check storeability.
	switch ( cxFetch.getEvSci( ).getArg( 3 ) & MAP_TYPE )
	{
	default:
	    evTarget.setModelFail( WhString( "mmap: unknown mode" ) );
	    break;

	case MAP_PRIVATE:
	    break;

	case MAP_SHARED:
	    if ( ( cxFetch.getEvSci( ).getArg( 2 ) & PROT_WRITE ) != 0 )
		evTarget.setModelFail( WhString( "mmap: shared writeable" ) );
	    break;
	}

	// Get addresses.
	const MmAddr addrMin = MmAddr( cxFetch.getEvSco( ).getScrWord( 0 ) );
	const MmAddr addrMax = addrMin
	    + ( ( cxFetch.getEvSci( ).getArg( 1 ) + (4096-1) ) & ~(4096-1) );
	if ( addrMax < addrMin )
	    ErFatal( "FetchOutMmap: bad area." );

	// Fetch segment.
	{
	    MmSeg * psegOutMap = new MmSeg;
	    if ( psegOutMap == 0 )
		ErMem( );
	    psegOutMap->fetchProc( cxFetch.getProc( ), tyMmMmap,
		tySegAny, addrMin, addrMax - addrMin );
	    if ( !psegOutMap->hasArea( ) || !psegOutMap->hasData( ) )
		ErFatal( "FetchOutMmap: failed fetch." );
	    MmArea * pareaMap = new MmArea( psegOutMap->getArea( ) );
	    if ( pareaMap == 0 )
		ErMem( );
	    cxFetch.getMap( ).mergeArea ( *pareaMap  );
	    evTarget.appArea            (  pareaMap  );
	    evTarget.appSeg             ( psegOutMap );
	}
    }
}



// Fetch segout's (combiner).
static void FetchOutModifyLdt( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 0 ) )
    {
    default:
	evTarget.setModelFail( "modify_ldt: unknown mode" );
	break;

    case 0:
	MsLine::fetchArraySeg( amsModifyLdt, WhCount(amsModifyLdt),
	    cxFetch, evTarget );
	break;

    case 1:
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutMsgctl( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 2 ) )
    {
    default:
	evTarget.setModelFail( "msgctl: unknown mode" );
	break;

    case IPC_RMID:
    case IPC_SET:
	break;

    case IPC_INFO:
    case MSG_INFO:
	MsLine::fetchArraySeg( amsMsgctlMsginfo, WhCount(amsMsgctlMsginfo),
	    cxFetch, evTarget );
	break;

    case IPC_STAT:
    case MSG_STAT:
	MsLine::fetchArraySeg( amsMsgctlMsqidDs, WhCount(amsMsgctlMsqidDs),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutMsgrcv0( CxFetch & cxFetch, EvBase & evTarget )
{
    MmSeg * psegOutMsgbuf = new MmSeg;
    if ( psegOutMsgbuf == 0 )
	ErMem( );
    const MmSeg & segInIpcKludge = cxFetch.getEvSci( ).getSeg( 0 );
    if ( segInIpcKludge.hasArea( ) && segInIpcKludge.hasData( ) )
    {
	segInIpcKludge.checkCountOne( sizeof(struct ipc_kludge) );
	const struct ipc_kludge & ipc_kludge = * (const struct ipc_kludge *)
	    segInIpcKludge.address( );
	if ( !cxFetch.getEvSco( ).isScrError( ) )
	{
	    const MmAddr addrMsg = MmAddr( ipc_kludge.msgp );
	    const int    sMsg    = int( cxFetch.getEvSco( ).getScrWord( 0 ) );
	    if ( addrMsg != 0 && sMsg >= 0 )
	    {
		// Carefully fetch right size.
		struct msgbuf msgbufForSize;
		psegOutMsgbuf->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegMsgbuf, addrMsg, MmAddr( &msgbufForSize.mtext[sMsg] )
		    - MmAddr( &msgbufForSize ) );
	    }
	}
    }
    evTarget.appSeg( psegOutMsgbuf );
}



static void FetchOutMsgrcv1( CxFetch & cxFetch, EvBase & evTarget )
{
    MmSeg * psegOutMsgbuf = new MmSeg;
    if ( psegOutMsgbuf == 0 )
	ErMem( );
    if ( !cxFetch.getEvSco( ).isScrError( ) )
    {
	const MmAddr addrMsg = MmAddr( cxFetch.getEvSci( ).getArg( 4 ) );
	const int    sMsg    = int( cxFetch.getEvSco( ).getScrWord( 0 ) );
	if ( addrMsg != 0 && sMsg >= 0 )
	{
	    // Carefully fetch right size.
	    struct msgbuf msgbufForSize;
	    psegOutMsgbuf->fetchProc( cxFetch.getProc( ), tyMmData,
		tySegMsgbuf, addrMsg, MmAddr( &msgbufForSize.mtext[sMsg] )
		- MmAddr( &msgbufForSize ) );
	}
    }
    evTarget.appSeg( psegOutMsgbuf );
}



// Fetch segout's (combiner).
static void FetchOutMunmap( CxFetch & cxFetch, EvBase & evTarget )
{
    if ( !cxFetch.getEvSco( ).isScrError( ) )
    {
	const MmAddr addrMin = MmAddr( cxFetch.getEvSci( ).getArg( 0 ) );
	const MmAddr addrMax = addrMin
	    + ( ( cxFetch.getEvSci( ).getArg( 1 ) + (4096-1) ) & ~(4096-1) );
	if ( addrMax < addrMin )
	    ErFatal( "FetchOutMunmap: bad area." );
	MmArea * pareaBlank = new MmArea( tyMmBlank, addrMin, addrMax );
	cxFetch.getMap( ).mergeArea ( *pareaBlank );
	evTarget.appArea            (  pareaBlank );
    }
}



// Fetch segout's (combiner).
static void FetchOutPtrace( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 0 ) )
    {
    default:
	evTarget.setModelFail( "ptrace: unknown mode" );
	break;

    case PTRACE_ATTACH:
    case PTRACE_CONT:
    case PTRACE_DETACH:
    case PTRACE_KILL:
    case PTRACE_POKEDATA:
    case PTRACE_POKETEXT:
    case PTRACE_POKEUSR:
    case PTRACE_SINGLESTEP:
    case PTRACE_SYSCALL:
    case PTRACE_TRACEME:
	break;

    case PTRACE_PEEKDATA:
    case PTRACE_PEEKTEXT:
    case PTRACE_PEEKUSR:
	// Linux 1.3.35: third argument is ret ptr.
	MsLine::fetchArraySeg( amsPtraceWord, WhCount(amsPtraceWord),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutReaddir( CxFetch & cxFetch, EvBase & evTarget )
{
    MmSeg * psegOutDirent = new MmSeg;
    if ( psegOutDirent == 0 )
	ErMem( );

    if ( !cxFetch.getEvSco( ).isScrError( ) && cxFetch.getEvSco( ).getScrWord( 0 ) > 0 )
    {
	// For size.
	struct dirent direntForSize;

	// Fetch for size.
	MmSeg segOutDirentHead;
	segOutDirentHead.fetchProc( cxFetch.getProc( ), tyMmData,
	    tySegDirent, MmAddr( cxFetch.getEvSci( ).getArg( 1 ) ),
	      (const char *) ( &direntForSize.d_name[0] )
	    - (const char *) ( &direntForSize ) );

	// Fetch for real.
	if ( segOutDirentHead.hasArea( ) && segOutDirentHead.hasData( ) )
	{
	    const struct dirent & direntHead =
		* (const struct dirent *) segOutDirentHead.address( );
	    psegOutDirent->fetchProc( cxFetch.getProc( ), tyMmData,
		tySegDirent, MmAddr( cxFetch.getEvSci( ).getArg( 1 ) ),
		  (const char *) ( &direntForSize.d_name[direntHead.d_reclen+1] )
		- (const char *) ( &direntForSize ) );
	}
    }
    evTarget.appSeg( psegOutDirent );
}



// Fetch segout's (combiner).
static void FetchOutReadv( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInListIovec = cxFetch.getEvSci( ).getSeg( 0 );
    if ( segInListIovec.hasArea( ) && segInListIovec.hasData( ) )
    {
	segInListIovec.checkCountList( sizeof(struct iovec) );
	const struct iovec * plIovec = (const struct iovec *)
	    segInListIovec.address( );
	const int nIovec = segInListIovec.count( ) / sizeof(struct iovec);
	for ( int iIovec = 0; iIovec < nIovec; ++iIovec )
	{
	    MmSeg * psegOutData = new MmSeg;
	    if ( psegOutData == 0 )
		ErMem( );
	    if ( plIovec[iIovec].iov_len >= 0 )
	    {
		psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, MmAddr( plIovec[iIovec].iov_base ),
		    plIovec[iIovec].iov_len );
	    }
	    evTarget.appSeg( psegOutData );
	}
    }
}



// Fetch segout's (combiner).
static void FetchOutRecvfrom( CxFetch & cxFetch, EvBase & evTarget )
{
    if ( MmAddr( cxFetch.getEvSci( ).getArg( 4 ) ) != 0 )
    {
	MsLine::fetchArraySeg( amsRecvfromAddr, WhCount(amsRecvfromAddr),
	    cxFetch, evTarget );
    }
}



// Fetch segout's (combiner).
static void FetchOutRecvmsg( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInMsghdr = cxFetch.getEvSci( ).getSeg( 0 );
    if ( segInMsghdr.hasArea( ) && segInMsghdr.hasData( ) )
    {
	segInMsghdr.checkCountOne( sizeof(struct msghdr) );
	const struct msghdr msghdr = * (const struct msghdr *)
	    segInMsghdr.address( );

	// Fetch socket name.
	{
	    MmSeg * psegOutName = new MmSeg;
	    if ( psegOutName == 0 )
		ErMem( );
	    if ( MmAddr( msghdr.msg_name ) != 0 && msghdr.msg_namelen >= 0 )
	    {
		psegOutName->fetchProc( cxFetch.getProc( ),
		    tyMmData, tySegListMmByte,
		    MmAddr( msghdr.msg_name ), msghdr.msg_namelen );
	    }
	    evTarget.appSeg( psegOutName );
	}

	// Fetch iovec list.
	{
	    MmSeg * psegOutListIovec = new MmSeg;
	    if ( psegOutListIovec == 0 )
		ErMem( );
	    if ( msghdr.msg_iovlen >= 0 )
	    {
		psegOutListIovec->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegListIovec, MmAddr( msghdr.msg_iov ),
		    msghdr.msg_iovlen );
	    }
	    evTarget.appSeg( psegOutListIovec );
	}

	// Fetch accrights.
	{
	    MmSeg * psegOutAccrights = new MmSeg;
	    if ( psegOutAccrights == 0 )
		ErMem( );
	    if ( MmAddr( msghdr.msg_accrights ) != 0
	    &&   msghdr.msg_accrightslen >= 0 )
	    {
		psegOutAccrights->fetchProc( cxFetch.getProc( ), tyMmData,
		    tySegAny, MmAddr( msghdr.msg_accrights ),
		    msghdr.msg_accrightslen );
	    }
	    evTarget.appSeg( psegOutAccrights );
	}

	// Grab original iovec list.
	{
	    const MmSeg & segInListIovec = cxFetch.getEvSci( ).getSeg( 2 );
	    if ( segInListIovec.hasArea( ) && segInListIovec.hasData( ) )
	    {
		segInListIovec.checkCountList( sizeof(struct iovec) );
		const struct iovec * plIovec = (const struct iovec *)
		    segInListIovec.address( );
		const int nIovec = segInListIovec.count( ) / sizeof(struct iovec);

		// Fetch data segments.
		for ( int iIovec = 0; iIovec < nIovec; ++iIovec )
		{
		    MmSeg * psegOutData = new MmSeg;
		    if ( psegOutData == 0 )
			ErMem( );
		    psegOutData->fetchProc( cxFetch.getProc( ), tyMmData,
			tySegAny, MmAddr( plIovec[iIovec].iov_base ),
			plIovec[iIovec].iov_len );
		    evTarget.appSeg( psegOutData );
		}
	    }
	}
    }
}



// Fetch segout's (combiner).
static void FetchOutSemctl( CxFetch & cxFetch, EvBase & evTarget )
{
    const MmSeg & segInSemun = cxFetch.getEvSci( ).getSeg( 0 );

    switch ( cxFetch.getEvSci( ).getArg( 3 ) )
    {
    default:
	evTarget.setModelFail( "semctl: unknown mode" );
	break;

    case GETNCNT:
    case GETPID:
    case GETVAL:
    case GETZCNT:
    case IPC_RMID:
    case IPC_SET:
    case SETALL:
    case SETVAL:
	break;

    case GETALL:
	{
	    MmSeg * psegOutListMmShort = new MmSeg;
	    if ( psegOutListMmShort == 0 )
		ErMem( );
	    if ( segInSemun.hasArea( ) && segInSemun.hasData( ) )
	    {
		segInSemun.checkCountOne( sizeof(union semun) );
		const union semun & semun = * (const union semun *)
		    segInSemun.address( );

		if ( !cxFetch.getEvSco( ).isScrError( ) )
		{
		    psegOutListMmShort->fetchProc( cxFetch.getProc( ),
			tyMmData, tySegListMmShort,
			MmAddr( semun.array ), SEMMSL );
		}
	    }
	    evTarget.appSeg( psegOutListMmShort );
	}
	break;

    case IPC_INFO:
    case SEM_INFO:
	{
	    MmSeg * psegOutSeminfo = new MmSeg;
	    if ( psegOutSeminfo == 0 )
		ErMem( );
	    if ( segInSemun.hasArea( ) && segInSemun.hasData( ) )
	    {
		segInSemun.checkCountOne( sizeof(union semun) );
		const union semun & semun = * (const union semun *)
		    segInSemun.address( );

		if ( !cxFetch.getEvSco( ).isScrError( ) )
		{
		    psegOutSeminfo->fetchProc( cxFetch.getProc( ), tyMmData,
			tySegSeminfo, MmAddr( semun.__buf ), 1 );
		}
	    }
	    evTarget.appSeg( psegOutSeminfo );
	}
	break;

    case IPC_STAT:
    case SEM_STAT:
	{
	    MmSeg * psegOutSemidDs = new MmSeg;
	    if ( psegOutSemidDs == 0 )
		ErMem( );
	    if ( segInSemun.hasArea( ) && segInSemun.hasData( ) )
	    {
		segInSemun.checkCountOne( sizeof(union semun) );
		const union semun & semun = * (const union semun *)
		    segInSemun.address( );

		if ( !cxFetch.getEvSco( ).isScrError( ) )
		{
		    psegOutSemidDs->fetchProc( cxFetch.getProc( ), tyMmData,
			tySegSemidDs, MmAddr( semun.buf ), 1 );
		}
	    }
	    evTarget.appSeg( psegOutSemidDs );
	}
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutShmctl( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 2 ) )
    {
    default:
	evTarget.setModelFail( "shmctl: unknown mode" );
	break;

    case IPC_RMID:
    case IPC_SET:
    case SHM_LOCK:
    case SHM_UNLOCK:
	break;

    case IPC_INFO:
	MsLine::fetchArraySeg( amsShmctlShminfo, WhCount(amsShmctlShminfo),
	    cxFetch, evTarget );
	break;

    case IPC_STAT:
    case SHM_STAT:
	MsLine::fetchArraySeg( amsShmctlShmidDs, WhCount(amsShmctlShmidDs),
	    cxFetch, evTarget );
	break;

    case SHM_INFO:
	MsLine::fetchArraySeg( amsShmctlShmInfo, WhCount(amsShmctlShmInfo),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutSysfs( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 0 ) )
    {
    default:
	evTarget.setModelFail( "sysfs: unknown mode" );
	break;

    case 1:
    case 3:
	break;

    case 2:
	MsLine::fetchArraySeg( amsSysfsTwo, WhCount(amsSysfsTwo),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutSyslog( CxFetch & cxFetch, EvBase & evTarget )
{
    switch ( cxFetch.getEvSci( ).getArg( 0 ) )
    {
    default:
	evTarget.setModelFail( "syslog: unknown mode" );
	break;

    case 0:
    case 1:
    case 5:
    case 6:
    case 7:
    case 8:
	break;

    case 2:
    case 3:
    case 4:
	MsLine::fetchArraySeg( amsSyslogStr, WhCount(amsSyslogStr),
	    cxFetch, evTarget );
	break;
    }
}



// Fetch segout's (combiner).
static void FetchOutUselib( CxFetch & cxFetch, EvBase & evTarget )
{
    // Fetch restoration segment at input-name location.
    //   This works even if new library overlays it.
    if ( !cxFetch.getEvSco( ).isScrError( ) )
    {
	MmSeg * psegOutName = new MmSeg;
	if ( psegOutName == 0 )
	    ErMem( );
	const MmSeg & segInName = cxFetch.getEvSci( ).getSeg( 0 );
	if ( segInName.hasArea( ) && segInName.hasData( ) )
	{
	    segInName.checkCountList( sizeof(MmByte) );
	    psegOutName->fetchProc( cxFetch.getProc( ), tyMmData,
		tySegStrCount, segInName.getAddrFirst( ), segInName.count( ) );
	}
	evTarget.appSeg( psegOutName );
    }
}
