// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: RillMain.cc
//   Main program for mec-rill.
//
// File Created:	24 Feb 1995		Michael Chastain
// Last Edited:		19 Nov 1995		Michael Chastain

#include <stdio.h>
#include <stdlib.h>

#include <RiLine.hh>
#include <WhList.hh>



// Entry point.
int main( int argc, const char * argv[] )
{
    WhList <const RiLine *> lpri;
    int nDup = 1;
    if ( argc == 2 )
	nDup = atoi( argv[1] );
    RiLineList( lpri, nDup );

    for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
    {
	const RiLine * pri = lpri[ipri];
	if ( pri == 0 )
	    ::abort( );
	::printf( "0x%8.8X   %-28s 0x%8.8X 0x%8.8X\n",
	    pri->wRequest, pri->pstrRequest, pri->itySegIn, pri->itySegOut );
    }
}
