// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: RiLineLix.cc
//   Request ioctl line.
//   This is a struct.
//
// File Created:	18 Oct 1994		Michael Chastain
// Last Edited:		16 Nov 1995		Michael Chastain



// Ordinary header files.
#include <RiLine.hh>
#include <TySegLix.hh>
#include <WhCount.hh>



// System header files with ioctl definitions.
#include <linux/types.h>
#include <asm/socket.h>
#include <asm/termios.h>
#include <linux/ax25.h>
#include <linux/cdk.h>
#include <linux/cdrom.h>
#include <linux/cm206.h>
#include <linux/cyclades.h>
#include <linux/ext2_fs.h>
#include <linux/fd.h>
#include <linux/fs.h>
#include <linux/hdreg.h>
#include <linux/if_eql.h>
#include <linux/if_plip.h>
#include <linux/if_ppp.h>
#include <linux/ipx.h>
#include <linux/kd.h>
#include <linux/lp.h>
#include <linux/mroute.h>
#include <linux/mtio.h>
#include <linux/netrom.h>
#include <linux/random.h>
#include <linux/sbpcd.h>
#include <linux/scc.h>
#include <linux/scsi.h>
#include <linux/smb_fs.h>
#include <linux/sockios.h>
#include <linux/soundcard.h>
#include <linux/umsdos_fs.h>
#include <linux/vt.h>



// Macros for defining table lines.
#define Nil(req)	{ req, #req, tySegNil, tySegNil }
#define  In(req, tys)	{ req, #req, tys,      tySegNil }
#define Out(req, tys)	{ req, #req, tySegNil, tys      }
#define  Io(req, tys)	{ req, #req, tys,      tys      }



// Ioctl requests.
static const RiLine lriMain [] =
{
    // <include/asm-i386/socket.h>
    // Linux 1.3.24: reviewed.
    In  ( FIOSETOWN,			tySegMmWord			),
    In  ( SIOCSPGRP,			tySegMmWord			),
    Out ( FIOGETOWN,			tySegMmWord			),
    Out ( SIOCGPGRP,			tySegMmWord			),
    Out ( SIOCATMARK,			tySegMmWord			),
    Out ( SIOCGSTAMP,			tySegTimeval			),

    // <include/asm-i386/termios.h>
    // Linux 1.3.24: reviewed.
    // Linux 1.3.24: SNDCTL_TMR_* conflicts with 3 of these.
    Out ( TCGETS,			tySegTermios			),
    In  ( TCSETS,			tySegTermios			),
    In  ( TCSETSW,			tySegTermios			),
    In  ( TCSETSF,			tySegTermios			),
    Out ( TCGETA,			tySegTermio			),
    In  ( TCSETA,			tySegTermio			),
    In  ( TCSETAW,			tySegTermio			),
    In  ( TCSETAF,			tySegTermio			),
    Nil ( TCSBRK			/* int */			),
    Nil ( TCXONC			/* int */			),
    Nil ( TCFLSH			/* int */			),
    Nil ( TIOCEXCL			/* void */			),
    Nil ( TIOCNXCL			/* void */			),
    Nil ( TIOCSCTTY			/* int */			),
    Out ( TIOCGPGRP,			tySegPidT			),
    In  ( TIOCSPGRP,			tySegPidT			),
    Out ( TIOCOUTQ,			tySegMmWord			),
    In  ( TIOCSTI,			tySegMmByte			),
    Out ( TIOCGWINSZ,			tySegWinsize			),
    In  ( TIOCSWINSZ,			tySegWinsize			),
    Out ( TIOCMGET,			tySegMmWord			),
    In  ( TIOCMBIS,			tySegMmWord			),
    In  ( TIOCMBIC,			tySegMmWord			),
    In  ( TIOCMSET,			tySegMmWord			),
    Out ( TIOCGSOFTCAR,			tySegMmWord			),
    In  ( TIOCSSOFTCAR,			tySegMmWord			),
    // Linux 1.3.24: FIONREAD has the same value and meaning as TIOCINQ.
    Out ( FIONREAD,			tySegMmWord			),
    Out ( TIOCINQ,			tySegMmWord			),
    Nil ( TIOCCONS			/* void */			),
    Out ( TIOCGSERIAL,			tySegSerialStruct		),
    In  ( TIOCSSERIAL,			tySegSerialStruct		),
    In  ( TIOCPKT,			tySegMmWord			),
    In  ( FIONBIO,			tySegMmWord			),
    Nil ( TIOCNOTTY			/* void */			),
    In  ( TIOCSETD,			tySegMmWord			),
    Out ( TIOCGETD,			tySegMmWord			),
    Nil ( TCSBRKP			/* int */			),
    Out ( TIOCTTYGSTRUCT,		tySegTtyStruct			),
    Nil ( FIONCLEX			/* void */			),
    Nil ( FIOCLEX			/* void */			),
    In  ( FIOASYNC,			tySegMmWord			),
    Nil ( TIOCSERCONFIG			/* void */			),
    Out ( TIOCSERGWILD,			tySegMmWord			),
    In  ( TIOCSERSWILD,			tySegMmWord			),
    Out ( TIOCGLCKTRMIOS,		tySegTermios			),
    In  ( TIOCSLCKTRMIOS,		tySegTermios			),
    Out ( TIOCSERGSTRUCT,		tySegAsyncStruct		),
    Out ( TIOCSERGETLSR,		tySegMmWord			),
    Out ( TIOCSERGETMULTI,		tySegSerialMultiportStruct	),
    In  ( TIOCSERSETMULTI,		tySegSerialMultiportStruct	),

    // <include/linux/ax25.h>
    // Linux 1.3.27: reviewed.
    In  ( SIOCAX25GETUID,		tySegSockaddrAx25		),
    In  ( SIOCAX25ADDUID,		tySegSockaddrAx25		),
    In  ( SIOCAX25DELUID,		tySegSockaddrAx25		),
    In  ( SIOCAX25NOUID,		tySegMmWord			),
    Io  ( SIOCAX25GETPARMS,		tySegAx25ParmsStruct		),
    In  ( SIOCAX25SETPARMS,		tySegAx25ParmsStruct		),

    // <include/linux/cdk.h>
    // Linux 1.3.27: reviewed.
    Nil ( STL_BINTR			/* void */			),
    Nil ( STL_BSTART			/* void */			),
    Nil ( STL_BSTOP			/* void */			),
    Nil ( STL_BRESET			/* void */			),

    // <include/linux/cdrom.h>
    // Linux 1.3.24: reviewed.
    Nil ( CDROMPAUSE			/* void */			),
    Nil ( CDROMRESUME			/* void */			),
    In  ( CDROMPLAYMSF,			tySegCdromMsf			),
    In  ( CDROMPLAYTRKIND,		tySegCdromTi			),
    Out ( CDROMREADTOCHDR,		tySegCdromTochdr		),
    Io  ( CDROMREADTOCENTRY,		tySegCdromTocentry		),
    Nil ( CDROMSTOP			/* void */			),
    Nil ( CDROMSTART			/* void */			),
    Nil ( CDROMEJECT			/* void */			),
    In  ( CDROMVOLCTRL,			tySegCdromVolctrl		),
    Io  ( CDROMSUBCHNL,			tySegCdromSubchnl		),
    In  ( CDROMREADMODE2,		tySegCdromMsf	     /* MORE */	),
    In  ( CDROMREADMODE1,		tySegCdromMsf        /* MORE */	),
    In  ( CDROMREADAUDIO,		tySegCdromReadAudio  /* MORE */	),
    Nil ( CDROMEJECT_SW			/* int */			),
    Io  ( CDROMMULTISESSION,		tySegCdromMultisession		),
    Out ( CDROM_GET_UPC,		tySegMmByte8			),
    Nil ( CDROMRESET			/* void */			),
    Out ( CDROMVOLREAD,			tySegCdromVolctrl		),
    In  ( CDROMREADRAW,			tySegCdromMsf        /* MORE */	),
    In  ( CDROMREADCOOKED,		tySegCdromMsf        /* MORE */	),
    In  ( CDROMSEEK,			tySegCdromMsf			),
    In  ( CDROMPLAYBLK,			tySegCdromBlk			),

    // <include/linux/cm206.h>
    // Linux 1.3.24: reviewed.
    Nil ( CM206CTL_GET_STAT		/* int */			),
    Nil ( CM206CTL_GET_LAST_STAT	/* int */			),

    // <include/linux/cyclades.h>
    // Linux 1.3.24: reviewed.
    Out ( CYGETMON,			tySegCycladesMonitor		),
    Out ( CYGETTHRESH,			tySegMmWord			),
    Nil ( CYSETTHRESH			/* int */			),
    Out ( CYGETDEFTHRESH,		tySegMmWord			),
    Nil ( CYSETDEFTHRESH		/* int */			),
    Out ( CYGETTIMEOUT,			tySegMmWord			),
    Nil ( CYSETTIMEOUT			/* int */			),
    Out ( CYGETDEFTIMEOUT,		tySegMmWord			),
    Nil ( CYSETDEFTIMEOUT		/* int */			),

    // <include/linux/ext2_fs.h>
    // Linux 1.3.24: reviewed.
    Out ( EXT2_IOC_GETFLAGS,		tySegMmWord			),
    In  ( EXT2_IOC_SETFLAGS,		tySegMmWord			),
    Out ( EXT2_IOC_GETVERSION,		tySegMmWord			),
    In  ( EXT2_IOC_SETVERSION,		tySegMmWord			),

    // <include/linux/fd.h>
    // Linux 1.3.40: reviewed.
    Nil ( FDCLRPRM			/* void */			),
    In  ( FDSETPRM,			tySegFloppyStruct		),
    In  ( FDDEFPRM,			tySegFloppyStruct		),
    Out ( FDGETPRM,			tySegFloppyStruct		),
    Nil ( FDMSGON			/* void */			),
    Nil ( FDMSGOFF			/* void */			),
    Nil ( FDFMTBEG			/* void */			),
    In  ( FDFMTTRK,			tySegFormatDescr		),
    Nil ( FDFMTEND			/* void */			),
    Nil ( FDSETEMSGTRESH		/* int */			),
    Nil ( FDFLUSH			/* void */			),
    In  ( FDSETMAXERRS,			tySegFloppyMaxErrors		),
    Out ( FDGETMAXERRS,			tySegFloppyMaxErrors		),
    Out ( FDGETDRVTYP,			tySegMmByte16			),
    In  ( FDSETDRVPRM,			tySegFloppyDriveParams		),
    Out ( FDGETDRVPRM,			tySegFloppyDriveParams		),
    Out ( FDGETDRVSTAT,			tySegFloppyDriveStruct		),
    Out ( FDPOLLDRVSTAT,		tySegFloppyDriveStruct		),
    Nil ( FDRESET			/* int */			),
    Out ( FDGETFDCSTAT,			tySegFloppyFdcState		),
    Nil ( FDWERRORCLR			/* void */			),
    Out ( FDWERRORGET,			tySegFloppyWriteErrors		),
    Nil ( FDRAWCMD			/* void */	    /* MORE */	),
    Nil ( FDTWADDLE			/* void */			),

    // <include/linux/fs.h>
    // Linux 1.3.24: reviewed.
    In  ( BLKROSET,			tySegMmWord			),
    Out ( BLKROGET,			tySegMmWord			),
    Nil ( BLKRRPART			/* void */			),
    Out ( BLKGETSIZE,			tySegMmWord			),
    Nil ( BLKFLSBUF			/* void */			),
    Nil ( BLKRASET			/* int */			),
    Out ( BLKRAGET,			tySegMmWord			),
    Io  ( FIBMAP,			tySegMmWord			),
    Out ( FIGETBSZ,			tySegMmWord			),

    // <include/linux/hdreg.h>
    // Linux 1.3.24: reviewed.
    Out ( HDIO_GETGEO,			tySegHdGeometry			),
    Out ( HDIO_GET_UNMASKINTR,		tySegMmWord			),
    Out ( HDIO_GET_MULTCOUNT,		tySegMmWord			),
    Out ( HDIO_GET_IDENTITY,		tySegHdDriveid			),
    Out ( HDIO_GET_KEEPSETTINGS,	tySegMmWord			),
    Out ( HDIO_GET_CHIPSET,		tySegMmWord			),
    Out ( HDIO_GET_NOWERR,		tySegMmWord			),
    Out ( HDIO_GET_DMA,			tySegMmWord			),
    Io  ( HDIO_DRIVE_CMD,		tySegMmWord			),
    Nil ( HDIO_SET_MULTCOUNT		/* int */			),
    Nil ( HDIO_SET_UNMASKINTR		/* int */			),
    Nil ( HDIO_SET_KEEPSETTINGS		/* int */			),
    Nil ( HDIO_SET_CHIPSET		/* int */			),
    Nil ( HDIO_SET_NOWERR		/* int */			),
    Nil ( HDIO_SET_DMA			/* int */			),

    // <include/linux/if_eql.h>
    // Linux 1.3.27: reviewed.
    Io  ( EQL_ENSLAVE,			tySegIfreq	     /* MORE */	),
    Io  ( EQL_EMANCIPATE,		tySegIfreq	     /* MORE */	),
    Io  ( EQL_GETSLAVECFG,		tySegIfreq	     /* MORE */	),
    Io  ( EQL_SETSLAVECFG,		tySegIfreq	     /* MORE */	),
    Io  ( EQL_GETMASTRCFG,		tySegIfreq	     /* MORE */	),
    Io  ( EQL_SETMASTRCFG,		tySegIfreq	     /* MORE */	),

    // <include/linux/if_plip.h>
    // Linux 1.3.27: reviewed.
    Io  ( SIOCDEVPLIP,			tySegIfreq			),

    // <include/linux/if_ppp.h>
    // Linux 1.3.35: reviewed.
    Out ( PPPIOCGFLAGS,			tySegMmWord			),
    In  ( PPPIOCSFLAGS,			tySegMmWord			),
    Out ( PPPIOCGASYNCMAP,		tySegMmWord			),
    In  ( PPPIOCSASYNCMAP,		tySegMmWord			),
    Out ( PPPIOCGUNIT,			tySegMmWord			),
    Nil ( PPPIOCGRASYNCMAP		/* void */			),
    In  ( PPPIOCSRASYNCMAP,		tySegMmWord			),
    Nil ( PPPIOCGMRU			/* void */			),
    In  ( PPPIOCSMRU,			tySegMmWord			),
    In  ( PPPIOCSMAXCID,		tySegMmWord			),
    Out ( PPPIOCGXASYNCMAP,		tySegMmWord8			),
    In  ( PPPIOCSXASYNCMAP,		tySegMmWord8			),
    Nil ( PPPIOCXFERUNIT		/* void */			),
    In  ( PPPIOCSCOMPRESS,		tySegPppOptionData   /* MORE */ ),
    Nil ( PPPIOCGNPMODE			/* void */			),
    Nil ( PPPIOCSNPMODE			/* void */			),
    Out ( PPPIOCGDEBUG,			tySegMmWord			),
    In  ( PPPIOCSDEBUG,			tySegMmWord			),
    Out ( PPPIOCGIDLE,			tySegPppIdle			),
    Io  ( SIOCGPPPSTATS,		tySegIfreq	     /* MORE */	),
    Io  ( SIOCGPPPVER,			tySegIfreq	     /* MORE */	),
    Io  ( SIOCGPPPCSTATS,		tySegIfreq	     /* MORE */	),

    // <include/linux/ipx.h>
    // Linux 1.3.27: reviewed.
    In  ( SIOCAIPXITFCRT,		tySegMmByte			),
    In  ( SIOCAIPXPRISLT,		tySegMmByte			),
    Out ( SIOCIPXCFGDATA,		tySegIpxConfigData		),

    // <include/linux/kd.h>
    // Linux 1.3.24: reviewed.
    Out ( GIO_FONT,			tySegMmByte8192			),
    In  ( PIO_FONT,			tySegMmByte8192			),
    Io  ( GIO_FONTX,			tySegConsolefontdesc /* MORE */	),
    In  ( PIO_FONTX,			tySegConsolefontdesc /* MORE */	),
    Nil ( PIO_FONTRESET			/* void */			),
    Out ( GIO_CMAP,			tySegMmByte48			),
    In  ( PIO_CMAP,			tySegMmByte48			),
    Nil ( KIOCSOUND			/* int */			),
    Nil ( KDMKTONE			/* int */			),
    Out ( KDGETLED,			tySegMmByte			),
    Nil ( KDSETLED			/* int */			),
    Out ( KDGKBTYPE,			tySegMmByte			),
    Nil ( KDADDIO			/* int */	     /* MORE */	),
    Nil ( KDDELIO			/* int */	     /* MORE */	),
    Nil ( KDENABIO			/* void */	     /* MORE */	),
    Nil ( KDDISABIO			/* void */	     /* MORE */	),
    Nil ( KDSETMODE			/* int */			),
    Out ( KDGETMODE,			tySegMmWord			),
    Nil ( KDMAPDISP			/* void */	     /* MORE */	),
    Nil ( KDUNMAPDISP			/* void */	     /* MORE */	),
    Out ( GIO_SCRNMAP,			tySegMmByteTabsz		),
    In  ( PIO_SCRNMAP,			tySegMmByteTabsz		),
    Out ( GIO_UNISCRNMAP,		tySegMmShortTabsz		),
    In  ( PIO_UNISCRNMAP,		tySegMmShortTabsz		),
    Io  ( GIO_UNIMAP,			tySegUnimapdesc	     /* MORE */	),
    In  ( PIO_UNIMAP,			tySegUnimapdesc	     /* MORE */	),
    In  ( PIO_UNIMAPCLR,		tySegUnimapinit			),
    Out ( KDGKBMODE,			tySegMmWord			),
    Nil ( KDSKBMODE			/* int */			),
    Out ( KDGKBMETA,			tySegMmWord			),
    Nil ( KDSKBMETA			/* int */			),
    Out ( KDGKBLED,			tySegMmByte			),
    Nil ( KDSKBLED			/* int */			),
    Io  ( KDGKBENT,			tySegKbentry			),
    In  ( KDSKBENT,			tySegKbentry			),
    Io  ( KDGKBSENT,			tySegKbsentry			),
    In  ( KDSKBSENT,			tySegKbsentry			),
    Out ( KDGKBDIACR,			tySegKbdiacrs			),
    In  ( KDSKBDIACR,			tySegKbdiacrs			),
    Io  ( KDGETKEYCODE,			tySegKbkeycode			),
    In  ( KDSETKEYCODE,			tySegKbkeycode			),
    Nil ( KDSIGACCEPT			/* int */			),

    // <include/linux/lp.h>
    // Linux 1.3.24: reviewed.
    Nil ( LPCHAR			/* int */			),
    Nil ( LPTIME			/* int */			),
    Nil ( LPABORT			/* int */			),
    Nil ( LPSETIRQ			/* int */			),
    Out ( LPGETIRQ,			tySegMmWord			),
    Nil ( LPWAIT			/* int */			),
    Nil ( LPCAREFUL			/* int */			),
    Nil ( LPABORTOPEN			/* int */			),
    Out ( LPGETSTATUS,			tySegMmWord			),
    Nil ( LPRESET			/* void */			),
    Out ( LPGETSTATS,			tySegLpStats			),

    // <include/linux/mroute.h>
    // Linux 1.3.27: reviewed.
    Io  ( SIOCGETVIFCNT,		tySegSiocVifReq			),
    Io  ( SIOCGETSGCNT,			tySegSiocSgReq			),

    // <include/linux/mtio.h>
    // Linux 1.3.24: reviewed.
    In  ( MTIOCTOP,			tySegMtop			),
    Out ( MTIOCGET,			tySegMtget			),
    Out ( MTIOCPOS,			tySegMtpos			),
    Out ( MTIOCGETCONFIG,		tySegMtconfiginfo		),
    In  ( MTIOCSETCONFIG,		tySegMtconfiginfo		),

    // <include/linux/netrom.h>
    // Linux 1.3.27: reviewed.
    Io  ( SIOCNRGETPARMS,		tySegNrParmsStruct		),
    In  ( SIOCNRSETPARMS,		tySegNrParmsStruct		),
    Nil ( SIOCNRDECOBS			/* void */			),
    In  ( SIOCNRRTCTL,			tySegMmWord			),

    // <include/linux/random.h>
    // Linux 1.3.39: review in progress.
    Out ( RNDGETENTCNT,			tySegMmWord			),
    In  ( RNDADDTOENTCNT,		tySegMmWord			),
    Io  ( RNDGETPOOL,			tySegMmWord2	     /* MORE */ ),
    In  ( RNDADDENTROPY,		tySegMmWord2			),
    Nil ( RNDZAPENTCNT			/* void */			),

    // <include/linux/sbpcd.h>
    // Linux 1.3.24: reviewed.
    In  ( DDIOCSDBG,			tySegMmWord			),
    Nil ( CDROMAUDIOBUFSIZ		/* int */			),

    // <include/linux/scc.h>
    // Linux 1.3.27: reviewed.
    Nil ( TIOCSCCINI			/* void */			),
    In  ( TIOCCHANINI,			tySegSccModem			),
    Io  ( TIOCGKISS,			tySegIoctlCommand		),
    In  ( TIOCSKISS,			tySegIoctlCommand		),
    Out ( TIOCSCCSTAT,			tySegSccStat			),

    // <include/linux/scsi.h>
    // Linux 1.3.27: reviewed.
    Out ( SCSI_IOCTL_GET_IDLUN,		tySegMmWord2			),
    Nil ( SCSI_IOCTL_TAGGED_ENABLE	/* void */			),
    Nil ( SCSI_IOCTL_TAGGED_DISABLE	/* void */			),
    In  ( SCSI_IOCTL_PROBE_HOST,	tySegMmWord	     /* MORE */	),

    // <include/linux/smb_fs.h>
    // Linux 1.3.24: reviewed.
    Out ( SMB_IOC_GETMOUNTUID,		tySegUidT			),

    // <include/linux/sockios.h>
    // Linux 1.3.24: reviewed.
    // Linux 1.3.24: SIOCADDR, SIOCDELRT have context-sensitive args.
    In  ( SIOCADDRT,			tySegRtentry	     /* MORE */	),
    In  ( SIOCDELRT,			tySegRtentry	     /* MORE */	),
    Out ( SIOCGIFNAME,			tySegStrNul			),
    Nil ( SIOCSIFLINK			/* void */			),
    Io  ( SIOCGIFCONF,			tySegIfconf	     /* MORE */	),
    Io  ( SIOCGIFFLAGS,			tySegIfreq			),
    In  ( SIOCSIFFLAGS,			tySegIfreq			),
    Io  ( SIOCGIFADDR,			tySegIfreq			),
    In  ( SIOCSIFADDR,			tySegIfreq			),
    Io  ( SIOCGIFDSTADDR,		tySegIfreq			),
    In  ( SIOCSIFDSTADDR,		tySegIfreq			),
    Io  ( SIOCGIFBRDADDR,		tySegIfreq			),
    In  ( SIOCSIFBRDADDR,		tySegIfreq			),
    Io  ( SIOCGIFNETMASK,		tySegIfreq			),
    In  ( SIOCSIFNETMASK,		tySegIfreq			),
    Io  ( SIOCGIFMETRIC,		tySegIfreq			),
    In  ( SIOCSIFMETRIC,		tySegIfreq			),
    Io  ( SIOCGIFMEM,			tySegIfreq			),
    In  ( SIOCSIFMEM,			tySegIfreq			),
    Io  ( SIOCGIFMTU,			tySegIfreq			),
    In  ( SIOCSIFMTU,			tySegIfreq			),
    // Linux 1.3.24: SIOCSIFHWADDR has context-sensitive arg.
    In  ( SIOCSIFHWADDR,		tySegIfreq	     /* MORE */	),
    Out ( SIOCGIFENCAP,			tySegMmWord			),
    In  ( SIOCSIFENCAP,			tySegMmWord			),
    Io  ( SIOCGIFHWADDR,		tySegIfreq			),
    Nil ( SIOCGIFSLAVE			/* void */			),
    Nil ( SIOCSIFSLAVE			/* void */			),
    In  ( SIOCADDMULTI,			tySegIfreq			),
    In  ( SIOCDELMULTI,			tySegIfreq			),
    In  ( OLD_SIOCDARP,			tySegArpreqOld			),
    Io  ( OLD_SIOCGARP,			tySegArpreqOld			),
    In  ( OLD_SIOCSARP,			tySegArpreqOld			),
    In  ( SIOCDARP,			tySegArpreq			),
    Io  ( SIOCGARP,			tySegArpreq			),
    In  ( SIOCSARP,			tySegArpreq			),
    In  ( SIOCDRARP,			tySegArpreq			),
    Io  ( SIOCGRARP,			tySegArpreq			),
    In  ( SIOCSRARP,			tySegArpreq			),
    Io  ( SIOCGIFMAP,			tySegIfreq			),
    In  ( SIOCSIFMAP,			tySegIfreq			),

    // <include/linux/soundcard.h>
    // Linux 1.3.24: reviewed.
    Nil ( SNDCTL_SEQ_RESET		/* void */			),
    Nil ( SNDCTL_SEQ_SYNC		/* void */			),
    Io  ( SNDCTL_SYNTH_INFO,		tySegSynthInfo			),
    Io  ( SNDCTL_SEQ_CTRLRATE,		tySegMmWord			),
    Out ( SNDCTL_SEQ_GETOUTCOUNT,	tySegMmWord			),
    Out ( SNDCTL_SEQ_GETINCOUNT,	tySegMmWord			),
    Nil ( SNDCTL_SEQ_PERCMODE		/* void */			),
    In  ( SNDCTL_FM_LOAD_INSTR,		tySegSbiInstrument		),
    In  ( SNDCTL_SEQ_TESTMIDI,		tySegMmWord			),
    In  ( SNDCTL_SEQ_RESETSAMPLES,	tySegMmWord			),
    Out ( SNDCTL_SEQ_NRSYNTHS,		tySegMmWord			),
    Out ( SNDCTL_SEQ_NRMIDIS,		tySegMmWord			),
    Io  ( SNDCTL_MIDI_INFO,		tySegMidiInfo			),
    In  ( SNDCTL_SEQ_THRESHOLD,		tySegMmWord			),
    Io  ( SNDCTL_SYNTH_MEMAVL,		tySegMmWord			),
    In  ( SNDCTL_FM_4OP_ENABLE,		tySegMmWord			),
    Io  ( SNDCTL_PMGR_ACCESS,		tySegPatmgrInfo			),
    Nil ( SNDCTL_SEQ_PANIC		/* void */			),
    In  ( SNDCTL_SEQ_OUTOFBAND,		tySegSeqEventRec		),
    // Linux 1.3.24: SNDCTL_TMR_* reuse the termios 'T' letter.  Dumb move!
    Io  ( SNDCTL_TMR_TIMEBASE,		tySegMmWord			),
    Nil ( SNDCTL_TMR_START		/* void */			),
    Nil ( SNDCTL_TMR_STOP		/* void */			),
    Nil ( SNDCTL_TMR_CONTINUE		/* void */			),
    Io  ( SNDCTL_TMR_TEMPO,		tySegMmWord			),
    Io  ( SNDCTL_TMR_SOURCE,		tySegMmWord			),
    In  ( SNDCTL_TMR_METRONOME,		tySegMmWord			),
    Io  ( SNDCTL_TMR_SELECT,		tySegMmWord			),
    Io  ( SNDCTL_PMGR_IFACE,		tySegPatmgrInfo			),
    Io  ( SNDCTL_MIDI_PRETIME,		tySegMmWord			),
    In  ( SNDCTL_MIDI_MPUMODE,		tySegMmWord			),
    Io  ( SNDCTL_MIDI_MPUCMD,		tySegMpuCommandRec		),
    Nil ( SNDCTL_DSP_RESET		/* void */			),
    Nil ( SNDCTL_DSP_SYNC		/* void */			),
    Io  ( SNDCTL_DSP_SPEED,		tySegMmWord			),
    Io  ( SNDCTL_DSP_STEREO,		tySegMmWord			),
    Io  ( SNDCTL_DSP_GETBLKSIZE,	tySegMmWord			),
    Io  ( SOUND_PCM_WRITE_CHANNELS,	tySegMmWord			),
    Io  ( SOUND_PCM_WRITE_FILTER,	tySegMmWord			),
    Nil ( SNDCTL_DSP_POST		/* void */			),
    Io  ( SNDCTL_DSP_SUBDIVIDE,		tySegMmWord			),
    Io  ( SNDCTL_DSP_SETFRAGMENT,	tySegMmWord			),
    Out ( SNDCTL_DSP_GETFMTS,		tySegMmWord			),
    Io  ( SNDCTL_DSP_SETFMT,		tySegMmWord			),
    Out ( SNDCTL_DSP_GETOSPACE,		tySegAudioBufInfo		),
    Out ( SNDCTL_DSP_GETISPACE,		tySegAudioBufInfo		),
    Nil ( SNDCTL_DSP_NONBLOCK		/* void */			),
    Out ( SNDCTL_DSP_GETCAPS,		tySegMmWord			),
    Out ( SNDCTL_DSP_GETTRIGGER,	tySegMmWord			),
    In  ( SNDCTL_DSP_SETTRIGGER,	tySegMmWord			),
    Out ( SNDCTL_DSP_GETIPTR,		tySegCountInfo			),
    Out ( SNDCTL_DSP_GETOPTR,		tySegCountInfo			),
//  Xxx ( SNDCTL_DSP_MAPINBUF						),
//  Xxx ( SNDCTL_DSP_MAPOUTBUF						),
    Out ( SOUND_PCM_READ_RATE,		tySegMmWord			),
    Out ( SOUND_PCM_READ_CHANNELS,	tySegMmWord			),
    Out ( SOUND_PCM_READ_BITS,		tySegMmWord			),
    Out ( SOUND_PCM_READ_FILTER,	tySegMmWord			),
    Nil ( SNDCTL_COPR_RESET		/* void */			),
    In  ( SNDCTL_COPR_LOAD,		tySegCoprBuffer			),
    Io  ( SNDCTL_COPR_RDATA,		tySegCoprDebugBuf		),
    Io  ( SNDCTL_COPR_RCODE,		tySegCoprDebugBuf		),
    In  ( SNDCTL_COPR_WDATA,		tySegCoprDebugBuf		),
    In  ( SNDCTL_COPR_WCODE,		tySegCoprDebugBuf		),
    Io  ( SNDCTL_COPR_RUN,		tySegCoprDebugBuf		),
    Io  ( SNDCTL_COPR_HALT,		tySegCoprDebugBuf		),
    In  ( SNDCTL_COPR_SENDMSG,		tySegCoprMsg			),
    Out ( SNDCTL_COPR_RCVMSG,		tySegCoprMsg			),
    Out ( SOUND_MIXER_READ_VOLUME,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_BASS,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_TREBLE,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_SYNTH,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_PCM,		tySegMmWord			),
    Out ( SOUND_MIXER_READ_SPEAKER,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_LINE,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_MIC,		tySegMmWord			),
    Out ( SOUND_MIXER_READ_CD,		tySegMmWord			),
    Out ( SOUND_MIXER_READ_IMIX,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_ALTPCM,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_RECLEV,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_IGAIN,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_OGAIN,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_LINE1,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_LINE2,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_LINE3,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_MUTE,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_ENHANCE,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_LOUD,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_RECSRC,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_DEVMASK,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_RECMASK,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_STEREODEVS,	tySegMmWord			),
    Out ( SOUND_MIXER_READ_CAPS,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_VOLUME,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_BASS,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_TREBLE,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_SYNTH,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_PCM,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_SPEAKER,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_LINE,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_MIC,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_CD,		tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_IMIX,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_ALTPCM,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_RECLEV,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_IGAIN,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_OGAIN,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_LINE1,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_LINE2,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_LINE3,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_MUTE,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_ENHANCE,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_LOUD,	tySegMmWord			),
    Io  ( SOUND_MIXER_WRITE_RECSRC,	tySegMmWord			),

    // <include/linux/umsdos_fs.h>
    // Linux 1.3.24: reviewed.
    Io  ( UMSDOS_READDIR_DOS,		tySegUmsdosIoctl		),
    In  ( UMSDOS_UNLINK_DOS,		tySegUmsdosIoctl		),
    In  ( UMSDOS_RMDIR_DOS,		tySegUmsdosIoctl		),
    Io  ( UMSDOS_STAT_DOS,		tySegUmsdosIoctl		),
    In  ( UMSDOS_CREAT_EMD,		tySegUmsdosIoctl		),
    In  ( UMSDOS_UNLINK_EMD,		tySegUmsdosIoctl		),
    Io  ( UMSDOS_READDIR_EMD,		tySegUmsdosIoctl		),
    Out ( UMSDOS_GETVERSION,		tySegUmsdosIoctl		),
    Nil ( UMSDOS_INIT_EMD		/* void */			),
    In  ( UMSDOS_DOS_SETUP,		tySegUmsdosIoctl		),
    In  ( UMSDOS_RENAME_DOS,		tySegUmsdosIoctl		),

    // <include/linux/vt.h>
    // Linux 1.3.24: reviewed.
    Out ( VT_OPENQRY,			tySegMmWord			),
    Out ( VT_GETMODE,			tySegVtMode			),
    In  ( VT_SETMODE,			tySegVtMode			),
    Out ( VT_GETSTATE,			tySegVtStat			),
    Nil ( VT_SENDSIG			/* void */			),
    Nil ( VT_RELDISP			/* int */			),
    Nil ( VT_ACTIVATE			/* int */			),
    Nil ( VT_WAITACTIVE			/* int */			),
    Nil ( VT_DISALLOCATE		/* int */			),
    In  ( VT_RESIZE,			tySegVtSizes			),
    In  ( VT_RESIZEX,			tySegVtConsize			),
};



// Lookup a request structure by ioctl request number.
void RiLineGet( MmWord wRequest, WhList <const RiLine *> & lpriRet )
{
    lpriRet.clear( );
    for ( int iri = 0; iri < WhCount( lriMain ); ++iri )
    {
	if ( lriMain[iri].wRequest == wRequest )
	    lpriRet.appendVal( &lriMain[iri] );
    }
}



// TIOCLINUX sub-requests.
// Linux 1.3.24: reviewed.
static const RiLine lriTlx [] =
{
    { TIOCLINUX, "TIOCLINUX-0",  tySegNil,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-1",  tySegNil,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-2",  tySeg1Selection,	tySegNil	},
    { TIOCLINUX, "TIOCLINUX-3",  tySegNil,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-4",  tySegNil,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-5",  tySeg4MmWord8,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-6",  tySegNil,		tySegMmByte	},
    { TIOCLINUX, "TIOCLINUX-7",  tySegNil,		tySegMmByte	},
    { TIOCLINUX, "TIOCLINUX-8",  tySegNil,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-9",  tySegNil,		tySegNil	},
    { TIOCLINUX, "TIOCLINUX-10", tySeg1MmByte,		tySegNil	}
};



// Lookup a request structure by TIOCLINUX sub-request number.
void RiLineGetTlx( MmByte bRequestSub, WhList <const RiLine *> & lpriRet )
{
    lpriRet.clear( );
    if ( bRequestSub < WhCount(lriTlx) )
	lpriRet.appendVal( &lriTlx[bRequestSub] );
}



// List ioctl's; can count duplicates only.
void RiLineList( WhList <const RiLine *> & lpriRet, int nDupMin )
{
    lpriRet.clear( );
    for ( int iri1 = 0; iri1 < WhCount( lriMain ); ++iri1 )
    {
	const MmWord wRequest = lriMain[iri1].wRequest;
	int nDup = 0;
	for ( int iri2 = 0; iri2 < WhCount( lriMain ); ++iri2 )
	{
	    if ( wRequest == lriMain[iri2].wRequest )
		++nDup;
	}
	if ( nDup >= nDupMin )
	    lpriRet.appendVal( &lriMain[iri1] );
    }
}
