// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrSl.hh
//   Data set stash for links.
//   This is an external resource handler class.
//
// File Created:	11 Nov 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#if !defined(PR_SL_HH)
#define PR_SL_HH

#include <WhLap.hh>
#include <WhString.hh>

class	MmDs;
class	PrSd;



class	PrSl
{
    // Life cycle methods.
    public:
				PrSl		( const WhString & );
				~PrSl		(		   );
	void			finalize	(		   );

    // Forbidden copiers.
    private:
				PrSl		( const PrSl &	   );
	void			operator =	( const PrSl &	   );

    // Accessors.
    public:
	const WhString &	getNameDir	(		   ) const;

    // Stash interface.
    public:
	void			resetStash	(		   );
	void			stashLink	( const MmDs &,
						  const PrSd &	   );

    // Instance data.
    private:
	WhString		strNameDir_;	// Name of directory.
	WhLap <WhString>	lstrNameLink_;	// Stashed links.
};



// Inline methods.

inline const WhString & PrSl::getNameDir( ) const
{
    return strNameDir_;
}



#endif
