// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrSl.cc
//   Data set stash for links.
//   This is an external resource handler class.
//
// File Created:	11 Nov 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#include <sys/stat.h>
#include <unistd.h>

#include <ErFatal.hh>
#include <ErMem.hh>
#include <MmDs.hh>
#include <PrSd.hh>
#include <PrSl.hh>



// Constructor.
PrSl::PrSl( const WhString & strNameDir )
    : strNameDir_	( strNameDir	)
    , lstrNameLink_	(		)
{
    // Check name.
    WhString strNameDirNul( strNameDir );
    strNameDirNul.appChrRaw( '\0' );
    strNameDirNul.checkCcs( );

    // Create directory.
    if ( ::mkdir( strNameDirNul.address( ), 0755 ) != 0 )
	ErFatal( "PrSl::PrSl: failed mkdir." );
}



// Destructor.
PrSl::~PrSl( )
{
    finalize( );
}



// Finalizer.
void PrSl::finalize( )
{
    // Unlink files and links.
    resetStash( );

    // Unlink directory.
    WhString strNameDirNul( strNameDir_ );
    strNameDirNul.appChrRaw( '\0' );
    strNameDirNul.checkCcs( );
    if ( ::rmdir( strNameDirNul.address( ) ) != 0 )
	ErFatal( "PrSl::finalize: failed rmdir." );
}



// Unlink files and links.
void PrSl::resetStash( )
{
    for ( int istr = lstrNameLink_.count( ) - 1; istr >= 0; --istr )
    {
	WhString strNameLinkNul( lstrNameLink_[istr] );
	strNameLinkNul.appChrRaw( '\0' );
	strNameLinkNul.checkCcs( );
	if ( ::unlink( strNameLinkNul.address( ) ) != 0 )
	    ErFatal( "PrSl::resetStash: failed unlink." );
    }
    lstrNameLink_.reset( );
}



// Stash dataset as a link.
void PrSl::stashLink( const MmDs & dsStash, const PrSd & stashData )
{
    // Make stash name.
    WhString * pstrNameStash = new WhString( strNameDir_ );
    if ( pstrNameStash == 0 )
	ErMem( );
    pstrNameStash->appChrRaw( '/' );
    dsStash.appNameSmash( *pstrNameStash );
    WhString strNameStashNul( *pstrNameStash );
    strNameStashNul.appChrRaw( '\0' );
    strNameStashNul.checkCcs( );

    // Make data file name.
    WhString strNameDataNul( stashData.getNameDir( ) );
    strNameDataNul.appChrRaw( '/' );
    dsStash.appNameSmash( strNameDataNul );
    strNameDataNul.appChrRaw( '-' );
    strNameDataNul.appIntFmt( dsStash.getSeq( ) );
    strNameDataNul.appChrRaw( '\0' );
    strNameDataNul.checkCcs( );

    // Write into stash.
    if ( ::symlink( strNameDataNul.address( ), strNameStashNul.address( ) ) != 0 )
	ErFatal( "PrSl::stashLinkExec: failed symlink." );

    // Record this name.
    lstrNameLink_.appendAp( pstrNameStash );
}
