// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrSd.cc
//   Data set stash for data.
//   This is an external resource handler class.
//
// File Created:	11 Nov 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#include <sys/stat.h>
#include <unistd.h>

#include <ErFatal.hh>
#include <ErMem.hh>
#include <MmDs.hh>
#include <PrSd.hh>
#include <WhFileOut.hh>



// Constructor.
PrSd::PrSd( const WhString & strNameDir, const WhString & strNameExec )
    : strNameDir_	( strNameDir	)
    , strNameExec_	( strNameExec	)
    , lstrNameFile_	(		)
    , liExec_		(		)
{
    // Check exec'er.
    WhString strNameExecNul( strNameExec );
    strNameExecNul.appChrRaw( '\0' );
    strNameExecNul.checkCcs( );
    if ( ::access( strNameExecNul.address( ), X_OK ) != 0 )
	ErFatal( "PrSd::PrSd: failed access." );

    // Create directory.
    WhString strNameDirNul( strNameDir );
    strNameDirNul.appChrRaw( '\0' );
    strNameDirNul.checkCcs( );
    if ( ::mkdir( strNameDirNul.address( ), 0755 ) != 0 )
	ErFatal( "PrSd::PrSd: failed mkdir." );
}



// Destructor.
PrSd::~PrSd( )
{
    finalize( );
}



// Finalizer.
void PrSd::finalize( )
{
    // Unlink files.
    resetStash( );

    // Unlink directory.
    WhString strNameDirNul( strNameDir_ );
    strNameDirNul.appChrRaw( '\0' );
    strNameDirNul.checkCcs( );
    if ( ::rmdir( strNameDirNul.address( ) ) != 0 )
	ErFatal( "PrSd::finalize: failed rmdir." );
}



// Unlink files and links.
void PrSd::resetStash( )
{
    for ( int istr = lstrNameFile_.count( ) - 1; istr >= 0; --istr )
    {
	WhString strNameFileNul( lstrNameFile_[istr] );
	strNameFileNul.appChrRaw( '\0' );
	strNameFileNul.checkCcs( );
	if ( ::unlink( strNameFileNul.address( ) ) != 0 )
	    ErFatal( "PrSd::resetStash: failed unlink." );
    }

    lstrNameFile_.reset( );
    liExec_.clear( );
}



// Stash a dataset as a file.
void PrSd::stashFile( const MmDs & dsStash )
{
    // Write data file.
    {
	// Make stash name.
	WhString * pstrNameStash = new WhString( strNameDir_ );
	if ( pstrNameStash == 0 )
	    ErMem( );
	pstrNameStash->appChrRaw( '/' );
	dsStash.appNameSmash( *pstrNameStash );
	pstrNameStash->appChrRaw( '-' );
	pstrNameStash->appIntFmt( dsStash.getSeq( ) );

	// Write into stash.
	{
	    WhFileOut fileStash( *pstrNameStash, WhFileOut::tyOpenWriteExe );
	    if ( fileStash.isError( ) )
		ErFatal( "PrSd::stashFile: failed open." );
	    fileStash.writeArrayChar( dsStash.address( ), dsStash.count( ) );
	}

	// Record this name.
	lstrNameFile_.appendAp( pstrNameStash );
    }

    // Write exec link.
    if ( dsStash.getSeq( ) == 0 )
    {
	// Make stash name.
	WhString * pstrNameStash = new WhString( strNameDir_ );
	if ( pstrNameStash == 0 )
	    ErMem( );
	pstrNameStash->appChrRaw( '/' );
	dsStash.appNameSmash( *pstrNameStash );
	pstrNameStash->appStrRaw( "-X" );
	WhString strNameStashNul( *pstrNameStash );
	strNameStashNul.appChrRaw( '\0' );
	strNameStashNul.checkCcs( );

	// Make exec file name.
	WhString strNameExecNul( strNameExec_ );
	strNameExecNul.appChrRaw( '\0' );
	strNameExecNul.checkCcs( );

	// Write into stash.
	if ( ::symlink( strNameExecNul.address( ), strNameStashNul.address( ) ) != 0 )
	    ErFatal( "PrSd::stashLinkExec: failed symlink." );

	// Record this name.
	lstrNameFile_.appendAp( pstrNameStash );
	liExec_.appendVal( lstrNameFile_.count( ) - 2 );
    }
}
