// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrDir.hh
//   Directory tracker.
//   This is an external resource handler class.
//
// File Created:	16 Nov 1995		Michael Chastain
// Last Edited:		16 Nov 1995		Michael Chastain

#if !defined(PR_DIR_HH)
#define PR_DIR_HH

#include <MmType.hh>

class	MmSeg;
class	PrProc;
class	WhString;



class	PrDir
{
    // Life cycle methods.
    public:
				PrDir		(		   );
				~PrDir		(		   );
	void			finalize	(		   );

    // Forbidden copiers.
    private:
				PrDir		( const PrDir &	   );
	void			operator =	( const PrDir &	   );

    // Accessor.
    public:
	bool			translateName	( const PrProc &,
						  const MmSeg &,
						  WhString &	   ) const;

    // Mutators.
    public:
	void			trackChdir	( const MmSeg &	   );
	void			trackChroot	( const MmSeg &	   );
	void			trackFchdir	( MmWord	   );

    // Instance data.
    private:
	bool			fKnowRoot_;	// I know where '/' is.
	bool			fKnowCwd_;	// I know where '.' is.
};



#endif
