// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrDir.cc
//   Directory tracker.
//   This is an external resource handler class.
//
// File Created:	16 Nov 1995		Michael Chastain
// Last Edited:		16 Nov 1995		Michael Chastain

#include <unistd.h>

#include <MmSeg.hh>
#include <PrDir.hh>
#include <PrProc.hh>
#include <WhString.hh>



// Constructor.
PrDir::PrDir( )
    : fKnowRoot_	( true	)
    , fKnowCwd_		( true	)
{
    ;
}



// Destructor.
PrDir::~PrDir( )
{
    finalize( );
}



// Finalizer.
void PrDir::finalize( )
{
    ;
}



// Translate a file name from target space to my space.
bool PrDir::translateName( const PrProc & procFetch,
    const MmSeg & segInName, WhString & strNameRet ) const
{
    // Clear return value.
    strNameRet.clear( );

    // Get name.
    segInName.checkCcs( );
    const MmByte * pbInName = segInName.address( );

    // Copy in name.
    if ( pbInName[0] == MmByte( '/' ) ? fKnowRoot_ : fKnowCwd_ )
    {
	// Simply copy the name.
	strNameRet.appStrRaw( (const char *) pbInName );
    }
    else
    {
	// Make name in '/proc'.
	strNameRet.appStrRaw( "/proc/"			);
	strNameRet.appIntFmt( procFetch.getPid( )	);
	if ( pbInName[0] == MmByte( '/' ) )
	    strNameRet.appStrRaw( "/root"		);
	else
	    strNameRet.appStrRaw( "/cwd/"		);
	strNameRet.appStrRaw( (const char *) pbInName	);
    }

    // See if name exists.
    WhString strNameNul( strNameRet );
    strNameNul.appChrRaw( '\0' );
    return ::access( strNameNul.address( ), R_OK ) == 0;
}



// Track a target 'chdir'.
void PrDir::trackChdir( const MmSeg & )
{
    // Loses track.
    fKnowCwd_ = false;
}



// Track a target 'chroot'.
void PrDir::trackChroot( const MmSeg & )
{
    // Loses track.
    fKnowRoot_ = false;
}



// Track a target 'fchdir'.
void PrDir::trackFchdir( MmWord )
{
    // Loses track.
    fKnowCwd_ = false;
}
