// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrBpt.hh
//   Target breakpoints.
//   This is a concrete class.
//
// File Created:	14 Nov 1995		Michael Chastain
// Last Edited:		14 Nov 1995		Michael Chastain

#if !defined(PR_BPT_HH)
#define PR_BPT_HH

#include <MmType.hh>
#include <WhList.hh>



class	PrBpt
{
    // Life cycle methods.
    public:
				PrBpt		(		   );

    // Forbidden copiers.
    private:
				PrBpt		( const PrBpt &	   );
	void			operator =	( const PrBpt &	   );

    // Accessor.
    public:
	bool			isBpt		( MmAddr	   ) const;

    // Mutators.
    public:
	bool			changeWord	( MmAddr, MmWord,
						  MmWord	   );
	void			clear		(		   );

    // Instance data.
    private:
	WhList <MmAddr>		laddr_;		// Addresses.
	WhList <MmInsn>		linsn_;		// Saved instructions.
};



// Inline methods.

inline void PrBpt::clear( )
{
    laddr_.clear( );
    linsn_.clear( );
}



#endif
