// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrBpt.cc
//   Target breakpoints.
//   This is a concrete class.
//
// File Created:	14 Nov 1995		Michael Chastain
// Last Edited:		14 Nov 1995		Michael Chastain

#include <ErAbort.hh>
#include <MmInsn.hh>
#include <MmType.hh>
#include <PrBpt.hh>



// Constructor.
PrBpt::PrBpt( )
    : laddr_	( )
    , linsn_	( )
{
    ;
}



// Return whether address has a breakpoint.
bool PrBpt::isBpt( MmAddr addrFind ) const
{
    for ( int iaddr = 0; iaddr < laddr_.count( ); ++iaddr )
    {
	if ( laddr_[iaddr] == addrFind )
	    return true;
    }
    return false;
}



// Change word in text space.
//   Word may have multiple insn's in it.
//   Can change old->bpt or bpt->old.
bool PrBpt::changeWord( MmAddr addrChange, MmWord wOld, MmWord wNew )
{
    // Calculate # insnBpt's in one word.
    if ( insnBpt[0] != 1 )
	ErAbort( "PrBpt::changeWord: bad count." );
    if ( sizeof(MmWord) % sizeof(MmInsn) != 0 )
	ErAbort( "PrBpt::changeWord: bad size." );
    const int nInsnBpt = sizeof(MmWord) / sizeof(MmInsn);

    // New lists.
    WhList <MmAddr> laddrNew ( laddr_ );
    WhList <MmInsn> linsnNew ( linsn_ );

    // Look at each proposed change.
    for ( int iInsn = 0; iInsn < nInsnBpt; ++iInsn )
    {
	const MmAddr addrNew = addrChange + iInsn * sizeof(MmInsn);
	const MmInsn insnNew = ((const MmInsn *) &wNew) [iInsn];
	const MmInsn insnOld = ((const MmInsn *) &wOld) [iInsn];

	if ( insnNew != insnOld )
	{
	    // Look for existing breakpoint.
	    bool faddrBpt = false;
	    int iaddrBpt;
	    for ( iaddrBpt = 0; iaddrBpt < laddrNew.count( ); ++iaddrBpt )
	    {
		if ( laddrNew[iaddrBpt] == addrNew )
		{
		    faddrBpt = true;
		    break;
		}
	    }

	    // Remove old breakpoint.
	    if      (  faddrBpt && insnNew == linsnNew[iaddrBpt] )
	    {
		laddrNew.remove( iaddrBpt );
		linsnNew.remove( iaddrBpt );
	    }

	    // Add new breakpoint.
	    else if ( !faddrBpt && insnNew == insnBpt[1] )
	    {
		laddrNew.appendVal( addrNew );
		linsnNew.appendVal( insnOld );
	    }

	    // Forbidden.
	    else
	    {
		return false;
	    }
	}
    }

    // Accepted.
    laddr_ = laddrNew;
    linsn_ = linsnNew;
    return true;
}
