// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MsLine.cc
//   System call line.
//   This is a concrete class.
//
// These are the methods.
//
// File Created:	29 Jul 1995		Michael Chastain
// Last Edited:		03 Nov 1995		Michael Chastain

#include <sys/types.h>

#include <CxFetch.hh>
#include <ErAbort.hh>
#include <ErFatal.hh>
#include <ErMem.hh>
#include <ErPtr.hh>
#include <EvBase.hh>
#include <EvSci.hh>
#include <EvSco.hh>
#include <MmSeg.hh>
#include <MmSpace.hh>
#include <MsLine.hh>
#include <PrProc.hh>



// Fetch an array of segments.
void MsLine::fetchArraySeg( const MsLine amsLine [], int nmsLine,
    CxFetch & cxFetch, EvBase & evTarget )
{
    // Check count and pointer.
    if ( nmsLine < 0 )
	ErAbort( "MsLine::fetchArraySeg: negative count." );
    if ( nmsLine > 0 && amsLine == 0 )
	ErPtr( );

    // Fetch each line.
    for ( int imsLine = 0; imsLine < nmsLine; ++imsLine )
    {
	const MsLine & msLine = amsLine[imsLine];
	if (  cxFetch.getProc  ( ).getTyEvent ( ) == tyEvSci ? msLine.fIn_        :
	   ( !cxFetch.getEvSco ( ).isScrError ( )            ? msLine.fOutOk_     :
						               msLine.fOutError_  ) )
	{
	    msLine.fetchSeg( cxFetch, evTarget );
	}
    }
}



// Fetch one segment.
void MsLine::fetchSeg( CxFetch & cxFetch, EvBase & evTarget ) const
{
    // Control whether to fetch.
    bool fFetch = true;

    // Get address.
    MmAddr addrSeg = 0;
    switch ( tyAddr_ )
    {
    default:
	ErAbort( "MsLine::fetchSeg: bad enum." );

    case tyAddrArg:
	addrSeg = MmAddr( cxFetch.getEvSci( ).getArg( iAddr_ ) );
	break;

    case tyAddrArgNz:
	addrSeg = MmAddr( cxFetch.getEvSci( ).getArg( iAddr_ ) );
	if ( addrSeg == 0 )
	    fFetch = false;
	break;
    }

    // Get count.
    int nCount = 0;
    switch ( tyCount_ )
    {
    default:
	ErAbort( "MsLine::fetchSeg: bad enum." );

    case tyCountArg:
	nCount = int( cxFetch.getEvSci( ).getArg( iCount_ ) );
	break;

    case tyCountMem:
	{
	    // Need to allow unaligned access here.
	    MmWord wnCount;
	    if ( !cxFetch.getProc( ).fetchWord( tyMmData,
		MmAddr( cxFetch.getEvSci( ).getArg( iCount_ ) ), wnCount ) )
	    {
		fFetch = false;
	    }
	    else
	    {
		nCount = int( wnCount );
	    }
	}
	break;

    case tyCountOne:
	if ( iCount_ != 1 )
	    ErAbort( "MsLine::fetchSeg: tyCountOne." );
	nCount = 1;
	break;

    case tyCountRet:
	if ( cxFetch.getEvSco( ).isScrError( ) )
	    ErAbort( "MsLine::fetchSeg: tyCountRet." );
	nCount = int( cxFetch.getEvSco( ).getScrWord( 0 ) );
	break;

    case tyCountSel:
	{
	    const int nfd = int( cxFetch.getEvSci( ).getArg( iCount_ ) );
	    nCount = (nfd >= 0)
		    ? ( (nfd + __NFDBITS - 1) / __NFDBITS ) * sizeof(MmWord)
		    : sizeof(fd_set);
	}
	break;
    }

    // Fetch segment.
    MmSeg * psegFetch = new MmSeg;
    if ( psegFetch == 0 )
	ErMem( );
    if ( fFetch && nCount >= 0 )
    {
	psegFetch->fetchProc( cxFetch.getProc( ), tyMmData, itySeg_,
	    addrSeg, nCount );
    }
    evTarget.appSeg( psegFetch );
}
