// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmType.hh
//   Target machine types.
//   These are typedefs.
//
// File Created:	16 Apr 1995		Michael Chastain
// Last Reviewed:	09 Oct 1995		Michael Chastain
// Last Edited:		14 Nov 1995		Michael Chastain

#if !defined(MM_TYPE_HH)
#define MM_TYPE_HH



#if defined(MEC_TARGET_LIX) || defined(MEC_TARGET_SUN)

typedef unsigned char	MmByte;
typedef long long	MmLoff;
typedef unsigned short	MmShort;
typedef unsigned int	MmWord;

typedef MmByte *	MmAddr;
static const MmAddr mmAddrMin = MmAddr( 0x00000000 );
static const MmAddr mmAddrMac = MmAddr( 0xFFFFFFFF );

inline MmAddr MmAddrAlign( MmAddr addrData )
{
    return MmAddr( MmWord( addrData ) &~ ( sizeof(MmWord) - 1 ) );
}

inline int MmAddrRem( MmAddr addrData )
{
    return MmWord( addrData ) & ( sizeof(MmWord) - 1 );
}

#endif



#if defined(MEC_TARGET_LIX)

typedef MmByte		MmInsn;

// Linux 1.3.36: see 'asm/a.out.h' and 'asm/processor.h'.
static const MmAddr mmAddrStackMax = MmAddr( 0xC0000000 );

#endif



#if defined(MEC_TARGET_SUN)

typedef MmWord		MmInsn;

#endif



#endif
