// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmSeg.hh
//   Memory segment.
//   This is a concrete class.
//
// File Created:	11 Jun 1994		Michael Chastain
// Last Reviewed:	09 Oct 1995		Michael Chastain
// Last Edited:		02 Nov 1995		Michael Chastain

#if !defined(MM_SEG_HH)
#define MM_SEG_HH

#include <MmArea.hh>
#include <MmSpace.hh>
#include <MmType.hh>
#include <WhList.hh>

class	PrProc;
class	WhFlatIn;
class	WhFlatOut;
class	WhString;



class	MmSeg
{
    // Constructors.
    public:
				MmSeg		(		   );

    // Flat interface.
    public:
	void			fromFlat	( WhFlatIn  &	   );
	void			toFlat		( WhFlatOut &	   ) const;

    // Accessors.
    public:
	const MmByte *		address		(		   ) const;
	int			count		(		   ) const;
	MmAddr			getAddrFirst	(		   ) const;
	MmAddr			getAddrLast	(		   ) const;
	const MmArea &		getArea		(		   ) const;
	int			getItySeg	(		   ) const;
	bool			hasArea		(		   ) const;
	bool			hasData		(		   ) const;
	bool			hasOverlap	( const MmSeg &	   ) const;

    // Formatter.
    public:
	void			fmtStr		( WhString &	   ) const;

    // Mutators.
    public:
	void			replaceByte	( MmByte, MmByte   );
	void			smashData	( const MmByte *,
						  int		   );

    // Checkers.
    public:
	void			checkCcs	(		   ) const;
	void			checkCountList	( int		   ) const;
	void			checkCountMin	( int		   ) const;
	void			checkCountOne	( int		   ) const;

    // Process interface.
    public:
	void			fetchCopy	( const PrProc &,
						  const MmSeg &    );
	void			fetchProc	( const PrProc &,
						  TyMmSpace, int,
						  MmAddr, int	   );
	void			storeProc	( PrProc &	   ) const;

    // Instance data.
    //   MmAddrAlign( area_.getAddrMin( ) ) <--> &lwData_[0].
    private:
	bool			fArea_;		// Has area.
	bool			fData_;		// Has data.
	int			itySeg_;	// Type of segment.
	int			nItem_;		// # of items specified.
	MmArea			area_;		// Address area.
	WhList <MmWord>		lwData_;	// Data in this segment.
};



// Inline methods.

inline int MmSeg::getItySeg( ) const
{
    return itySeg_;
}

inline bool MmSeg::hasArea( ) const
{
    return fArea_;
}

inline bool MmSeg::hasData( ) const
{
    return fData_;
}



#endif
