// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmScr.hh
//   System call return value.
//   This is a concrete class.
//
// File Created:	19 Jun 1995		Michael Chastain
// Last Edited:		03 Nov 1995		Michael Chastain

#if !defined(MM_SCR_HH)
#define MM_SCR_HH

#include <MmType.hh>

class	PrProc;
class	WhFlatIn;
class	WhFlatOut;
class	WhString;



class	MmScr
{
    // Types.
    //   These values go into files.
    //   These values must fit in one character.
    public:
	enum	TyScr
	{
	    tyScrUnbound = 0x00,		// Not bound.
	    tyScrAddr,				// Address.
	    tyScrHex,				// Hexadecimal.
	    tyScrInt,				// Integer (could be errno).
	    tyScrNot,				// Return not expected!
	    tyScrOct				// Octal.
	};

    // Constructor.
    public:
				MmScr		( TyScr		   );

    // Flat interface.
    public:
	void			fromFlat	( WhFlatIn  &	   );
	void			toFlat		( WhFlatOut &	   ) const;

    // Process interface.
    public:
	void			fetchProc	( const PrProc &   );
	void			storeProc	( PrProc &	   ) const;

    // Formatter.
    public:
	void			fmtScr		( WhString &	   ) const;

    // Accessors.
    public:
	TyScr			getTyScr	(		   ) const;
	MmWord			getWord		( int iWord	   ) const;
	bool			isError		(		   ) const;
	bool			match		( const MmScr &	   ) const;

    // Mutators.
    public:
	void			setTyScr	( TyScr		   );
	void			setError	( MmWord	   );
	void			setValue	( MmWord, MmWord   );

    // Helpers.
    private:
	void			fmtError	( WhString &	   ) const;

    // Instance data.
    private:
	TyScr			tyScr_;		// Type.

#if defined(MEC_TARGET_LIX)
    // Linux 1.2.9: instance data.
    private:
	MmWord			wScr_;		// Sys call return value.
#endif

#if defined(MEC_TARGET_SUN)
    // SunOS 4.1.3: instance data.
    private:
	MmWord			wError_;	// 'u_error' (plus stuff).
	MmWord			w1_;		// 'u_rval1'.
	MmWord			w2_;		// 'u_rval2'.
#endif

};



// Inline methods.

inline MmScr::TyScr MmScr::getTyScr( ) const
{
    return tyScr_;
}

inline void MmScr::setTyScr( TyScr tyScr )
{
    tyScr_ = tyScr;
}



#endif
