// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmArea.hh
//   Address area class.
//   This is a concrete class.
//
// File Created:	24 Apr 1995		Michael Chastain
// Last Edited:		26 Oct 1995		Michael Chastain

#if !defined(MM_AREA_HH)
#define MM_AREA_HH

#include <MmSpace.hh>
#include <MmType.hh>

class	WhFlatIn;
class	WhFlatOut;
class	WhString;



class	MmArea
{
    // Constructors.
    public:
				MmArea		(		   );
				MmArea		( TyMmSpace,
						  MmAddr, MmAddr   );

    // Flat interface.
    public:
	void			fromFlat	( WhFlatIn  &	   );
	void			toFlat		( WhFlatOut &	   ) const;

    // Accessors.
    public:
	int			count		(		   ) const;
	TyMmSpace		getTyMmSpace	(		   ) const;
	MmAddr			getAddrMin	(		   ) const;
	MmAddr			getAddrMax	(		   ) const;

    // String interface.
    public:
	void			fmtStr		( WhString &	   ) const;

    // Mutators.
    public:
	void			setCover	( TyMmSpace	   );

    // Instance data.
    private:
	TyMmSpace		tyMmSpace_;	// Address space.
	MmAddr			addrMin_;	// Min address (inclusive).
	MmAddr			addrMax_;	// Max address (exclusive).
};



// Inline methods.

inline int MmArea::count( ) const
{
    return addrMax_ - addrMin_;
}

inline TyMmSpace MmArea::getTyMmSpace( ) const
{
    return tyMmSpace_;
}

inline MmAddr MmArea::getAddrMin( ) const
{
    return addrMin_;
}

inline MmAddr MmArea::getAddrMax( ) const
{
    return addrMax_;
}



#endif
