// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmArea.cc
//   Address area class.
//   This is a concrete class.
//
// File Created:	24 Apr 1995		Michael Chastain
// Last Edited:		26 Oct 1995		Michael Chastain

#include <ErAbort.hh>
#include <ErFatal.hh>
#include <MmArea.hh>
#include <MmSpace.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>
#include <WhString.hh>



// Constructor.
MmArea::MmArea( )
    : tyMmSpace_	( tyMmBlank	)
    , addrMin_		( 0		)
    , addrMax_		( 0		)
{
    ;
}



// Constructor.
MmArea::MmArea( TyMmSpace tyMmSpace, MmAddr addrMin, MmAddr addrMax )
    : tyMmSpace_	( tyMmSpace	)
    , addrMin_		( addrMin	)
    , addrMax_		( addrMax	)
{
    if ( addrMin > addrMax )
	ErAbort( "MmArea::MmArea: bad range." );

    switch ( tyMmSpace )
    {
    default:
	ErAbort( "MmArea::MmArea: bad enum." );
    case tyMmBlank:
    case tyMmUser:
    case tyMmText:
    case tyMmData:
    case tyMmBss:
    case tyMmBrk:
    case tyMmLib:
    case tyMmMmap:
    case tyMmStack:
	break;
    }
}



// Flat input.
void MmArea::fromFlat( WhFlatIn & flatIn )
{
    // Read values.
    int    ityMmSpace; flatIn.getInt  ( ityMmSpace );
    MmAddr addrMin;    flatIn.getAddr ( addrMin    );
    MmAddr addrMax;    flatIn.getAddr ( addrMax    );

    // Check values.
    switch ( ityMmSpace )
    {
    default:
    	ErFatal( "MmArea::fromFlat: bad enum." );
    case tyMmBlank:
    case tyMmUser:
    case tyMmText:
    case tyMmData:
    case tyMmBss:
    case tyMmBrk:
    case tyMmLib:
    case tyMmMmap:
    case tyMmStack:
	break;
    }
    if ( addrMin > addrMax )
	ErFatal( "MmArea::fromFlat: bad address pair." );

    // Success.
    tyMmSpace_  = TyMmSpace( ityMmSpace );
    addrMin_    = addrMin;
    addrMax_    = addrMax;
}



// Flat output.
void MmArea::toFlat( WhFlatOut & flatOut ) const
{
    flatOut.putInt  ( int( tyMmSpace_ )	);
    flatOut.putAddr ( addrMin_		);
    flatOut.putAddr ( addrMax_		);
}



// Format to string.
void MmArea::fmtStr( WhString & strRet ) const
{
    strRet.appStrRaw( "    <area> " );

    switch ( tyMmSpace_ )
    {
    default:		ErAbort( "MmArea::fmtStr: bad enum." );
    case tyMmBlank:	strRet.appStrRaw( "blank " ); break;
    case tyMmUser:	strRet.appStrRaw( "user  " ); break;
    case tyMmText:	strRet.appStrRaw( "text  " ); break;
    case tyMmData:	strRet.appStrRaw( "data  " ); break;
    case tyMmBss:	strRet.appStrRaw( "bss   " ); break;
    case tyMmBrk:	strRet.appStrRaw( "brk   " ); break;
    case tyMmLib:	strRet.appStrRaw( "lib   " ); break;
    case tyMmMmap:	strRet.appStrRaw( "mmap  " ); break;
    case tyMmStack:	strRet.appStrRaw( "stack " ); break;
    }

    strRet.appPtrFmt( addrMin_	);
    strRet.appChrRaw( ' '	);
    strRet.appPtrFmt( addrMax_	);
    strRet.appChrRaw( '\n'	);
}



// Set to cover the address space.
//   Fencepost error (mac->max), addrMax_ doesn't cover highest address.
void MmArea::setCover( TyMmSpace tyMmSpace )
{
    tyMmSpace_ = tyMmSpace;
    addrMin_   = mmAddrMin;
    addrMax_   = mmAddrMac;
}
