// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ListArg.hh
//   Argument holder.
//   This is a concrete class.
//
// File Created:	06 Nov 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#if !defined(LIST_ARG_HH)
#define LIST_ARG_HH

#include <WhString.hh>



class	ListArg
{
    // Constructor.
    public:
				ListArg		( const char * []  );

    // Usage interface.
    public:
	void			showUsage	( const char *	   ) const;

    // Accessors.
    public:
	bool			isError		(		   ) const;
	bool			hasHelp		(		   ) const;
	const WhString &	getNameSelf	(		   ) const;
	const WhString &	getNameTrace	(		   ) const;

    // Instance data.
    private:
	bool			fError_;	// Args have error.
	bool			fHelp_;		// '-h'.
	WhString		strNameSelf_;	// Name of self.
	WhString		strNameTrace_;	// Name of trace file.
};



// Inline methods.

inline bool ListArg::isError( ) const
{
    return fError_;
}

inline bool ListArg::hasHelp( ) const
{
    return fHelp_;
}

inline const WhString & ListArg::getNameSelf( ) const
{
    return strNameSelf_;
}

inline const WhString & ListArg::getNameTrace( ) const
{
    return strNameTrace_;
}



#endif
