// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvType.cc
//   Event types.
//   This is an enumeration.
//   These values are stored into files.
//
// File Created:	02 Nov 1995		Michael Chastain
// Last Edited:		08 Nov 1995		Michael Chastain

#include <ErAbort.hh>
#include <ErMem.hh>
#include <EvBase.hh>
#include <EvExec.hh>
#include <EvExit.hh>
#include <EvFirst.hh>
#include <EvSci.hh>
#include <EvSco.hh>
#include <EvSignal.hh>
#include <EvType.hh>



// Create an event pointer.
EvBase * TyEventCreateBase( TyEvent tyEvent )
{
    EvBase * pev = 0;
    switch ( tyEvent )
    {
    default:         ErAbort( "TyEventCreateBase: bad enum." );
    case tyEvExec:   pev = new EvExec;   break;
    case tyEvExit:   pev = new EvExit;   break;
    case tyEvFirst:  pev = new EvFirst;  break;
    case tyEvSci:    pev = new EvSci;    break;
    case tyEvSco:    pev = new EvSco;    break;
    case tyEvSignal: pev = new EvSignal; break;
    }
    if ( pev == 0 )
	ErMem( );
    return pev;
}
