// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvLog.hh
//   A log of events.
//   This is a concrete class.
//
// File Created:	28 Jun 1995		Michael Chastain
// Last Edited:		08 Nov 1995		Michael Chastain

#if !defined(EV_LOG_HH)
#define EV_LOG_HH

#include <WhLap.hh>

class	EvBase;
class	EvSco;



class	EvLog
{
    // Life cycle methods.
    public:
    				EvLog		( WhLap<EvBase>* & );
    				EvLog		( const EvLog &	   );
	void			operator =	( const EvLog &    );
				~EvLog		(		   );

    // Accessors.
    public:
	int			count		(		   ) const;
	const EvBase &		getEvCur	(		   ) const;
	const EvSco *		getEvScoNext	(		   ) const;
	bool			isAtEnd		(		   ) const;

    // Cursor movement.
    public:
	void			advance		(		   );
	void			backspace	(		   );
	void			rewind		(		   );
	void			seekExecFirst	(		   );

    // Instance data.
    private:
	int *			pnref_;		// Reference count.
	WhLap <EvBase> *	plev_;		// List of events.
	int			iev_;		// Current event.
};



// Inline methods.

inline int EvLog::count( ) const
{
    return plev_->count( );
}

inline const EvBase & EvLog::getEvCur( ) const
{
    return (*plev_)[iev_];
}

inline bool EvLog::isAtEnd( ) const
{
    return iev_ >= plev_->count( );
}

inline void EvLog::advance( )
{
    if ( iev_ < plev_->count( ) )
	++iev_;
}

inline void EvLog::backspace( )
{
    if ( iev_ > 0 )
	--iev_;
}

inline void EvLog::rewind( )
{
    iev_ = 0;
}



#endif
