// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvLog.cc
//   A log of events.
//   This is a concrete class.
//
// File Created:	28 Jun 1995		Michael Chastain
// Last Edited:		08 Nov 1995		Michael Chastain

#include <ErFatal.hh>
#include <ErMem.hh>
#include <ErPtr.hh>
#include <EvBase.hh>
#include <EvLog.hh>



// Constructor.
EvLog::EvLog( WhLap <EvBase> * & plev )
    : pnref_	( new int	)
    , plev_	( plev		)
    , iev_	( 0		)
{
    if ( pnref_ == 0 )
	ErMem( );
    *pnref_ = 1;

    if ( plev == 0 )
	ErPtr( );
    plev = 0;
}



// Copy constructor.
EvLog::EvLog( const EvLog & logOld )
    : pnref_	( logOld.pnref_	)
    , plev_	( logOld.plev_	)
    , iev_	( logOld.iev_	)
{
    ++*pnref_;
}



// Assignment operator.
void EvLog::operator = ( const EvLog & logOld )
{
    if ( this != &logOld )
    {
	if ( --*pnref_ == 0 )
	{
	    delete pnref_;
	    delete plev_;
	}

	pnref_ = logOld.pnref_;
	plev_  = logOld.plev_;
	iev_   = logOld.iev_;
	++*pnref_;
    }
}



// Destructor.
EvLog::~EvLog( )
{
    if ( --*pnref_ == 0 )
    {
	delete pnref_;
	delete plev_;
    }
    pnref_ = 0;
    plev_  = 0;
}



// Return next EvSco without moving cursor.
const EvSco * EvLog::getEvScoNext( ) const
{
    for ( int ievSco = iev_; ievSco < plev_->count( ); ++ievSco )
    {
	const EvSco * pevSco = (*plev_)[ievSco].ptrEvSco( );
	if ( pevSco != 0 )
	    return pevSco;
    }
    return 0;
}



// Seek to next EvExec.
void EvLog::seekExecFirst( )
{
    for ( iev_ = 0; iev_ < plev_->count( ); ++iev_ )
    {
	if ( (*plev_)[iev_].ptrEvExec( ) != 0 )
	{
	    if ( iev_ == 0 )
		ErFatal( "EvLog::seekExecFirst: exec first." );
	    --iev_;
	    return;
	}
    }

    ErFatal( "EvLog::seekExecFirst: no exec." );
}
