// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvExec.hh
//   An event, type 'execution in'.
//
// File Created:	19 Sep 1994		Michael Chastain
// Last Reviewed:	15 Oct 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#if !defined(EV_EXEC_HH)
#define EV_EXEC_HH

#include <EvBase.hh>
#include <MmType.hh>
#include <WhList.hh>



class	EvExec			: public EvBase
{
    // Constructor and destructor.
    public:
				EvExec		(		   );
				~EvExec		(		   );

    // RTTI.
    public:
	const EvExec *		ptrEvExec	(		   ) const;

    // Flat interface (combiner).
    private:
	void			fromFlatEv	( WhFlatIn  &	   );
	void			toFlatEv	( WhFlatOut &	   ) const;

    // String interface (combiner).
    private:
	void			fmtStrEv	( WhString &	   ) const;

    // Process interface.
    public:
	void			fetch		( CxFetch &	   );
	void			storeAw		( CxStore &	   ) const;
	void			storeBc		( CxStore &	   ) const;

    // Instance data.
    private:
	bool			fInit_;		// Has initial registers.
	MmWord			wSp_;		// Stack pointer.
	MmWord			wFl_;		// Flags.
	WhList <MmWord>		lwInit_;	// Initial registers.
};



#endif
