// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvBase.hh
//   An event.
//   This is an abstract base class.
//
// File Created:	29 Jul 1994		Michael Chastain
// Last Reviewed:	13 Oct 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#if !defined(EV_BASE_HH)
#define EV_BASE_HH

#include <ErMem.hh>
#include <MmArea.hh>
#include <WhLap.hh>
#include <WhList.hh>
#include <WhString.hh>

class	CxFetch;
class	CxStore;
class	EvExec;
class	EvSci;
class	EvSco;
class	MmDs;
class	MmSeg;
class	WhFlatIn;
class	WhFlatOut;



class	EvBase
{
    // Life cycle methods.
    public:
				EvBase		(		   );
	virtual			~EvBase		(		   );

    // Forbidden copiers.
    private:
				EvBase		( const EvBase &   );
	void			operator =	( const EvBase &   );

    // RTTI.
    public:
	virtual const EvExec *	ptrEvExec	(		   ) const;
	virtual const EvSci  *	ptrEvSci	(		   ) const;
	virtual const EvSco  *	ptrEvSco	(		   ) const;

    // Flat interface.
    public:
	void			fromFlat	( WhFlatIn  &	   );
	void			toFlat		( WhFlatOut &	   ) const;

    // Flat interface (combiner).
    private:
	virtual void		fromFlatEv	( WhFlatIn  &	   )       = 0;
	virtual void		toFlatEv	( WhFlatOut &	   ) const = 0;

    // Time stamp.
    public:
	void			setStamp	( int, int	  );

    // Model-fail interface.
    public:
	const WhString &	getModelFail	(		   ) const;
	bool			isModelFail	(		   ) const;
	void			setModelFail	( const WhString & );

    // String interface.
    public:
	void			fmtStr		( WhString &       ) const;

    // String interface (combiner).
    private:
	virtual void		fmtStrEv	( WhString &	   ) const = 0;

    // Process interface.
    public:
	virtual void		fetch		( CxFetch &	   )       = 0;
	virtual void		storeAw		( CxStore &	   ) const = 0;
	virtual void		storeBc		( CxStore &	   ) const = 0;

    // Area interface.
    public:
	void			appArea		( MmArea * &	   );
	int			countArea	(		   ) const;
	const MmArea &		getArea		( int		   ) const;

    // Segment interface.
    public:
	void			appSeg		( MmSeg * &	   );
	int			countSeg	(		   ) const;
	const MmSeg &		getSeg		( int		   ) const;

    // Dataset interface.
    public:
	void			appDs		( MmDs * &	   );
	int			countDs		(		   ) const;
	const MmDs &		getDs		( int		   ) const;

    // Instance data.
    private:
	int			itimeSecond_;	// Time stamp.
	int			itimeMicro_;	// Time stamp.
	WhString		strModelFail_;	// Model failure reason.
	WhLap <MmArea>		larea_;		// Areas.
	WhLap <MmSeg>		lseg_;		// Segments.
	WhLap <MmDs>		lds_;		// Datasets.
};



// Inline methods.

inline void EvBase::setStamp( int itimeSecond, int itimeMicro )
{
    itimeSecond_ = itimeSecond;
    itimeMicro_  = itimeMicro;
}

inline const WhString & EvBase::getModelFail( ) const
{
    return strModelFail_;
}

inline bool EvBase::isModelFail( ) const
{
    return strModelFail_.count( ) > 0;
}

inline void EvBase::setModelFail( const WhString & strModelFail )
{
    strModelFail_ = strModelFail;
    if ( strModelFail_.count( ) == 0 )
	strModelFail_.appStrRaw( "UNKNOWN" );
}

inline void EvBase::appArea( MmArea * & pareaApp )
{
    larea_.appendAp( pareaApp );
}

inline int EvBase::countArea( ) const
{
    return larea_.count( );
}

inline const MmArea & EvBase::getArea( int iarea ) const
{
    return larea_[iarea];
}

inline void EvBase::appSeg( MmSeg * & psegApp )
{
    lseg_.appendAp( psegApp );
}

inline int EvBase::countSeg( ) const
{
    return lseg_.count( );
}

inline const MmSeg & EvBase::getSeg( int iseg ) const
{
    return lseg_[iseg];
}

inline void EvBase::appDs( MmDs * & psegDs )
{
    lds_.appendAp( psegDs );
}

inline int EvBase::countDs( ) const
{
    return lds_.count( );
}

inline const MmDs & EvBase::getDs( int ids ) const
{
    return lds_[ids];
}



#endif
