// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvBase.cc
//   An event.
//   This is an abstract base class.
//
// File Created:	29 Jul 1994		Michael Chastain
// Last Reviewed:	13 Oct 1995		Michael Chastain
// Last Edited:		07 Nov 1995		Michael Chastain

#include <ErAbort.hh>
#include <ErFatal.hh>
#include <ErMem.hh>
#include <EvBase.hh>
#include <MmDs.hh>
#include <MmSeg.hh>
#include <TySeg.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>



// Constructor.
EvBase::EvBase( )
    : itimeSecond_	( 0		)
    , itimeMicro_	( 0		)
    , strModelFail_	(		)
    , larea_		(		)
    , lseg_		(		)
    , lds_		(		)
{
    ;
}



// Destructor.
EvBase::~EvBase( )
{
    ;
}



// RTTI.
const EvExec * EvBase::ptrEvExec ( ) const { return 0; }
const EvSci  * EvBase::ptrEvSci  ( ) const { return 0; }
const EvSco  * EvBase::ptrEvSco  ( ) const { return 0; }



// Flat input.
void EvBase::fromFlat( WhFlatIn & flatIn )
{
    flatIn.getInt	( itimeSecond_	);
    flatIn.getInt	( itimeMicro_	);
    flatIn.getString	( strModelFail_	);

    {
	int narea;
	flatIn.getInt( narea );
	if ( narea < 0 )
	    ErFatal( "EvBase::fromFlat: negative count." );

	larea_.reset( narea );
	for ( int iarea = 0; iarea < narea; ++iarea )
	{
	    MmArea * parea = new MmArea;
	    if ( parea == 0 )
		ErMem( );
	    parea->fromFlat( flatIn );
	    larea_.appendAp( parea );
	}
    }

    {
	int nseg;
	flatIn.getInt( nseg );
	if ( nseg < 0 )
	    ErFatal( "EvBase::fromFlat: negative count." );

	lseg_.reset( nseg );
	for ( int iseg = 0; iseg < nseg; ++iseg )
	{
	    MmSeg * pseg = new MmSeg;
	    if ( pseg == 0 )
		ErMem( );
	    pseg->fromFlat( flatIn );
	    lseg_.appendAp( pseg );
	}
    }

    {
	int nds;
	flatIn.getInt( nds );
	if ( nds < 0 )
	    ErFatal( "EvBase::fromFlat: negative count." );

	lds_.reset( nds );
	for ( int ids = 0; ids < nds; ++ids )
	{
	    MmDs * pds = new MmDs;
	    if ( pds == 0 )
		ErMem( );
	    pds->fromFlat( flatIn );
	    lds_.appendAp( pds );
	}
    }

    fromFlatEv( flatIn );
}



// Flat output.
void EvBase::toFlat( WhFlatOut & flatOut ) const
{
    flatOut.putInt	( itimeSecond_		);
    flatOut.putInt	( itimeMicro_		);
    flatOut.putString	( strModelFail_		);

    {
	flatOut.putInt( larea_.count( ) );
	for ( int iarea = 0; iarea < larea_.count( ); ++iarea )
	    larea_[iarea].toFlat( flatOut );
    }

    {
	flatOut.putInt( lseg_.count( ) );
	for ( int iseg = 0; iseg < lseg_.count( ); ++iseg )
	    lseg_[iseg].toFlat( flatOut );
    }

    {
	flatOut.putInt( lds_.count( ) );
	for ( int ids = 0; ids < lds_.count( ); ++ids )
	    lds_[ids].toFlat( flatOut );
    }

    toFlatEv( flatOut );
}



// Format to string.
void EvBase::fmtStr( WhString & strRet ) const
{
    strRet.appIntFmt( itimeSecond_		);
    strRet.appChrRaw( '.'			);
    strRet.appIntFmt( itimeMicro_, 10, 6	);
    strRet.appStrRaw( "  "			);

    fmtStrEv( strRet );

    if ( isModelFail( ) )
    {
	strRet.appStrRaw( "    <cannot replay: " );
	strRet.appStrRaw( getModelFail( )        );
	strRet.appStrRaw( ">\n"                  );
    }

    for ( int iarea = 0; iarea < larea_.count( ); ++iarea )
	larea_[iarea].fmtStr( strRet );

    for ( int iseg = 0; iseg < lseg_.count( ); ++iseg )
	lseg_[iseg].fmtStr( strRet );

    for ( int ids = 0; ids < lds_.count( ); ++ids )
	lds_[ids].fmtStr( strRet );
}
