// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ErUser.cc
//   Report a user-generated error.
//
// File Created:	21 Oct 1995		Michael Chastain
// Last Edited:		29 Oct 1995		Michael Chastain

#include <unistd.h>

#include <ErUser.hh>
#include <WhString.hh>



// Report an error.
void ErUser( const WhString & strMessage )
{
    ::write( 2, strMessage.address( ), strMessage.count( ) );
}



// Report an error.
void ErUser( const WhString & strNameSelf, const WhString & strType,
    const WhString & strName, const WhString & strReason )
{
    WhString strError( strNameSelf );

    if ( strType.count( ) != 0 )
    {
	strError.appStrRaw( ": "	);
	strError.appStrRaw( strType	);
    }

    if ( strName.count( ) != 0 )
    {
	strError.appStrRaw( " '"	);
	strError.appStrRaw( strName	);
	strError.appStrRaw( "'"		);
    }

    strError.appStrRaw( ": "		);
    strError.appStrRaw( strReason	);
    strError.appStrRaw( ".\n"		);
    ErUser( strError );
}
