// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ErFatal.cc
//   Exit due to fatal external error.
//
// File Created:	10 Oct 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#include <unistd.h>

#include <ErFatal.hh>
#include <ErPtr.hh>



// Use low-level calls and no more dynamic memory.
void ErFatal( const char * pcMessage )
{
    if ( pcMessage == 0 )
	ErPtr( );

    ::write( 2, "*** Fatal: ", 11 );
    for ( int icMessage = 0; pcMessage[icMessage] != '\0'; ++icMessage )
	::write( 2, pcMessage + icMessage, 1 );
    ::write( 2, "\n", 1 );
    ::abort( );
}
